/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.j2ee.deploy.spi.status;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.j2ee.deploy.spi.DeploymentManagerImpl;
import com.ibm.ws.management.application.j2ee.deploy.spi.TargetImpl;
import com.ibm.ws.management.application.j2ee.deploy.spi.TargetModuleIDImpl;
import com.ibm.ws.management.application.j2ee.deploy.spi.status.ProgressObjectImpl;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.enterprise.deploy.shared.ActionType;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.spi.status.DeploymentStatus;

public class DeploymentStatusImpl
implements DeploymentStatus {
    private int command;
    private int state;
    private int action;
    private String message;
    private String defaultMessage;
    private ResourceBundle resBundle = null;
    private ProgressObjectImpl po = null;
    private static TraceComponent tc = Tr.register((Class)DeploymentStatusImpl.class, (String)"Admin", (String)"com.ibm.ws.management.resources.J2eeDeploymentMessages");

    public DeploymentStatusImpl(int n, int n2, int n3, ResourceBundle resourceBundle, ProgressObjectImpl progressObjectImpl) {
        this.command = n;
        this.state = n2;
        this.action = n3;
        this.po = progressObjectImpl;
        this.resBundle = resourceBundle;
    }

    public StateType getState() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getState returns " + StateType.getStateType((int)this.state)));
        }
        return StateType.getStateType((int)this.state);
    }

    public void setState(int n) {
        this.state = n;
        this.updateMessage();
    }

    public CommandType getCommand() {
        return CommandType.getCommandType((int)this.command);
    }

    public ActionType getAction() {
        return ActionType.getActionType((int)this.action);
    }

    public String getMessage() {
        String string = null;
        if (this.message == null) {
            if (this.defaultMessage == null) {
                ResourceBundle resourceBundle = AppUtils.getBundle(DeploymentManagerImpl.getLocalePrefs());
                string = AppUtils.getMessage(resourceBundle, "progress.object.message", new Object[]{CommandType.getCommandType((int)this.command).toString(), StateType.getStateType((int)this.state).toString()});
            } else {
                string = this.defaultMessage;
            }
        } else {
            string = this.message;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getMessage", (Object)string);
        }
        return string;
    }

    public boolean isCompleted() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("isCompleted returns " + (this.state == StateType.COMPLETED.getValue())));
        }
        return this.state == StateType.COMPLETED.getValue();
    }

    public boolean isFailed() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("isFailed returns " + (this.state == StateType.FAILED.getValue())));
        }
        return this.state == StateType.FAILED.getValue();
    }

    public boolean isRunning() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("isRunning returns " + (this.state == StateType.RUNNING.getValue())));
        }
        return this.state == StateType.RUNNING.getValue();
    }

    private void updateMessage() {
        if (this.po != null) {
            if (this.po.successfulTargetMods != null && this.po.failedTargetMods == null) {
                this.defaultMessage = AppUtils.getMessage(this.resBundle, "ADMJ1011I", new Object[]{CommandType.getCommandType((int)this.command).toString(), this.getModuleNamesString(this.po.successfulTargetMods)});
            } else if (this.po.successfulTargetMods == null && this.po.failedTargetMods != null) {
                this.defaultMessage = AppUtils.getMessage(this.resBundle, "ADMJ1012E", new Object[]{CommandType.getCommandType((int)this.command).toString(), this.getModuleNamesString(this.po.failedTargetMods)});
            } else if (this.po.successfulTargetMods != null && this.po.failedTargetMods != null) {
                this.defaultMessage = AppUtils.getMessage(this.resBundle, "ADMJ1013W", new Object[]{CommandType.getCommandType((int)this.command).toString(), this.getModuleNamesString(this.po.successfulTargetMods), this.getModuleNamesString(this.po.failedTargetMods)});
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"updateMessage", (Object)this.defaultMessage);
            }
        }
    }

    private String getModuleNamesString(Vector vector) {
        Iterator iterator = vector.iterator();
        StringBuffer stringBuffer = new StringBuffer();
        TargetModuleIDImpl targetModuleIDImpl = null;
        if (iterator.hasNext()) {
            targetModuleIDImpl = (TargetModuleIDImpl)iterator.next();
            stringBuffer.append(targetModuleIDImpl.getApplicationName() + " - " + ((TargetImpl)targetModuleIDImpl.getTarget()).getServerName());
        }
        while (iterator.hasNext()) {
            targetModuleIDImpl = (TargetModuleIDImpl)iterator.next();
            stringBuffer.append(",");
            stringBuffer.append(targetModuleIDImpl.getApplicationName() + " - " + ((TargetImpl)targetModuleIDImpl.getTarget()).getServerName());
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getModuleNamesString returns " + stringBuffer.toString()));
        }
        return stringBuffer.toString();
    }

    public void setMessage(String string, Object[] objectArray) {
        this.message = AppUtils.getMessage(this.resBundle, string, objectArray);
    }

    public void setMessage(String string) {
        this.message = string;
    }

    public Object clone() {
        return new DeploymentStatusImpl(this.command, this.state, this.action, this.resBundle, this.po);
    }

    public String toString() {
        return "command=" + this.command + ", state=" + this.state + ",action=" + this.action;
    }
}

