/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.dfltbndngs;

import com.ibm.ejs.models.base.bindings.clientbnd.ApplicationClientBinding;
import com.ibm.ejs.models.base.bindings.commonbnd.EjbRefBinding;
import com.ibm.ejs.models.base.bindings.commonbnd.ResourceEnvRefBinding;
import com.ibm.ejs.models.base.bindings.commonbnd.ResourceRefBinding;
import com.ibm.ejs.models.base.bindings.ejbbnd.CMPConnectionFactoryBinding;
import com.ibm.ejs.models.base.bindings.ejbbnd.EJBJarBinding;
import com.ibm.ejs.models.base.bindings.ejbbnd.EnterpriseBeanBinding;
import com.ibm.ejs.models.base.bindings.ejbbnd.MessageDrivenBeanBinding;
import com.ibm.ejs.models.base.bindings.webappbnd.WebAppBinding;
import com.ibm.etools.client.ApplicationClient;
import com.ibm.etools.commonarchive.ApplicationClientFile;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.EJBJarFile;
import com.ibm.etools.commonarchive.WARFile;
import com.ibm.etools.ejb.EJBJar;
import com.ibm.etools.ejb.EnterpriseBean;
import com.ibm.etools.j2ee.common.EjbRef;
import com.ibm.etools.j2ee.common.ResourceEnvRef;
import com.ibm.etools.j2ee.common.ResourceRef;
import com.ibm.etools.j2ee.commonarchivecore.Archive;
import com.ibm.etools.webapplication.WebApp;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.application.dfltbndngs.Preferences;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Iterator;

public class StrategyExporter {
    PrintStream out = System.out;
    int indentation = -1;
    EARFile ear = null;

    public StrategyExporter(Preferences preferences, EARFile eARFile) {
        this.ear = eARFile;
        try {
            this.out = new PrintStream(new FileOutputStream(preferences.getExportFile()));
        }
        catch (Throwable throwable) {
            System.err.println("couldnt open export file " + preferences.getExportFile() + " ...  writing to System.out instead ...");
            this.out = System.out;
        }
    }

    public void export() {
        this.out.println("<?xml version=\"1.0\"?>");
        this.out.println("<!DOCTYPE dfltbndngs SYSTEM \"dfltbndngs.dtd\">");
        this.startElement("dfltbndngs", true);
        this.exportGlobalBindings();
        this.exportModuleBindings();
        this.endElement("dfltbndngs", true);
    }

    void exportGlobalBindings() {
        this.startElement("global-bindings", true);
        this.endElement("global-bindings", true);
    }

    void exportModuleBindings() {
        this.startElement("module-bindings", true);
        Iterator iterator = this.ear.getModuleFiles().iterator();
        while (iterator.hasNext()) {
            Archive archive = (Archive)iterator.next();
            if (archive.isEJBJarFile()) {
                this.exportEjbJarFile((EJBJarFile)archive);
                continue;
            }
            if (archive.isWARFile()) {
                this.exportWarFile((WARFile)archive);
                continue;
            }
            if (!archive.isApplicationClientFile()) continue;
            this.exportClientJar((ApplicationClientFile)archive);
        }
        this.endElement("module-bindings", true);
    }

    void exportEjbJarFile(EJBJarFile eJBJarFile) {
        Iterator iterator;
        CMPConnectionFactoryBinding cMPConnectionFactoryBinding;
        this.startElement("ejb-jar-binding", true);
        this.printElement("jar-name", eJBJarFile.getURI());
        EJBJarBinding eJBJarBinding = eJBJarFile.getBindings();
        EJBJar eJBJar = eJBJarFile.getDeploymentDescriptor();
        ResourceRefBinding resourceRefBinding = eJBJarBinding.getDefaultDatasource();
        if (resourceRefBinding != null) {
            this.exportDataSource(resourceRefBinding.getJndiName(), "_user_", "_password_");
        }
        if ((cMPConnectionFactoryBinding = eJBJarBinding.getDefaultCMPConnectionFactory()) != null) {
            this.exportConnectionFactory(cMPConnectionFactoryBinding.getJndiName(), Preferences.RES_AUTH[cMPConnectionFactoryBinding.getResAuth().getValue()]);
        }
        if ((iterator = eJBJar.getEnterpriseBeans().iterator()).hasNext()) {
            this.startElement("ejb-bindings", true);
            while (iterator.hasNext()) {
                try {
                    ResourceRefBinding resourceRefBinding2;
                    Iterator iterator2;
                    Iterator iterator3;
                    Iterator iterator4;
                    EnterpriseBean enterpriseBean = (EnterpriseBean)iterator.next();
                    EnterpriseBeanBinding enterpriseBeanBinding = eJBJarBinding.getEJBBinding(enterpriseBean);
                    this.startElement("ejb-binding", true);
                    this.printElement("ejb-name", enterpriseBean.getName());
                    if (enterpriseBean.isMessageDriven()) {
                        this.printElement("listener-port", ((MessageDrivenBeanBinding)enterpriseBeanBinding).getListenerInputPortName());
                    } else {
                        this.printElement("jndi-name", enterpriseBeanBinding.getJndiName());
                        if (enterpriseBean.isContainerManagedEntity()) {
                            if (eJBJar.isVersion2_0Descriptor() && (iterator4 = enterpriseBeanBinding.getCmpConnectionFactory()) != null) {
                                this.exportConnectionFactory(iterator4.getJndiName(), Preferences.RES_AUTH[iterator4.getResAuth().getValue()]);
                            }
                            if (eJBJar.isVersion1_1Descriptor() && (iterator4 = enterpriseBeanBinding.getDatasource()) != null) {
                                this.exportDataSource(iterator4.getJndiName(), "_user_", "_password_");
                            }
                        }
                    }
                    iterator4 = enterpriseBean.getEjbRefs().iterator();
                    if (iterator4.hasNext()) {
                        this.startElement("ejb-ref-bindings", true);
                        while (iterator4.hasNext()) {
                            iterator3 = (EjbRef)iterator4.next();
                            iterator2 = enterpriseBeanBinding.getEjbRefBinding((EjbRef)iterator3);
                            this.exportEjbRef(iterator3.getName(), iterator2.getJndiName());
                        }
                        this.endElement("ejb-ref-bindings", true);
                    }
                    if ((iterator3 = enterpriseBean.getResourceRefs().iterator()).hasNext()) {
                        this.startElement("resource-ref-bindings", true);
                        while (iterator3.hasNext()) {
                            iterator2 = (ResourceRef)iterator3.next();
                            resourceRefBinding2 = enterpriseBeanBinding.getResRefBinding((ResourceRef)iterator2);
                            this.exportResourceRef(iterator2.getName(), resourceRefBinding2.getJndiName());
                        }
                        this.endElement("resource-ref-bindings", true);
                    }
                    if ((iterator2 = enterpriseBean.getResourceEnvRefs().iterator()).hasNext()) {
                        this.startElement("resource-env-ref-bindings", true);
                        while (iterator2.hasNext()) {
                            resourceRefBinding2 = (ResourceEnvRef)iterator2.next();
                            ResourceEnvRefBinding resourceEnvRefBinding = enterpriseBeanBinding.getResEnvRefBinding((ResourceEnvRef)resourceRefBinding2);
                            this.exportResourceEnvRef(resourceRefBinding2.getName(), resourceEnvRefBinding.getJndiName());
                        }
                        this.endElement("resource-env-ref-bindings", true);
                    }
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.application.dfltbndngs.StrategyExporter.exportEjbJarFile", (String)"238", (Object)this);
                }
                this.endElement("ejb-binding", true);
            }
            this.endElement("ejb-bindings", true);
        }
        this.endElement("ejb-jar-binding", true);
    }

    void exportConnectionFactory(String string, String string2) {
        if (string != null) {
            this.startElement("connection-factory", true);
            this.printElement("jndi-name", string);
            this.printElement("res-auth", string2);
            this.endElement("connection-factory", true);
        }
    }

    void exportDataSource(String string, String string2, String string3) {
        if (string != null) {
            this.startElement("data-source", true);
            this.printElement("jndi-name", string);
            this.printElement("user", string2);
            this.printElement("password", string3);
            this.endElement("data-source", true);
        }
    }

    void exportEjbRef(String string, String string2) {
        this.startElement("ejb-ref-binding", true);
        this.printElement("ejb-ref-name", string);
        this.printElement("jndi-name", string2);
        this.endElement("ejb-ref-binding", true);
    }

    void exportResourceRef(String string, String string2) {
        this.startElement("resource-ref-binding", true);
        this.printElement("resource-ref-name", string);
        this.printElement("jndi-name", string2);
        this.endElement("resource-ref-binding", true);
    }

    void exportResourceEnvRef(String string, String string2) {
        this.startElement("resource-env-ref-binding", true);
        this.printElement("resource-env-ref-name", string);
        this.printElement("jndi-name", string2);
        this.endElement("resource-env-ref-binding", true);
    }

    void exportWarFile(WARFile wARFile) {
        Iterator iterator;
        Iterator iterator2;
        this.startElement("war-binding", true);
        WebApp webApp = wARFile.getDeploymentDescriptor();
        WebAppBinding webAppBinding = wARFile.getBindings();
        this.printElement("jar-name", wARFile.getURI());
        Iterator iterator3 = webAppBinding.getEjbRefBindings().iterator();
        if (iterator3.hasNext()) {
            this.startElement("ejb-ref-bindings", true);
            while (iterator3.hasNext()) {
                iterator2 = (EjbRefBinding)iterator3.next();
                this.exportEjbRef(iterator2.getBindingEjbRef().getName(), iterator2.getJndiName());
            }
            this.endElement("ejb-ref-bindings", true);
        }
        if ((iterator2 = webAppBinding.getResRefBindings().iterator()).hasNext()) {
            this.startElement("resource-ref-bindings", true);
            while (iterator2.hasNext()) {
                iterator = (ResourceRefBinding)iterator2.next();
                this.exportResourceRef(iterator.getBindingResourceRef().getName(), iterator.getJndiName());
            }
            this.endElement("resource-ref-bindings", true);
        }
        if ((iterator = webAppBinding.getResourceEnvRefBindings().iterator()).hasNext()) {
            this.startElement("resource-env-ref-bindings", true);
            while (iterator.hasNext()) {
                ResourceEnvRefBinding resourceEnvRefBinding = (ResourceEnvRefBinding)iterator.next();
                this.exportResourceEnvRef(resourceEnvRefBinding.getBindingResourceEnvRef().getName(), resourceEnvRefBinding.getJndiName());
            }
            this.endElement("resource-env-ref-bindings", true);
        }
        this.endElement("war-binding", true);
    }

    void exportClientJar(ApplicationClientFile applicationClientFile) {
        Iterator iterator;
        Iterator iterator2;
        this.startElement("java-binding", true);
        ApplicationClient applicationClient = applicationClientFile.getDeploymentDescriptor();
        ApplicationClientBinding applicationClientBinding = applicationClientFile.getBindings();
        this.printElement("jar-name", applicationClientFile.getURI());
        Iterator iterator3 = applicationClientBinding.getEjbRefs().iterator();
        if (iterator3.hasNext()) {
            this.startElement("ejb-ref-bindings", true);
            while (iterator3.hasNext()) {
                iterator2 = (EjbRefBinding)iterator3.next();
                this.exportEjbRef(iterator2.getBindingEjbRef().getName(), iterator2.getJndiName());
            }
            this.endElement("ejb-ref-bindings", true);
        }
        if ((iterator2 = applicationClientBinding.getResourceRefs().iterator()).hasNext()) {
            this.startElement("resource-ref-bindings", true);
            while (iterator2.hasNext()) {
                iterator = (ResourceRefBinding)iterator2.next();
                this.exportResourceRef(iterator.getBindingResourceRef().getName(), iterator.getJndiName());
            }
            this.endElement("resource-ref-bindings", true);
        }
        if ((iterator = applicationClientBinding.getResourceEnvRefBindings().iterator()).hasNext()) {
            this.startElement("resource-env-ref-bindings", true);
            while (iterator.hasNext()) {
                ResourceEnvRefBinding resourceEnvRefBinding = (ResourceEnvRefBinding)iterator.next();
                this.exportResourceEnvRef(resourceEnvRefBinding.getBindingResourceEnvRef().getName(), resourceEnvRefBinding.getJndiName());
            }
            this.endElement("resource-env-ref-bindings", true);
        }
        this.endElement("java-binding", true);
    }

    void printElement(String string, String string2) {
        this.startElement(string, false);
        this.out.print(string2);
        this.endElement(string, false);
    }

    void startElement(String string, boolean bl) {
        this.indent(1);
        if (bl) {
            this.out.println("<" + string + ">");
        } else {
            this.out.print("<" + string + ">");
        }
    }

    void endElement(String string, boolean bl) {
        if (bl) {
            this.indent();
        }
        this.out.println("</" + string + ">");
        --this.indentation;
    }

    void indent() {
        for (int i = 0; i < this.indentation; ++i) {
            this.out.print("  ");
        }
    }

    void indent(int n) {
        this.indentation += n;
        this.indent();
    }

    void indent(int n, boolean bl) {
        this.indentation += n;
        if (bl) {
            this.indent();
        }
    }

    void outdent(int n) {
        this.indentation -= n;
        this.indent();
    }
}

