/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.client;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.j2ee.commonarchivecore.ModuleRef;
import com.ibm.etools.webapplication.ServletMapping;
import com.ibm.etools.webapplication.WebApp;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import java.util.ArrayList;
import org.eclipse.emf.common.util.EList;

class ArchiveValidator {
    private static TraceComponent tc = Tr.register((Class)ArchiveValidator.class, (String)"Admin", (String)"com.ibm.ws.management.resources.AppDeploymentMessages");
    ModuleRef moduleRef;
    ArrayList msgs;

    public ArchiveValidator(ModuleRef moduleRef) {
        this.moduleRef = moduleRef;
        this.msgs = new ArrayList();
    }

    public void validate(boolean bl) throws AppDeploymentException {
        try {
            if (this.moduleRef.isWeb()) {
                WebApp webApp = (WebApp)this.moduleRef.getDeploymentDescriptor();
                EList eList = webApp.getServletMappings();
                for (int i = 0; i < eList.size(); ++i) {
                    String string;
                    ServletMapping servletMapping = (ServletMapping)eList.get(i);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("servlet map: " + servletMapping.getName() + " pat=" + servletMapping.getUrlPattern()));
                    }
                    if ((string = servletMapping.getUrlPattern()).indexOf("\r") == -1 && string.indexOf("\n") == -1) continue;
                    this.msgs.add("Invalid servlet mapping name:" + servletMapping.getName() + " as url pattern: " + servletMapping.getUrlPattern() + " has a newline character");
                }
                if (this.msgs.size() > 0) {
                    StringBuffer stringBuffer = new StringBuffer();
                    for (int i = 0; i < this.msgs.size(); ++i) {
                        stringBuffer.append("\n" + this.msgs.get(i));
                    }
                    throw new AppDeploymentException("WAR validation failed: " + stringBuffer.toString(), null);
                }
            }
        }
        catch (Throwable throwable) {
            if (throwable instanceof AppDeploymentException) {
                throw (AppDeploymentException)throwable;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Exception from validation:" + throwable));
            }
            throw new AppDeploymentException("Unexpected exception from validation: ", throwable);
        }
    }
}

