/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.client;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.application.Application;
import com.ibm.etools.application.WebModule;
import com.ibm.etools.commonarchive.CommonarchiveFactory;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.impl.CommonarchiveFactoryImpl;
import com.ibm.etools.j2ee.common.CommonPackage;
import com.ibm.etools.j2ee.common.DisplayName;
import com.ibm.etools.j2ee.common.XMLResource;
import com.ibm.etools.j2ee.commonarchivecore.Archive;
import com.ibm.etools.j2ee.commonarchivecore.ModuleFile;
import com.ibm.etools.j2ee.commonarchivecore.ModuleRef;
import com.ibm.etools.j2ee.commonarchivecore.exception.DuplicateObjectException;
import com.ibm.etools.j2ee.commonarchivecore.exception.OpenFailureException;
import com.ibm.etools.j2ee.commonarchivecore.helpers.ArchiveOptions;
import com.ibm.etools.j2ee.commonarchivecore.strategy.SaveStrategy;
import com.ibm.etools.j2ee.commonarchivecore.strategy.ZipStreamSaveStrategyImpl;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.application.AppConstants;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.client.AppDeploymentInfo;
import com.ibm.websphere.management.application.client.ArchiveDeploymentInfo;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.filetransfer.client.FileTransferClient;
import com.ibm.websphere.management.filetransfer.client.TransferFailedException;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.PartialDeploymentInfo;
import com.ibm.ws.management.application.client.ArchiveValidator;
import com.ibm.ws.management.fileservice.FileTransferFactory;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.ResourceBundle;

public class AppInstallHelper {
    private static TraceComponent tc = Tr.register((Class)AppInstallHelper.class, (String)"Admin", (String)"com.ibm.ws.management.resources.AppDeploymentMessages");
    public static final String STANDALONE_WEB_MARKER = "META-INF/was.webmodule";
    public static final String STANDALONE_EJB_MARKER = "META-INF/was.ejbmodule";
    private static final String MOF_PATH_SEPERATOR = "/";

    public static EARFile getEarFile(String string, boolean bl, ResourceBundle resourceBundle) throws AppDeploymentException {
        return AppInstallHelper.getEarFile(string, bl, false, resourceBundle);
    }

    public static EARFile getEarFile(String string, boolean bl, boolean bl2, ResourceBundle resourceBundle) throws AppDeploymentException {
        return (EARFile)AppInstallHelper.getArchive(string, bl, bl2, resourceBundle, true);
    }

    public static Archive getArchive(String string, boolean bl, boolean bl2, ResourceBundle resourceBundle, boolean bl3) throws AppDeploymentException {
        try {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)("getArchive " + string));
            }
            Object object = null;
            CommonarchiveFactory commonarchiveFactory = CommonarchiveFactoryImpl.getActiveFactory();
            ArchiveOptions archiveOptions = new ArchiveOptions();
            archiveOptions.setUseJavaReflection(bl);
            archiveOptions.setIsReadOnly(bl2);
            object = bl3 ? commonarchiveFactory.openEARFile(archiveOptions, string) : commonarchiveFactory.openArchive(archiveOptions, string);
            if (object instanceof EARFile && new File(string).isFile() && object.containsFile("META-INF/ibm-application-sa.props")) {
                throw new AppDeploymentException("This is an EAR file which is a system application.  The system application should always be installed from an expanded directory.", null);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("getArchive " + object));
            }
            return object;
        }
        catch (OpenFailureException openFailureException) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Throwing new AppDeploymentException from AppInstallHelper::getEarFile " + (Object)((Object)openFailureException)));
            }
            throw new AppDeploymentException("", openFailureException);
        }
    }

    public static AppDeploymentInfo getAppDeploymentInfo(String string, Hashtable hashtable) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getAppDeploymentInfo");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Archive is: " + string));
        }
        EARFile eARFile = null;
        try {
            Object object;
            eARFile = hashtable.get("earfile") != null ? (EARFile)hashtable.get("earfile") : AppInstallHelper.getEarFile(string, true, false, AppUtils.getBundle(hashtable));
            if (hashtable.get("jsr88") != null) {
                AppUtils.dbg(tc, "JSR88 - validate wars");
                object = eARFile.getWebModuleRefs();
                for (int i = 0; i < object.size(); ++i) {
                    ArchiveValidator archiveValidator = new ArchiveValidator((ModuleRef)object.get(i));
                    archiveValidator.validate(true);
                }
            }
            object = AppInstallHelper.getAppDeploymentInfo(eARFile, hashtable);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getAppDeploymentInfo");
            }
            return object;
        }
        catch (AppDeploymentException appDeploymentException) {
            if (eARFile != null) {
                eARFile.close();
            }
            throw appDeploymentException;
        }
    }

    public static AppDeploymentInfo getAppDeploymentInfo(EARFile eARFile) throws AppDeploymentException {
        return AppInstallHelper.getAppDeploymentInfo(eARFile, new Hashtable());
    }

    public static AppDeploymentInfo getAppDeploymentInfo(EARFile eARFile, Hashtable hashtable) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getAppDeploymentInfo");
        }
        ArchiveDeploymentInfo archiveDeploymentInfo = new ArchiveDeploymentInfo(eARFile, hashtable);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getAppDeploymentInfo");
        }
        return archiveDeploymentInfo;
    }

    public static AppDeploymentInfo getPartialDeploymentInfo(EARFile eARFile, Hashtable hashtable) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getPartialDeploymentInfo");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Archive is: " + eARFile));
        }
        PartialDeploymentInfo partialDeploymentInfo = new PartialDeploymentInfo(eARFile, hashtable);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getPartialDeploymentInfo");
        }
        return partialDeploymentInfo;
    }

    public static AppDeploymentInfo getAppDeploymentInfoForUpdate(String string, String string2, Hashtable hashtable, boolean bl) throws AppDeploymentException {
        if (bl) {
            return AppInstallHelper.getAppDeploymentInfo(string, hashtable);
        }
        try {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"getAppDeploymentInfoForUpdate");
            }
            File file = File.createTempFile("ibm-app", "wrap");
            String string3 = AppInstallHelper.createEarWrapper(string, file.getPath(), string2, (String)hashtable.get("contextroot"));
            hashtable.put("ibm.update.mod.path", string);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getAppDeploymentInfoForUpdate");
            }
            return AppInstallHelper.getAppDeploymentInfo(string3, hashtable);
        }
        catch (Throwable throwable) {
            if (throwable instanceof AppDeploymentException) {
                throw (AppDeploymentException)throwable;
            }
            throw new AppDeploymentException(null, throwable);
        }
    }

    public static AppDeploymentInfo getAppDeploymentInfoGenericRead(String string, String string2, Hashtable hashtable) throws AppDeploymentException {
        AppDeploymentInfo appDeploymentInfo;
        block11: {
            boolean bl;
            Archive archive;
            block9: {
                AppDeploymentInfo appDeploymentInfo2;
                block10: {
                    archive = null;
                    bl = false;
                    if (hashtable == null) {
                        hashtable = new Hashtable<String, String>();
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.entry((TraceComponent)tc, (String)"getAppDeploymentInfoGeneric");
                    }
                    if (!((archive = AppInstallHelper.getArchive(string, false, true, null, false)) instanceof EARFile)) break block9;
                    appDeploymentInfo2 = AppInstallHelper.getAppDeploymentInfo((EARFile)archive, hashtable);
                    Object var9_8 = null;
                    if (!bl || archive == null) break block10;
                    archive.close();
                }
                return appDeploymentInfo2;
            }
            try {
                File file = File.createTempFile("ibm-app", "wrap");
                String string3 = AppInstallHelper.createEarWrapper((ModuleFile)archive, file.getPath(), string2, (String)hashtable.get("contextroot"));
                hashtable.put("ibm.update.mod.path", string);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"getAppDeploymentInfoForUpdate");
                }
                appDeploymentInfo = AppInstallHelper.getAppDeploymentInfo(string3, hashtable);
                Object var9_9 = null;
                if (!bl || archive == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    bl = true;
                    if (throwable instanceof AppDeploymentException) {
                        throw (AppDeploymentException)throwable;
                    }
                    throw new AppDeploymentException(null, throwable);
                }
                catch (Throwable throwable2) {
                    block12: {
                        Object var9_10 = null;
                        if (!bl || archive == null) break block12;
                        archive.close();
                    }
                    throw throwable2;
                }
            }
            archive.close();
        }
        return appDeploymentInfo;
    }

    public static String createEarWrapper(String string, String string2, String string3) throws AppDeploymentException {
        return AppInstallHelper.createEarWrapper(string, string2, null, string3);
    }

    public static String createEarWrapper(String string, String string2, String string3, String string4) throws AppDeploymentException {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        if (string4 != null) {
            hashtable.put("contextroot", string4);
        }
        return AppInstallHelper.createEarWrapper(string, string2, string3, hashtable);
    }

    public static String createEarWrapper(String string, String string2, String string3, Hashtable hashtable) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createEarWrapper");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("moduleFile: " + string + ", earName: " + string2 + ", prefs: " + hashtable));
        }
        CommonarchiveFactory commonarchiveFactory = CommonarchiveFactoryImpl.getActiveFactory();
        ModuleFile moduleFile = null;
        try {
            moduleFile = (ModuleFile)commonarchiveFactory.openArchive(string);
            String string4 = AppInstallHelper.createEarWrapper(moduleFile, string2, string3, hashtable);
            return string4;
        }
        catch (OpenFailureException openFailureException) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Throwing new AppDeploymentException from AppInstallHelper::createEarWrapper:1 " + (Object)((Object)openFailureException)));
            }
            throw new AppDeploymentException("", openFailureException);
        }
        finally {
            if (moduleFile != null) {
                moduleFile.close();
            }
        }
    }

    public static String createEarWrapper(ModuleFile moduleFile, String string, String string2, String string3) throws AppDeploymentException {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        if (string3 != null) {
            hashtable.put("contextroot", string3);
        }
        return AppInstallHelper.createEarWrapper(moduleFile, string, string2, hashtable);
    }

    public static String createEarWrapper(ModuleFile moduleFile, String string, String string2, Hashtable hashtable) throws AppDeploymentException {
        String string3;
        block38: {
            String string4;
            block37: {
                DisplayName displayName;
                Object object;
                if (!(moduleFile.isEJBJarFile() || moduleFile.isWARFile() || moduleFile.isApplicationClientFile() || moduleFile.isRARFile())) {
                    throw new AppDeploymentException(AppUtils.getMessage(AppUtils.getBundle(null), "ADMA0084E", new String[]{moduleFile.getURI()}), null);
                }
                String string5 = hashtable != null ? (String)hashtable.get("contextroot") : null;
                CommonarchiveFactory commonarchiveFactory = CommonarchiveFactoryImpl.getActiveFactory();
                string3 = string;
                if (string3 == null) {
                    object = new File(moduleFile.getURI());
                    string3 = ((File)object).getName().replace('.', '_') + ".ear";
                    if (((File)object).getParent() != null) {
                        string3 = ((File)object).getParent() + (((File)object).getParent().endsWith(File.separator) ? "" : File.separator) + string3;
                    }
                }
                if (((String)(object = string3.substring(string3.lastIndexOf(File.separator) + 1, string3.length()))).lastIndexOf(".") > 0) {
                    object = ((String)object).substring(0, ((String)object).lastIndexOf("."));
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("earFileName: " + string3 + ", appDisplayName: " + (String)object));
                }
                EARFile eARFile = commonarchiveFactory.createEARFileInitialized(string3);
                Application application = eARFile.getDeploymentDescriptor();
                try {
                    ((XMLResource)application.eResource()).setVersionID(((XMLResource)moduleFile.getDeploymentDescriptorResource()).getVersionID());
                }
                catch (Throwable throwable) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Exception getting version of old module file: " + throwable));
                    }
                    ((XMLResource)application.eResource()).setVersionID(14);
                }
                if (((XMLResource)application.eResource()).getVersionID() < 14) {
                    application.setDisplayName((String)object);
                } else {
                    displayName = CommonPackage.eINSTANCE.getCommonFactory().createDisplayName();
                    displayName.setValue((String)object);
                    application.getDisplayNames().add((Object)displayName);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Ear file opened and display name of app is set.");
                }
                displayName = null;
                String string6 = string2;
                if (string6 == null) {
                    string6 = new File(moduleFile.getURI()).getName();
                }
                try {
                    displayName = eARFile.addCopyRef(moduleFile);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Added copy of module file to the ear.");
                    }
                }
                catch (DuplicateObjectException duplicateObjectException) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Throwing new AppDeploymentException from AppInstallHelper::createEarWrapper:2 " + (Object)((Object)duplicateObjectException)));
                    }
                    throw new AppDeploymentException("", duplicateObjectException);
                }
                displayName.setURI(string6);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("New URI for module file is set to " + string6));
                }
                try {
                    if (displayName.isWeb()) {
                        if (string5 == null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Null Context root. Setting to /");
                            }
                            string5 = MOF_PATH_SEPERATOR;
                        }
                        ((WebModule)displayName.getModule()).setContextRoot(string5);
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"New context root for web module set.");
                        }
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Module is not a web module, so can not set context root.");
                    }
                }
                catch (Exception exception) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Throwing new AppDeploymentException from AppInstallHelper::createEarWrapper:3 " + exception));
                    }
                    throw new AppDeploymentException("", exception);
                }
                ClassLoader classLoader = AppInstallHelper.class.getClassLoader();
                InputStream inputStream = classLoader.getResourceAsStream("was.policy");
                String string7 = null;
                if (inputStream != null) {
                    string7 = ArchiveDeploymentInfo.saveAsFile(eARFile, null, "META-INF/was.policy", inputStream);
                }
                String string8 = displayName.isWeb() ? STANDALONE_WEB_MARKER : STANDALONE_EJB_MARKER;
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string8.getBytes());
                string4 = ArchiveDeploymentInfo.saveAsFile(eARFile, null, string8, byteArrayInputStream);
                eARFile.rollUpRoles();
                SaveStrategy saveStrategy = eARFile.getSaveStrategy();
                try {
                    eARFile.save((SaveStrategy)new ZipStreamSaveStrategyImpl((OutputStream)new FileOutputStream(string3)));
                }
                catch (Exception exception) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Throwing new AppDeploymentException from AppInstallHelper::createEarWrapper:4 " + exception));
                    }
                    throw new AppDeploymentException("", exception);
                }
                moduleFile.close();
                eARFile.close();
                if (string7 != null) {
                    try {
                        AppUtils.deleteDirTree(string7);
                    }
                    catch (IOException iOException) {
                        if (!tc.isDebugEnabled()) break block37;
                        Tr.debug((TraceComponent)tc, (String)("Error deleting temp dir: " + string7 + "," + iOException));
                    }
                }
            }
            if (string4 != null) {
                try {
                    AppUtils.deleteDirTree(string4);
                }
                catch (IOException iOException) {
                    if (!tc.isDebugEnabled()) break block38;
                    Tr.debug((TraceComponent)tc, (String)("Error deleting temp dir: " + string4 + "," + iOException));
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createEarWrapper");
        }
        return string3;
    }

    public static Hashtable createDefaultDeployEJBOptions() {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("deployejb.codegen", AppConstants.APPDEPL_DEPLOYEJB_CODEGEN_OPTION_DEFAULT);
        hashtable.put("deployejb.validate", AppConstants.APPDEPL_DEPLOYEJB_VALIDATE_OPTION_DEFAULT);
        hashtable.put("deployejb.rmic", "");
        hashtable.put("deployejb.dbtype", AppConstants.APPDEPL_DEPLOYEJB_DBTYPE_OPTION_DEFAULT);
        hashtable.put("deployejb.dbname", "");
        hashtable.put("deployejb.dbschema", "");
        hashtable.put("deployejb.classpath", "");
        return hashtable;
    }

    public static String getAppDisplayName(EARFile eARFile, Hashtable hashtable) {
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getAppDisplayName");
        }
        if ((string = eARFile.getDeploymentDescriptor().getDisplayName()) == null || string.trim().length() == 0) {
            int n;
            String string2 = (String)hashtable.get("app.original.uri");
            if (string2 == null || string2.trim().length() == 0) {
                string2 = eARFile.getURI();
            }
            if ((n = (string = new File(string2).getName()).lastIndexOf(46)) > 0) {
                string = string.substring(0, n);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getAppDisplayName - " + string));
        }
        return string;
    }

    public static String copyToServer(AdminClient adminClient, String string) throws TransferFailedException, AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("copyToServer: " + string));
        }
        FileTransferClient fileTransferClient = FileTransferFactory.getFileTransferClient((AdminClient)adminClient);
        File file = new File(string);
        String string2 = fileTransferClient.getServerStagingLocation();
        String string3 = File.separator;
        if (string2 != null) {
            string3 = string2.indexOf(MOF_PATH_SEPERATOR) >= 0 ? MOF_PATH_SEPERATOR : "\\";
        }
        String string4 = "upload" + string3 + Long.toHexString(System.currentTimeMillis()) + file.getName();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("targetName: " + string4));
        }
        fileTransferClient.uploadFile(file, string4);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Staging location: " + string2));
        }
        if (!string2.endsWith(MOF_PATH_SEPERATOR) && !string2.endsWith("\\")) {
            string2 = string2 + string3;
        }
        String string5 = string2 + string4;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("copyToServer: " + string5));
        }
        return string5;
    }
}

