/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.client;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.application.EditionHelper;
import com.ibm.websphere.management.application.client.AppDeploymentController;
import com.ibm.websphere.management.application.client.AppDeploymentProfile;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.client.util;
import java.text.MessageFormat;
import java.util.Vector;

public class AppDeploymentOptions
extends AppDeploymentTask {
    private static final long serialVersionUID = -8352120549891343541L;
    private static TraceComponent tc = Tr.register((Class)AppDeploymentOptions.class, (String)"Admin", (String)"com.ibm.ws.management.resources.AppDeploymentMessages");
    public static final String TaskName = "AppDeploymentOptions";

    public AppDeploymentOptions(AppDeploymentController appDeploymentController) {
        super(appDeploymentController);
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)TaskName);
        }
        this.name = TaskName;
        long l = appDeploymentController.getDeploymentMode();
        Vector vector = AppDeploymentProfile.getProfile(l);
        this.colNames = new String[vector.size()];
        this.mutables = new boolean[vector.size()];
        this.requiredColumns = new boolean[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            AppDeploymentProfile.DeplOption deplOption = (AppDeploymentProfile.DeplOption)vector.elementAt(i);
            this.colNames[i] = deplOption.name;
            this.mutables[i] = (deplOption.mutable & l) != 0L;
            this.requiredColumns[i] = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)TaskName);
        }
    }

    public boolean isEJBDeployEnabled() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isEJBDeployEnabled");
        }
        if (this.taskData == null || this.isTaskEmpty) {
            return false;
        }
        for (int i = 0; i < this.colNames.length; ++i) {
            if (!this.taskData[0][i].equals("deployejb")) continue;
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("isEJBDeployEnabled: " + "AppDeploymentOption.Yes".equals(this.taskData[1][i])));
            }
            return "AppDeploymentOption.Yes".equals(this.taskData[1][i]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"isEJBDeployEnabled: no col found");
        }
        return false;
    }

    public boolean isWSDeployEnabled() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isWSDeployEnabled");
        }
        if (this.taskData == null || this.isTaskEmpty) {
            return false;
        }
        for (int i = 0; i < this.colNames.length; ++i) {
            if (!this.taskData[0][i].equals("deployws")) continue;
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("isWSDeployEnabled: " + "AppDeploymentOption.Yes".equals(this.taskData[1][i])));
            }
            return "AppDeploymentOption.Yes".equals(this.taskData[1][i]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"isWSDeployEnabled: no col found");
        }
        return false;
    }

    public boolean isPreCompileJSPEnabled() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isPreCompileJSPEnabled");
        }
        boolean bl = false;
        if (this.taskData == null || this.isTaskEmpty) {
            return bl;
        }
        for (int i = 0; i < this.colNames.length; ++i) {
            if (!this.taskData[0][i].equals("preCompileJSPs")) continue;
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("isPreCompileJSPEnabled: " + "AppDeploymentOption.Yes".equals(this.taskData[1][i])));
            }
            return "AppDeploymentOption.Yes".equals(this.taskData[1][i]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("isPreCompileJSPEnabled - " + bl));
        }
        return bl;
    }

    public boolean isUseBinaryConfigEnabled() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isUseBinaryConfigEnabled");
        }
        if (this.taskData == null || this.isTaskEmpty) {
            return false;
        }
        for (int i = 0; i < this.colNames.length; ++i) {
            if (!this.taskData[0][i].equals("useMetaDataFromBinary")) continue;
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("isUseBinaryConfigEnabled: " + "AppDeploymentOption.Yes".equals(this.taskData[1][i])));
            }
            return "AppDeploymentOption.Yes".equals(this.taskData[1][i]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"isUseBinaryConfigEnabled: no col found");
        }
        return false;
    }

    public boolean isProcessEmbeddedCFG() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isUseBinaryConfigEnabled");
        }
        if (this.taskData == null || this.isTaskEmpty) {
            return false;
        }
        for (int i = 0; i < this.colNames.length; ++i) {
            if (!this.taskData[0][i].equals("processEmbeddedConfig")) continue;
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("isProcessEmbeddedCFG: " + "AppDeploymentOption.Yes".equals(this.taskData[1][i])));
            }
            return "AppDeploymentOption.Yes".equals(this.taskData[1][i]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"isProcessEmbeddedCFG: no col found");
        }
        return false;
    }

    public String[] validate() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"validate");
        }
        Vector<String> vector = new Vector<String>();
        this.taskValidateErrorMessages = null;
        if (this.taskData == null || this.taskData.length < 2) {
            return this.taskValidateErrorMessages;
        }
        for (int i = 0; i < this.taskData[0].length; ++i) {
            String string;
            String string2;
            if ("appname".equals(this.taskData[0][i])) {
                if (!ConfigServiceHelper.checkIfNameValid(this.taskData[1][i])) {
                    string2 = MessageFormat.format(util.getMessage(this, "ADMA0085E"), util.getGoalTitle(this, this.name), this.taskData[1][i]);
                    vector.addElement(string2);
                    this.buildErrorMessages(vector);
                }
            } else if ("edition".equals(this.taskData[0][i]) && !AppUtils.isEmpty(this.taskData[1][i])) {
                if (!EditionHelper.checkIfEditionValid(this.taskData[1][i])) {
                    string2 = MessageFormat.format(util.getMessage(this, "ADMA0140E"), util.getGoalTitle(this, this.name), this.taskData[1][i]);
                    vector.addElement(string2);
                    this.buildErrorMessages(vector);
                }
            } else if ("reloadInterval".equals(this.taskData[0][i]) && !AppUtils.isEmpty(this.taskData[1][i])) {
                try {
                    Long.parseLong(this.taskData[1][i]);
                }
                catch (NumberFormatException numberFormatException) {
                    string = MessageFormat.format(util.getMessage(this, "ADMA7100E"), util.getGoalTitle(this, this.name), this.taskData[1][i]);
                    vector.addElement(string);
                    this.buildErrorMessages(vector);
                }
            }
            if (!"validateinstall".equals(this.taskData[0][i]) || (string2 = this.taskData[1][i]).equals("off") || string2.equals("warn") || string2.equals("fail")) continue;
            string = MessageFormat.format(util.getMessage(this, "ADMA0109W"), this.taskData[1][i]);
            vector.addElement(string);
            this.buildErrorMessages(vector);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"validate");
        }
        return this.taskValidateErrorMessages;
    }
}

