/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.application.AppManagement;
import com.ibm.websphere.management.application.AppNotification;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.DefaultTaskProvider;
import com.ibm.ws.management.application.EditApplication;
import com.ibm.ws.management.application.ExtensionHelper;
import com.ibm.ws.management.application.SchedulerImpl;
import java.util.Hashtable;
import java.util.Vector;

public class UninstallSchedulerImpl
extends SchedulerImpl {
    private static TraceComponent tc = Tr.register((Class)UninstallSchedulerImpl.class, (String)"Admin", (String)"com.ibm.ws.management.resources.AppDeploymentMessages");

    public UninstallSchedulerImpl(String string, Hashtable hashtable, AppManagement appManagement, AppNotification.Listener listener) {
        super(string, hashtable, appManagement, listener);
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"UninstallSchedulerImpl");
        }
        this.appTaskName = "UninstallApplication";
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"UninstallSchedulerImpl");
        }
    }

    protected void setupTasks() throws Exception {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setupTasks");
        }
        Object object2 = null;
        try {
            object = new EditApplication(this.appName, this.properties, null, this.getWorkSpace().getUserName(), this.appManagement);
            object2 = ((EditApplication)object).checkIfAppExists();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("App " + this.appName + " exists: " + object2));
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.application.UninstallSchedulerImpl.setupTasks", (String)"80", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Exception in checking app existence: " + this.appName));
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)throwable.toString());
            }
            if (this.resBundle != null) {
                throw new AdminException(throwable, AppUtils.getMessage(this.resBundle, "ADMA0054E", new Object[]{this.appName}));
            }
            throw new AdminException(throwable);
        }
        if (object2 == null) {
            object = AppUtils.getMessage(this.resBundle, "ADMA5108E", new String[]{this.appName});
            throw new AdminException((String)object);
        }
        boolean bl = this.appName.equals(object2);
        if (bl) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Detected system app uninstall: " + this.appName));
            }
            if (this.getProperties().get("cell.name") == null) {
                throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0125", new String[]{this.appName}));
            }
            if (this.getProperties().get("node.name") == null) {
                throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0126", new String[]{this.appName}));
            }
            this.getProperties().put("META-INF/ibm-application-sa.props", Boolean.TRUE);
        }
        this.tasks = new Vector();
        new DefaultTaskProvider().provideServerUninstallExtensions(this.tasks, this);
        if (!bl) {
            ExtensionHelper.processServerUninstallExtensions(this.properties, this.tasks, this);
        }
        Tr.debug((TraceComponent)tc, (String)("The tasks are: " + this.tasks));
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setupTasks");
        }
    }

    protected String getJMXEventType() {
        return "websphere.admin.appmgmt.uninstall";
    }

    protected AppNotification createCompletionEvent(boolean bl) {
        String string = "";
        if (this.resBundle != null) {
            string = AppUtils.getMessage(this.resBundle, bl ? "ADMA5106I" : "ADMA5107E", new String[]{this.appName});
        }
        AppNotification appNotification = new AppNotification("UninstallApplication", "", bl ? "Completed" : "Failed", "", string);
        return appNotification;
    }

    protected AppNotification createStartEvent() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createStartEvent");
        }
        String string = "";
        if (this.resBundle != null) {
            string = AppUtils.getMessage(this.resBundle, "ADMA5017I", new String[]{this.appName});
        }
        AppNotification appNotification = new AppNotification("UninstallApplication", "", "InProgress", "", string);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createStartEvent");
        }
        return appNotification;
    }

    protected void performCleanup(boolean bl) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"performCleanup");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"performCleanup");
        }
    }
}

