/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.websphere.management.application.AppManagement;
import com.ibm.websphere.management.application.AppManagementHelper;
import com.ibm.websphere.management.application.AppNotification;
import com.ibm.websphere.management.application.EditionHelper;
import com.ibm.websphere.management.application.InstallScheduler;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.ArchiveSchedulerImpl;
import com.ibm.ws.management.application.DefaultTaskProvider;
import com.ibm.ws.management.application.ExtensionHelper;
import com.ibm.ws.management.application.client.AppInstallHelper;
import com.ibm.ws.management.application.task.ConfigRepoHelper;
import com.ibm.ws.sm.workspace.RepositoryContext;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class InstallSchedulerImpl
extends ArchiveSchedulerImpl
implements InstallScheduler {
    private static TraceComponent tc = Tr.register((Class)InstallSchedulerImpl.class, (String)"Admin", (String)"com.ibm.ws.management.resources.AppDeploymentMessages");

    public InstallSchedulerImpl(String string, String string2, Hashtable hashtable, AppManagement appManagement, AppNotification.Listener listener) {
        super(string, string2, hashtable, appManagement, listener);
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"InstallSchedulerImpl");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Ear: " + string + ", appName: " + string2 + ", options: " + hashtable));
        }
        this.appTaskName = "InstallApplication";
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Uniquie id: " + this.id));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"InstallSchedulerImpl");
        }
    }

    public String getEarPath() {
        return this.getArchivePath();
    }

    public void setEarPath(String string) throws AdminException {
        this.setArchivePath(string);
    }

    public EARFile getEarFile() throws AdminException {
        return (EARFile)this.getArchive(false, false);
    }

    public EARFile getEarFile(boolean bl, boolean bl2) throws AdminException {
        return (EARFile)this.getArchive(bl, bl2);
    }

    protected String getJMXEventType() {
        return "websphere.admin.appmgmt.install";
    }

    protected AppNotification createStartEvent() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createStartEvent");
        }
        String string = "";
        if (this.resBundle != null) {
            string = AppUtils.getMessage(this.resBundle, "ADMA5016I", new String[]{this.appName});
        }
        AppNotification appNotification = new AppNotification("InstallApplication", "", "InProgress", "", string);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createStartEvent");
        }
        return appNotification;
    }

    protected AppNotification createCompletionEvent(boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createCompletionEvent");
        }
        String string = "";
        if (this.resBundle != null) {
            string = AppUtils.getMessage(this.resBundle, bl ? "ADMA5013I" : ("app".equals(this.getProperties().get("contenttype")) ? "ADMA5069E" : "ADMA5014E"), new String[]{this.appName});
        }
        AppNotification appNotification = new AppNotification("InstallApplication", "", bl ? "Completed" : "Failed", "", string);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createCompletionEvent");
        }
        return appNotification;
    }

    protected void setupTasks() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setupTasks");
        }
        this.updateAppAndCellName();
        RepositoryContext repositoryContext = AppUtils.findAppContextFromConfig(this.getAppName(), this.getWorkSpace(), this.getProperties());
        if (repositoryContext != null) {
            throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA5015E", new String[]{this.appName}));
        }
        boolean bl = AppManagementHelper.isSystemApp(this.getEarPath());
        if (bl) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Detected system app install: " + bl));
            }
            if (this.getProperties().get("cell.name") == null) {
                throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0125E", new String[]{this.appName}));
            }
            if (this.getProperties().get("node.name") == null) {
                throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0126E", new String[]{this.appName}));
            }
            if (this.getProperties().get("server.name") == null) {
                throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0127E", new String[]{this.appName}));
            }
            this.getProperties().put("META-INF/ibm-application-sa.props", Boolean.TRUE);
        }
        this.tasks = new Vector();
        new DefaultTaskProvider().provideServerInstallExtensions(this.tasks, this);
        if (!bl) {
            ExtensionHelper.processServerInstallExtensions(this.properties, this.tasks, this);
        }
        AppUtils.dbg(tc, AppUtils.getMessage(this.resBundle, "ADMA6010I", new Object[]{this.tasks}));
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setupTasks");
        }
    }

    private void updateAppAndCellName() throws Exception {
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"updateAppAndCellName");
        }
        if (this.appName == null) {
            this.appName = (String)this.getProperties().get("appname");
            if (AppUtils.isEmpty(this.appName)) {
                this.appName = AppInstallHelper.getAppDisplayName(this.getEarFile(false, true), this.properties);
            }
            if (this.appName != null) {
                this.appName = this.appName.trim();
            }
        }
        if (!ConfigServiceHelper.checkIfNameValid(this.appName)) {
            throw new AdminException(null, AppUtils.getMessage(this.resBundle, "ADMA5019E", new Object[]{this.appName}));
        }
        if (EditionHelper.isEditionSupportEnabled()) {
            if (this.appName.indexOf("-edition") != -1) {
                throw new AdminException(null, "AppName can not contain -edition.  Invalid app name: " + this.appName);
            }
            string = (String)this.getProperties().get("edition");
            if (string != null && !(string instanceof String)) {
                throw new AdminException(null, "Edition must be a string: " + string);
            }
        }
        string = null;
        Hashtable hashtable = (Hashtable)this.getProperties().get("moduleToServer");
        if (hashtable == null) {
            hashtable = new Hashtable();
            this.getProperties().put("moduleToServer", hashtable);
        }
        Iterator iterator = hashtable.values().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "+");
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken().trim();
                if (AppUtils.isEmpty(string3)) continue;
                ObjectName objectName = null;
                try {
                    objectName = new ObjectName(string3);
                    string = objectName.getKeyProperty("cell");
                    if (string == null) continue;
                    break;
                }
                catch (MalformedObjectNameException malformedObjectNameException) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Bad token: " + string3));
                    }
                    throw new AdminException(malformedObjectNameException, AppUtils.getMessage(AppUtils.getBundle(null), "ADMA5025E", new Object[]{string3}));
                }
            }
            if (string == null) continue;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("cellName " + string));
        }
        if (string != null) {
            this.getProperties().put("cell.name", string);
        }
        if ((string = (String)this.getProperties().get("cell.name")) == null) {
            throw new AdminException(null, AppUtils.getMessage(this.resBundle, "ADMA5046E", new Object[0]));
        }
        this.cellContext = AppUtils.findContext("cells", string, null, null, this.getWorkSpace(), true);
        if (this.cellContext == null) {
            throw new AdminException(null, AppUtils.getMessage(this.resBundle, "ADMA0128E", new String[]{this.appName}));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("updateAppAndCellName:" + this.appName + ", " + string));
        }
    }

    protected void performCleanup(boolean bl) throws Exception {
        super.performCleanup(bl);
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"performCleanup");
        }
        if (!this.setupDone || bl) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"performCleanup:  nosetupDone or success");
            }
            return;
        }
        RepositoryContext repositoryContext = AppUtils.findAppContextFromConfig(this.getAppName(), this.getWorkSpace(), this.getProperties());
        RepositoryContext repositoryContext2 = null;
        try {
            if (repositoryContext != null && repositoryContext.isAvailable("deployment.xml")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Install failed. Found deployment.xml");
                }
                ApplicationDeployment applicationDeployment = ConfigRepoHelper.getAppDeploymentForApp(repositoryContext);
                Vector vector = ConfigRepoHelper.getServersForAppDeployment(applicationDeployment, null, this.getCellContext(), this.getWorkSpace(), false);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("App was to be installed on: " + vector));
                }
                Hashtable hashtable = ConfigRepoHelper.updateServerIndexDocs(repositoryContext, this.getWorkSpace(), vector, false, this.resBundle);
                this.getProperties().remove("nodesvr.added");
                this.getProperties().remove("nodesvr.removed");
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Removed entry from: " + hashtable));
                }
            }
        }
        catch (Throwable throwable) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Exception in cleaning SI entry: " + throwable));
            }
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.application.InstallSchedulerImpl.performCleanup", (String)"405", (Object)this);
        }
        if (repositoryContext != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Deleting application ctx " + repositoryContext + " after install failed."));
            }
            repositoryContext2 = repositoryContext.getParent();
            repositoryContext.delete(true);
        }
        if (repositoryContext2 != null && repositoryContext2.getChildren().size() == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Deleting backup ctx " + repositoryContext2 + " after install failed."));
            }
            repositoryContext2.delete(true);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"performCleanup");
        }
    }
}

