/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application;

import com.ibm.ejs.models.base.bindings.applicationbnd.ApplicationBinding;
import com.ibm.ejs.models.base.bindings.applicationbnd.AuthorizationTable;
import com.ibm.ejs.models.base.bindings.applicationbnd.RoleAssignment;
import com.ibm.ejs.models.base.bindings.applicationbnd.RunAsBinding;
import com.ibm.ejs.models.base.bindings.applicationbnd.Subject;
import com.ibm.ejs.models.base.bindings.commonbnd.AbstractAuthData;
import com.ibm.ejs.models.base.bindings.commonbnd.BasicAuthData;
import com.ibm.ejs.models.base.bindings.ejbbnd.EJBBindingsHelper;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.EJBJarFile;
import com.ibm.etools.commonarchive.impl.CommonarchiveFactoryImpl;
import com.ibm.etools.commonarchive.util.ArchiveInit;
import com.ibm.etools.ejb.EJBJar;
import com.ibm.etools.j2ee.common.XMLResource;
import com.ibm.etools.j2ee.commonarchivecore.Container;
import com.ibm.etools.j2ee.commonarchivecore.File;
import com.ibm.etools.j2ee.commonarchivecore.ModuleFile;
import com.ibm.etools.j2ee.commonarchivecore.ModuleRef;
import com.ibm.etools.webapplication.WebApp;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.application.AppManagement;
import com.ibm.websphere.management.application.AppManagementFactory;
import com.ibm.websphere.management.application.EarUtils;
import com.ibm.websphere.management.application.EditionHelper;
import com.ibm.websphere.management.application.EditionInfo;
import com.ibm.websphere.management.application.client.AppDeploymentController;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.models.config.appcfg.AppcfgFactory;
import com.ibm.websphere.models.config.appcfg.AppcfgPackage;
import com.ibm.websphere.models.config.appcfg.impl.AppcfgPackageImpl;
import com.ibm.websphere.models.config.appdeployment.AppdeploymentFactory;
import com.ibm.websphere.models.config.appdeployment.AppdeploymentPackage;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.websphere.models.config.appdeployment.impl.AppdeploymentPackageImpl;
import com.ibm.websphere.models.config.init.ConfigInit;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.application.AppManagementImpl;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.EditSchedulerImpl;
import com.ibm.ws.management.application.client.AppInstallHelper;
import com.ibm.ws.management.application.client.ListModules;
import com.ibm.ws.management.application.client.util;
import com.ibm.ws.management.application.task.ConfigRepoHelper;
import com.ibm.ws.management.application.task.SetApplicationInfoTask;
import com.ibm.ws.management.configarchive.EnhancedEarConfigurator;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.management.AttributeList;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EPackage;

public class EditApplication {
    public static final String TableDDL = "META-INF/Table.ddl";
    public static final String BackendDir = "META-INF/backends/";
    private static AppdeploymentFactory appFactory = null;
    private static AppcfgFactory appCfgFactory = null;
    private String appName;
    private Hashtable prefs;
    private String uniqueModuleURI;
    private String workspaceID;
    private AppManagement appM;
    boolean isApp = false;
    ResourceBundle resBundle = null;
    private static TraceComponent tc = Tr.register((Class)EditApplication.class, null, (String)"com.ibm.ws.management.resources.AppDeploymentMessages");
    static /* synthetic */ Class class$java$util$Properties;

    private static AppdeploymentFactory getAppFactory() {
        if (appFactory != null) {
            return appFactory;
        }
        ArchiveInit.init();
        CommonarchiveFactoryImpl.getActiveFactory();
        ConfigInit.init();
        AppdeploymentPackageImpl.init();
        AppdeploymentPackage appdeploymentPackage = (AppdeploymentPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/appdeployment.xmi");
        appFactory = appdeploymentPackage.getAppdeploymentFactory();
        return appFactory;
    }

    private static AppcfgFactory getAppcfgFactory() {
        if (appCfgFactory != null) {
            return appCfgFactory;
        }
        ArchiveInit.init();
        CommonarchiveFactoryImpl.getActiveFactory();
        ConfigInit.init();
        AppcfgPackageImpl.init();
        AppcfgPackage appcfgPackage = (AppcfgPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/appcfg.xmi");
        appCfgFactory = appcfgPackage.getAppcfgFactory();
        return appCfgFactory;
    }

    public EditApplication(String string, Hashtable hashtable, String string2, String string3, AppManagement appManagement) {
        this.appName = string;
        this.prefs = hashtable;
        this.uniqueModuleURI = string2;
        this.workspaceID = string3;
        this.appM = appManagement;
        if (this.prefs == null) {
            this.prefs = new Hashtable();
        }
        this.isApp = this.uniqueModuleURI == null;
        this.resBundle = AppUtils.getBundle(this.prefs);
    }

    private void doFinally(WorkSpace workSpace, EARFile eARFile, boolean bl) {
        EditApplication.doFinally(workSpace, this.workspaceID, eARFile, bl);
    }

    public static void doFinally(WorkSpace workSpace, String string, EARFile eARFile, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("doFinally: " + bl));
        }
        if (eARFile != null) {
            eARFile.close();
        }
        if (workSpace != null && string == null) {
            try {
                ConfigRepoHelper.removeWorkSpace(bl, workSpace);
            }
            catch (Throwable throwable) {
                Tr.warning((TraceComponent)tc, (String)"ADMA0077W", (Object)throwable);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"doFinally");
        }
    }

    public Object checkIfAppExists() throws AdminException {
        Tr.entry((TraceComponent)tc, (String)("checkIfAppExists: " + this.appName));
        if (this.appName == null) {
            throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0045E"));
        }
        WorkSpace workSpace = null;
        try {
            workSpace = ConfigRepoHelper.getWorkSpace(this.workspaceID);
            RepositoryContext repositoryContext = AppUtils.findAppContextFromConfig(this.appName, workSpace, this.prefs);
            Tr.debug((TraceComponent)tc, (String)("App " + this.appName + " exists: " + repositoryContext));
            if (repositoryContext != null) {
                Tr.exit((TraceComponent)tc, (String)"checkIfAppExists");
                RepositoryContext repositoryContext2 = repositoryContext;
                return repositoryContext2;
            }
            if (AppUtils.isAnInstalledSystemApp(this.appName, workSpace, this.prefs, false)) {
                String string = this.appName;
                return string;
            }
            Object var3_6 = null;
            return var3_6;
        }
        catch (Throwable throwable) {
            if (throwable instanceof AdminException) {
                throw (AdminException)((Object)throwable);
            }
            throw new AdminException(throwable, "");
        }
        finally {
            EditApplication.doFinally(workSpace, this.workspaceID, null, false);
        }
    }

    public Vector getApplicationInfo() throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getApplicationInfo:" + this.appName + ", " + this.uniqueModuleURI));
        }
        if (this.appName == null) {
            throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0016E"));
        }
        Vector<AppDeploymentTask> vector = new Vector<AppDeploymentTask>();
        WorkSpace workSpace = null;
        EARFile eARFile = null;
        try {
            ConfigService configService;
            workSpace = ConfigRepoHelper.getWorkSpace(this.workspaceID);
            RepositoryContext repositoryContext = AppUtils.findAppContextFromConfig(this.appName, workSpace, this.prefs);
            if (repositoryContext == null) {
                throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0017E", new Object[]{this.appName}));
            }
            if (this.uniqueModuleURI == null) {
                this.prefs.put("EditAppOnly", "");
            } else {
                this.prefs.put("EditModuleOnly", this.uniqueModuleURI);
            }
            this.prefs.put("configsession", new Session(workSpace.getUserName(), true));
            if (AppManagementImpl.isLocalMode()) {
                configService = EditApplication.getLocalConfigService();
                if (configService != null) {
                    this.prefs.put("configservice", configService);
                }
            } else if (AdminServiceFactory.getAdminService() != null) {
                this.prefs.put("configservice", ConfigServiceFactory.getConfigService());
            }
            eARFile = (configService = ConfigRepoHelper.getAppDeploymentForApp(repositoryContext)).isUseMetadataFromBinaries() ? ConfigRepoHelper.getEarFileFromBinaries(repositoryContext, workSpace, this.resBundle, null) : ConfigRepoHelper.getEarFileFromDeployment(workSpace, repositoryContext);
            this.prefs.put("ClientVersion", AppUtils.getClientVersion());
            AppDeploymentController appDeploymentController = AppManagementFactory.readPartialArchive(eARFile, this.prefs);
            appDeploymentController.getAppOptions().put("cell.name", repositoryContext.getParent().getParent().getName());
            appDeploymentController.getAppOptions().put("appname", this.appName);
            appDeploymentController.getAppOptions().put("edit.deplresource", configService.eResource());
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Created partial controller: " + appDeploymentController));
            }
            AppDeploymentTask appDeploymentTask = appDeploymentController.getFirstTask();
            while (appDeploymentTask != null) {
                vector.add(appDeploymentTask);
                appDeploymentTask = appDeploymentController.getNextTask();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Read tasks from controller: " + vector.size()));
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getApplicationInfo");
            }
            Vector<AppDeploymentTask> vector2 = vector;
            this.doFinally(workSpace, eARFile, false);
            return vector2;
        }
        catch (Throwable throwable) {
            try {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.application.EditApplication.getApplicationInfo", (String)"354", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Exception thrown in getApplicationInfo: " + throwable));
                }
                if (throwable instanceof AdminException) {
                    throw (AdminException)((Object)throwable);
                }
                throw new AdminException(throwable, "");
            }
            catch (Throwable throwable2) {
                this.doFinally(workSpace, eARFile, false);
                throw throwable2;
            }
        }
    }

    public void setApplicationInfo(Vector vector) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("setApplicationInfo: " + this.appName + ", " + this.uniqueModuleURI));
        }
        if (this.appName == null) {
            throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0016E"));
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            EditSchedulerImpl editSchedulerImpl = new EditSchedulerImpl(this.appName, this.prefs, this.appM, vector, this.uniqueModuleURI);
            editSchedulerImpl.setWorkSpaceID(this.workspaceID);
            editSchedulerImpl.run();
            if (editSchedulerImpl.getLastEx() != null) {
                throw editSchedulerImpl.getLastEx();
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.application.EditApplication.setApplicationInfo", (String)"423", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Exception thrown in setApplicationInfo: " + throwable));
            }
            if (throwable instanceof AdminException) {
                throw (AdminException)((Object)throwable);
            }
            throw new AdminException(throwable, "");
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    /*
     * Loose catch block
     */
    public void exportApplication(String string) throws AdminException {
        block28: {
            EnhancedEarConfigurator enhancedEarConfigurator;
            String string2;
            EARFile eARFile;
            WorkSpace workSpace;
            block26: {
                block25: {
                    Object object;
                    if (tc.isEntryEnabled()) {
                        Tr.entry((TraceComponent)tc, (String)("exportApplication: " + string));
                    }
                    if (this.appName == null) {
                        throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0016E"));
                    }
                    workSpace = null;
                    eARFile = null;
                    string2 = null;
                    enhancedEarConfigurator = null;
                    workSpace = ConfigRepoHelper.getWorkSpace(this.workspaceID);
                    RepositoryContext repositoryContext = AppUtils.findAppContextFromConfig(this.appName, workSpace, this.prefs);
                    if (repositoryContext == null) {
                        throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0017E", new Object[]{this.appName}));
                    }
                    eARFile = ConfigRepoHelper.getEarFileFromBinaries(repositoryContext, workSpace, this.resBundle, (String)this.appM.getGlobalSettings().get("Config Root for variable map"), true);
                    java.io.File file = new java.io.File(string);
                    if (file.getParentFile() != null) {
                        file.getParentFile().mkdirs();
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Export path: " + string));
                    }
                    ApplicationDeployment applicationDeployment = ConfigRepoHelper.getAppDeploymentForApp(repositoryContext);
                    boolean bl = applicationDeployment.isUseMetadataFromBinaries();
                    AppUtils.dbg(tc, "useMetadataFromBinaries = " + bl);
                    if (bl) {
                        eARFile.saveAs(string);
                        break block25;
                    }
                    string2 = AppUtils.getAppTempExportDir(this.appName, this.appM.getGlobalSettings());
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Temp export at: " + string2));
                    }
                    int n = 126;
                    EarUtils.extractEar(eARFile, string2, true, n &= 0xFFFFFFDF);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Ear file extracted to: " + string2));
                    }
                    eARFile.close();
                    Vector<String> vector = new Vector<String>();
                    vector.add("deployment.xml");
                    vector.add("variables.xml");
                    vector.add("resources.xml");
                    AppUtils.xcopy(repositoryContext, string2, vector);
                    String string3 = (String)this.prefs.get("cell.name");
                    if (string3 == null) {
                        object = AdminServiceFactory.getAdminService();
                        if (object != null) {
                            string3 = object.getCellName();
                        }
                        if (string3 == null) {
                            string3 = System.getProperty("local.cell");
                        }
                    }
                    object = AppUtils.getAppBinDirName(null, this.appName);
                    enhancedEarConfigurator = new EnhancedEarConfigurator(workSpace, string2, string3, this.appName, (String)object);
                    enhancedEarConfigurator.exportApplicationConfiguration();
                    eARFile = AppInstallHelper.getEarFile(string2, false, this.resBundle);
                    String string4 = file.getAbsolutePath();
                    java.io.File file2 = new java.io.File(string4);
                    if (!file2.getParentFile().canWrite()) {
                        String string5 = file2.getParent();
                        Tr.debug((TraceComponent)tc, (String)("The export directory: " + string5 + " is read only"));
                        throw new AdminException("The application can not be exported. The export directory: " + string5 + " has read only permission");
                    }
                    eARFile.saveAs(string4);
                }
                Object var18_18 = null;
                this.doFinally(workSpace, eARFile, false);
                try {
                    if (enhancedEarConfigurator != null) {
                        enhancedEarConfigurator.cleanup();
                    }
                    AppUtils.deleteDirTree(string2);
                }
                catch (Throwable throwable) {
                    if (!tc.isDebugEnabled()) break block26;
                    Tr.debug((TraceComponent)tc, (String)("Error deleting temp dir " + string2 + " after export: " + throwable));
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("exportApplication: " + string));
            }
            break block28;
            {
                catch (Throwable throwable) {
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.application.EditApplication.exportApplication", (String)"538", (Object)this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Exception thrown in exportApplication: " + throwable));
                    }
                    if (throwable instanceof AdminException) {
                        throw (AdminException)((Object)throwable);
                    }
                    throw new AdminException(throwable, "");
                }
            }
            catch (Throwable throwable) {
                block27: {
                    Object var18_19 = null;
                    this.doFinally(workSpace, eARFile, false);
                    try {
                        if (enhancedEarConfigurator != null) {
                            enhancedEarConfigurator.cleanup();
                        }
                        AppUtils.deleteDirTree(string2);
                    }
                    catch (Throwable throwable2) {
                        if (!tc.isDebugEnabled()) break block27;
                        Tr.debug((TraceComponent)tc, (String)("Error deleting temp dir " + string2 + " after export: " + throwable2));
                    }
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)("exportApplication: " + string));
                }
                throw throwable;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void extractDDL(String string, String string2) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("extractDDL: " + string2));
        }
        if (this.appName == null) {
            throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0016E"));
        }
        WorkSpace workSpace = null;
        EARFile eARFile = null;
        try {
            try {
                String string3;
                String string4;
                Object object;
                workSpace = ConfigRepoHelper.getWorkSpace(this.workspaceID);
                RepositoryContext repositoryContext = AppUtils.findAppContextFromConfig(this.appName, workSpace, this.prefs);
                if (repositoryContext == null) {
                    throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0017E", new Object[]{this.appName}));
                }
                eARFile = ConfigRepoHelper.getEarFileFromDeployment(workSpace, repositoryContext);
                if (eARFile == null) {
                    throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0019E", new Object[]{eARFile}));
                }
                HashMap<String, String> hashMap = new HashMap<String, String>(20);
                List list = eARFile.getEJBJarFiles();
                for (int i = 0; i < list.size(); ++i) {
                    object = (EJBJarFile)list.get(i);
                    EJBJar eJBJar = object.getDeploymentDescriptor();
                    string4 = EJBBindingsHelper.getEJBJarBinding((EJBJar)eJBJar).getCurrentBackendId();
                    string3 = object.getName();
                    hashMap.put(string3, string4);
                }
                eARFile.close();
                eARFile = ConfigRepoHelper.getEarFileFromBinaries(repositoryContext, workSpace, this.resBundle, (String)this.appM.getGlobalSettings().get("Config Root for variable map"), true);
                if (eARFile == null) {
                    throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0019E", new Object[]{eARFile}));
                }
                java.io.File file = new java.io.File(string2);
                file.mkdirs();
                object = file.getAbsolutePath();
                list = eARFile.getEJBJarFiles();
                for (int i = 0; i < list.size(); ++i) {
                    Object object2;
                    Object object3;
                    Object object4;
                    string4 = (EJBJarFile)list.get(i);
                    string3 = string4.getName();
                    String string5 = (String)hashMap.get(string3);
                    if (string5 != null) {
                        object4 = BackendDir + string5 + "/Table.ddl";
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("backend Table ddl name for " + string5 + " is " + (String)object4));
                        }
                        if (string4.containsFile((String)object4)) {
                            object3 = string4.getFile((String)object4);
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("Table ddl for " + string3 + " is " + (String)object4));
                            }
                            object2 = (String)object + java.io.File.separator + (string == null ? "" : string) + "_" + string3 + "_" + string5 + "_" + "Table.ddl";
                            InputStream inputStream = object3.getInputStream();
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("Copying Table.ddl to " + (String)object2));
                            }
                            AppUtils.copyFile(inputStream, (String)object2);
                            inputStream.close();
                        } else {
                            string5 = null;
                            Tr.warning((TraceComponent)tc, (String)"ADMA0095W", (Object)new Object[]{object4, string3});
                        }
                    }
                    if (string5 != null || !string4.containsFile(TableDDL)) continue;
                    object4 = string4.getFile(TableDDL);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Table ddl for " + string4.getName() + " is " + object4));
                    }
                    object3 = (String)object + java.io.File.separator + (string == null ? "" : string) + "_" + string4.getName() + "_" + "Table.ddl";
                    object2 = object4.getInputStream();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Copying Table.ddl to " + (String)object3));
                    }
                    AppUtils.copyFile((InputStream)object2, (String)object3);
                    ((InputStream)object2).close();
                }
                Object var19_21 = null;
                this.doFinally(workSpace, eARFile, false);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.application.EditApplication.exportApplication", (String)"627", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Exception thrown in extractDDL: " + throwable));
                }
                if (!(throwable instanceof AdminException)) throw new AdminException(throwable, "");
                throw (AdminException)((Object)throwable);
            }
        }
        catch (Throwable throwable) {
            Object var19_22 = null;
            this.doFinally(workSpace, eARFile, false);
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)("extractDDL: " + string2));
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit((TraceComponent)tc, (String)("extractDDL: " + string2));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void publishWSDL(String string) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("publishWSDL " + string));
        }
        if (this.appName == null) {
            throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0016E"));
        }
        WorkSpace workSpace = null;
        try {
            try {
                workSpace = ConfigRepoHelper.getWorkSpace(this.workspaceID);
                RepositoryContext repositoryContext = AppUtils.findAppContextFromConfig(this.appName, workSpace, this.prefs);
                if (repositoryContext == null) {
                    throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0017E", new Object[]{this.appName}));
                }
                Class<?> clazz = Class.forName("com.ibm.ws.webservices.deploy.DeployUtils");
                Class[] classArray = new Class[]{RepositoryContext.class, String.class, AttributeList.class};
                Method method = clazz.getMethod("publishWSDLFiles", classArray);
                AttributeList attributeList = (AttributeList)this.prefs.get("PREFIXES");
                Object[] objectArray = new Object[]{repositoryContext, string, attributeList};
                try {
                    method.invoke(null, objectArray);
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw invocationTargetException.getTargetException();
                }
                Object var11_11 = null;
                this.doFinally(workSpace, null, false);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.application.EditApplication.publishWSDL", (String)"708", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Exception thrown in publishWSDL: " + throwable));
                }
                if (!(throwable instanceof AdminException)) throw new AdminException(throwable, "");
                throw (AdminException)((Object)throwable);
            }
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            this.doFinally(workSpace, null, false);
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)("publishWSDL: " + string));
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit((TraceComponent)tc, (String)("publishWSDL: " + string));
    }

    public static Vector listApplications(Hashtable hashtable, String string) throws AdminException {
        Vector<String> vector;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("listApplications: prefs: " + hashtable + " wID: " + string));
        }
        ResourceBundle resourceBundle = AppUtils.getBundle(hashtable);
        WorkSpace workSpace = null;
        Vector<String> vector2 = new Vector<String>();
        if (hashtable == null) {
            hashtable = new Hashtable();
        }
        try {
            workSpace = ConfigRepoHelper.getWorkSpace(string);
            String string2 = (String)hashtable.get("cell.name");
            Object[] objectArray = null;
            if (string2 == null) {
                objectArray = AppUtils.getContextArray("cells", null, workSpace);
            } else {
                RepositoryContext repositoryContext = AppUtils.findContext("cells", string2, null, null, workSpace, false);
                objectArray = new RepositoryContext[]{repositoryContext};
            }
            for (int i = 0; i < objectArray.length; ++i) {
                Object[] objectArray2 = AppUtils.getContextArray("deployments", (RepositoryContext)objectArray[i], workSpace);
                if (objectArray2 == null) continue;
                for (int j = 0; j < objectArray2.length; ++j) {
                    vector2.addElement(((RepositoryContext)objectArray2[j]).getName());
                }
            }
            vector = vector2;
            Object var11_13 = null;
        }
        catch (Throwable throwable) {
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Exception thrown in listApplications: " + throwable));
                }
                if (throwable instanceof AdminException) {
                    throw (AdminException)((Object)throwable);
                }
                throw new AdminException(throwable, "");
            }
            catch (Throwable throwable2) {
                block13: {
                    Object var11_14 = null;
                    EditApplication.doFinally(workSpace, string, null, false);
                    if (!tc.isEntryEnabled()) break block13;
                    Tr.exit((TraceComponent)tc, (String)"listApplications");
                }
                throw throwable2;
            }
        }
        EditApplication.doFinally(workSpace, string, null, false);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"listApplications");
        }
        return vector;
    }

    public AppDeploymentTask listModules() throws AdminException {
        ListModules listModules;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("listModules: " + this.appName));
        }
        if (this.appName == null) {
            throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0016E"));
        }
        WorkSpace workSpace = null;
        EARFile eARFile = null;
        ListModules listModules2 = null;
        try {
            workSpace = ConfigRepoHelper.getWorkSpace(this.workspaceID);
            RepositoryContext repositoryContext = AppUtils.findAppContextFromConfig(this.appName, workSpace, this.prefs);
            if (repositoryContext == null) {
                throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0017E", new Object[]{this.appName}));
            }
            eARFile = ConfigRepoHelper.getEarFileFromDeployment(workSpace, repositoryContext);
            if (eARFile == null) {
                throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0019E", new Object[]{eARFile}));
            }
            ApplicationDeployment applicationDeployment = ConfigRepoHelper.getAppDeploymentForApp(repositoryContext);
            Hashtable hashtable = ConfigRepoHelper.getCNP(null, applicationDeployment, repositoryContext.getParent().getParent().getName());
            listModules2 = new ListModules(null);
            Vector<String> vector = new Vector<String>();
            String[] stringArray = listModules2.getColumnNames();
            for (int i = 0; i < stringArray.length; ++i) {
                vector.addElement(stringArray[i]);
            }
            EList eList = eARFile.getModuleRefs();
            int n = ((XMLResource)eARFile.getDeploymentDescriptor().eResource()).getVersionID();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("app version: " + n));
            }
            String string = Integer.toString(n);
            for (int i = 0; i < eList.size(); ++i) {
                ModuleRef moduleRef = (ModuleRef)eList.get(i);
                if (!ConfigRepoHelper.isDeployable(moduleRef)) continue;
                String string2 = null;
                if (moduleRef.isEJB()) {
                    string2 = ((EJBJar)moduleRef.getDeploymentDescriptor()).getDisplayName();
                }
                if (moduleRef.isWeb()) {
                    string2 = ((WebApp)moduleRef.getDeploymentDescriptor()).getDisplayName();
                }
                if (AppUtils.isEmpty(string2)) {
                    string2 = moduleRef.getUri();
                }
                vector.addElement(string2);
                String string3 = util.createUniqueModuleName(ConfigRepoHelper.getDDUri(moduleRef), moduleRef.getModule().getUri());
                vector.addElement(string3);
                String string4 = (String)hashtable.get(string3);
                vector.addElement(string4 == null ? "" : string4);
                vector.addElement(string);
                int n2 = ((XMLResource)moduleRef.getDeploymentDescriptor().eResource()).getVersionID();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("mod version: " + n2));
                }
                vector.addElement(Integer.toString(n2));
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Data is: " + vector));
            }
            listModules2.setTaskData(util.buildTaskData(vector, stringArray.length));
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Task is: " + listModules2));
            }
            listModules = listModules2;
            Object var19_21 = null;
            this.doFinally(workSpace, eARFile, false);
        }
        catch (Throwable throwable) {
            try {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.application.EditApplication.exportApplication", (String)"844", (Object)this);
                if (throwable instanceof AdminException) {
                    throw (AdminException)((Object)throwable);
                }
                throw new AdminException(throwable, "");
            }
            catch (Throwable throwable2) {
                block19: {
                    Object var19_22 = null;
                    this.doFinally(workSpace, eARFile, false);
                    if (!tc.isEntryEnabled()) break block19;
                    Tr.exit((TraceComponent)tc, (String)("listModules: " + this.appName));
                }
                throw throwable2;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("listModules: " + this.appName));
        }
        return listModules;
    }

    public List listURIs() throws AdminException {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("listURIs: " + this.appName));
        }
        if (this.appName == null) {
            throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0016E"));
        }
        WorkSpace workSpace = null;
        EARFile eARFile = null;
        Object var3_3 = null;
        try {
            Object object2;
            workSpace = ConfigRepoHelper.getWorkSpace(this.workspaceID);
            RepositoryContext repositoryContext = AppUtils.findAppContextFromConfig(this.appName, workSpace, this.prefs);
            if (repositoryContext == null) {
                throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0017E", new Object[]{this.appName}));
            }
            eARFile = ConfigRepoHelper.getEarFileFromBinaries(repositoryContext, workSpace, this.resBundle, null, true);
            if (eARFile == null) {
                throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0019E", new Object[]{eARFile}));
            }
            EARFile eARFile2 = eARFile;
            if (this.uniqueModuleURI != null) {
                object2 = this.uniqueModuleURI;
                if (((String)object2).indexOf(43) != -1) {
                    object2 = ((String)object2).substring(0, ((String)object2).indexOf(43));
                }
                object = eARFile.getModuleFiles();
                ModuleFile moduleFile = null;
                for (int i = 0; i < object.size(); ++i) {
                    if (!((ModuleFile)object.get(i)).getURI().equals(object2)) continue;
                    moduleFile = (ModuleFile)object.get(i);
                    break;
                }
                if (moduleFile == null) {
                    throw new AdminException("Invalid module.  Module URI " + this.uniqueModuleURI + " does not exist in the application.");
                }
                eARFile2 = moduleFile;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("archive to look into: " + eARFile2));
            }
            object2 = new ArrayList();
            this.listURIs((Container)eARFile2, "", (List)object2);
            object = object2;
            Object var11_11 = null;
            this.doFinally(workSpace, eARFile, false);
        }
        catch (Throwable throwable) {
            try {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.application.EditApplication.exportApplication", (String)"913", (Object)this);
                if (throwable instanceof AdminException) {
                    throw (AdminException)((Object)throwable);
                }
                throw new AdminException(throwable, "");
            }
            catch (Throwable throwable2) {
                block15: {
                    Object var11_12 = null;
                    this.doFinally(workSpace, eARFile, false);
                    if (!tc.isEntryEnabled()) break block15;
                    Tr.exit((TraceComponent)tc, (String)("listURIs: " + this.appName));
                }
                throw throwable2;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("listURIs: " + this.appName));
        }
        return object;
    }

    private void listURIs(Container container, String string, List list) {
        EList eList = container.getFiles();
        for (int i = 0; i < eList.size(); ++i) {
            File file = (File)eList.get(i);
            if (file instanceof ModuleFile) continue;
            list.add(string + file.getURI());
            if (!(file instanceof Container)) continue;
            this.listURIs((Container)file, file.getURI() + "/", list);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateAccessIDs(Boolean bl) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("updateAccessIDs: " + this.appName + "bAll: " + bl));
        }
        if (AppManagementImpl.isLocalMode()) {
            if (!tc.isDebugEnabled()) throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0090E", new Object[]{"updateAccessIDs"}));
            Tr.debug((TraceComponent)tc, (String)"Local mode: no-op");
            throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0090E", new Object[]{"updateAccessIDs"}));
        }
        if (this.appName == null) {
            throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0016E"));
        }
        WorkSpace workSpace = null;
        EARFile eARFile = null;
        boolean bl2 = false;
        boolean bl3 = Boolean.TRUE.equals(bl);
        try {
            try {
                RepositoryContext repositoryContext;
                Iterator iterator = AdminServiceFactory.getAdminService().queryNames(new ObjectName("WebSphere:type=SecurityAdmin,process=" + AdminServiceFactory.getAdminService().getProcessName() + ",*"), null).iterator();
                ObjectName objectName = (ObjectName)iterator.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("MBean: " + objectName));
                }
                if ((repositoryContext = AppUtils.findAppContextFromConfig(this.appName, workSpace = ConfigRepoHelper.getWorkSpace(this.workspaceID), this.prefs)) == null) {
                    throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0017E", new Object[]{this.appName}));
                }
                ApplicationDeployment applicationDeployment = ConfigRepoHelper.getAppDeploymentForApp(repositoryContext);
                boolean bl4 = applicationDeployment.isUseMetadataFromBinaries();
                eARFile = bl4 ? ConfigRepoHelper.getEarFileFromBinaries(repositoryContext, workSpace, this.resBundle, (String)this.appM.getGlobalSettings().get("Config Root for variable map")) : ConfigRepoHelper.getEarFileFromDeployment(workSpace, repositoryContext);
                ApplicationBinding applicationBinding = eARFile.getBindings();
                AuthorizationTable authorizationTable = applicationBinding.getAuthorizationTable();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Table: " + authorizationTable));
                }
                if (authorizationTable != null) {
                    Iterator iterator2 = authorizationTable.getAuthorizations().iterator();
                    while (iterator2.hasNext()) {
                        RoleAssignment roleAssignment = (RoleAssignment)iterator2.next();
                        this.updateID((List)roleAssignment.getUsers(), objectName, true, bl3);
                        this.updateID((List)roleAssignment.getGroups(), objectName, false, bl3);
                    }
                }
                if (bl4) {
                    eARFile.save();
                }
                SetApplicationInfoTask.saveEarFileToDeployment(eARFile, repositoryContext);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.application.EditApplication.updateAccessIDs", (String)"1015", (Object)this);
                bl2 = true;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Exception thrown in updateAccessIDs: " + throwable));
                }
                if (!(throwable instanceof AdminException)) throw new AdminException(throwable, "");
                throw (AdminException)((Object)throwable);
            }
            Object var16_16 = null;
            this.doFinally(workSpace, eARFile, !bl2);
        }
        catch (Throwable throwable) {
            Object var16_17 = null;
            this.doFinally(workSpace, eARFile, !bl2);
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)("updateAccessIDs: " + this.appName));
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit((TraceComponent)tc, (String)("updateAccessIDs: " + this.appName));
    }

    private void updateID(List list, ObjectName objectName, boolean bl, boolean bl2) throws Exception {
        for (int i = 0; i < list.size(); ++i) {
            Subject subject = (Subject)list.get(i);
            if (!bl2 && subject.getAccessId() != null) continue;
            String string = (String)AdminServiceFactory.getAdminService().invoke(objectName, "getAccessIds", new Object[]{new Boolean(bl), subject.getName(), null}, new String[]{Boolean.TYPE.getName(), (class$java$lang$String == null ? EditApplication.class$("java.lang.String") : class$java$lang$String).getName(), (class$java$util$Properties == null ? EditApplication.class$("java.util.Properties") : class$java$util$Properties).getName()});
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("name: " + subject.getName() + " --> id: " + string));
            }
            if (string == null) continue;
            subject.setAccessId(string);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deleteUserAndGroupEntries() throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("deleteUserAndGroupEntries: " + this.appName));
        }
        if (this.appName == null) {
            throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0016E"));
        }
        WorkSpace workSpace = null;
        EARFile eARFile = null;
        boolean bl = false;
        try {
            try {
                RoleAssignment roleAssignment;
                Object object;
                workSpace = ConfigRepoHelper.getWorkSpace(this.workspaceID);
                RepositoryContext repositoryContext = AppUtils.findAppContextFromConfig(this.appName, workSpace, this.prefs);
                if (repositoryContext == null) {
                    throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0017E", new Object[]{this.appName}));
                }
                ApplicationDeployment applicationDeployment = ConfigRepoHelper.getAppDeploymentForApp(repositoryContext);
                boolean bl2 = applicationDeployment.isUseMetadataFromBinaries();
                eARFile = bl2 ? ConfigRepoHelper.getEarFileFromBinaries(repositoryContext, workSpace, this.resBundle, (String)this.appM.getGlobalSettings().get("Config Root for variable map")) : ConfigRepoHelper.getEarFileFromDeployment(workSpace, repositoryContext);
                ApplicationBinding applicationBinding = eARFile.getBindings();
                AuthorizationTable authorizationTable = applicationBinding.getAuthorizationTable();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Table: " + authorizationTable));
                }
                if (authorizationTable != null) {
                    object = authorizationTable.getAuthorizations().iterator();
                    while (object.hasNext()) {
                        roleAssignment = (RoleAssignment)object.next();
                        roleAssignment.getUsers().clear();
                        roleAssignment.getGroups().clear();
                        roleAssignment.getSpecialSubjects().clear();
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)("Cleared: " + roleAssignment));
                    }
                }
                object = applicationBinding.getRunAsMap();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Map: " + object));
                }
                if (object != null) {
                    roleAssignment = object.getRunAsBindings();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Bnd: " + roleAssignment));
                    }
                    if (roleAssignment != null) {
                        Iterator iterator = roleAssignment.iterator();
                        while (iterator.hasNext()) {
                            RunAsBinding runAsBinding = (RunAsBinding)iterator.next();
                            AbstractAuthData abstractAuthData = runAsBinding.getAuthData();
                            if (abstractAuthData == null || !(abstractAuthData instanceof BasicAuthData)) continue;
                            BasicAuthData basicAuthData = (BasicAuthData)abstractAuthData;
                            basicAuthData.setUserId(null);
                            basicAuthData.setPassword(null);
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug((TraceComponent)tc, (String)("Zap for: " + runAsBinding));
                        }
                    }
                }
                if (bl2) {
                    eARFile.save();
                }
                SetApplicationInfoTask.saveEarFileToDeployment(eARFile, repositoryContext);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.application.EditApplication.deleteUserAndGroupEntries", (String)"1142", (Object)this);
                bl = true;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Exception thrown in deleteUserAndGroupEntries:" + throwable));
                }
                if (!(throwable instanceof AdminException)) throw new AdminException(throwable, "");
                throw (AdminException)((Object)throwable);
            }
            Object var16_16 = null;
            this.doFinally(workSpace, eARFile, !bl);
        }
        catch (Throwable throwable) {
            Object var16_17 = null;
            this.doFinally(workSpace, eARFile, !bl);
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)("deleteUserAndGroupEntries: " + this.appName));
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit((TraceComponent)tc, (String)("deleteUserAndGroupEntries: " + this.appName));
    }

    public static ConfigService getLocalConfigService() {
        if (ConfigServiceFactory.getConfigService() != null) {
            return ConfigServiceFactory.getConfigService();
        }
        Properties properties = new Properties();
        properties.setProperty("location", "local");
        try {
            return ConfigServiceFactory.createConfigService(true, properties);
        }
        catch (AdminException adminException) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Exception creating config servicein local mode:" + (Object)((Object)adminException)));
            }
            return null;
        }
    }

    /*
     * Unable to fully structure code
     */
    public byte[] getApplicationContents(String var1_1) throws AdminException {
        block35: {
            block33: {
                if (EditApplication.tc.isEntryEnabled()) {
                    Tr.entry((TraceComponent)EditApplication.tc, (String)("getApplicationContents: " + var1_1));
                }
                if (var1_1 == null) {
                    return null;
                }
                var2_2 = var1_1.replace('\\', '/');
                if (this.appName == null) {
                    throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0016E"));
                }
                var3_3 = null;
                var4_4 = null;
                var5_5 = null;
                var3_3 = ConfigRepoHelper.getWorkSpace(this.workspaceID);
                var6_6 = AppUtils.findAppContextFromConfig(this.appName, var3_3, this.prefs);
                if (var6_6 == null) {
                    throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0017E", new Object[]{this.appName}));
                }
                if (!var6_6.isAvailable(var2_2)) break block33;
                if (EditApplication.tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)EditApplication.tc, (String)("Metadata uri: " + var2_2));
                }
                var7_8 = ConfigRepoHelper.getAppDeploymentForApp(var6_6);
                var8_9 = var7_8.isUseMetadataFromBinaries();
                if (EditApplication.tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)EditApplication.tc, (String)("useMetadataFromBinaries = " + var8_9));
                }
                if (var8_9) break block33;
                var6_6.extract(var2_2, false);
                var5_5 = new FileInputStream(var6_6.getPath() + "/" + var2_2);
                var9_12 = AppUtils.getFileContents(var5_5);
                var11_13 = null;
                try {
                    if (var5_5 != null) {
                        var5_5.close();
                    }
                }
                catch (IOException var12_17) {
                    if (EditApplication.tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)EditApplication.tc, (String)("IO exception closing the inputstream: " + var12_17));
                    }
                    FFDCFilter.processException((Throwable)var12_17, (String)"com.ibm.ws.management.application.EditApplication.getApplicationContents-2", (String)"1309", (Object)this);
                }
                this.doFinally(var3_3, var4_4, false);
                if (EditApplication.tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)EditApplication.tc, (String)("getApplicationContents: " + var2_2));
                }
                return var9_12;
            }
            var4_4 = ConfigRepoHelper.getEarFileFromBinaries(var6_6, var3_3, this.resBundle, null, true);
            if (EditApplication.tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)EditApplication.tc, (String)("ear from bin: " + var4_4));
            }
            if (!((Container)(var7_8 = AppUtils.getContainerAndOffset((Container)var4_4, var2_2))[0]).containsFile((String)var7_8[1])) break block35;
            var5_5 = ((Container)var7_8[0]).getInputStream((String)var7_8[1]);
            if (EditApplication.tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)EditApplication.tc, (String)("input stream from ear: " + var5_5));
            }
            if (var5_5 == null) ** GOTO lbl72
            var8_10 = AppUtils.getFileContents(var5_5);
            var11_14 = null;
            try {
                if (var5_5 != null) {
                    var5_5.close();
                }
            }
            catch (IOException var12_18) {
                if (EditApplication.tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)EditApplication.tc, (String)("IO exception closing the inputstream: " + var12_18));
                }
                FFDCFilter.processException((Throwable)var12_18, (String)"com.ibm.ws.management.application.EditApplication.getApplicationContents-2", (String)"1309", (Object)this);
            }
            this.doFinally(var3_3, var4_4, false);
            if (EditApplication.tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)EditApplication.tc, (String)("getApplicationContents: " + var2_2));
            }
            return var8_10;
        }
        if (EditApplication.tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)EditApplication.tc, (String)(var2_2 + " does not exist in ear"));
        }
lbl72:
        // 4 sources

        var8_11 = null;
        var11_15 = null;
        try {
            if (var5_5 != null) {
                var5_5.close();
            }
        }
        catch (IOException var12_19) {
            if (EditApplication.tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)EditApplication.tc, (String)("IO exception closing the inputstream: " + var12_19));
            }
            FFDCFilter.processException((Throwable)var12_19, (String)"com.ibm.ws.management.application.EditApplication.getApplicationContents-2", (String)"1309", (Object)this);
        }
        this.doFinally(var3_3, var4_4, false);
        if (EditApplication.tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)EditApplication.tc, (String)("getApplicationContents: " + var2_2));
        }
        return var8_11;
        catch (Throwable var6_7) {
            try {
                FFDCFilter.processException((Throwable)var6_7, (String)"com.ibm.ws.management.application.EditApplication.getApplicationContents", (String)"1267", (Object)this);
                if (EditApplication.tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)EditApplication.tc, (String)("Exception thrown in getApplicationContents: " + var6_7));
                }
                if (var6_7 instanceof AdminException) {
                    throw (AdminException)var6_7;
                }
                throw new AdminException(var6_7, "");
            }
            catch (Throwable var10_21) {
                block38: {
                    var11_16 = null;
                    try {
                        if (var5_5 != null) {
                            var5_5.close();
                        }
                    }
                    catch (IOException var12_20) {
                        if (EditApplication.tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)EditApplication.tc, (String)("IO exception closing the inputstream: " + var12_20));
                        }
                        FFDCFilter.processException((Throwable)var12_20, (String)"com.ibm.ws.management.application.EditApplication.getApplicationContents-2", (String)"1309", (Object)this);
                    }
                    this.doFinally(var3_3, var4_4, false);
                    if (!EditApplication.tc.isEntryEnabled()) break block38;
                    Tr.exit((TraceComponent)EditApplication.tc, (String)("getApplicationContents: " + var2_2));
                }
                throw var10_21;
            }
        }
    }

    public EditionInfo[] getEditionInfo(String string) throws AdminException {
        EditionInfo[] editionInfoArray;
        EditionInfo[] editionInfoArray2;
        ArrayList<Object> arrayList;
        WorkSpace workSpace;
        block22: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)("getEditionInfo: " + this.appName + ", " + string));
            }
            if (this.appName == null) {
                throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0016E"));
            }
            workSpace = null;
            workSpace = ConfigRepoHelper.getWorkSpace(this.workspaceID);
            arrayList = new ArrayList<Object>();
            String string2 = (String)this.prefs.get("cell.name");
            Object[] objectArray = null;
            if (string2 == null) {
                objectArray = AppUtils.getContextArray("cells", null, workSpace);
            } else {
                RepositoryContext repositoryContext = AppUtils.findContext("cells", string2, null, null, workSpace, false);
                objectArray = new RepositoryContext[]{repositoryContext};
            }
            for (int i = 0; i < objectArray.length; ++i) {
                Object[] objectArray2;
                if (!"*".equals(string)) {
                    editionInfoArray2 = EditionHelper.getCompositeName(this.appName, string);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("comp name: " + (String)editionInfoArray2));
                    }
                    objectArray2 = AppUtils.findAppContextFromConfig((String)editionInfoArray2, workSpace, this.prefs);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("rc = " + objectArray2));
                    }
                    if (objectArray2 == null) continue;
                    arrayList.add(objectArray2);
                    continue;
                }
                editionInfoArray2 = EditionHelper.getAppAndEdition(this.appName)[0];
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("app name is: " + (String)editionInfoArray2));
                }
                if (editionInfoArray2 == null) break;
                objectArray2 = AppUtils.getContextArray("deployments", (RepositoryContext)objectArray[i], workSpace);
                if (objectArray2 == null) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("ar is null for " + objectArray[i]));
                    continue;
                }
                for (int j = 0; j < objectArray2.length; ++j) {
                    RepositoryContext repositoryContext = (RepositoryContext)objectArray2[j];
                    if (!EditionHelper.getAppAndEdition(repositoryContext.getName())[0].equals(editionInfoArray2)) continue;
                    arrayList.add(repositoryContext);
                }
            }
            if (arrayList.size() != 0) break block22;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"no editions for this name");
            }
            EditionInfo[] editionInfoArray3 = new EditionInfo[]{};
            Object var12_19 = null;
            this.doFinally(workSpace, null, false);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("getEditionInfo: " + this.appName));
            }
            return editionInfoArray3;
        }
        try {
            Properties properties = AppUtils.getEditionProps((RepositoryContext)arrayList.get(0));
            editionInfoArray2 = new EditionInfo[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                RepositoryContext repositoryContext = (RepositoryContext)arrayList.get(i);
                editionInfoArray2[i] = new EditionInfo(repositoryContext.getName(), repositoryContext.getParent().getParent().getName());
                this.props2Info(editionInfoArray2[i], repositoryContext, properties);
            }
            editionInfoArray = editionInfoArray2;
            Object var12_20 = null;
            this.doFinally(workSpace, null, false);
        }
        catch (Throwable throwable) {
            try {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.application.EditApplication.getEditionInfo", (String)"1337", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Exception thrown in getEditionInfo:" + throwable));
                }
                if (throwable instanceof AdminException) {
                    throw (AdminException)((Object)throwable);
                }
                throw new AdminException(throwable, "");
            }
            catch (Throwable throwable2) {
                block23: {
                    Object var12_21 = null;
                    this.doFinally(workSpace, null, false);
                    if (!tc.isEntryEnabled()) break block23;
                    Tr.exit((TraceComponent)tc, (String)("getEditionInfo: " + this.appName));
                }
                throw throwable2;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getEditionInfo: " + this.appName));
        }
        return editionInfoArray;
    }

    private void props2Info(EditionInfo editionInfo, RepositoryContext repositoryContext, Properties properties) {
        editionInfo.setDescription(properties.getProperty(EditionHelper.getEditionDescPropName(repositoryContext.getName()), ""));
        String string = properties.getProperty(EditionHelper.getEditionStatePropName(repositoryContext.getName()), "");
        if (string != null && string.length() > 0) {
            editionInfo.setEditionState(string);
        } else if (properties.isEmpty() && editionInfo.getEdition().equals("")) {
            editionInfo.setEditionState("ACTIVE");
        } else {
            editionInfo.setEditionState("INACTIVE");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setEditionInfo(EditionInfo[] editionInfoArray) throws AdminException {
        boolean bl;
        WorkSpace workSpace;
        block12: {
            block11: {
                if (tc.isEntryEnabled()) {
                    Tr.entry((TraceComponent)tc, (String)"setEditionInfo");
                }
                workSpace = null;
                bl = false;
                try {
                    try {
                        workSpace = ConfigRepoHelper.getWorkSpace(this.workspaceID);
                        if (editionInfoArray == null) {
                            Object var9_4 = null;
                            this.doFinally(workSpace, null, !bl);
                            break block11;
                        }
                        for (int i = 0; i < editionInfoArray.length; ++i) {
                            RepositoryContext repositoryContext = AppUtils.findContext("cells", editionInfoArray[i].getCellName(), null, null, workSpace, false);
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("cellc " + repositoryContext));
                            }
                            if (repositoryContext == null) continue;
                            this.prefs.put("cell.name", repositoryContext.getName());
                            RepositoryContext repositoryContext2 = AppUtils.findAppContextFromConfig(EditionHelper.getCompositeName(editionInfoArray[i].getAppName(), editionInfoArray[i].getEdition()), workSpace, this.prefs);
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("appC = " + repositoryContext2));
                            }
                            if (repositoryContext2 == null) continue;
                            Properties properties = AppUtils.getEditionProps(repositoryContext2);
                            this.info2Props(editionInfoArray[i], properties, repositoryContext2);
                            AppUtils.setEditionProps(repositoryContext2, properties);
                        }
                        break block12;
                    }
                    catch (Throwable throwable) {
                        bl = true;
                        FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.application.EditApplication.setEditionInfo", (String)"1407", (Object)this);
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Exception thrown in setEditionInfo:" + throwable));
                        }
                        if (!(throwable instanceof AdminException)) throw new AdminException(throwable, "");
                        throw (AdminException)((Object)throwable);
                    }
                }
                catch (Throwable throwable) {
                    Object var9_6 = null;
                    this.doFinally(workSpace, null, !bl);
                    if (!tc.isEntryEnabled()) throw throwable;
                    Tr.exit((TraceComponent)tc, (String)("setEditionInfo: " + this.appName));
                    throw throwable;
                }
            }
            if (!tc.isEntryEnabled()) return;
            Tr.exit((TraceComponent)tc, (String)("setEditionInfo: " + this.appName));
            return;
        }
        Object var9_5 = null;
        this.doFinally(workSpace, null, !bl);
        if (!tc.isEntryEnabled()) return;
        Tr.exit((TraceComponent)tc, (String)("setEditionInfo: " + this.appName));
    }

    private void info2Props(EditionInfo editionInfo, Properties properties, RepositoryContext repositoryContext) {
        String string = editionInfo.getDescription();
        properties.setProperty(EditionHelper.getEditionDescPropName(repositoryContext.getName()), string == null ? "" : string);
        properties.setProperty(EditionHelper.getEditionStatePropName(repositoryContext.getName()), editionInfo.getEditionState());
    }

    public String[] getAppAssociation(String string, String string2) throws AdminException {
        String[] stringArray;
        WorkSpace workSpace;
        block26: {
            RepositoryContext repositoryContext;
            Object object;
            block24: {
                Object object2;
                Vector vector;
                block25: {
                    if (tc.isEntryEnabled()) {
                        Tr.entry((TraceComponent)tc, (String)"getAppAssociation");
                    }
                    workSpace = null;
                    boolean bl = false;
                    workSpace = ConfigRepoHelper.getWorkSpace(this.workspaceID);
                    if (!"server.name".equals(string2) && !"node.name".equals(string2)) break block24;
                    this.appName = string;
                    RepositoryContext repositoryContext2 = AppUtils.findAppContextFromConfig(this.appName, workSpace, this.prefs);
                    if (repositoryContext2 == null) {
                        throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0017E", new Object[]{this.appName}));
                    }
                    RepositoryContext repositoryContext3 = repositoryContext2.getParent().getParent();
                    ApplicationDeployment applicationDeployment = ConfigRepoHelper.getAppDeploymentForApp(repositoryContext2);
                    vector = ConfigRepoHelper.getServersForAppDeployment(applicationDeployment, null, repositoryContext3, workSpace, false);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("All targets: " + vector));
                    }
                    vector = ConfigRepoHelper.getAllServers(workSpace, vector);
                    if (!"server.name".equals(string2)) break block25;
                    String[] stringArray2 = new String[vector.size()];
                    for (int i = 0; i < vector.size(); ++i) {
                        stringArray2[i] = ConfigRepoHelper.getTargetString((RepositoryContext)vector.elementAt(i), (String)null);
                    }
                    String[] stringArray3 = stringArray2;
                    Object var14_23 = null;
                    this.doFinally(workSpace, null, false);
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)("getAppAssociation: " + this.appName));
                    }
                    return stringArray3;
                }
                Vector<Object[]> vector2 = new Vector<Object[]>();
                for (int i = 0; i < vector.size(); ++i) {
                    object2 = ConfigRepoHelper.getTargetString((RepositoryContext)vector.elementAt(i), (String)null);
                    ObjectName objectName = new ObjectName((String)object2);
                    object2 = "WebSphere:cell=" + objectName.getKeyProperty("cell") + ",node=" + objectName.getKeyProperty("node");
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Trying to add: " + (String)object2));
                    }
                    if (vector2.contains(object2)) continue;
                    vector2.add((Object[])object2);
                }
                Object[] objectArray = new String[vector2.size()];
                vector2.copyInto(objectArray);
                object2 = objectArray;
                Object var14_24 = null;
                this.doFinally(workSpace, null, false);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)("getAppAssociation: " + this.appName));
                }
                return object2;
            }
            if (!"cell.name".equals(string2)) break block26;
            this.appName = string;
            String string3 = (String)this.prefs.get("cell.name");
            Object[] objectArray = null;
            if (string3 == null) {
                objectArray = AppUtils.getContextArray("cells", null, workSpace);
            } else {
                object = AppUtils.findContext("cells", string3, null, null, workSpace, false);
                objectArray = new RepositoryContext[]{object};
            }
            object = new Vector();
            for (int i = 0; i < objectArray.length; ++i) {
                repositoryContext = AppUtils.findContext("deployments", this.appName, null, (RepositoryContext)objectArray[i], workSpace, true);
                if (repositoryContext == null) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Tring to add cell: " + repositoryContext.getParent().getName()));
                }
                ((Vector)object).add("WebSphere:cell=" + repositoryContext.getParent().getName());
            }
            RepositoryContext repositoryContext4 = new String[((Vector)object).size()];
            ((Vector)object).copyInto((Object[])repositoryContext4);
            repositoryContext = repositoryContext4;
            Object var14_25 = null;
            this.doFinally(workSpace, null, false);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("getAppAssociation: " + this.appName));
            }
            return repositoryContext;
        }
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Nothing to process .. returning empty array");
            }
            stringArray = new String[]{};
            Object var14_26 = null;
            this.doFinally(workSpace, null, false);
        }
        catch (Throwable throwable) {
            try {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.application.EditApplication.getAppAssociation", (String)"1521", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Exception thrown in getAppAssociation:" + throwable));
                }
                if (throwable instanceof AdminException) {
                    throw (AdminException)((Object)throwable);
                }
                throw new AdminException(throwable, "");
            }
            catch (Throwable throwable2) {
                block27: {
                    Object var14_27 = null;
                    this.doFinally(workSpace, null, false);
                    if (!tc.isEntryEnabled()) break block27;
                    Tr.exit((TraceComponent)tc, (String)("getAppAssociation: " + this.appName));
                }
                throw throwable2;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getAppAssociation: " + this.appName));
        }
        return stringArray;
    }
}

