/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.j2ee.commonarchivecore.Container;
import com.ibm.etools.j2ee.commonarchivecore.File;
import com.ibm.websphere.management.application.AppManagementBaseFactory;
import com.ibm.websphere.management.application.EditionHelper;
import com.ibm.websphere.management.application.Scheduler;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessorFactory;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataHelper;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.websphere.models.config.classloader.ClassloaderFactory;
import com.ibm.websphere.models.config.classloader.ClassloaderPackage;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.application.AppManagementImpl;
import com.ibm.ws.management.application.task.ConfigRepoHelper;
import com.ibm.ws.management.connector.interop.JMXVersionValidation;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.RepositoryFactory;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.runtime.service.VariableMapFactory;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceFile;
import com.ibm.ws.sm.workspace.metadata.RepositoryContextType;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaDataFactory;
import java.beans.beancontext.BeanContextServiceProvider;
import java.beans.beancontext.BeanContextServicesSupport;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.management.MBeanException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;

public class AppUtils {
    private static final String systemAppsFileName = "systemapps.xml";
    private static TraceComponent tc = Tr.register((Class)AppUtils.class, null, (String)"com.ibm.ws.management.resources.AppDeploymentMessages");
    private static ClassloaderFactory classloaderFactory;

    public static boolean isEmpty(String string) {
        return string == null || string.trim().length() == 0;
    }

    public static void printEx(Throwable throwable) {
        AppUtils.printEx(throwable, true);
    }

    private static ClassloaderFactory getClassloaderFactory() {
        if (classloaderFactory == null) {
            ClassloaderPackage classloaderPackage = (ClassloaderPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/classloader.xmi");
            classloaderFactory = classloaderPackage.getClassloaderFactory();
        }
        return classloaderFactory;
    }

    public static void printEx(Throwable throwable, boolean bl) {
        if (throwable instanceof AdminException && ((AdminException)((Object)throwable)).getCause() != null) {
            AppUtils.printEx(((AdminException)((Object)throwable)).getCause(), bl);
        } else if (throwable instanceof MBeanException && ((MBeanException)throwable).getTargetException() != null) {
            AppUtils.printEx(((MBeanException)throwable).getTargetException(), bl);
        } else if (throwable instanceof AppDeploymentException && ((AppDeploymentException)throwable).getEmbeddedEx() != null) {
            AppUtils.printEx(((AppDeploymentException)throwable).getEmbeddedEx(), bl);
        } else {
            AppUtils.dbg(tc, "Exception: " + throwable);
            if (bl) {
                throwable.printStackTrace();
            }
        }
    }

    public static ResourceBundle getBundle(String string, Locale locale) {
        Locale locale2 = locale;
        if (locale2 == null) {
            locale2 = Locale.getDefault();
        }
        try {
            return ResourceBundle.getBundle(string, locale2);
        }
        catch (MissingResourceException missingResourceException) {
            FFDCFilter.processException((Throwable)missingResourceException, (String)"com.ibm.ws.management.application.AppUtils.getBundle", (String)"90");
            AppUtils.dbg(tc, "Error loading class: " + string + ", locale " + locale2 + ", " + missingResourceException);
            return null;
        }
    }

    public static ResourceBundle getBundle(Hashtable hashtable) {
        Locale locale = null;
        if (hashtable != null) {
            locale = (Locale)hashtable.get("app.client.locale");
        }
        ResourceBundle resourceBundle = AppUtils.getBundle("com.ibm.ws.management.resources.AppDeploymentMessages", locale);
        return resourceBundle;
    }

    public static String getMessage(ResourceBundle resourceBundle, String string) {
        if (resourceBundle == null) {
            return string;
        }
        try {
            String string2 = resourceBundle.getString(string);
            if (string2 == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Translation key not found: " + string));
                }
                return string;
            }
            return string2;
        }
        catch (MissingResourceException missingResourceException) {
            FFDCFilter.processException((Throwable)missingResourceException, (String)"com.ibm.ws.management.application.AppUtils.getMessage", (String)"114");
            return string;
        }
    }

    public static String getMessage(ResourceBundle resourceBundle, String string, Object[] objectArray) {
        String string2 = AppUtils.getMessage(resourceBundle, string);
        if (objectArray == null) {
            return string2;
        }
        return MessageFormat.format(string2, objectArray);
    }

    public static void dbg(TraceComponent traceComponent, String string, Object object) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)traceComponent, (String)string, (Object)object);
        }
    }

    public static void dbg(TraceComponent traceComponent, String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)traceComponent, (String)string);
        }
    }

    public static String validateInstall(Scheduler scheduler) {
        return (String)scheduler.getProperties().get("validateinstall");
    }

    public static boolean isPreCompileJSPs(Scheduler scheduler) {
        return scheduler.getProperties().get("preCompileJSPs") != null && scheduler.getProperties().get("preCompileJSPs").equals(Boolean.TRUE);
    }

    public static boolean isDeployEJBs(Scheduler scheduler) {
        return scheduler.getProperties().get("deployejb") != null && scheduler.getProperties().get("deployejb").equals(Boolean.TRUE);
    }

    public static RepositoryContextType getContextType(String string) throws Exception {
        return RepositoryMetaDataFactory.getRepositoryMetaData().getContextType(string);
    }

    public static RepositoryContext getContextFromArray(Object[] objectArray, String string, String string2, boolean bl) throws Exception {
        RepositoryContext repositoryContext = null;
        for (int i = 0; i < objectArray.length; ++i) {
            RepositoryContext repositoryContext2 = (RepositoryContext)objectArray[i];
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("aaa: " + repositoryContext2.getName()));
            }
            if (!repositoryContext2.getName().equals(string)) continue;
            if (string2 != null) {
                if (!repositoryContext2.getParent().getName().equals(string2)) continue;
                return repositoryContext2;
            }
            if (bl) {
                return repositoryContext2;
            }
            if (repositoryContext == null) {
                repositoryContext = repositoryContext2;
                continue;
            }
            throw new AdminException(AppUtils.getMessage(AppUtils.getBundle(null), "ADMA5023E", new Object[]{repositoryContext.getName(), repositoryContext.getParent().getName(), repositoryContext2.getParent().getName(), repositoryContext2.getParent().getType().getName()}));
        }
        return repositoryContext;
    }

    public static Object[] getContextArray(String string, RepositoryContext repositoryContext, WorkSpace workSpace) throws Exception {
        if (string.equals("cells")) {
            return workSpace.findContext(AppUtils.getContextType("cells")).toArray();
        }
        return repositoryContext.findContext(AppUtils.getContextType(string)).toArray();
    }

    public static RepositoryContext findContext(String string, String string2, String string3, RepositoryContext repositoryContext, WorkSpace workSpace, boolean bl) throws Exception {
        Object[] objectArray = AppUtils.getContextArray(string, repositoryContext, workSpace);
        if (objectArray == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("ar is null: type: " + string));
            }
            return null;
        }
        return AppUtils.getContextFromArray(objectArray, string2, string3, bl);
    }

    public static Vector listSystemApps(Hashtable hashtable, String string) throws Exception {
        WorkSpace workSpace = ConfigRepoHelper.getWorkSpace(string);
        Object[] objectArray = AppUtils.getContextArray("cells", null, workSpace);
        Vector vector = new Vector();
        for (int i = 0; i < objectArray.length; ++i) {
            WorkSpaceFile workSpaceFile;
            Object[] objectArray2 = AppUtils.getContextArray("nodes", (RepositoryContext)objectArray[i], workSpace);
            for (int j = 0; j < objectArray2.length && (workSpaceFile = ((RepositoryContext)objectArray2[j]).getFile(systemAppsFileName)) != null; ++j) {
                ((RepositoryContext)objectArray2[j]).extract(systemAppsFileName, false);
                Resource resource = ((RepositoryContext)objectArray2[j]).getResourceSet().createResource(URI.createURI((String)systemAppsFileName));
                resource.load(new HashMap());
                vector.addAll(AppUtils.listSystemApps(resource));
            }
        }
        return vector;
    }

    public static Vector listSystemApps(Resource resource) {
        Vector<String> vector = new Vector<String>();
        ServerIndex serverIndex = (ServerIndex)resource.getContents().get(0);
        EList eList = serverIndex.getServerEntries();
        for (int i = 0; i < eList.size(); ++i) {
            ServerEntry serverEntry = (ServerEntry)eList.get(i);
            EList eList2 = serverEntry.getDeployedApplications();
            for (int j = 0; j < eList2.size(); ++j) {
                String string = (String)eList2.get(j);
                if (!string.endsWith(".ear")) continue;
                String string2 = string.substring(string.lastIndexOf("/") + 1);
                string2 = string2.substring(0, string2.lastIndexOf(".ear"));
                vector.add(string2);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("sys apps: " + vector));
        }
        return vector;
    }

    public static boolean isAnInstalledSystemApp(String string, WorkSpace workSpace, Hashtable hashtable, boolean bl) throws Exception {
        String string2 = hashtable == null ? null : (String)hashtable.get("cell.name");
        String string3 = (String)hashtable.get("node.name");
        String string4 = (String)hashtable.get("server.name");
        RepositoryContext repositoryContext = workSpace.findContext("cells/" + string2 + "/nodes/" + string3);
        WorkSpaceFile workSpaceFile = null;
        try {
            workSpaceFile = repositoryContext.getFile(systemAppsFileName);
        }
        catch (Throwable throwable) {
            return false;
        }
        if (workSpaceFile == null) {
            return false;
        }
        repositoryContext.extract(systemAppsFileName, false);
        Resource resource = repositoryContext.getResourceSet().createResource(URI.createURI((String)systemAppsFileName));
        resource.load(new HashMap());
        ServerIndex serverIndex = (ServerIndex)resource.getContents().get(0);
        EList eList = serverIndex.getServerEntries();
        for (int i = 0; i < eList.size(); ++i) {
            ServerEntry serverEntry = (ServerEntry)eList.get(i);
            EList eList2 = serverEntry.getDeployedApplications();
            for (int j = 0; j < eList2.size(); ++j) {
                String string5 = (String)eList2.get(j);
                if (!string5.endsWith(".ear")) continue;
                String string6 = string5.substring(string5.lastIndexOf("/") + 1);
                if (!(string6 = string6.substring(0, string6.lastIndexOf(".ear"))).equals(string)) continue;
                if (bl) {
                    serverEntry.getDeployedApplications().remove(j);
                    serverEntry.eResource().save(new HashMap());
                }
                if (!serverEntry.getServerName().equals(string4)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("isAnInstalledSystemApp" + string + ", " + string2 + ", " + string4 + ": true"));
                }
                return true;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("isAnInstalledSystemApp" + string + ", " + string2));
        }
        return false;
    }

    public static RepositoryContext findAppContextFromConfig(String string, WorkSpace workSpace, Hashtable hashtable) throws Exception {
        String string2;
        String string3 = AppUtils.getAppBinDirName(hashtable, string);
        String string4 = EditionHelper.getCompositeName(string, hashtable);
        String string5 = string2 = hashtable == null ? null : (String)hashtable.get("cell.name");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("findAppContextFromConfig:" + string + ", " + string2 + ", " + string3));
        }
        Object[] objectArray = AppUtils.getContextArray("cells", null, workSpace);
        RepositoryContext repositoryContext = null;
        if (string2 != null) {
            repositoryContext = AppUtils.getContextFromArray(objectArray, string2, null, true);
        }
        if (repositoryContext == null && objectArray.length == 1) {
            repositoryContext = (RepositoryContext)objectArray[0];
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("cell context: " + repositoryContext));
        }
        if (string3 == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"setting bin name to appname.ear");
            }
            string3 = string + ".ear";
        }
        if (repositoryContext != null) {
            RepositoryContext repositoryContext2 = repositoryContext.getChild(AppUtils.getContextType("applications"), string3);
            if (repositoryContext2 == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("No binC : " + string3));
                }
                return null;
            }
            RepositoryContext repositoryContext3 = repositoryContext2.getChild(AppUtils.getContextType("deployments"), string4);
            return repositoryContext3;
        }
        Object[] objectArray2 = workSpace.findContext(AppUtils.getContextType("applications")).toArray();
        RepositoryContext repositoryContext4 = AppUtils.getContextFromArray(objectArray2, string3, null, false);
        if (repositoryContext4 == null) {
            return null;
        }
        return repositoryContext4.getChild(AppUtils.getContextType("deployments"), string4);
    }

    public static boolean isCluster(RepositoryContext repositoryContext) {
        if (repositoryContext == null) {
            return false;
        }
        return repositoryContext.getType().getName().equals("clusters");
    }

    public static RepositoryContext getClusterFromMember(RepositoryContext repositoryContext, WorkSpace workSpace) throws Exception {
        Object[] objectArray;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getClusterFromMember: " + repositoryContext.getName()));
        }
        if ((objectArray = AppUtils.getContextArray("clusters", repositoryContext.getParent().getParent(), workSpace)) == null || objectArray.length == 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getClusterFromMember:none");
            }
            return null;
        }
        URI uRI = URI.createURI((String)"server.xml");
        Resource resource = repositoryContext.getResourceSet().createResource(uRI);
        HashMap hashMap = new HashMap();
        resource.load(hashMap);
        Server server = (Server)resource.getContents().get(0);
        String string = server.getClusterName();
        if (string == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getClusterFromMember:null");
            }
            return null;
        }
        RepositoryContext repositoryContext2 = AppUtils.getContextFromArray(objectArray, string, null, false);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("For server: " + repositoryContext.getName() + ", clusterName: " + string + ", clContext: " + repositoryContext2));
        }
        if (repositoryContext2 == null) {
            throw new AdminException(AppUtils.getMessage(AppUtils.getBundle(null), "ADMA5029E", new Object[]{repositoryContext.getName(), string}));
        }
        return repositoryContext2;
    }

    public static boolean isServer(RepositoryContext repositoryContext) {
        if (repositoryContext == null) {
            return false;
        }
        return repositoryContext.getType().getName().equals("servers");
    }

    public static String getAppDir(String string) {
        String string2 = string;
        string2 = string2.replace(' ', '_');
        string2 = string2.replace('.', '_');
        return string2;
    }

    public static String getAppDir(Scheduler scheduler) {
        return AppUtils.getAppDir(scheduler.getAppName());
    }

    public static String getAppTempDir(Scheduler scheduler) {
        String string = AppUtils.getTempDir(scheduler);
        string = string + AppUtils.getAppDir("app." + scheduler.getID());
        return string;
    }

    public static String getTempDir() {
        return AppUtils.getTempDir(null);
    }

    public static String getTempDir(Scheduler scheduler) {
        String string = "";
        string = scheduler == null ? AppManagementBaseFactory.getTempExtractDir() : (String)scheduler.getAppManagement().getGlobalSettings().get("Temp extraction dir for multiserver");
        if (!string.endsWith(java.io.File.separator)) {
            string = string + java.io.File.separator;
        }
        return string;
    }

    public static String getAppTempExtractDir(Scheduler scheduler) throws AdminException {
        return AppUtils.getAppTempDir(scheduler) + java.io.File.separator + "ext";
    }

    public static String getAppTempMergeDir(Scheduler scheduler) throws AdminException {
        return AppUtils.getAppTempDir(scheduler) + java.io.File.separator + "mrg";
    }

    public static String getAppTempDeployDir(Scheduler scheduler) throws AdminException {
        return AppUtils.getAppTempDir(scheduler) + java.io.File.separator + "dpl";
    }

    public static String getAppDeployFileName(String string) {
        return "dpl_" + AppUtils.getAppDir(string);
    }

    public static String getPreAppDeployFileName(String string) {
        return "predpl_" + AppUtils.getAppDir(string) + ".ear";
    }

    public static String getAppTempExportDir(String string, Hashtable hashtable) {
        String string2 = (String)hashtable.get("Temp extraction dir for multiserver");
        if (!string2.endsWith(java.io.File.separator)) {
            string2 = string2 + java.io.File.separator;
        }
        string2 = string2 + "tmp." + System.currentTimeMillis();
        return string2;
    }

    public static boolean isSystemApp(Scheduler scheduler) {
        return Boolean.TRUE.equals(scheduler.getProperties().get("META-INF/ibm-application-sa.props"));
    }

    public static String getAppInstallDir(Scheduler scheduler, RepositoryContext repositoryContext) throws Exception {
        Object v = scheduler.getProperties().get("installed.ear.destination.final");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("INSTALL_DIR_FINAL= " + v));
        }
        if (v != null) {
            return v.toString();
        }
        String string = (String)scheduler.getProperties().get("installed.ear.destination");
        if (AppUtils.isEmpty(string)) {
            string = "$(APP_INSTALL_ROOT)/" + repositoryContext.getParent().getParent().getName() + "/";
        } else if (!(string = string.trim().replace(java.io.File.separatorChar, '/')).endsWith("/")) {
            string = string + "/";
        }
        string = string + EditionHelper.getAppEarName(scheduler.getAppName(), scheduler.getProperties());
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Install Dir: " + string));
        }
        return string;
    }

    public static String getAppBinDirName(Scheduler scheduler) {
        return AppUtils.getAppBinDirName(scheduler.getProperties(), scheduler.getAppName());
    }

    public static String getAppBinDirName(Hashtable hashtable, String string) {
        String string2 = null;
        if (hashtable != null) {
            string2 = (String)hashtable.get("appbinary.name");
        }
        if (string2 != null) {
            return string2;
        }
        String string3 = EditionHelper.getAppAndEdition(string, hashtable)[0];
        return string3 + ".ear";
    }

    public static String convert2AbsPath(String string, VariableMap variableMap) throws Exception {
        if (string.indexOf("$(") == -1 && string.indexOf("${") == -1) {
            return string;
        }
        if (variableMap == null) {
            return string;
        }
        String string2 = variableMap.expand(string);
        string2 = string2.replace('/', java.io.File.separatorChar);
        string2 = string2.replace('\\', java.io.File.separatorChar);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("convert2AbsPath: " + string + " = " + string2));
        }
        return string2;
    }

    public static VariableMap createVarMap(RepositoryContext repositoryContext, String string) throws Exception {
        if (AppManagementImpl.isLocalMode()) {
            String string2 = repositoryContext.getParent().getParent().getName();
            String string3 = repositoryContext.getParent().getName();
            return AppUtils.createVarMap(string, string2, string3, null);
        }
        String string4 = repositoryContext.getParent().getParent().getName();
        String string5 = repositoryContext.getParent().getName();
        String string6 = repositoryContext.getName();
        Tr.debug((TraceComponent)tc, (String)(" cellName => " + string4));
        Tr.debug((TraceComponent)tc, (String)(" nodeName => " + string5));
        Tr.debug((TraceComponent)tc, (String)(" server   => " + string6));
        return AppUtils.createVarMap(string, string4, string5, string6);
    }

    public static VariableMap createVarMap(String string, String string2, String string3, String string4) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createVarMap");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("ConfigRoot: " + string + ", " + "CellName: " + string2 + ", " + "NodeName: " + string3 + ", " + "ProcName: " + string4));
        }
        BeanContextServicesSupport beanContextServicesSupport = new BeanContextServicesSupport();
        Repository repository = RepositoryFactory.createRepository((String)"ws-server", (String)string, (String)string2, (String)string3, (String)string4);
        beanContextServicesSupport.addService(Repository.class, (BeanContextServiceProvider)repository);
        VariableMap variableMap = VariableMapFactory.createVariableMap();
        beanContextServicesSupport.add(variableMap);
        variableMap.initialize(null);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("createVarMap: " + variableMap));
        }
        return variableMap;
    }

    public static synchronized void deleteDirTree(String string) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"deleteDirTree");
        }
        AppUtils._deleteDirTree(new java.io.File(string).getCanonicalFile(), true);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"deleteDirTree");
        }
    }

    public static synchronized void deleteDirTree(String string, boolean bl) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"deleteDirTree");
        }
        AppUtils._deleteDirTree(new java.io.File(string).getCanonicalFile(), bl);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"deleteDirTree");
        }
    }

    public static synchronized void deleteDirTree(java.io.File file) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"deleteDirTree");
        }
        AppUtils._deleteDirTree(file.getCanonicalFile(), true);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"deleteDirTree");
        }
    }

    public static synchronized void deleteDirTree(java.io.File file, boolean bl) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"deleteDirTree");
        }
        AppUtils._deleteDirTree(file.getCanonicalFile(), bl);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"deleteDirTree");
        }
    }

    private static synchronized void _deleteDirTree(java.io.File file, boolean bl) throws IOException {
        if (!file.exists()) {
            Tr.event((TraceComponent)tc, (String)"directory does not exist");
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"deleteDirTree");
            }
            return;
        }
        String string = System.getProperty("os.name");
        boolean bl2 = true;
        if (!bl && !string.startsWith("Windows")) {
            bl2 = string.equals("OS/400") ? file.getAbsolutePath().equalsIgnoreCase(file.getCanonicalPath()) : file.getAbsolutePath().equals(file.getCanonicalPath());
        }
        if (!bl2) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("file/dir a symlink: " + file));
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"deleteDirTree");
            }
            return;
        }
        if (file.isDirectory()) {
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                java.io.File file2 = new java.io.File(file.getPath(), stringArray[i]);
                AppUtils._deleteDirTree(file2, bl);
            }
        }
        if (!file.delete()) {
            Tr.warning((TraceComponent)tc, (String)"ADMA0078W", (Object)file);
        }
    }

    public static void xcopy(RepositoryContext repositoryContext, String string, Vector vector) throws Exception {
        String string2;
        String string3;
        int n;
        java.io.File file = new java.io.File(string);
        String string4 = file.getAbsolutePath();
        file.mkdirs();
        repositoryContext.extract(false);
        String string5 = repositoryContext.getPath();
        List list = new ArrayList(repositoryContext.getFiles());
        for (n = 0; n < list.size(); ++n) {
            string3 = (String)list.get(n);
            if (vector.contains(string3)) continue;
            if (java.io.File.separatorChar != '/') {
                string3 = string3.replace('/', java.io.File.separatorChar);
            }
            string2 = string5 + java.io.File.separator + string3;
            AppUtils.copyFile(new java.io.File(string2), string4 + java.io.File.separator + string3);
        }
        list = repositoryContext.getChildren();
        for (n = 0; n < list.size(); ++n) {
            string3 = (RepositoryContext)list.get(n);
            string2 = string3.getPath();
            AppUtils.xcopy((RepositoryContext)string3, string + java.io.File.separator + string3.getName(), vector);
        }
    }

    public static void copyFile(java.io.File file, String string) throws Exception {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Copying..: " + file.getAbsolutePath() + " to " + string));
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        AppUtils.copyFile(fileInputStream, string);
        fileInputStream.close();
    }

    public static void copyFile(InputStream inputStream, String string) throws Exception {
        java.io.File file = new java.io.File(string);
        file.getParentFile().mkdirs();
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        byte[] byArray = new byte[4096];
        int n = inputStream.read(byArray);
        while (n != -1) {
            fileOutputStream.write(byArray, 0, n);
            n = inputStream.read(byArray);
        }
        fileOutputStream.flush();
        fileOutputStream.close();
    }

    public static byte[] getFileContents(InputStream inputStream) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getFileContents");
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[4096];
        int n = inputStream.read(byArray);
        while (n != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
            n = inputStream.read(byArray);
        }
        byteArrayOutputStream.flush();
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getFileContents: " + byArray2.length));
        }
        return byArray2;
    }

    public static String getInstallDirFromBinariesURL(ApplicationDeployment applicationDeployment) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getInstallDirFromBinariesURL " + applicationDeployment));
        }
        String string = applicationDeployment.getBinariesURL();
        int n = string.lastIndexOf(47);
        int n2 = string.lastIndexOf(92);
        if (n2 > n) {
            n = n2;
        }
        if (n == -1) {
            return string;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getInstallDirFromBinariesURL " + string));
        }
        return string.substring(0, n);
    }

    public static String getBinaryContextFromBinariesURL(ApplicationDeployment applicationDeployment) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getBinaryContextFromBinariesURL " + applicationDeployment));
        }
        String string = applicationDeployment.getBinariesURL();
        int n = string.lastIndexOf(47);
        int n2 = string.lastIndexOf(92);
        if (n2 > n) {
            n = n2;
        }
        if (n == -1) {
            return string;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getBinaryContextFromBinariesURL " + string));
        }
        return string.substring(n + 1);
    }

    public static List getURIs(String string) {
        return AppUtils.getFiles(string, "");
    }

    public static List getFiles(String string, String string2) {
        ArrayList arrayList = new ArrayList();
        AppUtils.getFiles(arrayList, new java.io.File(string), string2);
        return arrayList;
    }

    public static void getFiles(List list, java.io.File file, String string) {
        if (!file.isDirectory()) {
            return;
        }
        if (!file.exists()) {
            return;
        }
        java.io.File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            String string2 = fileArray[i].getName();
            if (string2.equals(".") || string2.equals("..")) continue;
            if (fileArray[i].isDirectory()) {
                AppUtils.getFiles(list, fileArray[i], string + string2 + "/");
                continue;
            }
            list.add((string + string2).replace('\\', '/'));
        }
    }

    public static Object[] getContainerAndOffset(Container container, String string) throws Exception {
        string.replace('\\', '/');
        EList eList = container.getFiles();
        for (int i = 0; i < eList.size(); ++i) {
            File file = (File)eList.get(i);
            if (file.getURI().equals(string)) {
                return new Object[]{container, string};
            }
            if (!string.startsWith(file.getURI() + "/") || !(file instanceof Container)) continue;
            return AppUtils.getContainerAndOffset((Container)file, string.substring(string.indexOf(file.getURI()) + file.getURI().length() + 1));
        }
        return new Object[]{container, string};
    }

    public static String getNodeMajorVersion(String string, String string2) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getNodeMajorVersion");
        }
        try {
            Properties properties = new Properties();
            properties.setProperty("local.cell", string);
            ManagedObjectMetadataHelper managedObjectMetadataHelper = new ManagedObjectMetadataHelper(ManagedObjectMetadataAccessorFactory.createAccessor(properties));
            String string3 = managedObjectMetadataHelper.getNodeMajorVersion(string2);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getNodeMajorVersion");
            }
            return string3;
        }
        catch (Throwable throwable) {
            throw new AdminException(throwable, "");
        }
    }

    public static String[][] getResourceTable() {
        String[] stringArray = new String[]{"server", "MapModulesToServers", "Server", "name"};
        String[] stringArray2 = new String[]{"virtualHost", "MapWebModToVH", "VirtualHost", "name"};
        String[] stringArray3 = new String[]{"JNDI", "BindJndiForEJBMessageBinding", "J2EEResourceFactory", "jndiName"};
        String[] stringArray4 = new String[]{"JNDI", "DataSourceFor10CMPBeans", "J2EEResourceFactory", "jndiName"};
        String[] stringArray5 = new String[]{"JNDI", "DataSourceFor10EJBModules", "J2EEResourceFactory", "jndiName"};
        String[] stringArray6 = new String[]{"JNDI", "DataSourceFor20CMPBeans", "J2EEResourceFactory", "jndiName"};
        String[] stringArray7 = new String[]{"JNDI", "DataSourceFor20EJBModules", "J2EEResourceFactory", "jndiName"};
        String[] stringArray8 = new String[]{"JNDI", "BindJndiForEJBNonMessageBinding", "J2EEResourceFactory", "jndiName"};
        String[] stringArray9 = new String[]{"JNDI", "MapResRefToEJB", "J2EEResourceFactory", "jndiName"};
        String[] stringArray10 = new String[]{"JNDI", "MapResEnvRefToRes", "J2EEResourceFactory", "jndiName"};
        String[] stringArray11 = new String[]{"JNDI", "BindJndiForEJBMessageBinding", "J2CActivationSpec", "destinationJndiName"};
        String[] stringArray12 = new String[]{"JNDI", "BindJndiForEJBMessageBinding", "J2CActivationSpec", "jndiName"};
        String[] stringArray13 = new String[]{"jndi.dest", "BindJndiForEJBMessageBinding", "J2CAdminObject", "jndiName"};
        String[] stringArray14 = new String[]{"jndi.dest", "MapRunAsRolesToUsers", "JAASAuthData", "authData"};
        String[][] stringArray15 = new String[][]{stringArray, stringArray2, stringArray3, stringArray4, stringArray4, stringArray6, stringArray7, stringArray8, stringArray9, stringArray10, stringArray11, stringArray12, stringArray13, stringArray14};
        return stringArray15;
    }

    public static String getClientVersion() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getClientVersion ");
        }
        if (AppManagementImpl.isLocalMode()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getClientVersion: 999999");
            }
            return "999999";
        }
        JMXVersionValidation jMXVersionValidation = new JMXVersionValidation();
        String string = jMXVersionValidation.getClientVersion();
        if (string == null) {
            string = "999999";
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getClientVersion: " + string));
        }
        return string;
    }

    public static String getClientVersion(Hashtable hashtable, boolean bl) {
        if (bl) {
            return "999999";
        }
        return AppUtils.getClientVersion();
    }

    public static Properties getEditionProps(RepositoryContext repositoryContext) throws AdminException {
        if (!repositoryContext.getParent().isAvailable("ibm-edition-metadata.props")) {
            return new Properties();
        }
        try {
            repositoryContext.getParent().extract("ibm-edition-metadata.props", false);
            Properties properties = new Properties();
            FileInputStream fileInputStream = new FileInputStream(repositoryContext.getParent().getPath() + "/" + "ibm-edition-metadata.props");
            properties.load(fileInputStream);
            fileInputStream.close();
            return properties;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.application.AppUtils.getEditionProps", (String)"756");
            AppUtils.dbg(tc, "Error loading edition props: " + repositoryContext);
            if (throwable instanceof AdminException) {
                throw (AdminException)((Object)throwable);
            }
            throw new AdminException(throwable, null);
        }
    }

    public static void setEditionProps(RepositoryContext repositoryContext, Properties properties) throws AdminException {
        try {
            if (properties == null) {
                return;
            }
            boolean bl = repositoryContext.getParent().isAvailable("ibm-edition-metadata.props");
            OutputStream outputStream = repositoryContext.getParent().getOutputStream("ibm-edition-metadata.props");
            properties.store(outputStream, "File contains metadata for all editions of the application");
            outputStream.flush();
            outputStream.close();
            repositoryContext.getParent().notifyChanged(bl ? 0 : 1, "ibm-edition-metadata.props");
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.application.AppUtils.setEditionProps", (String)"779");
            AppUtils.dbg(tc, "Error saving edition props: " + repositoryContext);
            if (throwable instanceof AdminException) {
                throw (AdminException)((Object)throwable);
            }
            throw new AdminException(throwable, null);
        }
    }
}

