/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.j2ee.commonarchivecore.Archive;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.client.AppInstallHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;

public abstract class AppUpdate {
    protected Locale locale;
    protected ResourceBundle bundle;
    protected static final String ADD = "add";
    protected static final String DELETE = "delete";
    protected static final String UPDATE = "update";
    protected static final String ADDUPDATE = "addupdate";
    private static final String defaultBundleName = "com.ibm.ws.management.resources.AppDeploymentMessages";
    private static TraceComponent tc = Tr.register((Class)AppUpdate.class, null, (String)"com.ibm.ws.management.resources.AppDeploymentMessages");
    private List _deleted = new ArrayList();
    private List _added = new ArrayList();
    private List _updated = new ArrayList();
    private boolean _syncMode = false;

    public AppUpdate() {
        this._deleted = new ArrayList();
    }

    public abstract List getURIs();

    public abstract InputStream getContentAsInputStream(String var1);

    public List getDeletedList() {
        return this._deleted;
    }

    public void setLists(List list, List list2, List list3) {
        this._deleted = list;
        this._added = list2;
        this._updated = list3;
    }

    public void setSyncMode(boolean bl) {
        this._syncMode = bl;
    }

    public void mergeFiles(String string, String string2, String string3) throws Exception {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"mergeFiles");
        }
        ArrayList arrayList = new ArrayList();
        List list = this.getURIs();
        for (n = 0; n < list.size(); ++n) {
            this.createDirsInPath(string3, (String)list.get(n), arrayList);
            this.performFileOperation(string2, string3, (String)list.get(n), this._deleted, string);
        }
        AppUtils.dbg(tc, "Collapse list is: " + arrayList);
        for (n = 0; n < arrayList.size(); ++n) {
            Archive archive = AppInstallHelper.getArchive((String)arrayList.get(n), false, true, this.getResourceBundle(), false);
            archive.saveNoReopen();
            archive.close();
            archive = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"mergeFiles");
        }
    }

    private void createDirsInPath(String string, String string2, List list) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("createDirsInPath " + string2));
        }
        String string3 = string;
        String[] stringArray = string2.split("/");
        for (int i = 0; i < stringArray.length - 1; ++i) {
            File file = new File(string3 + "/" + stringArray[i]);
            if (!file.exists()) {
                return;
            }
            if (!file.isDirectory()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Expanding archive at " + file.getPath()));
                }
                Archive archive = AppInstallHelper.getArchive(file.getPath(), false, true, this.getResourceBundle(), false);
                archive.extract(0);
                archive.close();
                archive = null;
                String string4 = file.getPath().substring(string.length() + 1);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("archURI: " + string4));
                }
                if (this.addToCollapse(string4)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Need to collapse archURI: " + string4));
                    }
                    list.add(file.getPath());
                }
            }
            string3 = string3 + "/" + stringArray[i];
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("createDirsInPath " + string2));
        }
    }

    private void performFileOperation(String string, String string2, String string3, List list, String string4) throws Exception {
        AppUtils.dbg(tc, "performFileOperation: source=" + string + ", dest=" + string2 + ", uri= " + string3 + ", op= " + string4);
        if (this.doDeletes(string, string2, string3, string4, list)) {
            return;
        }
        File file = new File(string2 + "/" + string3);
        if (!this._syncMode) {
            if (string4.equals(ADD) && file.exists()) {
                throw new AdminException("File URI " + string3 + " already exists so add operation failed.");
            }
            if (string4.equals(UPDATE) && !file.exists()) {
                throw new AdminException("File URI " + string3 + " does not exists so update operation failed.");
            }
        }
        InputStream inputStream = this.getContentAsInputStream(string3);
        if (!string4.equals(DELETE)) {
            if (file.exists()) {
                this._updated.add(string3);
                if (file.isDirectory()) {
                    AppUtils.deleteDirTree(file, false);
                }
            } else {
                this._added.add(string3);
            }
            AppUtils.dbg(tc, "Copying file from " + string + "/" + string3 + " to " + file.getPath());
            AppUtils.copyFile(inputStream, file.getPath());
        }
        inputStream.close();
    }

    private boolean doDeletes(String string, String string2, String string3, String string4, List list) throws Exception {
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"doDeletes");
        }
        String string5 = null;
        String string6 = "";
        if (string3.endsWith("META-INF/ibm-partialapp-delete.props")) {
            Object object;
            Object object2;
            AppUtils.dbg(tc, "Processing delete from : " + string3);
            string5 = this.getPropFileArchiveURI(string3);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("deleting files under archive path: " + string5));
            }
            String string7 = string2 + "/" + string5;
            try {
                object2 = null;
                object = new BufferedReader(new FileReader(string + "/" + string3));
                while ((object2 = ((BufferedReader)object).readLine()) != null) {
                    string6 = (string6.trim().equals("") ? string6 : string6 + "|") + (String)object2;
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.application.AppUpdate.doDeletes", (String)"233", (Object)this);
                Tr.debug((TraceComponent)tc, (String)("Error reading " + string3 + " for partial app deletion processing."));
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("delete patterns = " + string6));
            }
            object2 = AppUtils.getURIs(string7);
            object = "";
            for (int i = 0; i < object2.size(); ++i) {
                object = (String)object2.get(i);
                AppUtils.dbg(tc, "trying to match file for delete: " + (String)object);
                if (!((String)object).matches(string6)) continue;
                AppUtils.dbg(tc, "Deleting file " + (String)object + " from " + string7);
                File file = new File(string7 + "/" + (String)object);
                if (file.exists()) {
                    file.delete();
                    list.add((AppUtils.isEmpty(string5) ? "" : string5 + "/") + (String)object);
                    continue;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("File does not exist: " + file));
            }
        } else if (DELETE.equals(string4)) {
            File file = new File(string2 + "/" + string3);
            if (file.exists()) {
                AppUtils.deleteDirTree(string2 + "/" + string3, false);
                list.add(string3);
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"doDeletes");
            }
            return false;
        }
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"doDeletes");
        }
        return true;
    }

    protected boolean addToCollapse(String string) throws Exception {
        return true;
    }

    private String getPropFileArchiveURI(String string) {
        String string2 = "";
        int n = string.indexOf("META-INF/ibm-partialapp-delete.props");
        if (n != 0) {
            string2 = string.substring(0, n - 1);
        }
        return string2.trim();
    }

    protected ResourceBundle getResourceBundle() {
        if (this.bundle == null) {
            this.bundle = AppUtils.getBundle(this.getResourceBundleName(), this.locale);
        }
        return this.bundle;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    protected String getResourceBundleName() {
        return defaultBundleName;
    }
}

