/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.RuntimeCollaborator;
import com.ibm.websphere.management.application.AppManagement;
import com.ibm.websphere.management.application.AppManagementFactory;
import com.ibm.websphere.management.application.AppNotification;
import com.ibm.websphere.management.application.EditionHelper;
import com.ibm.websphere.management.application.EditionInfo;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.application.AppAssociation;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.DistributionStatusSchedulerImpl;
import com.ibm.ws.management.application.EditApplication;
import com.ibm.ws.management.application.InstallSchedulerImpl;
import com.ibm.ws.management.application.RedeploymentManager;
import com.ibm.ws.management.application.ResourceLookup;
import com.ibm.ws.management.application.UninstallSchedulerImpl;
import com.ibm.ws.management.application.UpdateClusterScheduler;
import com.ibm.ws.management.application.UpdateSchedulerImpl;
import com.ibm.ws.management.application.task.ConfigRepoHelper;
import com.ibm.ws.management.connector.interop.JMXVersionValidation;
import com.ibm.ws.management.util.SecurityHelper;
import com.ibm.ws.security.policy.ApplicationPolicyParser;
import com.ibm.ws.security.policy.FilterPolicyParser;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.security.Permission;
import java.security.PrivilegedExceptionAction;
import java.security.Security;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import javax.management.Notification;
import javax.management.ObjectName;
import javax.security.auth.Subject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;

public class AppManagementImpl
extends RuntimeCollaborator
implements AppManagement {
    public static final String TEMP_EXTRACT_DIR = "Temp extraction dir for multiserver";
    public static final String CONFIG_ROOT = "Config Root for variable map";
    private static TraceComponent tc = Tr.register((Class)AppManagementImpl.class, (String)"Admin", (String)"com.ibm.ws.management.resources.AppDeploymentMessages");
    private static TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.management.resources.AppDeploymentMessages");
    private static final String PROPERTIES_PATH = "version.properties";
    private static final String VERSION_KEY = "app.management.roam.key";
    private static final String VERSION_VALUE = "3828436921961863062";
    private Hashtable _props;
    private static ObjectName objectName;
    private static long seqNum;
    private boolean readOnly = false;
    private String readOnlyPath = null;
    private long readOnlyTimeStamp;
    static final String RES_SCOPE = "scope";
    static final String RES_TYPE = "type";
    static final String RES_VALUE = "value";
    static final String RES_INDEX = "index";
    static /* synthetic */ Class class$java$lang$String;

    public static AppManagement createLocalImpl() {
        return AppManagementFactory.createLocalAppManagementImpl();
    }

    public static AppManagement createLocalImpl(String string) {
        return AppManagementFactory.createLocalAppManagementImpl(string);
    }

    public AppManagementImpl(Hashtable hashtable) {
        this._props = hashtable;
    }

    public Hashtable getGlobalSettings() {
        return this._props;
    }

    public void setObjectName(ObjectName objectName) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("setObjectName: " + objectName));
        }
        super.setObjectName(objectName);
        AppManagementImpl.objectName = objectName;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setObjectName");
        }
    }

    public static boolean isLocalMode() {
        return objectName == null;
    }

    public void sendJMXEvent(Object object) {
        this.sendJMXEvent("websphere.admin.appmgmt", object);
    }

    public void sendJMXEvent(String string, Object object) {
        block5: {
            if (AppManagementImpl.isLocalMode()) {
                return;
            }
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"sendJMXEvent");
            }
            try {
                Notification notification = new Notification("websphere.admin.appmgmt", objectName, ++seqNum);
                notification.setUserData(object);
                this.sendNotification(notification);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.application.AppManagementImpl.sendJMXEvent", (String)"163", (Object)this);
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug((TraceComponent)tc, (String)("Exception from sending JMX event: " + throwable));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"sendJMXEvent");
        }
    }

    public boolean checkIfAppExists(String string, Hashtable hashtable, String string2) throws AdminException {
        Tr.entry((TraceComponent)tc, (String)("checkIfAppExists: " + string));
        EditApplication editApplication = new EditApplication(string, hashtable, null, string2, this);
        boolean bl = editApplication.checkIfAppExists() != null;
        Tr.entry((TraceComponent)tc, (String)("checkIfAppExists: " + bl));
        return bl;
    }

    public void installApplication(String string, Hashtable hashtable, String string2) throws AdminException {
        this.installApplication(string, null, hashtable, string2);
    }

    public void installApplication(String string, String string2, Hashtable hashtable, String string3) throws AdminException {
        this._installApplication(string, string2, hashtable, null, true, string3);
    }

    public void installApplicationLocal(String string, String string2, Hashtable hashtable, AppNotification.Listener listener) throws AdminException {
        this._installApplication(string, string2, hashtable, listener, false, null);
    }

    public void installApplicationLocal(String string, String string2, Hashtable hashtable, AppNotification.Listener listener, String string3) throws AdminException {
        this._installApplication(string, string2, hashtable, listener, false, string3);
    }

    private void _installApplication(String string, String string2, Hashtable hashtable, AppNotification.Listener listener, boolean bl, String string3) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("_installApplication " + string + ", " + string2));
        }
        ResourceBundle resourceBundle = AppUtils.getBundle(hashtable);
        if (this.isReadOnlyMode()) {
            throw new AdminException(AppUtils.getMessage(resourceBundle, "ADMA0094E", new Object[]{"installApplication"}));
        }
        if (string == null) {
            throw new AdminException(AppUtils.getMessage(resourceBundle, "ADMA0041E"));
        }
        if (hashtable == null) {
            throw new AdminException(AppUtils.getMessage(resourceBundle, "ADMA0042E"));
        }
        if (!new File(string).exists()) {
            throw new AdminException(AppUtils.getMessage(resourceBundle, "ADMA0043E", new Object[]{string}));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Create new installscheduler");
        }
        InstallSchedulerImpl installSchedulerImpl = new InstallSchedulerImpl(string, string2, hashtable, this, listener);
        try {
            installSchedulerImpl.setWorkSpaceID(string3);
            Thread thread = new Thread(installSchedulerImpl);
            thread.start();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.application.AppManagementImpl._installApplication", (String)"264", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"_installAppliction");
            }
            throw new AdminException(throwable, AppUtils.getMessage(resourceBundle, "ADMA0044E", new Object[]{string}));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"_installAppliction");
        }
    }

    public void uninstallApplicationLocal(String string, Hashtable hashtable, AppNotification.Listener listener) throws AdminException {
        this._uninstallApplication(string, hashtable, listener, false, null);
    }

    public void uninstallApplicationLocal(String string, Hashtable hashtable, AppNotification.Listener listener, String string2) throws AdminException {
        this._uninstallApplication(string, hashtable, listener, false, string2);
    }

    public void uninstallApplication(String string, Hashtable hashtable, String string2) throws AdminException {
        this._uninstallApplication(string, hashtable, null, true, string2);
    }

    public void _uninstallApplication(String string, Hashtable hashtable, AppNotification.Listener listener, boolean bl, String string2) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("_uninstallApplication " + string));
        }
        ResourceBundle resourceBundle = AppUtils.getBundle(hashtable);
        if (this.isReadOnlyMode()) {
            throw new AdminException(AppUtils.getMessage(resourceBundle, "ADMA0094E", new Object[]{"uninstallApplication"}));
        }
        if (string == null) {
            throw new AdminException(AppUtils.getMessage(resourceBundle, "ADMA0045E"));
        }
        if (!bl && hashtable == null) {
            throw new AdminException(AppUtils.getMessage(resourceBundle, "ADMA0046E"));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Create new uninstallscheduler");
        }
        UninstallSchedulerImpl uninstallSchedulerImpl = new UninstallSchedulerImpl(string, hashtable, this, listener);
        try {
            uninstallSchedulerImpl.setWorkSpaceID(string2);
            Thread thread = new Thread(uninstallSchedulerImpl);
            thread.start();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.application.AppManagementImpl._uninstallApplication", (String)"328", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"_uninstallAppliction");
            }
            throw new AdminException(throwable, AppUtils.getMessage(resourceBundle, "ADMA0047E", new Object[]{string}));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("_uninstallApplication " + string));
        }
    }

    public void redeployApplicationLocal(String string, String string2, Hashtable hashtable, AppNotification.Listener listener, String string3) throws AdminException {
        if (this.isReadOnlyMode()) {
            ResourceBundle resourceBundle = AppUtils.getBundle(hashtable);
            throw new AdminException(AppUtils.getMessage(resourceBundle, "ADMA0094E", new Object[]{"redeployApplication"}));
        }
        RedeploymentManager redeploymentManager = new RedeploymentManager(string, string2, hashtable, string3, listener, true, this);
        redeploymentManager.performTask();
    }

    public void redeployApplication(String string, String string2, Hashtable hashtable, String string3) throws AdminException {
        if (this.isReadOnlyMode()) {
            ResourceBundle resourceBundle = AppUtils.getBundle(hashtable);
            throw new AdminException(AppUtils.getMessage(resourceBundle, "ADMA0094E", new Object[]{"redeployApplication"}));
        }
        RedeploymentManager redeploymentManager = new RedeploymentManager(string, string2, hashtable, string3, null, false, this);
        redeploymentManager.performTask();
    }

    public Vector getApplicationInfo(String string, Hashtable hashtable, String string2) throws AdminException {
        return this._getApplicationInfo(string, hashtable, null, string2);
    }

    public Vector getModuleInfo(String string, Hashtable hashtable, String string2, String string3) throws AdminException {
        return this._getApplicationInfo(string, hashtable, string2, string3);
    }

    private Vector _getApplicationInfo(String string, Hashtable hashtable, String string2, String string3) throws AdminException {
        Vector vector;
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getApplicationInfo:" + string + ", " + string2));
        }
        if (AdminHelper.getPlatformHelper().isZOS() && AdminHelper.getPlatformHelper().isServantJvm() && hashtable != null && (object = (String)hashtable.get("REQUEST_CLIENT_VERSION")) != null) {
            vector = new JMXVersionValidation();
            Tr.debug((TraceComponent)tc, (String)("client version is " + (String)object));
            JMXVersionValidation.setClientVersion((String)object);
            hashtable.remove("REQUEST_CLIENT_VERSION");
        }
        if (hashtable == null) {
            hashtable = new Hashtable();
        }
        object = new EditApplication(string, hashtable, string2, string3, this);
        vector = ((EditApplication)object).getApplicationInfo();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getApplicationInfo");
        }
        return vector;
    }

    public void setApplicationInfo(String string, Hashtable hashtable, String string2, Vector vector) throws AdminException {
        this._setApplicationInfo(string, hashtable, null, string2, vector);
    }

    public void setModuleInfo(String string, Hashtable hashtable, String string2, String string3, Vector vector) throws AdminException {
        this._setApplicationInfo(string, hashtable, string2, string3, vector);
    }

    private void _setApplicationInfo(String string, Hashtable hashtable, String string2, String string3, Vector vector) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("_setApplicationInfo: " + string + ", " + string2));
        }
        EditApplication editApplication = new EditApplication(string, hashtable, string2, string3, this);
        editApplication.setApplicationInfo(vector);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setApplicationInfo");
        }
    }

    public void moveModule(String string, Hashtable hashtable, String string2, ObjectName objectName, String string3) throws AdminException {
    }

    public void exportApplication(String string, String string2, Hashtable hashtable, String string3) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("exportApplication: " + string));
        }
        EditApplication editApplication = new EditApplication(string, hashtable, null, string3, this);
        editApplication.exportApplication(string2);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("exportApplication: " + string));
        }
    }

    public void extractDDL(String string, String string2, String string3, Hashtable hashtable, String string4) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("extractDDL: " + string));
        }
        EditApplication editApplication = new EditApplication(string, hashtable, null, string4, this);
        editApplication.extractDDL(string2, string3);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("extractDDL: " + string));
        }
    }

    public void publishWSDL(String string, String string2, Hashtable hashtable, String string3) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("publishWSDL: " + string));
        }
        EditApplication editApplication = new EditApplication(string, hashtable, null, string3, this);
        editApplication.publishWSDL(string2);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("publishWSDL: " + string));
        }
    }

    public Vector listSystemApplications(Hashtable hashtable, String string) throws AdminException {
        Vector vector;
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"listSystemApplications");
            }
            vector = new Vector();
            try {
                vector = AppUtils.listSystemApps(hashtable, string);
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug((TraceComponent)tc, (String)("Exception from listSystemApps " + exception));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("listSystemApplications: " + vector));
        }
        return vector;
    }

    public Vector listApplications(Hashtable hashtable, String string) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"listApplications");
        }
        Vector vector = EditApplication.listApplications(hashtable, string);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("listApplications: " + vector));
        }
        return vector;
    }

    public Object listModules(String string, Hashtable hashtable, String string2) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("listModules: " + string));
        }
        EditApplication editApplication = new EditApplication(string, hashtable, null, string2, this);
        AppDeploymentTask appDeploymentTask = editApplication.listModules();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("listModules: " + string + ", " + appDeploymentTask));
        }
        return appDeploymentTask;
    }

    public List listURIs(String string, String string2, Hashtable hashtable, String string3) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("listURIs: " + string + ", " + string2));
        }
        EditApplication editApplication = new EditApplication(string, hashtable, string2, string3, this);
        List list = editApplication.listURIs();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"listURIs");
        }
        return list;
    }

    public void removeAllAppsFromNode(String string, String string2, Hashtable hashtable, String string3) throws AdminException {
        if (this.isReadOnlyMode()) {
            ResourceBundle resourceBundle = AppUtils.getBundle(hashtable);
            throw new AdminException(AppUtils.getMessage(resourceBundle, "ADMA0094E", new Object[]{"removeAllAppsFromNode"}));
        }
        AppAssociation appAssociation = new AppAssociation(this, hashtable, string3);
        appAssociation.removeAllAppsFromNode(string, string2);
    }

    public void removeAllAppsFromServer(ObjectName objectName, Hashtable hashtable, String string) throws AdminException {
        if (this.isReadOnlyMode()) {
            ResourceBundle resourceBundle = AppUtils.getBundle(hashtable);
            throw new AdminException(AppUtils.getMessage(resourceBundle, "ADMA0094E", new Object[]{"removeAllAppsFromServer"}));
        }
        AppAssociation appAssociation = new AppAssociation(this, hashtable, string);
        appAssociation.removeAllAppsFromServer(objectName);
    }

    public void removeAllAppsFromCluster(ObjectName objectName, Hashtable hashtable, String string) throws AdminException {
        if (this.isReadOnlyMode()) {
            ResourceBundle resourceBundle = AppUtils.getBundle(hashtable);
            throw new AdminException(AppUtils.getMessage(resourceBundle, "ADMA0094E", new Object[]{"removeAllAppsFromCluster"}));
        }
        AppAssociation appAssociation = new AppAssociation(this, hashtable, string);
        appAssociation.removeAllAppsFromCluster(objectName);
    }

    public void changeServerToCluster(ObjectName objectName, ObjectName objectName2, Hashtable hashtable, String string) throws AdminException {
        AppAssociation appAssociation = new AppAssociation(this, hashtable, string);
        appAssociation.changeServerToCluster(objectName, objectName2);
    }

    public void clusterMemberAdded(ObjectName objectName, ObjectName objectName2, Hashtable hashtable, String string) throws AdminException {
        AppAssociation appAssociation = new AppAssociation(this, hashtable, string);
        appAssociation.clusterMemberAdded(objectName, objectName2);
    }

    public void updateAccessIDs(String string, Boolean bl, Hashtable hashtable, String string2) throws AdminException {
        EditApplication editApplication = new EditApplication(string, hashtable, null, string2, this);
        editApplication.updateAccessIDs(bl);
    }

    public void deleteUserAndGroupEntries(String string, Hashtable hashtable, String string2) throws AdminException {
        EditApplication editApplication = new EditApplication(string, hashtable, null, string2, this);
        editApplication.deleteUserAndGroupEntries();
    }

    public String startApplication(String string, Hashtable hashtable, String string2) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("startApplication: " + string));
        }
        if (AppManagementImpl.isLocalMode()) {
            throw new AdminException(nls.getFormattedMessage("ADMA0090", new Object[]{"startApplication"}, "Invalid usage of {0}. Operation {0} can only be called in JMX mode of AppManagement"));
        }
        if (string == null) {
            throw new AdminException(nls.getFormattedMessage("ADMA0016E", new Object[0], "appName can not be null."));
        }
        AdminHelper.getInstance().audit("ADMN1008I", "ADMN1009I", new Object[]{string, null});
        WorkSpace workSpace = null;
        try {
            workSpace = ConfigRepoHelper.getWorkSpace(string2);
            RepositoryContext repositoryContext = AppUtils.findAppContextFromConfig(string, workSpace, hashtable);
            if (repositoryContext == null) {
                throw new AdminException(nls.getFormattedMessage("ADMA0017E", new Object[]{string}, "Unable to obtain context for {0}"));
            }
            RepositoryContext repositoryContext2 = repositoryContext.getParent().getParent();
            ApplicationDeployment applicationDeployment = ConfigRepoHelper.getAppDeploymentForApp(repositoryContext);
            Vector vector = ConfigRepoHelper.getServersForAppDeployment(applicationDeployment, null, repositoryContext2, workSpace, false);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("All targets: " + vector));
            }
            String string3 = this._startApplication(string, vector, workSpace);
            return string3;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.application.AppManagementImpl.startApplication", (String)"670", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Exception thrown in startApplication: " + throwable));
            }
            if (throwable instanceof AdminException) {
                throw (AdminException)((Object)throwable);
            }
            throw new AdminException(throwable, "");
        }
        finally {
            EditApplication.doFinally(workSpace, string2, null, false);
        }
    }

    public String startApplication(String string, String string2, Hashtable hashtable, String string3) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("startApplication: " + string));
        }
        if (AppManagementImpl.isLocalMode()) {
            throw new AdminException(nls.getFormattedMessage("ADMA0090", new Object[]{"startApplication"}, "Invalid usage of {0}. Operation {0} can only be called in JMX mode of AppManagement"));
        }
        if (string == null) {
            throw new AdminException(nls.getFormattedMessage("ADMA0016E", new Object[0], "appName can not be null."));
        }
        if (string2 == null) {
            return this.startApplication(string, hashtable, string3);
        }
        AdminHelper.getInstance().audit("ADMN1008I", "ADMN1009I", new Object[]{string, null});
        WorkSpace workSpace = null;
        try {
            workSpace = ConfigRepoHelper.getWorkSpace(string3);
            RepositoryContext repositoryContext = AppUtils.findAppContextFromConfig(string, workSpace, hashtable);
            if (repositoryContext == null) {
                throw new AdminException(nls.getFormattedMessage("ADMA0017E", new Object[]{string}, "Unable to obtain context for {0}"));
            }
            RepositoryContext repositoryContext2 = repositoryContext.getParent().getParent();
            Vector vector = ConfigRepoHelper.getServerNames(string2, string, false, repositoryContext2, workSpace);
            String string4 = this._startApplication(string, vector, workSpace);
            return string4;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.application.AppManagementImpl.startApplication", (String)"720", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Exception thrown in startApplication: " + throwable));
            }
            if (throwable instanceof AdminException) {
                throw (AdminException)((Object)throwable);
            }
            throw new AdminException(throwable, "");
        }
        finally {
            EditApplication.doFinally(workSpace, string3, null, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String _startApplication(String string, Vector vector, WorkSpace workSpace) throws Exception {
        Object object;
        Object object2;
        Serializable serializable;
        Object object3;
        Properties properties;
        RepositoryContext repositoryContext = null;
        vector = ConfigRepoHelper.getAllServers(workSpace, vector);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("All server targets: " + vector));
        }
        if (EditionHelper.isEditionSupportEnabled() && (properties = AppUtils.getEditionProps(object3 = AppUtils.findAppContextFromConfig(string, workSpace, (Hashtable)(serializable = new Hashtable())))) != null) {
            object2 = EditionHelper.getEditionStatePropName(string);
            object = (String)properties.get(object2);
            if (object == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"_startApplication");
                }
                throw new AdminException("Application " + string + " is not active");
            }
            if (!((String)object).equalsIgnoreCase("ACTIVE")) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"_startApplication");
                }
                throw new AdminException("Application " + string + " is not active");
            }
        }
        serializable = SecurityHelper.retrieveSubject();
        object3 = null;
        if (serializable != null) {
            serializable = SecurityHelper.pushInvocationSubject((Subject)serializable);
        }
        try {
            for (int i = 0; i < vector.size(); ++i) {
                repositoryContext = (RepositoryContext)vector.elementAt(i);
                object2 = new ObjectName("WebSphere:type=ApplicationManager,node=" + repositoryContext.getParent().getName() + ",process=" + repositoryContext.getName() + ",*");
                try {
                    object = AdminServiceFactory.getAdminService().queryNames((ObjectName)object2, null).iterator();
                    if (object.hasNext()) {
                        object2 = (ObjectName)object.next();
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Starting app: " + string + " using " + object2));
                        }
                        AdminServiceFactory.getAdminService().invoke((ObjectName)object2, "startApplication", new Object[]{string}, new String[]{(class$java$lang$String == null ? AppManagementImpl.class$("java.lang.String") : class$java$lang$String).getName()});
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Started app: " + string + " using " + object2));
                        }
                        String string2 = "WebSphere:cell=" + repositoryContext.getParent().getParent().getName() + ",node=" + repositoryContext.getParent().getName() + ",server=" + repositoryContext.getName();
                        object3 = object3 == null ? string2 : (String)object3 + "+" + string2;
                        continue;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("No ApplicationManager MBean on: " + repositoryContext));
                    continue;
                }
                catch (Throwable throwable) {
                    Tr.warning((TraceComponent)tc, (String)("Unable to start: " + string + " using: " + object2 + " exception is: " + throwable));
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.application.AppManagementImpl.startApplication", (String)"815", (Object)this);
                }
            }
            RepositoryContext repositoryContext2 = object3;
            return repositoryContext2;
        }
        finally {
            if (serializable != null) {
                SecurityHelper.popInvocationSubject((Subject)serializable);
            }
        }
    }

    public String stopApplication(String string, Hashtable hashtable, String string2) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("stopApplication: " + string));
        }
        if (AppManagementImpl.isLocalMode()) {
            throw new AdminException(nls.getFormattedMessage("ADMA0090", new Object[]{"stopApplication"}, "Invalid usage of {0}. Operation {0} can only be called in JMX mode of AppManagement"));
        }
        if (string == null) {
            throw new AdminException(nls.getFormattedMessage("ADMA0016E", new Object[0], "appName can not be null."));
        }
        AdminHelper.getInstance().audit("ADMN1010I", "ADMN1011I", new Object[]{string, null});
        String string3 = null;
        Subject subject = SecurityHelper.retrieveSubject();
        try {
            if (subject != null) {
                subject = SecurityHelper.pushInvocationSubject((Subject)subject);
            }
            ObjectName objectName = new ObjectName("WebSphere:type=Application,name=" + string + ",*");
            Set set = AdminServiceFactory.getAdminService().queryNames(objectName, null);
            String string4 = string3 = this._stopApplication(string, set, hashtable, string2);
            return string4;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.application.AppManagementImpl.stopApplication", (String)"864", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Exception thrown in stopApplication: " + throwable));
            }
            if (throwable instanceof AdminException) {
                throw (AdminException)((Object)throwable);
            }
            throw new AdminException(throwable, "");
        }
        finally {
            if (subject != null) {
                SecurityHelper.popInvocationSubject((Subject)subject);
            }
        }
    }

    public String stopApplication(String string, String string2, Hashtable hashtable, String string3) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("stopApplication: " + string));
        }
        if (string2 == null) {
            return this.stopApplication(string, hashtable, string3);
        }
        if (AppManagementImpl.isLocalMode()) {
            throw new AdminException(nls.getFormattedMessage("ADMA0090", new Object[]{"stopApplication"}, "Invalid usage of {0}. Operation {0} can only be called in JMX mode of AppManagement"));
        }
        if (string == null) {
            throw new AdminException(nls.getFormattedMessage("ADMA0016E", new Object[0], "appName can not be null."));
        }
        AdminHelper.getInstance().audit("ADMN1010I", "ADMN1011I", new Object[]{string, null});
        WorkSpace workSpace = null;
        try {
            workSpace = ConfigRepoHelper.getWorkSpace(string3);
            RepositoryContext repositoryContext = AppUtils.findAppContextFromConfig(string, workSpace, hashtable);
            if (repositoryContext == null) {
                throw new AdminException(nls.getFormattedMessage("ADMA0017E", new Object[]{string}, "Unable to obtain context for {0}"));
            }
            RepositoryContext repositoryContext2 = repositoryContext.getParent().getParent();
            Vector vector = ConfigRepoHelper.getServerNames(string2, string, false, repositoryContext2, workSpace);
            Vector vector2 = ConfigRepoHelper.getAllServers(workSpace, vector);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("All server targets: " + vector2));
            }
            HashSet<ObjectName> hashSet = new HashSet<ObjectName>();
            for (int i = 0; i < vector2.size(); ++i) {
                repositoryContext = (RepositoryContext)vector2.elementAt(i);
                ObjectName objectName = new ObjectName("WebSphere:type=Application,name=" + string + ",node=" + repositoryContext.getParent().getName() + ",process=" + repositoryContext.getName() + ",*");
                hashSet.add(objectName);
            }
            return this._stopApplication(string, hashSet, hashtable, string3);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.application.AppManagementImpl.stopApplication", (String)"933", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Exception thrown in stopApplication: " + throwable));
            }
            if (throwable instanceof AdminException) {
                throw (AdminException)((Object)throwable);
            }
            throw new AdminException(throwable, "");
        }
    }

    private String _stopApplication(String string, Set set, Hashtable hashtable, String string2) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("_stopApplication: " + string));
        }
        Object object = null;
        Subject subject = SecurityHelper.retrieveSubject();
        try {
            ObjectName objectName;
            if (subject != null) {
                subject = SecurityHelper.pushInvocationSubject((Subject)subject);
            }
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                objectName = (ObjectName)iterator.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Stopping: " + objectName));
                }
                objectName = new ObjectName("WebSphere:type=ApplicationManager,node=" + objectName.getKeyProperty("node") + ",process=" + objectName.getKeyProperty("process") + ",*");
                try {
                    Iterator iterator2 = AdminServiceFactory.getAdminService().queryNames(objectName, null).iterator();
                    if (iterator2.hasNext()) {
                        objectName = (ObjectName)iterator2.next();
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Stopping app: " + string + " using " + objectName));
                        }
                        AdminServiceFactory.getAdminService().invoke(objectName, "stopApplication", new Object[]{string}, new String[]{(class$java$lang$String == null ? AppManagementImpl.class$("java.lang.String") : class$java$lang$String).getName()});
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Stopped app: " + string + " using " + objectName));
                        }
                        object = ConfigRepoHelper.getTargetString(objectName, (String)object);
                        continue;
                    }
                    Tr.warning((TraceComponent)tc, (String)"ADMA0118W", (Object)new Object[]{objectName});
                }
                catch (Throwable throwable) {
                    Tr.warning((TraceComponent)tc, (String)"ADMA0117W", (Object)new Object[]{string, objectName, throwable});
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.application.AppManagementImpl.stopApplication", (String)"989", (Object)this);
                }
            }
            objectName = object;
            return objectName;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.application.AppManagementImpl.stopApplication", (String)"997", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Exception thrown in stopApplication: " + throwable));
            }
            if (throwable instanceof AdminException) {
                throw (AdminException)((Object)throwable);
            }
            throw new AdminException(throwable, "");
        }
        finally {
            if (subject != null) {
                SecurityHelper.popInvocationSubject((Subject)subject);
            }
        }
    }

    public void installStandaloneRAR(String string, Hashtable hashtable, String string2) throws AdminException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Vector compareSecurityPolicy(String var1_1, Hashtable var2_2, String var3_3) throws AdminException {
        block25: {
            if (AppManagementImpl.tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)AppManagementImpl.tc, (String)"compareSecurityPolicy");
            }
            var4_4 = new Vector<String>();
            var5_5 = null;
            var6_6 = new Vector<String>();
            var7_7 = new Vector<String>();
            var8_8 = AppUtils.getBundle(var2_2);
            if (var1_1 == null || var1_1.trim().equals("")) break block25;
            try {
                block26: {
                    var5_5 = ConfigRepoHelper.getWorkSpace(var3_3);
                    if (AppManagementImpl.tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)AppManagementImpl.tc, (String)("workspace: " + var5_5));
                    }
                    var9_9 = null;
                    var10_11 = AppUtils.getContextArray("cells", null, var5_5);
                    if (var10_11 != null) {
                        var11_12 = (String)var2_2.get("cell.name");
                        var9_9 = var11_12 != null ? AppUtils.getContextFromArray(var10_11, (String)var11_12, null, true) : (RepositoryContext)var10_11[0];
                    }
                    if (var10_11 != null && var9_9 != null) break block26;
                    Tr.warning((TraceComponent)AppManagementImpl.tc, (String)"ADMA0070W");
                    var4_4.addElement(AppUtils.getMessage(var8_8, "ADMA0070W"));
                    var11_12 = var4_4;
                    var32_13 = null;
                    if (var5_5 == null) return var11_12;
                    if (var3_3 != null) return var11_12;
                    ** GOTO lbl100
                }
                if (AppManagementImpl.tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)AppManagementImpl.tc, (String)("context found: " + var9_9));
                }
                if (var9_9.isAvailable("filter.policy")) {
                    var9_9.extract("filter.policy", false);
                    var11_12 = var9_9.getInputStream("filter.policy");
                    var12_21 = new InputStreamReader((InputStream)var11_12);
                    var13_22 = Security.getProperty("policy.expandProperties");
                    var14_23 = false;
                    if (var13_22 != null) {
                        var14_23 = var13_22.equalsIgnoreCase("true");
                    }
                    var15_24 = new FilterPolicyParser((Reader)var12_21, var14_23);
                    var15_24.parse();
                    var16_25 = var15_24.getFilterPermissions();
                    if (AppManagementImpl.tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)AppManagementImpl.tc, (String)("Permissions to be filtered: " + var16_25));
                    }
                    var11_12.close();
                    var17_26 = var1_1.getBytes();
                    var18_27 = new ByteArrayInputStream(var17_26);
                    var19_28 = new InputStreamReader(var18_27);
                    var20_29 = new ApplicationPolicyParser((Reader)var19_28, var14_23);
                    var20_29.parse();
                    var21_30 = var20_29.getPolicyTemplate();
                    var22_31 = var21_30.getSymbols();
                    for (var23_32 = 0; var23_32 < var22_31.length; ++var23_32) {
                        var24_33 = var21_30.get(var22_31[var23_32]);
                        if (AppManagementImpl.tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)AppManagementImpl.tc, (String)("Permissions for symbol " + var22_31[var23_32] + ": " + var24_33));
                        }
                        var25_34 = var24_33.iterator();
                        while (var25_34.hasNext()) {
                            var26_35 = true;
                            var27_36 = (Permission)var25_34.next();
                            var28_37 = var27_36.toString();
                            if (!(var28_37.startsWith("(java") || var28_37.startsWith("(javax") || var28_37.startsWith("(unresolved java") || var28_37.startsWith("(unresolved javax"))) {
                                if (AppManagementImpl.tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)AppManagementImpl.tc, (String)("Custom permission found: " + var27_36));
                                }
                                var7_7.addElement(var28_37);
                                continue;
                            }
                            var29_38 = var16_25.iterator();
                            while (var29_38.hasNext() && var26_35) {
                                var30_39 = (Permission)var29_38.next();
                                if (!var30_39.implies(var27_36)) continue;
                                var26_35 = false;
                            }
                            if (var26_35) continue;
                            var6_6.addElement(var28_37);
                        }
                    }
                }
                ** GOTO lbl106
            }
            catch (Throwable var9_10) {
                var4_4.addElement(AppUtils.getMessage(var8_8, "ADMA0071W", new Object[]{var9_10.toString()}));
                Tr.warning((TraceComponent)AppManagementImpl.tc, (String)"ADMA0071W", (Object)var9_10);
                var32_15 = null;
                if (var5_5 != null && var3_3 == null) {
                    try {
                        ConfigRepoHelper.removeWorkSpace(false, var5_5);
                    }
                    catch (Throwable var33_19) {
                        Tr.warning((TraceComponent)AppManagementImpl.tc, (String)"ADMA0077W", (Object)var33_19);
                    }
                }
                break block25;
            }
            {
                catch (Throwable var31_40) {
                    var32_16 = null;
                    if (var5_5 == null) throw var31_40;
                    if (var3_3 != null) throw var31_40;
                    ** try [egrp 2[TRYBLOCK] [6 : 790->799)] { 
lbl95:
                    // 1 sources

                    ConfigRepoHelper.removeWorkSpace(false, var5_5);
                    throw var31_40;
lbl97:
                    // 1 sources

                    catch (Throwable var33_20) {
                        Tr.warning((TraceComponent)AppManagementImpl.tc, (String)"ADMA0077W", (Object)var33_20);
                    }
                    throw var31_40;
                }
lbl100:
                // 1 sources

                ** try [egrp 2[TRYBLOCK] [6 : 790->799)] { 
lbl101:
                // 1 sources

                ConfigRepoHelper.removeWorkSpace(false, var5_5);
                return var11_12;
lbl103:
                // 1 sources

                catch (Throwable var33_17) {
                    Tr.warning((TraceComponent)AppManagementImpl.tc, (String)"ADMA0077W", (Object)var33_17);
                }
                return var11_12;
lbl106:
                // 1 sources

                var32_14 = null;
                if (var5_5 == null || var3_3 != null) break block25;
                ** try [egrp 2[TRYBLOCK] [6 : 790->799)] { 
lbl109:
                // 1 sources

                ConfigRepoHelper.removeWorkSpace(false, var5_5);
lbl111:
                // 1 sources

                catch (Throwable var33_18) {}
                Tr.warning((TraceComponent)AppManagementImpl.tc, (String)"ADMA0077W", (Object)var33_18);
            }
        }
        if (!var6_6.isEmpty()) {
            if (AppManagementImpl.tc.isDebugEnabled() == false) throw new AdminException(AppUtils.getMessage(var8_8, "ADMA0072E"));
            Tr.debug((TraceComponent)AppManagementImpl.tc, (String)("policy file contains filter permissions: " + var6_6));
            throw new AdminException(AppUtils.getMessage(var8_8, "ADMA0072E"));
        }
        if (!var7_7.isEmpty()) {
            var4_4.addElement(AppUtils.getMessage(var8_8, "ADMA0073W", new Object[]{var7_7}));
            Tr.warning((TraceComponent)AppManagementImpl.tc, (String)"ADMA0073W", var7_7);
        }
        if (AppManagementImpl.tc.isEntryEnabled() == false) return var4_4;
        Tr.exit((TraceComponent)AppManagementImpl.tc, (String)"compareSecurityPolicy");
        return var4_4;
    }

    private boolean isReadOnlyMode() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(this.readOnlyPath + ", " + this.readOnly + ", " + this.readOnlyTimeStamp));
        }
        if (this.readOnlyPath == null) {
            URL uRL = classLoader.getResource(PROPERTIES_PATH);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("url: " + uRL));
            }
            if (uRL == null) {
                this.readOnlyTimeStamp = 0L;
                this.readOnly = true;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"url not found");
                }
            } else {
                this.readOnlyPath = uRL.getFile();
                try {
                    this.readOnlyPath = URLDecoder.decode(this.readOnlyPath, "UTF-8");
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Decoded url: " + this.readOnlyPath));
                    }
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("exception in decoding url: " + unsupportedEncodingException));
                    }
                    FFDCFilter.processException((Throwable)unsupportedEncodingException, (String)"com.ibm.websphere.management.application.AppManagementBaseFactory", (String)"1204");
                }
                File file = new File(this.readOnlyPath);
                this.readOnly = AppManagementImpl.getReadOnlyFlag(file);
                this.readOnlyTimeStamp = file.lastModified();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(this.readOnlyPath + ", " + this.readOnly + ", " + this.readOnlyTimeStamp));
                }
            }
        } else {
            File file = new File(this.readOnlyPath);
            if (!file.exists()) {
                URL uRL;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("File not found: " + this.readOnlyPath + ", so look again"));
                }
                if ((uRL = classLoader.getResource(PROPERTIES_PATH)) == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"existing file not in classpath");
                    }
                    this.readOnlyTimeStamp = 0L;
                    this.readOnly = true;
                } else {
                    this.readOnlyPath = uRL.getFile();
                    try {
                        this.readOnlyPath = URLDecoder.decode(this.readOnlyPath, "UTF-8");
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Decoded url: " + this.readOnlyPath));
                        }
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("exception in decoding url: " + unsupportedEncodingException));
                        }
                        FFDCFilter.processException((Throwable)unsupportedEncodingException, (String)"com.ibm.websphere.management.application.AppManagementBaseFactory", (String)"1238");
                    }
                    File file2 = new File(this.readOnlyPath);
                    this.readOnly = AppManagementImpl.getReadOnlyFlag(file2);
                    this.readOnlyTimeStamp = file2.lastModified();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("new: " + this.readOnlyPath + ", " + this.readOnly + ", " + this.readOnlyTimeStamp));
                    }
                }
            } else if (file.lastModified() == this.readOnlyTimeStamp) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("lock not changed: " + this.readOnly));
                }
            } else {
                this.readOnly = AppManagementImpl.getReadOnlyFlag(file);
                this.readOnlyTimeStamp = file.lastModified();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("timestamp changed: " + this.readOnly + ", " + this.readOnlyTimeStamp));
                }
            }
        }
        return this.readOnly;
    }

    private static boolean getReadOnlyFlag(final File file) {
        boolean bl;
        Properties properties = null;
        try {
            properties = (Properties)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public Object run() {
                    Properties properties;
                    Properties properties2 = new Properties();
                    FileInputStream fileInputStream = null;
                    try {
                        try {
                            fileInputStream = new FileInputStream(file);
                            if (fileInputStream != null) {
                                properties2.load(fileInputStream);
                            }
                            properties = properties2;
                            Object var6_5 = null;
                            if (fileInputStream == null) return properties;
                        }
                        catch (Throwable throwable) {
                            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.websphere.management.application.AppManagementBaseFactory", (String)"1288");
                            Object var4_11 = null;
                            Object var6_6 = null;
                            if (fileInputStream == null) return var4_11;
                            try {
                                ((InputStream)fileInputStream).close();
                                return var4_11;
                            }
                            catch (IOException iOException) {
                                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.websphere.management.application.AppManagementBaseFactory", (String)"1300");
                            }
                            return var4_11;
                        }
                    }
                    catch (Throwable throwable2) {
                        Object var6_7 = null;
                        if (fileInputStream == null) throw throwable2;
                        try {}
                        catch (IOException iOException) {
                            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.websphere.management.application.AppManagementBaseFactory", (String)"1300");
                            throw throwable2;
                        }
                        ((InputStream)fileInputStream).close();
                        throw throwable2;
                    }
                    try {}
                    catch (IOException iOException) {
                        FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.websphere.management.application.AppManagementBaseFactory", (String)"1300");
                        return properties;
                    }
                    ((InputStream)fileInputStream).close();
                    return properties;
                }
            });
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.websphere.management.application.AppManagementBaseFactory", (String)"1308");
        }
        if (properties == null) {
            bl = true;
        } else {
            String string = properties.getProperty(VERSION_KEY);
            if (VERSION_VALUE.equals(string)) {
                bl = false;
            } else {
                bl = true;
                Tr.audit((TraceComponent)tc, (String)"ADMA0096I");
            }
        }
        if (bl) {
            Tr.audit((TraceComponent)tc, (String)"ADMA0097I");
        }
        return bl;
    }

    public Hashtable searchJNDIReferences(List list, String string, Hashtable hashtable, String string2) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("searchJNDIReferences: " + list + " nodes: " + string + " prefs: " + hashtable + " wID: " + string2));
        }
        ResourceBundle resourceBundle = AppUtils.getBundle(hashtable);
        if (list == null) {
            return null;
        }
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>(5);
        WorkSpace workSpace = null;
        try {
            workSpace = ConfigRepoHelper.getWorkSpace(string2);
        }
        catch (Exception exception) {
            Tr.warning((TraceComponent)tc, (String)"ADMA0104W", (Object)exception);
        }
        if (workSpace == null) {
            Tr.error((TraceComponent)tc, (String)"ADMA0106E", (Object)string2);
            throw new AdminException(AppUtils.getMessage(resourceBundle, "ADMA0106E", new Object[]{string2}));
        }
        Hashtable hashtable3 = hashtable;
        if (hashtable == null) {
            hashtable3 = new Hashtable();
        }
        String string3 = null;
        String string4 = string;
        String[] stringArray = new String[]{string4};
        if (string4.indexOf(43) != -1) {
            stringArray = string4.split("\\+|");
        }
        for (int i = 0; i < stringArray.length; ++i) {
            ObjectName objectName = null;
            try {
                objectName = new ObjectName(stringArray[i]);
                String string5 = null;
                String string6 = null;
                String string7 = null;
                string5 = objectName.getKeyProperty("cell");
                string6 = objectName.getKeyProperty("node");
                string7 = objectName.getKeyProperty("server");
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("cell" + string5 + " node = " + string6 + "server = " + string7));
                }
                Vector vector = null;
                vector = string6 != null ? this.listAppsOnNode(string6, string5, hashtable3, workSpace) : this.listApplications(hashtable3, string2);
                Iterator iterator = vector.iterator();
                while (iterator.hasNext()) {
                    string3 = (String)iterator.next();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("appName:" + string3));
                    }
                    Vector vector2 = null;
                    vector2 = this.getApplicationInfo(string3, hashtable3, string2);
                    Object var20_23 = null;
                    AppDeploymentTask appDeploymentTask = null;
                    StringBuffer stringBuffer = new StringBuffer();
                    for (int j = 0; j < vector2.size(); ++j) {
                        appDeploymentTask = (AppDeploymentTask)vector2.elementAt(j);
                        String string8 = appDeploymentTask.getName();
                        if (string8.equals("EmbeddedRar")) continue;
                        String[] stringArray2 = appDeploymentTask.getColumnNames();
                        int n = stringArray2.length;
                        int n2 = -1;
                        int n3 = -1;
                        int n4 = -1;
                        for (int k = 0; k < n; ++k) {
                            if ("module".equals(stringArray2[k])) {
                                n4 = k;
                            }
                            if ("EJBModule".equals(stringArray2[k])) {
                                n4 = k;
                            }
                            if ("JNDI".equals(stringArray2[k])) {
                                n2 = k;
                            }
                            if (!"jndi.dest".equals(stringArray2[k])) continue;
                            n3 = k;
                        }
                        if (n2 == -1 && n3 == -1) continue;
                        String[][] stringArray3 = appDeploymentTask.getTaskData();
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("jndi column found " + string3 + "  task: " + string8));
                        }
                        if (stringArray3 == null) continue;
                        String string9 = null;
                        String string10 = null;
                        String string11 = null;
                        boolean bl = false;
                        for (int k = 1; k < stringArray3.length; ++k) {
                            string10 = stringArray3[k][n2];
                            if (n3 != -1) {
                                string11 = stringArray3[k][n3];
                            }
                            if (tc.isDebugEnabled()) {
                                if (string10 != null) {
                                    Tr.debug((TraceComponent)tc, (String)("jndi name  " + string10));
                                }
                                if (string11 != null) {
                                    Tr.debug((TraceComponent)tc, (String)("djndi name  " + string11));
                                }
                            }
                            if (string10 != null && list.contains(string10)) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)("data matched" + string10));
                                }
                                bl = true;
                                string9 = "  " + string8 + " :";
                                if (n4 != -1) {
                                    string9 = string9 + stringArray3[k][n4];
                                }
                                string9 = string9 + " : [" + string10 + "]\n";
                            }
                            if (string11 == null || !list.contains(string11)) continue;
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("data matched" + string11));
                            }
                            bl = true;
                            string9 = "  " + string8 + " :";
                            if (n4 != -1) {
                                string9 = string9 + stringArray3[k][n4];
                            }
                            string9 = string9 + " : [" + string11 + "]\n";
                        }
                        if (!bl) continue;
                        stringBuffer.append(string9);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)("search result " + string9));
                    }
                    String string12 = stringBuffer.toString();
                    if (string12 != null && string12.length() != 0) {
                        hashtable2.put(string3, string12);
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("List:" + string3 + " Ref:" + string12));
                }
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (workSpace != null && string2 == null) {
            try {
                ConfigRepoHelper.removeWorkSpace(false, workSpace);
            }
            catch (Throwable throwable) {
                Tr.warning((TraceComponent)tc, (String)"ADMA0077W", (Object)throwable);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("searchJNDIReferences: " + hashtable2));
        }
        return hashtable2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Vector listAppsOnNode(String string, String string2, Hashtable hashtable, WorkSpace workSpace) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("listAppsOnNode: " + string + ", " + string2));
        }
        ResourceBundle resourceBundle = AppUtils.getBundle(hashtable);
        boolean bl = false;
        Vector<String> vector = new Vector<String>();
        try {
            try {
                RepositoryContext repositoryContext = AppUtils.findContext("cells", string2, null, null, workSpace, true);
                if (repositoryContext == null) {
                    throw new AdminException(AppUtils.getMessage(resourceBundle, "ADMA5047E", new Object[]{string2}));
                }
                RepositoryContext repositoryContext2 = AppUtils.findContext("nodes", string, null, repositoryContext, workSpace, false);
                if (repositoryContext2 == null) {
                    throw new AdminException(AppUtils.getMessage(resourceBundle, "ADMA5040E", new String[]{string}));
                }
                URI uRI = URI.createURI((String)"serverindex.xml");
                Resource resource = repositoryContext2.getResourceSet().getResource(uRI, true);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Found for node " + repositoryContext2 + " SI doc res: " + resource));
                }
                ServerIndex serverIndex = (ServerIndex)resource.getContents().get(0);
                EList eList = serverIndex.getServerEntries();
                Object var14_15 = null;
                for (int i = 0; i < eList.size(); ++i) {
                    ServerEntry serverEntry = (ServerEntry)eList.get(i);
                    EList eList2 = serverEntry.getDeployedApplications();
                    for (int j = 0; j < eList2.size(); ++j) {
                        String string3 = (String)eList2.get(j);
                        String string4 = string3.substring(string3.lastIndexOf("/") + 1);
                        vector.add(string4);
                    }
                }
                Object var22_22 = null;
            }
            catch (Throwable throwable) {
                bl = true;
                FFDCFilter.processException((Throwable)throwable, (String)(this.getClass().getName() + "." + "listAppsOnNode"), (String)"1560", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Exception thrown in listAppsOnNode: " + throwable));
                }
                if (!(throwable instanceof AdminException)) throw new AdminException(throwable, "");
                throw (AdminException)((Object)throwable);
            }
        }
        catch (Throwable throwable) {
            Object var22_23 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)"listAppsOnNode");
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return vector;
        Tr.exit((TraceComponent)tc, (String)"listAppsOnNode");
        return vector;
    }

    private boolean isFullUpdate(Hashtable hashtable) {
        return hashtable != null && "app".equals(hashtable.get("contenttype"));
    }

    public void updateApplication(String string, String string2, String string3, String string4, Hashtable hashtable, String string5) throws AdminException {
        if (this.isFullUpdate(hashtable)) {
            if (string4 != null && !"update".equals(string4)) {
                this.sendJMXEvent(new AppNotification("UpdateApplication", "", "Failed", "", "ERROR: " + string4 + " is not a valid operation for full application."));
                throw new AdminException("ERROR: " + string4 + " is not a valid operation for full application.");
            }
            this.redeployApplication(string3, string, hashtable, string5);
        } else {
            this._updateApplication(string, string2, string3, string4, hashtable, null, string5);
        }
    }

    public void updateApplicationLocal(String string, String string2, String string3, String string4, Hashtable hashtable, AppNotification.Listener listener, String string5) throws AdminException {
        if (this.isFullUpdate(hashtable)) {
            if (string4 != null && !"update".equals(string4)) {
                listener.appEventReceived(new AppNotification("UpdateApplication", "", "Failed", "", "ERROR: " + string4 + " is not a valid operation for full application."));
                throw new AdminException("ERROR: " + string4 + " is not a valid operation for full application.");
            }
            this.redeployApplicationLocal(string3, string, hashtable, listener, string5);
        } else {
            this._updateApplication(string, string2, string3, string4, hashtable, listener, string5);
        }
    }

    public void _updateApplication(String string, String string2, String string3, String string4, Hashtable hashtable, AppNotification.Listener listener, String string5) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("_updateApplication " + string));
        }
        ResourceBundle resourceBundle = AppUtils.getBundle(hashtable);
        if (this.isReadOnlyMode()) {
            throw new AdminException(AppUtils.getMessage(resourceBundle, "ADMA0094E", new Object[]{"updateApplication"}));
        }
        if (string == null) {
            throw new AdminException(AppUtils.getMessage(resourceBundle, "ADMA0045E"));
        }
        if (hashtable == null) {
            hashtable = new Hashtable();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Create new updatescheduler");
        }
        UpdateSchedulerImpl updateSchedulerImpl = new UpdateSchedulerImpl(string, string2, string3, string4, hashtable, this, listener);
        try {
            updateSchedulerImpl.setWorkSpaceID(string5);
            Thread thread = new Thread(updateSchedulerImpl);
            thread.start();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.application.AppManagementImpl.updateApplication", (String)"1672", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"_updateApplication");
            }
            throw new AdminException(throwable, AppUtils.getMessage(resourceBundle, "ADMA0047E", new Object[]{string}));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("_updateApplication " + string));
        }
    }

    public void updateClusterLocal(String[] stringArray, Integer n, Hashtable hashtable, String string, AppNotification.Listener listener) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("updateClusterLocal " + stringArray));
        }
        this._updateCluster(stringArray, n, hashtable, string, listener);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("updateClusterLocal " + stringArray));
        }
    }

    public void updateCluster(String[] stringArray, Integer n, Hashtable hashtable, String string) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("updateCluster " + stringArray));
        }
        this._updateCluster(stringArray, n, hashtable, string, null);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("_updateCluster " + stringArray));
        }
    }

    private void _updateCluster(String[] stringArray, Integer n, Hashtable hashtable, String string, AppNotification.Listener listener) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("_updateCluster " + stringArray));
        }
        ResourceBundle resourceBundle = AppUtils.getBundle(hashtable);
        String string2 = new String();
        for (int i = 0; i < stringArray.length; ++i) {
            string2 = string2.concat(stringArray[i]);
            if (i >= stringArray.length - 1) continue;
            string2 = string2.concat(";");
        }
        Tr.debug((TraceComponent)tc, (String)(" in _updateCluster -> LAUNCH_TIMEOUT " + n));
        hashtable.put("LAUNCH_TIMEOUT", n);
        UpdateClusterScheduler updateClusterScheduler = new UpdateClusterScheduler(stringArray, string2, hashtable, this, listener);
        Locale locale = null;
        if (hashtable != null) {
            locale = (Locale)hashtable.get("app.client.locale");
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        updateClusterScheduler.setLocale(locale);
        try {
            updateClusterScheduler.setWorkSpaceID(string);
            Thread thread = new Thread(updateClusterScheduler);
            thread.start();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.application.AppManagementImpl._updateCluster", (String)"1728", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"_updateCluster");
            }
            throw new AdminException(AppUtils.getMessage(resourceBundle, "ADMA0094E", new Object[]{"updateCluster"}));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("_updateCluster " + stringArray));
        }
    }

    public List searchResources(String string, Hashtable hashtable, String string2) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("searchResources(" + string + "," + hashtable + "," + string2 + ")"));
        }
        Hashtable hashtable2 = hashtable;
        if (hashtable == null) {
            hashtable2 = new Hashtable();
        }
        Vector vector = null;
        vector = this.getApplicationInfo(string, hashtable2, string2);
        List list = ResourceLookup.searchResources(string, hashtable, string2, vector);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("searchResources returns : " + list));
        }
        return list;
    }

    public List convertRefToConfigID(String string, List list, Hashtable hashtable, String string2) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("convertRefToConfigID(" + string + "," + list + "." + string2));
        }
        List list2 = ResourceLookup.convertRefToConfigID(string, list, hashtable, string2);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("convertRefToConfigID returns " + list2));
        }
        return list2;
    }

    public byte[] getApplicationContents(String string, String string2, Hashtable hashtable, String string3) throws AdminException {
        EditApplication editApplication = new EditApplication(string, hashtable, null, string3, this);
        return editApplication.getApplicationContents(string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void getDistributionStatus(String string, Hashtable hashtable, String string2) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getDistributionStatus " + string));
        }
        DistributionStatusSchedulerImpl distributionStatusSchedulerImpl = new DistributionStatusSchedulerImpl(string, hashtable, this, null);
        try {
            try {
                distributionStatusSchedulerImpl.setWorkSpaceID(string2);
                Thread thread = new Thread(distributionStatusSchedulerImpl);
                thread.start();
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.application.AppManagementImpl.getDistributionStatus", (String)"1802", (Object)this);
                if (!(throwable instanceof AdminException)) throw new AdminException(throwable, throwable.getMessage());
                throw (AdminException)((Object)throwable);
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)("getDistributionStatus " + string));
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit((TraceComponent)tc, (String)("getDistributionStatus " + string));
    }

    public String[] getAppAssociation(String string, String string2, Hashtable hashtable, String string3) throws AdminException {
        EditApplication editApplication = new EditApplication(null, hashtable, null, string3, this);
        return editApplication.getAppAssociation(string, string2);
    }

    public EditionInfo[] getEditionInfo(String string, String string2, Hashtable hashtable, String string3) throws AdminException {
        EditApplication editApplication = new EditApplication(string, hashtable, null, string3, this);
        return editApplication.getEditionInfo(string2);
    }

    public void setEditionInfo(EditionInfo[] editionInfoArray, Hashtable hashtable, String string) throws AdminException {
        EditApplication editApplication = new EditApplication(null, hashtable, null, string, this);
        editApplication.setEditionInfo(editionInfoArray);
    }

    static {
        seqNum = 0L;
    }
}

