/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management.application.sync;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.application.sync.AppData;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.ws.management.application.sync.AddBinaryTask;
import com.ibm.ws.management.application.sync.AppSyncUtils;
import com.ibm.ws.management.application.sync.RemoveBinaryTask;
import com.ibm.ws.management.application.sync.StartDeploymentTask;
import com.ibm.ws.management.application.sync.StopDeploymentTask;
import java.util.Hashtable;
import javax.security.auth.Subject;

public abstract class AbstractAppSyncTask {
    private static final String defaultBundleName = "com.ibm.ws.management.resources.AppDeploymentMessages";
    private static TraceComponent tc = Tr.register((Class)AbstractAppSyncTask.class, (String)"Admin", (String)"com.ibm.ws.management.resources.AppDeploymentMessages");
    protected ConfigRepository _repository;
    protected String _cellName;
    protected String _nodeName;
    protected Subject _subject = null;
    protected boolean _isLocal;
    protected boolean _isStandAlone;
    protected Object _notify;
    protected Class _cls;
    protected Hashtable _cachedSIMap;
    protected Hashtable _newSIMap;
    public static final String ADDBINARYTASK = AddBinaryTask.class.getName();
    public static final String REMOVEBINARYTASK = RemoveBinaryTask.class.getName();
    public static final String STARTDEPLOYMENTTASK = StartDeploymentTask.class.getName();
    public static final String STOPDEPLOYMENTTASK = StopDeploymentTask.class.getName();

    public void setData(ConfigRepository configRepository, String string, String string2, boolean bl, Hashtable hashtable, Hashtable hashtable2) {
        this._repository = configRepository;
        this._cellName = string;
        this._nodeName = string2;
        this._isLocal = bl;
        this._cachedSIMap = hashtable;
        this._newSIMap = hashtable2;
        this._isStandAlone = !AppSyncUtils.isCellDistributed(this._cellName, this._repository);
    }

    public void setSecurity(Subject subject, Object object, Class clazz) {
        this._subject = subject;
        this._notify = object;
        this._cls = clazz;
    }

    public boolean appIsDeployedOnNode(String string) {
        boolean bl;
        if (AdminServiceFactory.getAdminService() != null && "NodeAgent".equals(AdminServiceFactory.getAdminService().getProcessType())) {
            return true;
        }
        boolean bl2 = bl = this._newSIMap.get(string) != null;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(string + " appIsDeployedOnNode: " + bl));
        }
        return bl;
    }

    public boolean appWasDeployedOnNode(String string) {
        boolean bl;
        if (AdminServiceFactory.getAdminService() != null && "NodeAgent".equals(AdminServiceFactory.getAdminService().getProcessType())) {
            return true;
        }
        boolean bl2 = bl = this._cachedSIMap.get(string) != null;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(string + " appWasDeployedOnNode: " + bl));
        }
        return bl;
    }

    public abstract boolean performTask(AppData var1, AppData var2, Hashtable var3) throws Exception;
}

