/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management.application.commands;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.CommonarchiveFactory;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.impl.CommonarchiveFactoryImpl;
import com.ibm.etools.j2ee.commonarchivecore.Archive;
import com.ibm.websphere.management.application.EarUtils;
import java.io.File;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;

public class EARExpander {
    private static TraceComponent tc = Tr.register((Class)EARExpander.class);
    private static String earOption = "ear";
    private static String operationDirOption = "operationdir";
    private static String operationOption = "operation";
    private static String expansionFlagOption = "expansionflags";
    private EARFile _earFile;
    private String _operationDirectory;
    private String _expansionFlags;
    private String _earName;
    private static ResourceBundle resBundle = ResourceBundle.getBundle("com.ibm.ws.management.resources.AppDeploymentMessages", Locale.getDefault());
    int exitCode = 0;

    public EARExpander(String string, String string2, String string3) {
        this._earName = string;
        this._operationDirectory = string2;
        this._expansionFlags = string3;
    }

    protected static String usage() {
        return EARExpander.getMessage("ADMA4001I");
    }

    protected static String getMessage(String string) {
        if (resBundle != null) {
            try {
                return resBundle.getString(string);
            }
            catch (MissingResourceException missingResourceException) {
                return string;
            }
        }
        return string;
    }

    protected static String getMessage(String string, Object[] objectArray) {
        String string2 = EARExpander.getMessage(string);
        if (objectArray == null) {
            return string2;
        }
        return MessageFormat.format(string2, objectArray);
    }

    protected static void printCommandErrorAndExit(String string, Object[] objectArray) {
        System.err.println(EARExpander.getMessage(string, objectArray));
        System.err.println(EARExpander.usage());
        System.exit(-1);
    }

    protected static void printErrorAndExit(String string, Object[] objectArray) {
        System.err.println(EARExpander.getMessage(string, objectArray));
        System.exit(-1);
    }

    public static void main(String[] stringArray) {
        Hashtable hashtable = EARExpander.parseCommandLineArgs(stringArray);
        if (!hashtable.containsKey(earOption)) {
            EARExpander.printCommandErrorAndExit("ADMA4002E", new Object[]{"ear"});
        }
        if (!hashtable.containsKey(operationDirOption)) {
            EARExpander.printCommandErrorAndExit("ADMA4002E", new Object[]{"operationDir"});
        }
        if (!hashtable.containsKey(operationOption)) {
            EARExpander.printCommandErrorAndExit("ADMA4002E", new Object[]{"operation"});
        }
        EARExpander eARExpander = new EARExpander((String)hashtable.get(earOption), (String)hashtable.get(operationDirOption), (String)hashtable.get(expansionFlagOption));
        if (hashtable.get("operation").equals("expand")) {
            eARExpander.expand();
            if (eARExpander.exitCode == -1) {
                System.exit(-1);
            }
        } else if (hashtable.get("operation").equals("collapse")) {
            eARExpander.collapse();
            if (eARExpander.exitCode == -1) {
                System.exit(-1);
            }
        } else {
            EARExpander.printCommandErrorAndExit("ADMA4005E", new Object[]{hashtable.get("operation")});
        }
    }

    public static Hashtable parseCommandLineArgs(String[] stringArray) {
        Vector<String> vector = new Vector<String>();
        vector.addElement(earOption);
        vector.addElement(operationDirOption);
        vector.addElement(operationOption);
        vector.addElement(expansionFlagOption);
        Vector<String> vector2 = new Vector<String>();
        vector2.addElement(earOption);
        vector2.addElement(operationDirOption);
        vector2.addElement(operationOption);
        try {
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            for (int i = 0; i < stringArray.length; i += 2) {
                String string = stringArray[i].substring(1, stringArray[i].length());
                String string2 = string.toLowerCase();
                if (!vector.contains(string2)) {
                    System.out.println(EARExpander.usage());
                    System.exit(-1);
                }
                if (i < stringArray.length - 1) {
                    String string3 = stringArray[i + 1];
                    if (!string3.startsWith("-")) {
                        hashtable.put(string2, string3);
                        continue;
                    }
                    hashtable.put(string2, "NO SUB-ARG");
                    if (vector2.contains(string2)) {
                        EARExpander.printCommandErrorAndExit("ADMA4008E", new Object[]{string});
                    }
                    --i;
                    continue;
                }
                if (vector2.contains(string2)) {
                    EARExpander.printCommandErrorAndExit("ADMA4008E", new Object[]{string});
                }
                hashtable.put(string2, "NO SUB-ARG");
            }
            return hashtable;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void expand() {
        File file = new File(this._earName);
        if (!(file.exists() && file.isFile() && file.canRead())) {
            EARExpander.printErrorAndExit("ADMA4003E", new Object[]{this._earName});
        }
        if ((file = new File(this._operationDirectory)).exists() && file.isFile()) {
            EARExpander.printErrorAndExit("ADMA4004E", new Object[]{this._operationDirectory});
        }
        try {
            int n = 126;
            if (this._expansionFlags != null && this._expansionFlags.equalsIgnoreCase("war")) {
                n = 2;
            } else if (this._expansionFlags != null && !this._expansionFlags.equalsIgnoreCase("All")) {
                System.out.println(EARExpander.getMessage("ADMA4009W", new Object[]{this._expansionFlags}));
            }
            System.out.println(EARExpander.getMessage("ADMA4006I", new Object[]{this._earName, this._operationDirectory}));
            this._earFile = EarUtils.getEarFile(this._earName, false);
            EarUtils.extractEar(this._earFile, this._operationDirectory, false, n);
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Exception during expand" + exception));
            }
            this.exitCode = -1;
        }
        finally {
            Tr.debug((TraceComponent)tc, (String)"Closing archive");
            this._earFile.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void collapse() {
        File file = new File(this._operationDirectory);
        if (!file.exists() || !file.isDirectory()) {
            EARExpander.printErrorAndExit("ADMA4004E", new Object[]{this._operationDirectory});
        }
        if ((file = new File(this._earName)).exists()) {
            EARExpander.printErrorAndExit("ADMA4003E", new Object[]{this._earName});
        }
        try {
            System.out.println(EARExpander.getMessage("ADMA4007I", new Object[]{this._operationDirectory, this._earName}));
            CommonarchiveFactory commonarchiveFactory = CommonarchiveFactoryImpl.getActiveFactory();
            Archive archive = commonarchiveFactory.openArchive(this._operationDirectory);
            if (archive instanceof EARFile) {
                this._earFile = (EARFile)archive;
                this._earFile.saveAs(this._earName);
            } else {
                System.out.println(EARExpander.getMessage("ADMA4004E", new Object[]{this._operationDirectory}));
                this._earFile = null;
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Exception during collapse" + exception));
            }
            this.exitCode = -1;
        }
        finally {
            Tr.debug((TraceComponent)tc, (String)"Closing archive");
            this._earFile.close();
        }
    }
}

