/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management.application.client;

import com.ibm.ejs.models.base.bindings.ejbbnd.EJBJarBinding;
import com.ibm.ejs.models.base.bindings.webappbnd.WebAppBinding;
import com.ibm.ejs.models.base.extensions.ejbext.EJBJarExtension;
import com.ibm.ejs.models.base.extensions.webappext.WebAppExtension;
import com.ibm.ejs.models.base.resources.ResourcesFactory;
import com.ibm.ejs.models.base.resources.ResourcesPackage;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.deployment.deploywrapper.DeployUtil;
import com.ibm.etools.application.Module;
import com.ibm.etools.commonarchive.CommonarchiveFactory;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.EJBJarFile;
import com.ibm.etools.commonarchive.impl.CommonarchiveFactoryImpl;
import com.ibm.etools.commonarchive.util.ArchiveInit;
import com.ibm.etools.ejb.EJBJar;
import com.ibm.etools.j2ee.commonarchivecore.Archive;
import com.ibm.etools.j2ee.commonarchivecore.File;
import com.ibm.etools.j2ee.commonarchivecore.ModuleFile;
import com.ibm.etools.j2ee.commonarchivecore.ReadOnlyDirectory;
import com.ibm.etools.j2ee.commonarchivecore.helpers.FileIterator;
import com.ibm.etools.webapplication.WebApp;
import com.ibm.websphere.management.application.AppConstants;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.client.AppDeploymentInfo;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.websphere.models.config.appdeployment.Deployment;
import com.ibm.websphere.resource.WASResourceSetImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.J2CAppUtils;
import com.ibm.ws.management.application.client.AppInstallHelper;
import com.ibm.ws.management.application.dfltbndngs.BindEarCmd;
import com.ibm.ws.management.application.dfltbndngs.BindingError;
import com.ibm.ws.management.application.dfltbndngs.Preferences;
import com.ibm.ws.management.application.task.ConfigRepoHelper;
import com.ibm.ws.management.configarchive.EnhancedEarConfigurator;
import com.ibm.ws.sm.workspace.WorkSpace;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.resource.Resource;

public class ArchiveDeploymentInfo
extends AppDeploymentInfo {
    public static final String destModPath = "ibm.update.mod.path";
    protected EARFile archive;
    protected String archivePath;
    protected Vector saveAsFileTempDirs;
    protected String j2ee12SecurityWarning;
    protected Hashtable moduleForDD;
    protected ApplicationDeployment appDepl;
    protected String modPath = null;
    private static long saveAsTempDirBase = System.currentTimeMillis();
    protected Resource deplResource;
    protected Resource enh_deplResource;
    private static TraceComponent tc = Tr.register((Class)ArchiveDeploymentInfo.class, (String)"Admin", (String)"com.ibm.ws.management.resources.AppDeploymentMessages");

    public ArchiveDeploymentInfo(EARFile eARFile) throws AppDeploymentException {
        this(eARFile, new Hashtable());
    }

    public ArchiveDeploymentInfo(EARFile eARFile, Hashtable hashtable) throws AppDeploymentException {
        super(hashtable);
        this.archive = eARFile;
        this.j2ee12SecurityWarning = null;
        this.moduleForDD = null;
        this.modPath = (String)hashtable.get(destModPath);
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"ArchiveDeploymentInfo");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("ear is: " + eARFile.getURI()));
        }
        this.setApplication(this.archive.getDeploymentDescriptor());
        this.setApplicationBindings(this.archive.getBindings());
        this.setApplicationExtensions(this.archive.getExtensions());
        if (this.appBinding == null) {
            throw new AppDeploymentException("Null application bindings. Possibly corrupt ear file.", null);
        }
        if (this.appExtension == null) {
            throw new AppDeploymentException("Null application extension. Possibly corrupt ear file.", null);
        }
        if (this.appBinding.getApplication() == null) {
            throw new AppDeploymentException("Application bindings file does not contain a reference to the deployment descriptor.  Corrupt ear file. Check if META-INF/ibm-application-bnd.xmi uri in the ear file contains a valid application href tag.", null);
        }
        if (this.appExtension.getApplication() == null) {
            throw new AppDeploymentException("Application extensions file does not contain a reference to the deployment descriptor.  Corrupt ear file. Check if META-INF/ibm-application-ext.xmi uri in the ear file contains a valid application href tag.", null);
        }
        eARFile.rollUpRoles();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"ArchiveDeploymentInfo");
        }
    }

    protected Vector createModuleConfig(String string) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createModuleConfig");
        }
        if (this.archive == null) {
            return null;
        }
        Vector<EObject> vector = new Vector<EObject>();
        EList eList = this.archive.getDeploymentDescriptor().getModules();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            Module module = (Module)iterator.next();
            if (!(string.startsWith("JAR") && module.isEjbModule() || string.startsWith("WAR") && module.isWebModule()) && (!string.startsWith("RAR") || !module.isConnectorModule())) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Processing JAR/WAR/RAR module " + module.getUri()));
            }
            try {
                EJBJar eJBJar;
                String string2;
                EObject eObject;
                if (string.endsWith("DD")) {
                    vector.addElement(this.archive.getDeploymentDescriptor(module));
                    continue;
                }
                if (string.endsWith("BND")) {
                    eObject = this.archive.getBindings(module);
                    string2 = eObject.eResource().getURI().toString();
                    if (string.equals("JAR_BND") && (eJBJar = ((EJBJarBinding)eObject).getEjbJar()).eIsProxy()) {
                        Tr.warning((TraceComponent)tc, (String)"ADMA0091E", (Object)new String[]{string2, string2, module.getUri(), "" + ((EObjectImpl)eJBJar).eProxyURI()});
                        ((EJBJarBinding)eObject).setEjbJar((EJBJar)this.archive.getDeploymentDescriptor(module));
                    }
                    if (string.equals("WAR_BND") && (eJBJar = ((WebAppBinding)eObject).getWebapp()).eIsProxy()) {
                        Tr.warning((TraceComponent)tc, (String)"ADMA0091E", (Object)new String[]{string2, string2, module.getUri(), "" + ((EObjectImpl)eJBJar).eProxyURI()});
                        ((WebAppBinding)eObject).setWebapp((WebApp)this.archive.getDeploymentDescriptor(module));
                    }
                    vector.addElement(eObject);
                    continue;
                }
                if (!string.endsWith("EXT") || string.startsWith("RAR")) continue;
                eObject = this.archive.getExtensions(module);
                string2 = eObject.eResource().getURI().toString();
                if (string.equals("JAR_EXT") && (eJBJar = ((EJBJarExtension)eObject).getEjbJar()).eIsProxy()) {
                    Tr.warning((TraceComponent)tc, (String)"ADMA0091E", (Object)new String[]{string2, string2, module.getUri(), "" + ((EObjectImpl)eJBJar).eProxyURI()});
                    ((EJBJarExtension)eObject).setEjbJar((EJBJar)this.archive.getDeploymentDescriptor(module));
                }
                if (string.equals("WAR_EXT") && (eJBJar = ((WebAppExtension)eObject).getWebApp()).eIsProxy()) {
                    Tr.warning((TraceComponent)tc, (String)"ADMA0091E", (Object)new String[]{string2, string2, module.getUri(), "" + ((EObjectImpl)eJBJar).eProxyURI()});
                    ((WebAppExtension)eObject).setWebApp((WebApp)this.archive.getDeploymentDescriptor(module));
                }
                vector.addElement(eObject);
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Throwing new AppDeploymentException from AppInstallHelper::getModuleConfig " + exception));
                }
                if (exception instanceof AppDeploymentException) {
                    throw (AppDeploymentException)exception;
                }
                throw new AppDeploymentException("", exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("createModuleConfig: " + vector));
        }
        return vector;
    }

    public Module getModuleForDD(EObject eObject) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getModuleForDD");
        }
        Module module = null;
        if (this.moduleForDD == null) {
            this.moduleForDD = new Hashtable();
            EList eList = this.archive.getDeploymentDescriptor().getModules();
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                Module module2 = (Module)iterator.next();
                if (module2.isJavaModule()) continue;
                try {
                    this.moduleForDD.put(this.archive.getDeploymentDescriptor(module2), module2);
                }
                catch (Exception exception) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Got Exception in getting module dd " + module2 + " -- exc: " + exception));
                    }
                    throw new AppDeploymentException("", exception);
                }
            }
        }
        module = (Module)this.moduleForDD.get(eObject);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("The returned module is: " + module));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getModuleForDDLocal");
        }
        return module;
    }

    public ModuleFile getModuleFileForDD(EObject eObject) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getModuleFileForDD");
        }
        ModuleFile moduleFile = null;
        Module module = this.getModuleForDD(eObject);
        if (module != null) {
            try {
                moduleFile = this.archive.getModuleRef(module).getModuleFile();
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Got Exception in getting module file for module  " + module + " -- exc: " + exception));
                }
                throw new AppDeploymentException("", exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getModuleFileForDD");
        }
        return moduleFile;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close(boolean bl) throws AppDeploymentException {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"close");
        }
        if (this.archive == null) {
            Tr.warning((TraceComponent)tc, (String)"ADMA0142W", (Object)"Trying to close the archive that is already closed.");
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"close");
            }
            return;
        }
        java.io.File file = new java.io.File(this.archive.getURI());
        try {
            try {
                int n2 = n = file.exists() && file.isDirectory() ? 1 : 0;
                if (bl) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("isDir: " + (n != 0)));
                    }
                    if (n == 0) {
                        this.archive.save();
                    } else {
                        this.archive.extractNoReopen(66);
                    }
                }
                if (n == 0 && this.modPath != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("modPath =  " + this.modPath));
                    }
                    ModuleFile moduleFile = (ModuleFile)this.archive.getModuleFiles().get(0);
                    moduleFile.saveAs(this.modPath);
                }
                if (this.deplResource != null) {
                    this.deplResource.unload();
                }
                if (this.enh_deplResource != null) {
                    this.enh_deplResource.unload();
                }
            }
            catch (Throwable throwable) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Throwing new AppDeploymentException from AppInstallHelper::closeLocal " + throwable));
                }
                throw new AppDeploymentException("", throwable);
            }
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.archive.close();
            this.archive = null;
            if (this.modPath != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("deleting " + file.getPath()));
                }
                file.delete();
            }
            throw throwable;
        }
        this.archive.close();
        this.archive = null;
        if (this.modPath != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("deleting " + file.getPath()));
            }
            file.delete();
        }
        this.moduleData.clear();
        if (this.saveAsFileTempDirs != null) {
            for (n = 0; n < this.saveAsFileTempDirs.size(); ++n) {
                try {
                    AppUtils.deleteDirTree((String)this.saveAsFileTempDirs.elementAt(n));
                    continue;
                }
                catch (Exception exception) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("Error deleting temp dir: " + (String)this.saveAsFileTempDirs.elementAt(n) + ", " + exception));
                }
            }
            this.saveAsFileTempDirs = null;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Archive closed. moduleData cleared");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"close");
        }
    }

    public Hashtable getSavedResults() {
        Hashtable hashtable = new Hashtable();
        Enumeration enumeration = this.options.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            hashtable.put(string, this.options.get(string));
        }
        if (this.archivePath != null) {
            hashtable.put("original.ear.location", this.archivePath);
        }
        return hashtable;
    }

    public void createDefaultBindings(Preferences preferences) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("createDefaultBindings" + preferences));
        }
        try {
            Vector vector = this.getModuleConfig("JAR_BND");
            Vector vector2 = this.getModuleConfig("WAR_BND");
            Vector vector3 = this.getModuleConfig("JAR_EXT");
            Vector vector4 = this.getModuleConfig("WAR_EXT");
            BindEarCmd bindEarCmd = null;
            bindEarCmd = preferences != null ? new BindEarCmd(this.archive, preferences) : new BindEarCmd(this.archive, true);
            bindEarCmd.bind();
        }
        catch (BindingError bindingError) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Exception during creation of default bindings: " + bindingError));
            }
            Throwable throwable = this.getRootError(bindingError);
            throw new AppDeploymentException(bindingError.toString(), throwable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createDefaultBindings");
        }
    }

    public String getSecurityPolicyData(ResourceBundle resourceBundle) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getSecurityPolicyData");
        }
        String string = null;
        InputStream inputStream = null;
        if (this.archive != null) {
            try {
                Object object;
                try {
                    inputStream = this.archive.getResourceInputStream("META-INF/was.policy");
                }
                catch (FileNotFoundException fileNotFoundException) {
                    inputStream = null;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Input stream: " + inputStream));
                }
                if (inputStream == null) {
                    object = this.getJ2EEAppVersion();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("App Version: " + (String)object));
                    }
                    if (object != null && ((String)object).equals(AppConstants.APPDEPL_APP_VERSION_1_2)) {
                        ClassLoader classLoader = this.getClass().getClassLoader();
                        inputStream = classLoader.getResourceAsStream("was.policy");
                        if (inputStream != null) {
                            this.saveAsFile(null, "META-INF/was.policy", inputStream);
                            this.j2ee12SecurityWarning = AppUtils.getMessage(resourceBundle, "ADMA0080W");
                            Tr.warning((TraceComponent)tc, (String)"ADMA0080W");
                            try {
                                inputStream = this.archive.getResourceInputStream("META-INF/was.policy");
                            }
                            catch (FileNotFoundException fileNotFoundException) {
                                inputStream = null;
                            }
                        } else {
                            this.j2ee12SecurityWarning = AppUtils.getMessage(resourceBundle, "ADMA0081W");
                            Tr.warning((TraceComponent)tc, (String)"ADMA0081W");
                        }
                    }
                }
                if (inputStream != null) {
                    byte[] byArray;
                    int n;
                    object = new ByteArrayOutputStream();
                    int n2 = inputStream.available();
                    while (n2 > 0 && (n = inputStream.read(byArray = new byte[n2])) != -1) {
                        ((ByteArrayOutputStream)object).write(byArray, 0, n);
                        n2 = inputStream.available();
                    }
                    ((OutputStream)object).flush();
                    string = ((ByteArrayOutputStream)object).toString();
                    ((ByteArrayOutputStream)object).close();
                    inputStream.close();
                }
            }
            catch (Exception exception) {
                AppUtils.dbg(tc, "Unexpected exception caught while: " + exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getSecurityPolicyData - " + string));
        }
        return string;
    }

    public String getSecurityPolicyWarning() {
        return this.j2ee12SecurityWarning;
    }

    public void saveAsFile(String string, String string2, InputStream inputStream) throws AppDeploymentException {
        String string3 = ArchiveDeploymentInfo.saveAsFile(this.archive, string, string2, inputStream);
        if (string3 != null) {
            if (this.saveAsFileTempDirs == null) {
                this.saveAsFileTempDirs = new Vector();
            }
            this.saveAsFileTempDirs.addElement(string3);
        }
    }

    public static String saveAsFile(EARFile eARFile, String string, String string2, InputStream inputStream) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"saveAsFile");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("moduleUri: " + string + ", fileUri: " + string2));
        }
        String string3 = null;
        if (inputStream == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"inputStream is null");
            }
        } else {
            CommonarchiveFactory commonarchiveFactory;
            if (eARFile == null) {
                return null;
            }
            EARFile eARFile2 = null;
            if (string == null || string.trim().equals("")) {
                eARFile2 = eARFile;
            } else {
                commonarchiveFactory = eARFile.getArchiveFiles().iterator();
                while (commonarchiveFactory.hasNext() && !(eARFile2 = (Archive)commonarchiveFactory.next()).getURI().equals(string)) {
                    eARFile2 = null;
                }
            }
            if (eARFile2 != null) {
                Exception exception;
                block37: {
                    FileOutputStream fileOutputStream;
                    block36: {
                        java.io.File file;
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("found matching archive: " + eARFile2));
                        }
                        ArchiveInit.init();
                        commonarchiveFactory = CommonarchiveFactoryImpl.getActiveFactory();
                        exception = null;
                        String string4 = AppUtils.getTempDir();
                        while ((file = new java.io.File(string3 = string4 + "save_" + String.valueOf(++saveAsTempDirBase))).exists()) {
                        }
                        file.mkdirs();
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("temp dirname: " + string3));
                        }
                        String string5 = string3;
                        if (string2 != null && !string2.equals("")) {
                            string5 = string5 + java.io.File.separator + string2;
                        }
                        file = new java.io.File(string5);
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("save file location: " + string5));
                        }
                        file = new java.io.File(file.getParent());
                        fileOutputStream = null;
                        try {
                            if (file.exists()) {
                                AppUtils.deleteDirTree(file);
                            }
                            file.mkdirs();
                            fileOutputStream = new FileOutputStream(string5);
                            if (fileOutputStream != null) {
                                int n = 0;
                                byte[] byArray = new byte[1024];
                                while ((n = inputStream.read(byArray)) != -1) {
                                    fileOutputStream.write(byArray, 0, n);
                                }
                                fileOutputStream.close();
                                fileOutputStream = null;
                                ReadOnlyDirectory readOnlyDirectory = commonarchiveFactory.openReadOnlyDirectory(string3);
                                File file2 = null;
                                try {
                                    file2 = readOnlyDirectory.getFileInSelfOrSubdirectory(string2);
                                }
                                catch (Throwable throwable) {
                                    file2 = null;
                                }
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)("file in readDir: " + file2));
                                }
                                if (file2 != null && eARFile2.isDuplicate(string2)) {
                                    FileIterator fileIterator = eARFile2.getFilesForSave();
                                    while (fileIterator.hasNext()) {
                                        File file3 = fileIterator.next();
                                        if (!file3.getURI().equals(string2)) continue;
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug((TraceComponent)tc, (String)".... Removing existing file");
                                        }
                                        eARFile2.remove(file3);
                                        break;
                                    }
                                }
                                if (file2 != null) {
                                    eARFile2.addCopy(file2);
                                }
                                break block36;
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Not able to create the input stream as a file");
                            }
                        }
                        catch (Exception exception2) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("File IO exception: " + exception2));
                            }
                            exception = exception2;
                        }
                    }
                    if (fileOutputStream != null) {
                        try {
                            fileOutputStream.close();
                        }
                        catch (IOException iOException) {
                            if (!tc.isDebugEnabled()) break block37;
                            Tr.debug((TraceComponent)tc, (String)("Error closing save file: " + fileOutputStream + ", " + iOException));
                        }
                    }
                }
                if (exception != null) {
                    throw new AppDeploymentException(exception.toString(), exception);
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Not able to find matching module: " + string));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"saveAsFile");
        }
        return string3;
    }

    public String getAppDisplayName() {
        Object v = this.options.get("appname");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("app name from options " + v));
        }
        if (v != null && v instanceof String) {
            return (String)v;
        }
        return AppInstallHelper.getAppDisplayName(this.archive, this.options);
    }

    public String getURI() {
        return this.archive.getURI();
    }

    private Throwable getRootError(BindingError bindingError) {
        Throwable throwable;
        for (throwable = bindingError; throwable != null && throwable instanceof BindingError && throwable.getChainedEx() != null; throwable = throwable.getChainedEx()) {
        }
        return throwable;
    }

    public Resource getResource(String string, String string2, String string3) throws IOException {
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getResource: " + string + " uri=" + string2));
        }
        if (this.archive.containsFile(string2)) {
            InputStream inputStream = this.archive.getInputStream(string2);
            WASResourceSetImpl wASResourceSetImpl = new WASResourceSetImpl();
            URI uRI = URI.createURI((String)string3);
            Resource resource = wASResourceSetImpl.createResource(uRI);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("res is: " + resource));
            }
            HashMap hashMap = new HashMap();
            resource.load(inputStream, hashMap);
            return resource;
        }
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getResource: null");
        }
        return null;
    }

    public Resource getAppDeploymentResource(boolean bl) {
        Resource resource = super.getAppDeploymentResource(bl);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("deplres in memory: " + resource));
        }
        if (resource != null) {
            return resource;
        }
        if (this.deplResource != null) {
            return this.deplResource;
        }
        try {
            if (bl && this.enh_deplResource != null) {
                return this.enh_deplResource;
            }
            this.deplResource = this.getResource(null, "deployment.xml", "deployment.xml");
            return this.deplResource;
        }
        catch (Throwable throwable) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("exception loading depl resource: " + throwable));
            }
            FFDCFilter.processException((Throwable)throwable, (String)(this.getClass().getName() + ".getAppDeploymentResource"), (String)"784", (Object)this);
            return null;
        }
    }

    public ApplicationDeployment getAppDeploymentObject(boolean bl) {
        Resource resource = this.getAppDeploymentResource(bl);
        if (resource != null) {
            return (ApplicationDeployment)((Deployment)resource.getContents().get(0)).getDeployedObject();
        }
        return null;
    }

    public boolean checkIfEarDeployed() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"checkIfEarDeployed");
        }
        try {
            List list = this.archive.getEJBJarFiles();
            if (list.size() == 0) {
                return true;
            }
            for (int i = 0; i < list.size(); ++i) {
                boolean bl = DeployUtil.isEJBJarDeployed((EJBJarFile)((EJBJarFile)list.get(i)));
                if (bl) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(((EJBJarFile)list.get(i)).getURI() + " not deployed. Default will be set to run EJBDeploy."));
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"checkIfEarDeployed");
                }
                return false;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"checkIfEarDeployed: return true");
            }
            return true;
        }
        catch (Throwable throwable) {
            Tr.warning((TraceComponent)tc, (String)"ADMA0143W", (Object)new Object[]{throwable});
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"checkIfEarDeployed: return true after exception");
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean checkIfEnhancedEar() {
        boolean bl;
        block17: {
            WorkSpace workSpace;
            EnhancedEarConfigurator enhancedEarConfigurator;
            block16: {
                if (tc.isEntryEnabled()) {
                    Tr.entry((TraceComponent)tc, (String)"checkIfEnhancedEar");
                }
                bl = true;
                enhancedEarConfigurator = null;
                workSpace = null;
                workSpace = ConfigRepoHelper.getWorkSpace(null);
                enhancedEarConfigurator = new EnhancedEarConfigurator(workSpace, this.archive, true, "default", "appName", "appName.ear_");
                bl = enhancedEarConfigurator.isEnhancedEar();
                if (!bl) break block16;
                this.enh_deplResource = enhancedEarConfigurator.getDeployment();
            }
            Object var6_4 = null;
            try {
                if (workSpace != null) {
                    ConfigRepoHelper.removeWorkSpace(false, workSpace);
                }
                if (enhancedEarConfigurator != null) {
                    enhancedEarConfigurator.cleanup();
                }
                break block17;
            }
            catch (Throwable throwable) {
                Tr.warning((TraceComponent)tc, (String)"ADMA0077W", (Object)throwable);
            }
            break block17;
            {
                catch (Throwable throwable) {
                    Tr.warning((TraceComponent)tc, (String)"ADMA0104W", (Object)throwable);
                    bl = false;
                    Object var6_5 = null;
                    try {
                        if (workSpace != null) {
                            ConfigRepoHelper.removeWorkSpace(false, workSpace);
                        }
                        if (enhancedEarConfigurator != null) {
                            enhancedEarConfigurator.cleanup();
                        }
                        break block17;
                    }
                    catch (Throwable throwable2) {
                        Tr.warning((TraceComponent)tc, (String)"ADMA0077W", (Object)throwable2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                try {
                    if (workSpace != null) {
                        ConfigRepoHelper.removeWorkSpace(false, workSpace);
                    }
                    if (enhancedEarConfigurator != null) {
                        enhancedEarConfigurator.cleanup();
                    }
                }
                catch (Throwable throwable3) {
                    Tr.warning((TraceComponent)tc, (String)"ADMA0077W", (Object)throwable3);
                }
                throw throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("checkIfEnhancedEar: return" + bl));
        }
        return bl;
    }

    public boolean isStandaloneDeployment() {
        if (this.archive == null) {
            return false;
        }
        return this.archive.containsFile("META-INF/was.ejbmodule") || this.archive.containsFile("META-INF/was.webmodule");
    }

    public InputStream getInputStream(String string, String string2) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getInputStream: " + string + ", " + string2));
        }
        InputStream inputStream = null;
        try {
            if (string == null) {
                inputStream = this.archive.getInputStream(string2);
            } else {
                List list = this.archive.getModuleFiles();
                for (int i = 0; i < list.size(); ++i) {
                    ModuleFile moduleFile = (ModuleFile)list.get(i);
                    if (!moduleFile.getURI().equals(string)) continue;
                    inputStream = moduleFile.getInputStream(string2);
                    break;
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("getInputStream: " + inputStream));
            }
            return inputStream;
        }
        catch (IOException iOException) {
            throw new AppDeploymentException("", iOException);
        }
    }

    public boolean containsURI(String string, String string2) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("containsURI: " + string + ", " + string2));
        }
        if (string == null) {
            return this.archive.containsFile(string2);
        }
        List list = this.archive.getModuleFiles();
        for (int i = 0; i < list.size(); ++i) {
            ModuleFile moduleFile = (ModuleFile)list.get(i);
            if (!moduleFile.getURI().equals(string)) continue;
            return moduleFile.containsFile(string2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"containsURI: moduleURI did not match");
        }
        return false;
    }

    public Class loadClass(EObject eObject, String string, String string2) {
        Class clazz;
        block10: {
            ModuleFile moduleFile;
            block9: {
                if (tc.isEntryEnabled()) {
                    Tr.entry((TraceComponent)tc, (String)("loadClass: " + eObject + " className : " + string + " type : " + string2));
                }
                ResourcesPackage resourcesPackage = (ResourcesPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/resources.xmi");
                ResourcesFactory resourcesFactory = resourcesPackage.getResourcesFactory();
                clazz = null;
                moduleFile = null;
                try {
                    moduleFile = this.getModuleFileForDD(eObject);
                }
                catch (AppDeploymentException appDeploymentException) {
                    if (!tc.isDebugEnabled()) break block9;
                    Tr.debug((TraceComponent)tc, (String)("Failed to get DD" + appDeploymentException));
                }
            }
            if (moduleFile == null) {
                return null;
            }
            ClassLoader classLoader = moduleFile.getArchiveClassLoader();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("module is : " + moduleFile + " classLoader : " + classLoader));
            }
            if (classLoader == null) {
                return null;
            }
            try {
                clazz = J2CAppUtils.getDefinedClass(string, classLoader);
            }
            catch (AdminException adminException) {
                if (!tc.isDebugEnabled()) break block10;
                Tr.debug((TraceComponent)tc, (String)("Failed to getDefinedClass" + (Object)((Object)adminException)));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("Class: " + clazz));
        }
        return clazz;
    }
}

