/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management.application.client;

import com.ibm.ejs.models.base.bindings.applicationbnd.ApplicationBinding;
import com.ibm.ejs.models.base.extensions.applicationext.ApplicationExtension;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.application.Application;
import com.ibm.etools.application.Module;
import com.ibm.etools.ejb.EJBJar;
import com.ibm.etools.j2ee.common.SecurityRole;
import com.ibm.etools.j2ee.common.XMLResource;
import com.ibm.etools.j2ee.commonarchivecore.ModuleFile;
import com.ibm.etools.webapplication.WebApp;
import com.ibm.websphere.management.application.AppConstants;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.client.AppDeploymentProfile;
import com.ibm.ws.management.application.client.util;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public abstract class AppDeploymentInfo
implements AppConstants {
    public static final String JAR = "JAR";
    public static final String WAR = "WAR";
    public static final String RAR = "RAR";
    public static final String DD = "DD";
    public static final String BND = "BND";
    public static final String EXT = "EXT";
    public static final String JAR_DD = "JAR_DD";
    public static final String JAR_BND = "JAR_BND";
    public static final String JAR_EXT = "JAR_EXT";
    public static final String WAR_DD = "WAR_DD";
    public static final String WAR_BND = "WAR_BND";
    public static final String WAR_EXT = "WAR_EXT";
    public static final String RAR_DD = "RAR_DD";
    public static final String RAR_BND = "RAR_BND";
    public static final String DEPL_RES = "edit.deplresource";
    protected Hashtable options;
    protected transient Hashtable moduleData;
    protected transient Application app;
    protected transient ApplicationBinding appBinding;
    protected transient ApplicationExtension appExtension;
    private static TraceComponent tc = Tr.register((Class)AppDeploymentInfo.class, (String)"Admin", (String)"com.ibm.ws.management.resources.AppDeploymentMessages");

    public AppDeploymentInfo() {
        this(new Hashtable());
    }

    public AppDeploymentInfo(Hashtable hashtable) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"AppDeploymentInfo");
        }
        this.options = new Hashtable();
        this.populateOptions(hashtable);
        this.moduleData = new Hashtable();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Options are: " + this.options));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"AppDeploymentInfo");
        }
    }

    private void populateOptions(Hashtable hashtable) {
        if (this.options.get("deployejb.options") == null) {
            this.options.put("deployejb.options", AppDeploymentInfo.createDefaultDeployEJBOptions());
        }
        if (this.options.get("deployws.options") == null) {
            this.options.put("deployws.options", AppDeploymentInfo.createDefaultDeployWSOptions());
        }
    }

    public static Hashtable createDefaultDeployEJBOptions() {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        Vector vector = AppDeploymentProfile.getDeployEJBProfile();
        for (int i = 0; i < vector.size(); ++i) {
            AppDeploymentProfile.DeplOption deplOption = (AppDeploymentProfile.DeplOption)vector.elementAt(i);
            hashtable.put(deplOption.name, deplOption.defaultVal);
        }
        return hashtable;
    }

    public static Hashtable createDefaultDeployWSOptions() {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        Vector vector = AppDeploymentProfile.getDeployWSProfile();
        for (int i = 0; i < vector.size(); ++i) {
            AppDeploymentProfile.DeplOption deplOption = (AppDeploymentProfile.DeplOption)vector.elementAt(i);
            hashtable.put(deplOption.name, deplOption.defaultVal);
        }
        return hashtable;
    }

    public Hashtable getAppOptions() {
        return this.options;
    }

    public void setAppOptions(Hashtable hashtable) {
        this.options = hashtable;
    }

    public Application getApplication() {
        return this.app;
    }

    public void setApplication(Application application) {
        this.app = application;
    }

    public ApplicationBinding getApplicationBindings() {
        return this.appBinding;
    }

    public void setApplicationBindings(ApplicationBinding applicationBinding) {
        this.appBinding = applicationBinding;
    }

    public ApplicationExtension getApplicationExtensions() {
        return this.appExtension;
    }

    public void setApplicationExtensions(ApplicationExtension applicationExtension) {
        this.appExtension = applicationExtension;
    }

    public Vector getModuleConfig(String string) throws AppDeploymentException {
        Vector vector;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getModuleConfig");
        }
        if ((vector = (Vector)this.moduleData.get(string)) == null) {
            vector = this.createModuleConfig(string);
            this.setModuleConfig(string, vector);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Returning from getModuleConfig: " + vector));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getModuleConfig");
        }
        return vector;
    }

    public void setModuleConfig(String string, Vector vector) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setModuleConfig");
        }
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("The val is: " + vector));
        }
        if (vector != null) {
            this.moduleData.put(string, vector);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setModuleConfig");
        }
    }

    protected abstract Vector createModuleConfig(String var1) throws AppDeploymentException;

    public abstract void close(boolean var1) throws AppDeploymentException;

    public abstract Hashtable getSavedResults();

    public abstract Module getModuleForDD(EObject var1) throws AppDeploymentException;

    public abstract ModuleFile getModuleFileForDD(EObject var1) throws AppDeploymentException;

    public abstract String getSecurityPolicyData(ResourceBundle var1) throws AppDeploymentException;

    public abstract String getSecurityPolicyWarning();

    public abstract String getAppDisplayName();

    public abstract boolean isStandaloneDeployment();

    public abstract InputStream getInputStream(String var1, String var2) throws AppDeploymentException;

    public abstract boolean containsURI(String var1, String var2) throws AppDeploymentException;

    public Vector getAllURIStrings() throws AppDeploymentException {
        int n;
        Vector<String> vector = new Vector<String>();
        Vector vector2 = this.getModuleConfig(JAR_DD);
        for (n = 0; n < vector2.size(); ++n) {
            vector.addElement(util.formUriString(this, (EObject)vector2.elementAt(n)));
        }
        vector2 = this.getModuleConfig(WAR_DD);
        for (n = 0; n < vector2.size(); ++n) {
            vector.addElement(util.formUriString(this, (EObject)vector2.elementAt(n)));
        }
        vector2 = this.getModuleConfig(RAR_DD);
        for (n = 0; n < vector2.size(); ++n) {
            vector.addElement(util.formUriString(this, (EObject)vector2.elementAt(n)));
        }
        return vector;
    }

    public void printAppInfo(PrintStream printStream) {
        try {
            Object object;
            printStream.println();
            if (this.getApplication() == null) {
                printStream.println("Application not set.");
            } else {
                object = this.getApplication();
                printStream.println("Application DisplayName: " + object.getDisplayName());
                EList eList = object.getSecurityRoles();
                Iterator iterator = eList.iterator();
                boolean bl = true;
                while (iterator.hasNext()) {
                    SecurityRole securityRole = (SecurityRole)iterator.next();
                }
            }
            printStream.println();
            printStream.println("For EJB Jars --> ");
            printStream.println();
            object = this.getModuleConfig(JAR_DD);
            for (int i = 0; i < ((Vector)object).size(); ++i) {
                printStream.println("Jar[" + (i + 1) + "] " + ((EJBJar)((Vector)object).elementAt(i)).getDisplayName());
                printStream.println("DD: " + ((Vector)object).elementAt(i));
                printStream.println("Bindings: " + this.getModuleConfig(JAR_BND).elementAt(i));
                printStream.println("Extensions: " + this.getModuleConfig(JAR_EXT).elementAt(i));
                printStream.println();
            }
            printStream.println("End of EJB Jars --> ");
            printStream.println();
            printStream.println("For Web Apps --> ");
            printStream.println();
            Vector vector = this.getModuleConfig(WAR_DD);
            for (int i = 0; i < vector.size(); ++i) {
                printStream.println("War[" + (i + 1) + "] " + ((WebApp)vector.elementAt(i)).getDisplayName());
                printStream.println("DD: " + vector.elementAt(i));
                printStream.println("Bindings: " + this.getModuleConfig(WAR_BND).elementAt(i));
                printStream.println("Extensions: " + this.getModuleConfig(WAR_EXT).elementAt(i));
                printStream.println();
            }
            printStream.println("End of Web Apps --> ");
            printStream.println();
        }
        catch (Throwable throwable) {
            printStream.println("Exception thrown in printing the AppDeploymentInfo " + throwable);
        }
    }

    public void saveAsFile(String string, String string2, InputStream inputStream) throws AppDeploymentException {
    }

    public String getJ2EEAppVersion() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getJ2EEAppVersion");
        }
        String string = "";
        if (this.app == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Null Application DD");
            }
        } else {
            XMLResource xMLResource = (XMLResource)this.app.eResource();
            if (xMLResource == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("AppDD has no XML Resource: " + this.app));
                }
            } else {
                String string2 = xMLResource.getPublicId();
                if (string2 == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("AppDD has no XML Resource Id: " + this.app));
                    }
                } else if (string2.equalsIgnoreCase("-//Sun Microsystems, Inc.//DTD J2EE Application 1.2//EN")) {
                    string = AppConstants.APPDEPL_APP_VERSION_1_2;
                } else if (string2.equalsIgnoreCase("-//Sun Microsystems, Inc.//DTD J2EE Application 1.3//EN")) {
                    string = AppConstants.APPDEPL_APP_VERSION_1_3;
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Return J2EE version: " + string));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getJ2EEAppVersion");
        }
        return string;
    }

    public static String getLocalHost() {
        String string;
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"getLocalHost");
            }
            string = null;
            try {
                string = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException unknownHostException) {
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug((TraceComponent)tc, (String)("Exception in getting local host name: " + unknownHostException));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getLocalHost");
        }
        return string;
    }

    public Resource getAppDeploymentResource(boolean bl) {
        return (Resource)this.options.get(DEPL_RES);
    }
}

