/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management.application.client;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.application.Module;
import com.ibm.etools.application.WebModule;
import com.ibm.etools.j2ee.common.XMLResource;
import com.ibm.etools.jca.Connector;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.application.AppManagementFactory;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.client.AppDeploymentInfo;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.websphere.management.application.client.AppDeploymentTaskHelper;
import com.ibm.websphere.management.application.client.AppDeploymentTaskInfo;
import com.ibm.websphere.management.application.client.AppDeploymentTaskValidate;
import com.ibm.websphere.management.application.client.ArchiveDeploymentInfo;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.PartialDeploymentInfo;
import com.ibm.ws.management.application.client.AppDeploymentOptions;
import com.ibm.ws.management.application.client.DefaultBinding;
import com.ibm.ws.management.application.client.DefaultBindingHelper;
import com.ibm.ws.management.application.client.util;
import com.ibm.ws.management.application.dfltbndngs.Preferences;
import com.ibm.ws.util.ImplFactory;
import com.ibm.wtp.internal.encoders.EncoderDecoder;
import com.ibm.wtp.internal.encoders.EncoderDecoderRegistry;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;

public class AppDeploymentController
implements Serializable {
    private static final long serialVersionUID = -3828436921961863062L;
    private static TraceComponent tc = Tr.register((Class)AppDeploymentController.class, (String)"Admin", (String)"com.ibm.ws.management.resources.AppDeploymentMessages");
    private static final String taskPackageName = "com.ibm.ws.management.application.client.";
    public static final String taskHelperSuffix = "Helper";
    private static boolean encoderInit = false;
    protected Vector taskInfo = null;
    protected Vector taskNames = null;
    protected Vector tasks = null;
    protected int currentTask;
    protected Hashtable preferences = new Hashtable();
    protected transient AppDeploymentInfo deploymentInfo;
    protected transient ResourceBundle resBundle;
    protected long _deploymentMode;
    protected ConfigService configService;
    protected Session configSession;
    protected AdminClient adminClient;
    private static int[][] versionTable = new int[][]{{12, 5}, {13, 5}, {14, 6}};

    public static AppDeploymentController readArchive(String string, Hashtable hashtable) throws AppDeploymentException {
        return AppManagementFactory.readArchive(string, hashtable);
    }

    public static AppDeploymentController readArchive(String string, Hashtable hashtable, Vector vector) throws AppDeploymentException {
        return AppManagementFactory.readArchive(string, hashtable, vector);
    }

    public AppDeploymentController(AppDeploymentInfo appDeploymentInfo, Hashtable hashtable, Vector vector) throws AppDeploymentException {
        this(appDeploymentInfo, null, hashtable, vector);
    }

    public AppDeploymentController(Vector vector, Vector vector2, Hashtable hashtable) throws AppDeploymentException {
        this(null, vector, hashtable, vector2);
    }

    public AppDeploymentController(AppDeploymentInfo appDeploymentInfo, Vector vector, Hashtable hashtable, Vector vector2) throws AppDeploymentException {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"AppDeploymentController");
        }
        this.deploymentInfo = appDeploymentInfo;
        this.taskInfo = vector2;
        this.preferences = hashtable;
        this.taskNames = new Vector();
        for (n = 0; n < this.taskInfo.size(); ++n) {
            this.taskNames.addElement(((AppDeploymentTaskInfo)this.taskInfo.elementAt((int)n)).name);
        }
        this.setDeploymentMode(hashtable);
        this.handlePreferences(hashtable);
        this.initializeEncoderDecoder();
        if (vector == null) {
            this.createAppDeploymentTasks();
        } else {
            this.tasks = vector;
            for (n = 0; n < this.tasks.size(); ++n) {
                Object e = this.tasks.elementAt(n);
                if (e == null || !(e instanceof AppDeploymentTask)) continue;
                ((AppDeploymentTask)e).setAppDeploymentController(this);
            }
        }
        Locale locale = null;
        if (hashtable != null) {
            locale = (Locale)hashtable.get("app.client.locale");
        }
        this.resBundle = AppUtils.getBundle("com.ibm.ws.management.resources.AppDeploymentMessages", locale);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"AppDeploymentController");
        }
    }

    protected void setDeploymentMode(Hashtable hashtable) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setDeploymentMode");
        }
        this._deploymentMode = 1L;
        if (this.deploymentInfo != null && this.deploymentInfo instanceof PartialDeploymentInfo) {
            long l = this._deploymentMode = ((PartialDeploymentInfo)this.deploymentInfo).isApp() ? 16L : 256L;
        }
        if ("modulefile".equals(hashtable.get("contenttype"))) {
            this._deploymentMode = 0x100000L;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("setDeploymentMode:" + this._deploymentMode));
        }
    }

    public long getDeploymentMode() {
        return this._deploymentMode;
    }

    protected void handlePreferences(Hashtable hashtable) throws AppDeploymentException {
        Object v;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"handlePreferences");
        }
        if (hashtable == null || this.deploymentInfo == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"handlePreferences");
            }
            return;
        }
        this.configService = (ConfigService)hashtable.get("configservice");
        this.configSession = (Session)hashtable.get("configsession");
        this.adminClient = (AdminClient)hashtable.get("adminclient");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("config service: " + this.configService + ", " + this.configSession + ", " + this.adminClient));
        }
        if ((v = hashtable.get("usedefaultbindings")) != null) {
            this.handleDefaultBindings(v);
        } else {
            ((ArchiveDeploymentInfo)this.deploymentInfo).createDefaultBindings(null);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"handlePreferences");
        }
    }

    private void handleDefaultBindings(Object object) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"handleDefaultBindings");
        }
        if (!(this.deploymentInfo instanceof ArchiveDeploymentInfo)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Deployment not from an ear file.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"handleDefaultBindings");
            }
            return;
        }
        Preferences preferences = null;
        if (object instanceof Preferences) {
            preferences = (Preferences)object;
        } else if (object instanceof DefaultBinding) {
            preferences = DefaultBindingHelper.getPreferences((DefaultBinding)object);
        } else if (object instanceof Properties) {
            preferences = DefaultBindingHelper.getPreferencesFromHashtable((Properties)object);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Default bndg prefs: " + preferences));
        }
        if (preferences == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("No preference data for default bindings " + object));
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"handleDefaultBindings");
            }
            return;
        }
        ((ArchiveDeploymentInfo)this.deploymentInfo).createDefaultBindings(preferences);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"handleDefaultBindings");
        }
    }

    protected void initializeEncoderDecoder() throws AppDeploymentException {
        if (encoderInit) {
            return;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initializeEncoderDecoder");
        }
        try {
            EncoderDecoder encoderDecoder = (EncoderDecoder)ImplFactory.loadImplFromKey((Class)EncoderDecoder.class);
            EncoderDecoderRegistry.getDefaultRegistry().setDefaultEncoderDecoder(encoderDecoder);
            encoderInit = true;
        }
        catch (Throwable throwable) {
            throw new AppDeploymentException("", throwable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initializeEncoderDecoder");
        }
    }

    protected void createAppDeploymentTasks() throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createAppDeploymentTasks");
        }
        this.tasks = new Vector();
        for (int i = 0; i < this.taskNames.size(); ++i) {
            this.tasks.addElement(((AppDeploymentTaskInfo)this.taskInfo.elementAt((int)i)).helper.createTask(this, (String)this.taskNames.elementAt(i)));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createAppDeploymentTasks");
        }
    }

    protected static AppDeploymentTaskHelper getTaskHelper(String string) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getTaskHelper");
        }
        try {
            Class<?> clazz = string.indexOf(".") < 0 ? Class.forName(taskPackageName + string + taskHelperSuffix) : Class.forName(string + taskHelperSuffix);
            AppDeploymentTaskHelper appDeploymentTaskHelper = (AppDeploymentTaskHelper)clazz.newInstance();
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getTaskHelper");
            }
            return appDeploymentTaskHelper;
        }
        catch (Throwable throwable) {
            throw new AppDeploymentException("", throwable);
        }
    }

    protected AppDeploymentTaskHelper getTaskHelper(int n) throws AppDeploymentException {
        if (n < this.taskInfo.size() && ((AppDeploymentTaskInfo)this.taskInfo.elementAt((int)n)).helper != null) {
            return ((AppDeploymentTaskInfo)this.taskInfo.elementAt((int)n)).helper;
        }
        throw new AppDeploymentException(MessageFormat.format(AppUtils.getMessage(this.resBundle, "ADMA0012E"), (String)this.tasks.elementAt(n)), null);
    }

    public String[] getAppDeploymentTaskNames() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getAppDeploymentTaskNames");
        }
        Object[] objectArray = new String[this.taskNames.size()];
        this.taskNames.copyInto(objectArray);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getAppDeploymentTaskNames");
        }
        return objectArray;
    }

    public AppDeploymentTask getFirstTask() throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getFirstTask");
        }
        this.currentTask = 0;
        return this.getNthTask(this.currentTask);
    }

    protected AppDeploymentTask getNthTask(int n) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getNthTask");
        }
        AppDeploymentTask appDeploymentTask = (AppDeploymentTask)this.tasks.elementAt(n);
        try {
            if (appDeploymentTask.getTaskData() == null && !appDeploymentTask.isTaskEmpty()) {
                this.prepareTask(n, appDeploymentTask);
                this.getDependencyTask(n);
            }
        }
        catch (Throwable throwable) {
            String string = (String)this.taskNames.elementAt(n);
            throw new AppDeploymentException(MessageFormat.format(AppUtils.getMessage(this.resBundle, "ADMA0092E"), string), throwable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getNthTask");
        }
        return appDeploymentTask;
    }

    protected void prepareTask(int n, AppDeploymentTask appDeploymentTask) throws AppDeploymentException {
        this.getTaskHelper(n).prepareTask(this.deploymentInfo, appDeploymentTask);
    }

    public AppDeploymentTask getNextTask() throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getNextTask");
        }
        if (this.currentTask < 0) {
            return null;
        }
        if (this.currentTask + 1 >= this.tasks.size()) {
            return null;
        }
        return this.getNthTask(++this.currentTask);
    }

    public AppDeploymentTask getTaskByName(String string, boolean bl) throws AppDeploymentException {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getTaskByName");
        }
        if ((n = this.taskNames.indexOf(string)) < 0) {
            return null;
        }
        if (bl) {
            this.currentTask = n;
        }
        return this.getNthTask(n);
    }

    public Vector getAllTasks() {
        return this.tasks;
    }

    public AppDeploymentTask getTaskByName(String string) throws AppDeploymentException {
        return this.getTaskByName(string, true);
    }

    protected void getDependencyTask(int n) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getDependencyTask");
        }
        if (n < this.taskInfo.size()) {
            if (((AppDeploymentTaskInfo)this.taskInfo.elementAt((int)n)).dependency != null) {
                ((AppDeploymentTaskInfo)this.taskInfo.elementAt((int)n)).dependency.setupDependency(this, (AppDeploymentTask)this.tasks.elementAt(n));
            }
        } else {
            throw new AppDeploymentException(MessageFormat.format(AppUtils.getMessage(this.resBundle, "ADMA0013E"), (String)this.tasks.elementAt(n)), null);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getDependencyTask");
        }
    }

    public void getDependencyTask(String string) throws AppDeploymentException {
        this.getDependencyTask(this.taskNames.indexOf(string));
    }

    public void close(boolean bl, boolean bl2, boolean bl3) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("close:" + bl + ", " + bl2 + ", " + bl3));
        }
        if (bl2) {
            String[] stringArray;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"validating ..");
            }
            if ((stringArray = this.validate()) != null) {
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < stringArray.length; ++i) {
                    stringBuffer.append(stringArray[i]);
                    stringBuffer.append("\n");
                }
                throw new AppDeploymentException(MessageFormat.format(AppUtils.getMessage(this.resBundle, "ADMA0014E"), stringBuffer), null);
            }
        }
        if (bl) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"saving ..");
            }
            for (int i = 0; i < this.tasks.size(); ++i) {
                try {
                    this.getTaskHelper(i).completeTask(this.deploymentInfo, (AppDeploymentTask)this.tasks.elementAt(i));
                    continue;
                }
                catch (Throwable throwable) {
                    String string = (String)this.taskNames.elementAt(i);
                    throw new AppDeploymentException(MessageFormat.format(AppUtils.getMessage(this.resBundle, "ADMA0093E"), string), throwable);
                }
            }
        }
        if (bl3 && this.deploymentInfo != null) {
            this.deploymentInfo.close(bl);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"close");
        }
    }

    public void saveAndClose() throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"saveAndClose");
        }
        this.close(true, true, true);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"saveAndClose");
        }
    }

    public String[] validate() throws AppDeploymentException {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"validate");
        }
        Vector<String> vector = new Vector<String>();
        String[] stringArray = null;
        for (n = 0; n < this.tasks.size(); ++n) {
            AppDeploymentTask appDeploymentTask;
            String[] stringArray2;
            AppDeploymentTaskHelper appDeploymentTaskHelper;
            String[] stringArray3 = this.getNthTask(n).validate();
            if (stringArray3 != null) {
                for (int i = 0; i < stringArray3.length; ++i) {
                    vector.addElement(stringArray3[i]);
                }
            }
            if ((appDeploymentTaskHelper = this.getTaskHelper(n)) == null || !(appDeploymentTaskHelper instanceof AppDeploymentTaskValidate) || (stringArray2 = ((AppDeploymentTaskValidate)appDeploymentTaskHelper).validate(appDeploymentTask = (AppDeploymentTask)this.tasks.elementAt(n), this.deploymentInfo)) == null) continue;
            for (int i = 0; i < stringArray2.length; ++i) {
                vector.addElement(stringArray2[i]);
            }
        }
        if (vector.size() > 0) {
            stringArray = new String[vector.size()];
            for (n = 0; n < vector.size(); ++n) {
                stringArray[n] = (String)vector.elementAt(n);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"validate");
        }
        return stringArray;
    }

    public Hashtable getAppOptions() {
        return this.deploymentInfo.getAppOptions();
    }

    public void setAppOptions(Hashtable hashtable) {
        this.deploymentInfo.setAppOptions(hashtable);
    }

    public Hashtable getAppDeploymentSavedResults() {
        return this.deploymentInfo.getSavedResults();
    }

    public AppDeploymentTaskInfo getTaskInfo() {
        return (AppDeploymentTaskInfo)this.taskInfo.elementAt(this.currentTask);
    }

    public AppDeploymentTaskInfo getTaskInfo(String string) {
        int n = this.taskNames.indexOf(string);
        if (n < 0) {
            return null;
        }
        return (AppDeploymentTaskInfo)this.taskInfo.elementAt(n);
    }

    public boolean isPartialDeploymentInfo() {
        return this.deploymentInfo instanceof PartialDeploymentInfo;
    }

    public String getSecurityPolicyData() throws AppDeploymentException {
        return this.deploymentInfo.getSecurityPolicyData(this.resBundle);
    }

    public String getSecurityPolicyWarning() {
        return this.deploymentInfo.getSecurityPolicyWarning();
    }

    public void saveAsFile(String string, String string2, InputStream inputStream) throws AppDeploymentException {
        this.deploymentInfo.saveAsFile(string, string2, inputStream);
    }

    public void createDeploymentPlan(OutputStream outputStream) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createDeploymentPlan");
        }
        if (outputStream == null) {
            if (tc.isDebugEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"Null output stream for depl plan.");
            }
            return;
        }
        try {
            Vector<AppDeploymentTask> vector;
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
            Hashtable hashtable = this.getAppOptions();
            if (this.deploymentInfo.isStandaloneDeployment()) {
                vector = this.deploymentInfo.getAllURIStrings();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("standalone URI: " + vector));
                }
                if (vector.size() > 0) {
                    hashtable.put("appdeplStandaloneURI", vector.firstElement());
                }
            }
            objectOutputStream.writeObject(hashtable);
            vector = new Vector<AppDeploymentTask>();
            for (int i = 0; i < this.tasks.size(); ++i) {
                vector.addElement(this.getNthTask(i));
            }
            objectOutputStream.writeObject(vector);
            objectOutputStream.flush();
            outputStream.flush();
        }
        catch (Exception exception) {
            throw new AppDeploymentException(AppUtils.getMessage(this.resBundle, "ADMA0099E", new Object[]{exception}), exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createDeploymentPlan");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void readDeploymentPlan(File file) throws AppDeploymentException {
        if (file == null) {
            if (!tc.isDebugEnabled()) return;
            Tr.exit((TraceComponent)tc, (String)"Null depl plan.");
            return;
        }
        FileInputStream fileInputStream = null;
        try {
            try {
                fileInputStream = new FileInputStream(file);
                this.readDeploymentPlan(fileInputStream);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new AppDeploymentException("", fileNotFoundException);
            }
            Object var5_3 = null;
            if (fileInputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            if (fileInputStream == null) throw throwable;
            try {
                fileInputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                throw new AppDeploymentException(AppUtils.getMessage(this.resBundle, "ADMA0100E", new Object[]{iOException}), iOException);
            }
        }
        try {}
        catch (IOException iOException) {
            throw new AppDeploymentException(AppUtils.getMessage(this.resBundle, "ADMA0100E", new Object[]{iOException}), iOException);
        }
        fileInputStream.close();
    }

    public void readDeploymentPlan(InputStream inputStream) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"readDeploymentPlan");
        }
        try {
            Module module;
            Object object;
            if (inputStream == null || inputStream.available() == 0) {
                if (tc.isDebugEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"Null depl plan.");
                }
                return;
            }
            ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
            Hashtable hashtable = (Hashtable)objectInputStream.readObject();
            this.getAppOptions().putAll(hashtable);
            Vector vector = (Vector)objectInputStream.readObject();
            String string = (String)hashtable.get("appdeplStandaloneURI");
            String string2 = null;
            if (string != null) {
                Vector vector2 = this.deploymentInfo.getAllURIStrings();
                if (vector2.size() > 0) {
                    string2 = (String)vector2.firstElement();
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("oldStandaloneURI: " + string + " and newStandaloneURI: " + string2));
                }
            }
            for (int i = 0; i < vector.size(); ++i) {
                object = (AppDeploymentTask)vector.elementAt(i);
                AppDeploymentTask appDeploymentTask = null;
                for (int j = 0; j < this.tasks.size(); ++j) {
                    AppDeploymentTask appDeploymentTask2 = (AppDeploymentTask)this.tasks.elementAt(j);
                    if (!((AppDeploymentTask)object).getName().equals(appDeploymentTask2.getName())) continue;
                    appDeploymentTask = appDeploymentTask2;
                    break;
                }
                if (appDeploymentTask == null) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("No matching task for " + ((AppDeploymentTask)object).getName()));
                    continue;
                }
                if (string != null && string2 != null) {
                    appDeploymentTask.setTaskData(this.patchStandaloneData(((AppDeploymentTask)object).getTaskData(), string, string2));
                    continue;
                }
                appDeploymentTask.setTaskData(((AppDeploymentTask)object).getTaskData());
            }
            if (string != null && this.deploymentInfo.getApplication().getModules().size() == 1 && this.getAppOptions().get("contextroot") != null && (module = (Module)this.deploymentInfo.getApplication().getModules().get(0)).isWebModule()) {
                object = (String)this.getAppOptions().get("contextroot");
                ((WebModule)module).setContextRoot((String)object);
            }
        }
        catch (Exception exception) {
            throw new AppDeploymentException(AppUtils.getMessage(this.resBundle, "ADMA0100E", new Object[]{exception}), exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"readDeploymentPlan");
        }
    }

    private String[][] patchStandaloneData(String[][] stringArray, String string, String string2) {
        if (stringArray == null) {
            return null;
        }
        String string3 = null;
        String string4 = null;
        try {
            String[] stringArray2 = string.split(",");
            string3 = stringArray2[0];
            stringArray2 = string2.split(",");
            string4 = stringArray2[0];
        }
        catch (Exception exception) {
            string3 = null;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            for (int j = 0; j < stringArray[i].length; ++j) {
                if (string.equals(stringArray[i][j])) {
                    stringArray[i][j] = string2;
                    continue;
                }
                if (string3 == null || !string3.equals(stringArray[i][j])) continue;
                stringArray[i][j] = string4;
            }
        }
        return stringArray;
    }

    public List getSelectedOptions() {
        boolean bl;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        boolean bl5;
        ArrayList<String> arrayList;
        block12: {
            arrayList = new ArrayList<String>();
            bl5 = false;
            bl4 = false;
            bl3 = false;
            bl2 = false;
            bl = true;
            try {
                AppDeploymentOptions appDeploymentOptions = (AppDeploymentOptions)this.getTaskByName("AppDeploymentOptions", false);
                if (!appDeploymentOptions.isTaskDisabled() && appDeploymentOptions.isEJBDeployEnabled()) {
                    bl5 = true;
                }
                if (!appDeploymentOptions.isTaskDisabled() && appDeploymentOptions.isPreCompileJSPEnabled()) {
                    bl4 = true;
                }
                if (!appDeploymentOptions.isTaskDisabled() && appDeploymentOptions.isWSDeployEnabled()) {
                    bl3 = true;
                }
                if (!appDeploymentOptions.isTaskDisabled() && appDeploymentOptions.isUseBinaryConfigEnabled()) {
                    bl2 = true;
                }
                if (!appDeploymentOptions.isTaskDisabled() && !appDeploymentOptions.isProcessEmbeddedCFG()) {
                    bl = false;
                }
            }
            catch (AppDeploymentException appDeploymentException) {
                if (!tc.isDebugEnabled()) break block12;
                Tr.debug((TraceComponent)tc, (String)("Exception when calling getTaskByName: " + appDeploymentException));
            }
        }
        if (bl5) {
            arrayList.add("deployejb");
        }
        if (bl4) {
            arrayList.add("preCompileJSPs");
        }
        if (bl3) {
            arrayList.add("deployws");
        }
        if (bl2) {
            arrayList.add("useMetaDataFromBinary");
        }
        if (bl) {
            arrayList.add("processEmbeddedConfig");
        }
        return arrayList;
    }

    public int getAppVersion() {
        int n = ((XMLResource)this.deploymentInfo.getApplication().eResource()).getVersionID();
        Tr.debug((TraceComponent)tc, (String)("AppVersion " + n));
        return n;
    }

    public int getAppVersion(boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getAppVersion");
        }
        int n = this.getAppVersion();
        Tr.debug((TraceComponent)tc, (String)("AppVersion " + n));
        List list = this.getSelectedOptions();
        if (bl && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                String string = (String)list.get(i);
                if (!string.equals("deployejb") && !string.equals("preCompileJsp") && !((Object)list).equals("enhancedEar") && !((Object)list).equals("deployws") && !((Object)list).equals("useMetaDataFromBinary")) continue;
                return versionTable[versionTable.length - 1][0];
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getAppVersion " + n));
        }
        return n;
    }

    public int getRarVersion() throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getRarVersion");
        }
        int n = 99;
        int n2 = 15;
        Vector vector = this.deploymentInfo.getModuleConfig("RAR_DD");
        if (vector.size() > 0) {
            for (int i = 0; i < vector.size(); ++i) {
                Connector connector = (Connector)vector.elementAt(i);
                n = connector.getVersionID();
                if (n < n2) continue;
                n = n2;
            }
        }
        Tr.debug((TraceComponent)tc, (String)("the highest rar version " + n));
        return n;
    }

    public Hashtable getServerTable() throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getServerTable");
        }
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        int n = this.taskNames.indexOf("MapModulesToServers");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("index for mapmod task: " + n));
        }
        if (n < 0) {
            return hashtable;
        }
        AppDeploymentTask appDeploymentTask = (AppDeploymentTask)this.tasks.elementAt(n);
        if (appDeploymentTask.getTaskData() == null && !appDeploymentTask.isTaskEmpty()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Task not prepared .. return whats in options");
            }
            Hashtable<String, String> hashtable2 = (Hashtable<String, String>)this.getAppOptions().get("moduleToServer");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(" table is : " + hashtable2));
            }
            return hashtable2 != null ? hashtable2 : hashtable;
        }
        if (appDeploymentTask.isTaskEmpty()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Task empty");
            }
            return hashtable;
        }
        String[][] stringArray = appDeploymentTask.getTaskData();
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            if (stringArray[i][2] == null || stringArray[i][2].equals("") || (string = stringArray[i][2]).indexOf(58) == -1 && string.indexOf(44) == -1) continue;
            hashtable.put(util.createUniqueModuleNameFromUriString(stringArray[i][1]), string);
        }
        Tr.debug((TraceComponent)tc, (String)("servertbl " + hashtable.toString()));
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getServerTable");
        }
        return hashtable;
    }

    public AdminClient getAdminClient() {
        return this.adminClient;
    }

    public Session getConfigSession() {
        return this.configSession;
    }

    public ConfigService getConfigService() throws Exception {
        if (this.configService == null && ConfigServiceFactory.getConfigService() != null) {
            this.configService = ConfigServiceFactory.getConfigService();
        }
        return this.configService;
    }
}

