/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management.application;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.application.AppManagementBaseFactory;
import com.ibm.websphere.management.application.AppManagementHelper;
import com.ibm.websphere.management.application.client.AppDeploymentController;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.client.AppDeploymentInfo;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.websphere.management.application.client.AppDeploymentTaskInfo;
import com.ibm.websphere.management.application.client.RedeploymentController;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceProxy;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.DefaultTaskProvider;
import com.ibm.ws.management.application.ExtensionHelper;
import com.ibm.ws.management.application.client.AppInstallHelper;
import com.ibm.ws.management.application.client.FinderQueryForCMP1XHelper;
import com.ibm.ws.management.application.j2ee.deploy.spi.J2EEDeploymentController;
import java.util.Hashtable;
import java.util.Vector;

public class AppManagementFactory
extends AppManagementBaseFactory {
    private static TraceComponent tc = Tr.register((Class)AppManagementFactory.class, null, (String)"com.ibm.ws.management.resources.AppDeploymentMessages");

    public static AppDeploymentController readArchive(String string, Hashtable hashtable) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"readArchive");
        }
        AppDeploymentController appDeploymentController = AppManagementFactory.readArchive(string, hashtable, null);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"readArchive");
        }
        return appDeploymentController;
    }

    public static AppDeploymentController readArchive(String string, Hashtable hashtable, Vector vector) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"readArchive");
        }
        if (AppManagementHelper.isSystemApp(string)) {
            return null;
        }
        AppDeploymentInfo appDeploymentInfo = AppInstallHelper.getAppDeploymentInfo(string, hashtable);
        Vector vector2 = AppManagementFactory.collectInstallTaskInfo(appDeploymentInfo, hashtable, true);
        AppDeploymentController appDeploymentController = null;
        appDeploymentController = hashtable.get("jsr88") == null ? new AppDeploymentController(appDeploymentInfo, hashtable, vector2) : new J2EEDeploymentController(appDeploymentInfo, hashtable, vector2);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"readArchive");
        }
        return appDeploymentController;
    }

    private static Vector collectInstallTaskInfo(AppDeploymentInfo appDeploymentInfo, Hashtable hashtable, boolean bl) throws AppDeploymentException {
        Vector<AppDeploymentTaskInfo> vector;
        block11: {
            Object object;
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"collectInstallTaskInfo");
            }
            vector = new Vector<AppDeploymentTaskInfo>();
            DefaultTaskProvider defaultTaskProvider = new DefaultTaskProvider();
            if (bl) {
                defaultTaskProvider.provideClientDeploymentTasks(vector, appDeploymentInfo, hashtable);
            } else {
                defaultTaskProvider.provideClientDeploymentTasksForEdit(vector, appDeploymentInfo, hashtable);
            }
            if (hashtable.get("jsr88") != null) {
                object = new AppDeploymentTaskInfo("FinderQueryForCMP1X", new FinderQueryForCMP1XHelper(), null);
                vector.addElement((AppDeploymentTaskInfo)object);
            }
            if (hashtable.get("configservice") == null) {
                if (AdminServiceFactory.getAdminService() != null && ConfigServiceFactory.getConfigService() != null) {
                    hashtable.put("configservice", ConfigServiceFactory.getConfigService());
                } else if (hashtable.get("adminclient") != null) {
                    try {
                        object = new ConfigServiceProxy((AdminClient)hashtable.get("adminclient"));
                        hashtable.put("configservice", object);
                    }
                    catch (Throwable throwable) {
                        if (!tc.isDebugEnabled()) break block11;
                        Tr.debug((TraceComponent)tc, (String)("Exception creating config service: " + throwable));
                    }
                }
            }
        }
        ExtensionHelper.processClientInstallExtensions(appDeploymentInfo, hashtable, vector, bl);
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"collectInstallTaskInfo");
        }
        return vector;
    }

    public static AppDeploymentController readPartialArchive(EARFile eARFile, Hashtable hashtable) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"readPartialArchive");
        }
        AppDeploymentInfo appDeploymentInfo = AppInstallHelper.getPartialDeploymentInfo(eARFile, hashtable);
        Vector vector = AppManagementFactory.collectInstallTaskInfo(appDeploymentInfo, hashtable, false);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("The task info has: " + vector.size() + " tasks."));
        }
        AppDeploymentController appDeploymentController = new AppDeploymentController(appDeploymentInfo, hashtable, vector);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Created AppDeploymentController: " + appDeploymentController));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"readPartialArchive");
        }
        return appDeploymentController;
    }

    public static AppDeploymentController readTasks(Vector vector, Hashtable hashtable, String string) throws AppDeploymentException {
        Hashtable<String, String> hashtable2;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"readTasks");
        }
        if ((hashtable2 = hashtable) == null) {
            hashtable2 = new Hashtable<String, String>();
        }
        if (string == null) {
            hashtable2.put("EditAppOnly", "");
        } else {
            hashtable2.put("EditModuleOnly", string);
        }
        Vector vector2 = AppManagementFactory.getTaskInfoForTasks(vector, hashtable2, null);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Got " + vector2.size() + " taskInfo objectes for " + vector.size() + " tasks."));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("The final set of taskInfo: " + vector2));
        }
        AppDeploymentController appDeploymentController = new AppDeploymentController(vector, vector2, hashtable2);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"readTasks");
        }
        return appDeploymentController;
    }

    public static AppDeploymentController writeTasks(EARFile eARFile, Vector vector, Hashtable hashtable, String string) throws AppDeploymentException {
        Hashtable<String, String> hashtable2;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"writeTasks");
        }
        if ((hashtable2 = hashtable) == null) {
            hashtable2 = new Hashtable<String, String>();
        }
        if (string == null) {
            hashtable2.put("EditAppOnly", "");
        } else {
            hashtable2.put("EditModuleOnly", string);
        }
        AppDeploymentInfo appDeploymentInfo = null;
        try {
            appDeploymentInfo = AppInstallHelper.getPartialDeploymentInfo(eARFile, hashtable2);
        }
        catch (Throwable throwable) {
            if (throwable instanceof AppDeploymentException) {
                throw (AppDeploymentException)throwable;
            }
            throw new AppDeploymentException(AppUtils.getMessage(AppUtils.getBundle(hashtable), "ADMA0065E", new Object[]{eARFile}), throwable);
        }
        Vector vector2 = AppManagementFactory.getTaskInfoForTasks(vector, hashtable2, appDeploymentInfo);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Got " + vector2.size() + " taskInfo objectes for " + vector.size() + " tasks."));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("The final set of taskInfo: " + vector2));
        }
        AppDeploymentController appDeploymentController = new AppDeploymentController(appDeploymentInfo, vector, hashtable2, vector2);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"writeTasks");
        }
        return appDeploymentController;
    }

    private static Vector getTaskInfoForTasks(Vector vector, Hashtable hashtable, AppDeploymentInfo appDeploymentInfo) throws AppDeploymentException {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getTaskInfoForTask");
        }
        Hashtable hashtable2 = new Hashtable();
        ExtensionHelper.processTaskInfoToTaskMapping(vector, hashtable2);
        Vector vector2 = new Vector();
        DefaultTaskProvider defaultTaskProvider = new DefaultTaskProvider();
        defaultTaskProvider.provideClientDeploymentTasksForEdit(vector2, appDeploymentInfo, hashtable);
        Vector<Object> vector3 = new Vector<Object>();
        Vector<AppDeploymentTask> vector4 = new Vector<AppDeploymentTask>();
        for (n = 0; n < vector.size(); ++n) {
            AppDeploymentTask appDeploymentTask = (AppDeploymentTask)vector.elementAt(n);
            if (hashtable2.get(appDeploymentTask) != null) {
                vector3.add(hashtable2.get(appDeploymentTask));
                continue;
            }
            AppDeploymentTaskInfo appDeploymentTaskInfo = AppManagementFactory.getDefaultTaskInfoForTask(appDeploymentTask, vector2, hashtable);
            if (appDeploymentTaskInfo != null) {
                vector3.add(appDeploymentTaskInfo);
                continue;
            }
            Tr.warning((TraceComponent)tc, (String)"ADMA0079W", (Object)appDeploymentTask.getName());
            vector4.addElement(appDeploymentTask);
        }
        for (n = 0; n < vector4.size(); ++n) {
            vector.remove(vector4.elementAt(n));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getTaskInfoForTask");
        }
        return vector3;
    }

    private static AppDeploymentTaskInfo getDefaultTaskInfoForTask(AppDeploymentTask appDeploymentTask, Vector vector, Hashtable hashtable) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getDefaultTaskInfoForTask: " + appDeploymentTask));
        }
        for (int i = 0; i < vector.size(); ++i) {
            AppDeploymentTaskInfo appDeploymentTaskInfo = (AppDeploymentTaskInfo)vector.elementAt(i);
            if (!appDeploymentTaskInfo.name.equals(appDeploymentTask.getName())) continue;
            return appDeploymentTaskInfo;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Returning a null TaskInfo");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getDefaultTaskInfoForTask: " + appDeploymentTask));
        }
        return null;
    }

    public static AppDeploymentController readArchiveForRedeployment(String string, Hashtable hashtable, Vector vector) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"readArchiveForRedeployment");
        }
        hashtable.put("contenttype", "app");
        AppDeploymentController appDeploymentController = AppManagementFactory.readArchiveForUpdate(string, null, "update", hashtable, vector);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"readArchiveForRedeployment");
        }
        return appDeploymentController;
    }

    public static AppDeploymentController readArchiveForUpdate(String string, String string2, String string3, Hashtable hashtable, Vector vector) throws AppDeploymentException {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"readArchiveForUpdate");
        }
        if (hashtable == null) {
            return null;
        }
        String string4 = (String)hashtable.get("contenttype");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("cType: " + string4));
        }
        if (!"modulefile".equals(string4) && !"app".equals(string4)) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"Only app or modulefile can return a controller");
            }
            return null;
        }
        if (!("add".equals(string3) || "addupdate".equals(string3) || "update".equals(string3))) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("Invalid op: " + string3 + " for update"));
            }
            return null;
        }
        AppDeploymentInfo appDeploymentInfo = AppInstallHelper.getAppDeploymentInfoForUpdate(string, string2, hashtable, string4.equals("app"));
        Vector vector2 = AppManagementFactory.collectInstallTaskInfo(appDeploymentInfo, hashtable, true);
        AppDeploymentController appDeploymentController = null;
        if (vector == null || hashtable.get("redeploy.ignore.old") != null || "add".equals(string3)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"old tasks null or op=add so treat this like install");
            }
            appDeploymentController = new AppDeploymentController(appDeploymentInfo, hashtable, vector2);
        } else {
            object = null;
            if (hashtable.get("usedefaultbindings") != null && hashtable.get("redeploy.ignore.new") == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Need to get tasks before dfltbndg.... 3-way");
                }
                Object v = hashtable.get("usedefaultbindings");
                hashtable.remove("usedefaultbindings");
                Vector vector3 = new Vector(vector2);
                AppDeploymentController appDeploymentController2 = new AppDeploymentController(appDeploymentInfo, hashtable, vector3);
                object = new Vector();
                AppDeploymentTask appDeploymentTask = appDeploymentController2.getFirstTask();
                while (appDeploymentTask != null) {
                    ((Vector)object).addElement(appDeploymentTask);
                    appDeploymentTask = appDeploymentController2.getNextTask();
                }
                if (v != null) {
                    hashtable.put("usedefaultbindings", v);
                }
            }
            appDeploymentController = new RedeploymentController(appDeploymentInfo, hashtable, vector2, vector, (Vector)object);
        }
        object = (String)hashtable.get("contextroot");
        if (object != null) {
            appDeploymentController.getAppOptions().put("contextroot", object);
        }
        appDeploymentController.getAppOptions().put("contenttype", string4);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Adding to cType and cRoot to options:" + string4 + " , " + (String)object));
        }
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"readArchiveForUpdate");
        }
        return appDeploymentController;
    }
}

