/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management.application;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.application.client.AppDeploymentController;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.application.AppAssociation;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.client.util;
import com.ibm.ws.management.application.j2ee.deploy.spi.TargetModuleIDImpl;
import com.ibm.ws.management.application.task.ConfigRepoHelper;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.management.ObjectName;
import org.eclipse.emf.ecore.resource.Resource;

public class AppDeploymentUtil {
    private static TraceComponent tc = Tr.register((Class)AppDeploymentUtil.class, null, (String)"com.ibm.ws.management.resources.AppDeploymentMessages");
    private static int[][] versionTable = new int[][]{{12, 5}, {13, 5}, {14, 6}};
    private static int[][] JCAVersionTable = new int[][]{{12, 10, 0}, {13, 10, 0}, {14, 10, 15}};
    public static final Integer BAD_VERSION = new Integer(0);

    public static Hashtable getNodeVersionForAppTargets(Hashtable hashtable, RepositoryContext repositoryContext, WorkSpace workSpace) throws AdminException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getNodeVersionForAppTargets: " + hashtable));
        }
        Hashtable hashtable2 = new Hashtable();
        if (hashtable == null || hashtable.size() == 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"appValidation: empty mod2svr table");
            }
            return hashtable2;
        }
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            try {
                String string = (String)enumeration.nextElement();
                String string2 = (String)hashtable.get(string);
                Vector vector = AppAssociation.getServerNames(string2, string, false, repositoryContext, workSpace);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(string2 + " = " + vector));
                }
                for (int i = 0; i < vector.size(); ++i) {
                    RepositoryContext repositoryContext2 = (RepositoryContext)vector.elementAt(i);
                    ObjectName objectName = ConfigRepoHelper.getObjectName(repositoryContext2);
                    if (hashtable2.get(objectName) != null) continue;
                    ArrayList<String> arrayList = new ArrayList<String>();
                    if (AppUtils.isServer(repositoryContext2)) {
                        arrayList.add(repositoryContext2.getParent().getName());
                        arrayList.add(AppUtils.getNodeMajorVersion(repositoryContext.getName(), repositoryContext2.getParent().getName()));
                    } else {
                        Vector<RepositoryContext> vector2 = new Vector<RepositoryContext>();
                        vector2.add(repositoryContext2);
                        Hashtable hashtable3 = ConfigRepoHelper.getNodeServerRelation(workSpace, vector2);
                        Enumeration enumeration2 = hashtable3.keys();
                        while (enumeration2.hasMoreElements()) {
                            RepositoryContext repositoryContext3 = (RepositoryContext)enumeration2.nextElement();
                            arrayList.add(repositoryContext3.getName());
                            arrayList.add(AppUtils.getNodeMajorVersion(repositoryContext.getName(), repositoryContext3.getName()));
                        }
                    }
                    hashtable2.put(objectName, arrayList);
                }
            }
            catch (AdminException adminException) {
                throw adminException;
            }
            catch (Throwable throwable) {
                throw new AdminException(throwable, null);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getNodeVersionForAppTargets: " + hashtable2));
        }
        return hashtable2;
    }

    public static Vector appValidation(AppDeploymentController appDeploymentController, String string, WorkSpace workSpace) throws AdminException {
        Hashtable hashtable;
        Vector vector;
        block9: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"appValidation ");
            }
            vector = new Vector();
            hashtable = new Hashtable();
            try {
                hashtable = appDeploymentController.getServerTable();
            }
            catch (AppDeploymentException appDeploymentException) {
                if (!tc.isDebugEnabled()) break block9;
                Tr.debug((TraceComponent)tc, (String)("Exception when calling getServerTable: " + appDeploymentException));
            }
        }
        if (hashtable == null || hashtable.size() == 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"appValidation: empty mod2svr table");
            }
            return vector;
        }
        try {
            int n = appDeploymentController.getAppVersion();
            int n2 = appDeploymentController.getAppVersion(true);
            List list = appDeploymentController.getSelectedOptions();
            int n3 = appDeploymentController.getRarVersion();
            Tr.debug((TraceComponent)tc, (String)("earVersion: " + n + " appversion: " + n2 + " rarVersion: " + n3));
            RepositoryContext repositoryContext = AppUtils.findContext("cells", string, null, null, workSpace, true);
            Tr.debug((TraceComponent)tc, (String)("cellc " + repositoryContext));
            Hashtable hashtable2 = AppDeploymentUtil.getNodeVersionForAppTargets(hashtable, repositoryContext, workSpace);
            vector = AppDeploymentUtil.appValidation(n3, n, n2, list, hashtable2);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"appValidation");
            }
            return vector;
        }
        catch (AdminException adminException) {
            throw adminException;
        }
        catch (Throwable throwable) {
            throw new AdminException(throwable, null);
        }
    }

    public static Vector appValidation(int n, int n2, int n3, List list, Hashtable hashtable) throws Exception {
        Vector<String> vector;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"appValidation ");
        }
        Vector vector2 = new Vector();
        Tr.debug((TraceComponent)tc, (String)("earVersion: " + n2 + " appVersion: " + n3 + " rarVersion: " + n));
        int n4 = AppDeploymentUtil.getLowestSupportedNodeVersion(n3);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("lowest node: " + n4));
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = null;
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            vector = (Vector<String>)hashtable.get(enumeration.nextElement());
            for (int i = 0; i < vector.size(); i += 2) {
                String string2 = (String)vector.get(i);
                int n5 = Integer.parseInt((String)vector.get(i + 1));
                if (n5 >= n4 || arrayList.contains(string2)) continue;
                arrayList.add(string2);
                string = (String)vector.get(i + 1);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("failed nodes: " + arrayList + " version: " + string));
        }
        vector = new Vector<String>();
        String string3 = null;
        if (arrayList.size() > 0) {
            string3 = n2 < n3 && list.size() > 0 ? AppUtils.getMessage(AppUtils.getBundle(null), "ADMA0111E", new String[]{list.toString(), ((Object)arrayList).toString(), string}) : AppUtils.getMessage(AppUtils.getBundle(null), "ADMA0110E", new String[]{Integer.toString(n3), ((Object)arrayList).toString(), string});
            vector.addElement(string3);
        }
        vector2.addAll(vector);
        if (tc.isEntryEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("messages = " + vector2));
        }
        return vector2;
    }

    private static void concatException(AdminException adminException, StringBuffer stringBuffer) {
        if (adminException == null) {
            return;
        }
        stringBuffer.append("\n" + adminException.getMessage());
        Throwable throwable = adminException.getCause();
        if (throwable == null) {
            return;
        }
        if (throwable instanceof AdminException) {
            AppDeploymentUtil.concatException((AdminException)((Object)throwable), stringBuffer);
        } else {
            stringBuffer.append("\n" + throwable.toString());
        }
    }

    private static int getLowestSupportedNodeVersion(int n) {
        for (int i = 0; i < versionTable.length; ++i) {
            if (n != versionTable[i][0]) continue;
            return versionTable[i][1];
        }
        return Integer.MAX_VALUE;
    }

    public static Vector MDBValidation(Hashtable hashtable, Hashtable hashtable2, AppDeploymentTask appDeploymentTask) {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"MDBValidation ");
        }
        Vector<String> vector = new Vector<String>();
        String[][] stringArray = appDeploymentTask.getTaskData();
        String[] stringArray2 = appDeploymentTask.getColumnNames();
        int n2 = stringArray2.length;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        for (n = 0; n < n2; ++n) {
            if ("uri".equals(stringArray2[n])) {
                n3 = n;
            }
            if ("listenerPort".equals(stringArray2[n])) {
                n4 = n;
            }
            if ("EJBModule".equals(stringArray2[n])) {
                n5 = n;
            }
            if (!"EJB".equals(stringArray2[n])) continue;
            n6 = n;
        }
        if (stringArray != null) {
            for (n = 1; n < stringArray.length; ++n) {
                String string = util.getModuleUriFromUriString(stringArray[n][n3]);
                Enumeration enumeration = hashtable2.keys();
                while (enumeration.hasMoreElements()) {
                    String string2 = (String)enumeration.nextElement();
                    Tr.debug((TraceComponent)tc, (String)("key: " + string2));
                    String string3 = util.getModuleURIFromUniqueName(string2);
                    if (!string.equals(string3)) continue;
                    Enumeration enumeration2 = hashtable.keys();
                    while (enumeration2.hasMoreElements()) {
                        List list = (List)hashtable.get(enumeration2.nextElement());
                        for (int i = 0; i < list.size(); i += 2) {
                            String string4 = (String)list.get(i);
                            int n7 = Integer.parseInt((String)list.get(i + 1));
                            Tr.debug((TraceComponent)tc, (String)("Node: " + string4 + " version:" + n7));
                            if (n7 != 5 || stringArray[n][n4] != null && !stringArray[n][n4].trim().equals("")) continue;
                            String string5 = AppUtils.getMessage(AppUtils.getBundle(null), "ADMA0001E", new String[]{appDeploymentTask.getName(), stringArray[n][n6], stringArray[n][n5]});
                            vector.addElement(string5);
                        }
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"MDBValidation ");
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List listSystemApps(Repository repository) {
        ArrayList arrayList = new ArrayList();
        Resource resource = null;
        try {
            String string = repository.getConfigRoot().getAbsolutePath(3, "systemapps.xml");
            if (!new File(string).exists()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("no system apps: " + string));
                }
                ArrayList arrayList2 = arrayList;
                return arrayList2;
            }
            resource = repository.getConfigRoot().getResource(3, "systemapps.xml");
            Vector vector = AppUtils.listSystemApps(resource);
            if (vector != null) {
                arrayList.addAll(vector);
            }
        }
        catch (Throwable throwable) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("error getting system app xml " + throwable));
            }
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.websphere.management.application.AppDeploymentUtil", (String)"307", null);
        }
        finally {
            if (resource != null) {
                resource.unload();
            }
        }
        return arrayList;
    }

    public static String getTargetName(String string, String string2, String string3, boolean bl) {
        if (bl) {
            return "WebSphere:cluster=" + string + ",j2eeType=" + "J2EEServer" + ",cell=" + string3;
        }
        return "WebSphere:server=" + string + ",j2eeType=" + "J2EEServer" + ",node=" + string2 + ",cell=" + string3;
    }

    public static String getModuleID(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("WebSphere:name=");
        stringBuffer.append(string);
        stringBuffer.append(",type=");
        stringBuffer.append(string2);
        return stringBuffer.toString();
    }

    public static TargetModuleIDImpl createTargetMod(String string, String string2, Target target, TargetModuleID targetModuleID) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("createTargetMod: " + string + ", " + string2 + ", " + target));
        }
        TargetModuleIDImpl targetModuleIDImpl = new TargetModuleIDImpl();
        targetModuleIDImpl.setTarget(target);
        targetModuleIDImpl.setWebURL(null);
        String string3 = AppDeploymentUtil.getModuleID(string, string2);
        targetModuleIDImpl.setModuleID(string3);
        targetModuleIDImpl.setObjectName(new ObjectName(string3 + ",*"));
        targetModuleIDImpl.setModuleType(string2);
        if (targetModuleID != null) {
            targetModuleIDImpl.setParentTargetModuleID(targetModuleID);
            targetModuleIDImpl.setChildTargetModuleID(null);
        } else {
            targetModuleIDImpl.setParentTargetModuleID(null);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("createTargetMod: " + string + ", " + string2 + ", " + target));
        }
        return targetModuleIDImpl;
    }
}

