/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.j2c;

import com.ibm.ejs.j2c.HCMDetails;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Vector;
import javax.resource.ResourceException;
import javax.resource.spi.IllegalStateException;

public final class HandleList
implements Serializable {
    protected static final Object lockObject = new Object();
    protected static ArrayList orphanedHandles = new ArrayList();
    protected static Vector _noContextHandles = new Vector();
    private ArrayList handleList = new ArrayList();
    private boolean destroyed = false;
    private static final TraceComponent tc = Tr.register((Class)HandleList.class, (String)"WAS.j2c", (String)"com.ibm.ejs.resources.J2CAMessages");
    private static final long serialVersionUID = -4425328702653290017L;

    public void add(HCMDetails hCMDetails) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"add HCMDetails");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("adding handle " + hCMDetails._handle));
        }
        this.handleList.add(hCMDetails);
        if (tc.isEntryEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("  handleList size " + this.handleList.size() + " _noContextHandles size " + _noContextHandles.size() + "  orphanedHandles size " + orphanedHandles.size()));
        }
        Tr.exit((TraceComponent)tc, (String)"add HCMDetails");
    }

    public void removeConnections(Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeConnections");
        }
        for (int i = this.handleList.size() - 1; i >= 0; --i) {
            HCMDetails hCMDetails = (HCMDetails)this.handleList.get(i);
            if (hCMDetails._mcWrapper != object) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Removing HCMDetails for MCWrapper " + object));
            }
            this.handleList.remove(i);
        }
        if (tc.isEntryEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("  handleList size " + this.handleList.size() + " _noContextHandles size " + _noContextHandles.size() + "  orphanedHandles size " + orphanedHandles.size()));
            Tr.exit((TraceComponent)tc, (String)"removeConnections");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"remove");
        }
        if (!this.destroyed) {
            for (int i = this.handleList.size() - 1; i >= 0; --i) {
                HCMDetails hCMDetails = (HCMDetails)this.handleList.get(i);
                if (!hCMDetails._handle.equals(object)) continue;
                this.handleList.remove(i);
                if (tc.isEntryEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("  handleList size " + this.handleList.size() + " _noContextHandles size " + _noContextHandles.size() + "  orphanedHandles size " + orphanedHandles.size()));
                    Tr.exit((TraceComponent)tc, (String)("remove, handle removed " + hCMDetails._handle));
                }
                return;
            }
            if (_noContextHandles.remove(object)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("  handleList size " + this.handleList.size() + " _noContextHandles size " + _noContextHandles.size() + "  orphanedHandles size " + orphanedHandles.size()));
                    Tr.exit((TraceComponent)tc, (String)("remove, handle removed" + object + ".  from _noContextHandles"));
                }
                return;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("HandleList does not contain the handle attempting to be removed: " + object + ".  Adding to orphanedHandles"));
            }
            Object object2 = lockObject;
            synchronized (object2) {
                orphanedHandles.add(object);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("This connection handle was added to orphanedHandles: " + object));
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Ignoring remove request.  This is ok as it is being destroyed");
        }
        if (tc.isEntryEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("  handleList size " + this.handleList.size() + " _noContextHandles size " + _noContextHandles.size() + "  orphanedHandles size " + orphanedHandles.size()));
            Tr.exit((TraceComponent)tc, (String)"remove");
        }
    }

    public void close() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"close");
        }
        this.destroyed = true;
        for (int i = this.handleList.size() - 1; i >= 0; --i) {
            try {
                HCMDetails hCMDetails = (HCMDetails)this.handleList.get(i);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Closing cached handle " + hCMDetails._handle));
                }
                if (hCMDetails._handle instanceof Connection) {
                    ((Connection)hCMDetails._handle).close();
                    continue;
                }
                if (hCMDetails._handle instanceof javax.jms.Connection) {
                    ((javax.jms.Connection)hCMDetails._handle).close();
                    continue;
                }
                if (hCMDetails._handle instanceof javax.resource.cci.Connection) {
                    ((javax.resource.cci.Connection)hCMDetails._handle).close();
                    continue;
                }
                try {
                    Method method = hCMDetails._handle.getClass().getMethod("close", null);
                    method.invoke(hCMDetails._handle, null);
                }
                catch (Exception exception) {
                    Tr.debug((TraceComponent)tc, (String)("Troubles with introspection while closing connection handles, exception = " + exception));
                }
                continue;
            }
            catch (Exception exception) {
                Tr.debug((TraceComponent)tc, (String)("Troubles with closing connection handles, exception = " + exception));
            }
        }
        this.clear();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"close");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reAssociate() throws ResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"reAssociate");
        }
        for (int i = 0; i < this.handleList.size(); ++i) {
            Object[] objectArray;
            HCMDetails hCMDetails = (HCMDetails)this.handleList.get(i);
            int n = orphanedHandles.indexOf(hCMDetails._handle);
            if (n >= 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"reAssociate: handle found in orphanedHandles");
                }
                this.handleList.remove(i);
                --i;
                Object object = lockObject;
                synchronized (object) {
                    orphanedHandles.remove(n);
                    continue;
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("reAssociate " + hCMDetails._handle));
            }
            try {
                hCMDetails._cm.reAssociate(hCMDetails);
                continue;
            }
            catch (IllegalStateException illegalStateException) {
                objectArray = new Object[]{"reAssociate", "reAssociate", hCMDetails._handle, illegalStateException};
                Tr.warning((TraceComponent)tc, (String)"PARK_OR_REASSOCIATE_FAILED_W_J2CA0083", (Object)objectArray);
                continue;
            }
            catch (Exception exception) {
                objectArray = new Object[]{"reAssociate", "reAssociate", hCMDetails._handle, exception};
                Tr.warning((TraceComponent)tc, (String)"PARK_OR_REASSOCIATE_FAILED_W_J2CA0083", (Object)objectArray);
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ejs.j2c.HandleList.reAssociate", (String)"297", (Object)this);
                ResourceException resourceException = new ResourceException("Reassociate call Failed");
                resourceException.setLinkedException(exception);
                throw resourceException;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"reAssociate");
        }
    }

    public void parkHandle() throws ResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"parkHandle");
        }
        boolean bl = false;
        Object var3_2 = null;
        for (int i = 0; i < this.handleList.size(); ++i) {
            Object[] objectArray;
            HCMDetails hCMDetails = (HCMDetails)this.handleList.get(i);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("....parking " + hCMDetails._handle));
            }
            try {
                hCMDetails._cm.parkHandle(hCMDetails);
                continue;
            }
            catch (IllegalStateException illegalStateException) {
                objectArray = new Object[]{"parkHandle", "parkHandle", hCMDetails._handle, illegalStateException};
                Tr.warning((TraceComponent)tc, (String)"PARK_OR_REASSOCIATE_FAILED_W_J2CA0083", (Object)objectArray);
                continue;
            }
            catch (Exception exception) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"parkHandle: error");
                }
                objectArray = new Object[]{"parkHandle", "parkHandle", hCMDetails._handle, exception};
                Tr.warning((TraceComponent)tc, (String)"PARK_OR_REASSOCIATE_FAILED_W_J2CA0083", (Object)objectArray);
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ejs.j2c.HandleList.parkHandle", (String)"373", (Object)this);
                ResourceException resourceException = new ResourceException("parkHandle call Failed");
                resourceException.setLinkedException(exception);
                throw resourceException;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"parkHandle");
        }
    }

    public void printAllHandles() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"printAllHandles");
        }
        for (int i = this.handleList.size() - 1; i >= 0; --i) {
            HCMDetails hCMDetails = (HCMDetails)this.handleList.get(i);
            if (!tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)("...." + hCMDetails._handle));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"printAllHandles");
        }
    }

    public void componentDestroyed() {
        int n = this.handleList.size();
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"componentDestroyed");
        }
        if (n > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Closing " + n + " cached handle(s) at the end of boundary."));
            }
            this.close();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"componentDestroyed");
        }
    }

    private void clear() {
        this.destroyed = false;
        this.handleList.clear();
    }
}

