/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.csi;

import com.ibm.ejs.csi.ResRefImpl;
import com.ibm.ejs.models.base.bindings.commonbnd.ResourceRefBinding;
import com.ibm.ejs.models.base.bindings.ejbbnd.CMPConnectionFactoryBinding;
import com.ibm.ejs.models.base.bindings.ejbbnd.EJBJarBinding;
import com.ibm.ejs.models.base.bindings.ejbbnd.EnterpriseBeanBinding;
import com.ibm.ejs.models.base.bindings.webappbnd.WebAppBinding;
import com.ibm.ejs.models.base.extensions.commonext.ResourceRefExtension;
import com.ibm.ejs.models.base.extensions.ejbext.EnterpriseBeanExtension;
import com.ibm.ejs.models.base.extensions.webappext.WebAppExtension;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.ejb.EnterpriseBean;
import com.ibm.etools.j2ee.common.ResourceRef;
import com.ibm.etools.webapplication.WebApp;
import com.ibm.websphere.csi.ResRef;
import com.ibm.websphere.csi.ResRefList;
import com.ibm.ws.exception.WsRuntimeException;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.runtime.service.VariableMapFactory;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;

public class ResRefListImpl
implements ResRefList {
    private final Vector _resRefVector;
    private String lookupString = null;
    private final String WebSphereCMPConnectionFactory = "comp/PM/WebSphereCMPConnectionFactory";
    private boolean initialized = true;
    private static final TraceComponent tc = Tr.register((Class)ResRefListImpl.class, (String)"EJBContainer", (String)"com.ibm.ejs.container.container");

    public ResRefListImpl(List list) {
        this._resRefVector = new Vector();
        this.initializeResRef(list);
    }

    public ResRefListImpl(EnterpriseBean enterpriseBean, EnterpriseBeanBinding enterpriseBeanBinding, EnterpriseBeanExtension enterpriseBeanExtension) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init> for EJB");
        }
        this._resRefVector = new Vector();
        EList eList = enterpriseBean.getResourceRefs();
        this.initializeResRef((List)eList, enterpriseBeanBinding);
        if (null != enterpriseBeanBinding && enterpriseBean.isContainerManagedEntity()) {
            CMPConnectionFactoryBinding cMPConnectionFactoryBinding = enterpriseBeanBinding.getCmpConnectionFactory();
            String string = null;
            EList eList2 = null;
            if (cMPConnectionFactoryBinding != null) {
                string = cMPConnectionFactoryBinding.getLoginConfigurationName();
                eList2 = cMPConnectionFactoryBinding.getProperties();
            } else {
                EJBJarBinding eJBJarBinding = enterpriseBeanBinding.getModuleBinding();
                cMPConnectionFactoryBinding = eJBJarBinding.getDefaultCMPConnectionFactory();
                if (cMPConnectionFactoryBinding != null) {
                    string = cMPConnectionFactoryBinding.getLoginConfigurationName();
                    eList2 = cMPConnectionFactoryBinding.getProperties();
                }
            }
            this.initializeFactoryBindings(cMPConnectionFactoryBinding, 0, string, eList2);
        }
        if (null != enterpriseBeanExtension) {
            this.initializeIsolationLevel((List)enterpriseBeanExtension.getResourceRefExtensions());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init> for EJB");
        }
    }

    public ResRefListImpl(WebApp webApp, WebAppExtension webAppExtension) {
        this(webApp, webAppExtension, null);
    }

    public ResRefListImpl(WebApp webApp, WebAppExtension webAppExtension, WebAppBinding webAppBinding) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init> for WEB");
        }
        this._resRefVector = new Vector();
        EList eList = webApp.getResourceRefs();
        this.initializeResRef((List)eList, webAppBinding);
        if (null != webAppExtension) {
            this.initializeIsolationLevel((List)webAppExtension.getResourceRefExtensions());
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"The following list of resource ref's created:");
            Tr.debug((TraceComponent)tc, (String)this.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init> for WEB");
        }
    }

    private void initializeFactoryBindings(CMPConnectionFactoryBinding cMPConnectionFactoryBinding, int n, String string, EList eList) {
        String string2 = null;
        if (null != cMPConnectionFactoryBinding) {
            string2 = cMPConnectionFactoryBinding.getJndiName();
            if (string2 == null) {
                string2 = "comp/PM/WebSphereCMPConnectionFactory";
            }
            this._resRefVector.add(new ResRefImpl("WebSphere CMP Resource Ref Connection Factory", "comp/PM/WebSphereCMPConnectionFactory", string2, "javax.resource.cci.ConnectionFactory", cMPConnectionFactoryBinding.getResAuth().getValue() == 1 ? 0 : 1, n, 0, string, eList));
        }
    }

    private void initializeIsolationLevel(List list) {
        int n = 0;
        if (null == list) {
            return;
        }
        n = list.size();
        ResourceRefExtension[] resourceRefExtensionArray = list.toArray(new ResourceRefExtension[n]);
        for (int i = 0; i < n; ++i) {
            String string = resourceRefExtensionArray[i].getResourceRef().getName();
            ResRefImpl resRefImpl = (ResRefImpl)this.findByName(string);
            if (null == resRefImpl) continue;
            resRefImpl.setIsolationLevel(resourceRefExtensionArray[i].getIsolationLevel().getValue());
        }
    }

    private void initializeResRef(List list) {
        if (list == null) {
            return;
        }
        int n = list.size();
        ResourceRef[] resourceRefArray = list.toArray(new ResourceRef[n]);
        for (int i = 0; i < n; ++i) {
            this._resRefVector.add(new ResRefImpl(resourceRefArray[i].getDescription(), resourceRefArray[i].getName(), "Jndi Name unknown", resourceRefArray[i].getType(), resourceRefArray[i].getAuth().getValue(), resourceRefArray[i].getResSharingScope().getValue(), 0, null, null));
        }
    }

    private void initializeResRef(List list, EnterpriseBeanBinding enterpriseBeanBinding) {
        if (null == list) {
            return;
        }
        int n = list.size();
        String string = null;
        if (n > 0) {
            ResourceRef[] resourceRefArray = list.toArray(new ResourceRef[n]);
            VariableMap variableMap = VariableMapFactory.getVariableMap();
            for (int i = 0; i < n; ++i) {
                ResourceRefBinding resourceRefBinding;
                EList eList = null;
                String string2 = null;
                if (null != enterpriseBeanBinding && null != (resourceRefBinding = enterpriseBeanBinding.getResRefBinding(resourceRefArray[i]))) {
                    string = variableMap.expand(resourceRefBinding.getJndiName());
                    string2 = resourceRefBinding.getLoginConfigurationName();
                    eList = resourceRefBinding.getProperties();
                }
                if (string == null) {
                    string = "Resource Ref JNDI bindings not set.";
                }
                this._resRefVector.add(new ResRefImpl(resourceRefArray[i].getDescription(), resourceRefArray[i].getName(), string, resourceRefArray[i].getType(), resourceRefArray[i].getAuth().getValue(), resourceRefArray[i].getResSharingScope().getValue(), 0, string2, eList));
            }
        }
    }

    private void initializeResRef(List list, WebAppBinding webAppBinding) {
        if (list == null) {
            return;
        }
        int n = list.size();
        String string = null;
        if (n > 0) {
            ResourceRef[] resourceRefArray = list.toArray(new ResourceRef[n]);
            for (int i = 0; i < n; ++i) {
                String string2 = null;
                EList eList = null;
                if (webAppBinding != null) {
                    ResourceRefBinding resourceRefBinding = webAppBinding.getResRefBinding(resourceRefArray[i]);
                    VariableMap variableMap = VariableMapFactory.getVariableMap();
                    if (resourceRefBinding != null) {
                        string = variableMap.expand(resourceRefBinding.getJndiName());
                        string2 = resourceRefBinding.getLoginConfigurationName();
                        eList = resourceRefBinding.getProperties();
                    }
                } else {
                    string = resourceRefArray[i].getName();
                }
                if (string == null) {
                    string = "Resource Ref JNDI bindings not set.";
                }
                this._resRefVector.add(new ResRefImpl(resourceRefArray[i].getDescription(), resourceRefArray[i].getName(), string, resourceRefArray[i].getType(), resourceRefArray[i].getAuth().getValue(), resourceRefArray[i].getResSharingScope().getValue(), 0, string2, eList));
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public ResRef findByJNDIName(String string) {
        ResRef resRef;
        block13: {
            block12: {
                Object var2_2 = null;
                resRef = null;
                boolean bl = false;
                if (tc.isEntryEnabled()) {
                    if (this.lookupString != null) {
                        Tr.entry((TraceComponent)tc, (String)("findByJNDIName " + this.lookupString + "->" + string));
                    } else {
                        Tr.entry((TraceComponent)tc, (String)("findByJNDIName direct->" + string));
                    }
                }
                if (!this.initialized) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Throwing exception as the initialization is still not complete " + this.initialized));
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"findByJNDIName");
                    }
                    throw new WsRuntimeException("ResRefList is un-initialized");
                }
                if (this.lookupString == null) break block12;
                resRef = this.findByName(this.lookupString);
                if (resRef != null) {
                    bl = true;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Returning " + ((ResRefImpl)resRef).toString()));
                    }
                    break block13;
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Resource Reference name '" + this.lookupString + "' with JNDI Name of '" + string + "' not found. Returning null."));
                        Tr.debug((TraceComponent)tc, (String)"*** KNOWN RES-REF LIST BEGIN ***");
                        Tr.debug((TraceComponent)tc, (String)this.toString());
                        Tr.debug((TraceComponent)tc, (String)"*** KNOWN RES-REF LIST END ***");
                    }
                    throw new WsRuntimeException("Resource Reference not found.");
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"(Info)Direct lookup call. Returning null ResRef.(Not an error condition)");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"findByJNDIName");
        }
        return resRef;
    }

    public ResRef findByName(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("findByName " + string));
        }
        Iterator iterator = this._resRefVector.iterator();
        ResRef resRef = null;
        while (iterator.hasNext() && !string.equals((resRef = (ResRef)iterator.next()).getName())) {
            resRef = null;
        }
        if (tc.isDebugEnabled()) {
            if (resRef == null) {
                Tr.debug((TraceComponent)tc, (String)("Resource with name '" + string + "' not found. Returning null."));
            } else {
                Tr.debug((TraceComponent)tc, (String)("Returning " + ((ResRefImpl)resRef).toString()));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("findByName " + string));
        }
        return resRef;
    }

    public int size() {
        return this._resRefVector.size();
    }

    public ResRef get(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"get");
        }
        ResRef resRef = null;
        if (n > -1 && n < this._resRefVector.size()) {
            resRef = (ResRef)this._resRefVector.get(n);
        }
        if (tc.isDebugEnabled()) {
            if (resRef == null) {
                Tr.debug((TraceComponent)tc, (String)("Resource with get( " + n + ") not found. Returning null. max i= " + this._resRefVector.size()));
            } else {
                Tr.debug((TraceComponent)tc, (String)("Returning " + ((ResRefImpl)resRef).toString()));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"get");
        }
        return resRef;
    }

    public void setLookupString(String string) {
        this.lookupString = string;
    }

    public String toString() {
        String string = System.getProperty("line.separator", "\n");
        String string2 = "                                 ";
        StringBuffer stringBuffer = new StringBuffer();
        int n = this._resRefVector.size();
        stringBuffer.append(string + string2 + "    ******* ResRefList ******* ");
        stringBuffer.append(string + string2 + "ResRefList size=" + n);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(((ResRefImpl)this._resRefVector.get(i)).toString());
        }
        return stringBuffer.toString();
    }

    public void completeInitialization() {
        this.initialized = true;
    }

    public void setToUnintialized() {
        this.initialized = false;
    }

    public boolean isInitialized() {
        return this.initialized;
    }
}

