/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tcp.channel.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.tcp.channel.impl.TCPChannelDiagnosticModule;
import com.ibm.ws.tcp.channel.impl.ValidateUtils;
import com.ibm.wsspi.channel.framework.exception.ChannelFactoryException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class TCPFactoryConfiguration {
    private static final String CLASS_NAME = "com.ibm.ws.tcp.channel.impl.TCPFactoryConfiguration";
    protected static final String KEYS_PER_SELECTOR = "maxKeysPerSelector";
    protected static final String SELECTOR_IDLE_TIMEOUT = "channelSelectorIdleTimeout";
    protected static final String SELECTOR_TERM_TIMEOUT = "channelSelectorWaitToTerminate";
    protected static final String SELECTOR_YIELD = "selectorYield";
    protected static final String SELECTOR_WAKEUP = "selectorWakeup";
    protected static final String CANCEL_KEY_ON_CLOSE = "cancelKeyOnClose";
    protected static final String COMBINE_SELECTORS = "combineSelectors";
    protected static final String INBOUND_READ_SELECTORS_TO_STARTS = "inboundReadSelectorsToStart";
    public static final String MAX_SELECTOR_THREADS = "maxRunnableSelectorThreads";
    public static final String NEW_SELECTOR_THRESHOLD = "newSelectorConnectionThreshold";
    private static final TraceComponent tc = Tr.register((Class)TCPFactoryConfiguration.class, (String)"TCPChannel", (String)"com.ibm.ws.tcp.channel.resources.tcpchannelmessages");
    private Map commonProperties = null;
    private static int maxKeysPerSelector = 500;
    private static int channelSelectorIdleTimeout = 300000;
    private static int channelSelectorWaitToTerminate = 10000;
    private static int selectorYield = 0;
    private static int selectorWakeup = ValidateUtils.SELECTOR_WAKEUP_WHEN_NEEDED;
    private static int cancelKeyOnClose = 0;
    private static int combineSelectors = 0;
    private static int maxSelectorThreads = 40;
    private static int connectionThreshold = 20;
    private static int inboundReadSelectorsToStart = 4;
    private String channelName = "*";

    protected TCPFactoryConfiguration(Map map) throws ChannelFactoryException {
        this.setValues(map);
    }

    protected void setValues(Map map) throws ChannelFactoryException {
        boolean bl = false;
        this.commonProperties = map;
        String string = System.getProperty("os.name", "unknown");
        if (TCPFactoryConfiguration.isWindows(string)) {
            Tr.debug((TraceComponent)tc, (String)"Running on Windows, defaulting selectorYield to 1");
            selectorYield = 1;
        }
        if (TCPFactoryConfiguration.isISeries(string)) {
            Tr.debug((TraceComponent)tc, (String)"Running on iSeries, defaulting maxKeysPerSelector to 50");
            maxKeysPerSelector = 50;
        }
        if (TCPFactoryConfiguration.isSun(string)) {
            Tr.debug((TraceComponent)tc, (String)"Running on Sun, defaulting cancelKeyOnCloseSetting to 1");
            bl = true;
            cancelKeyOnClose = 1;
        }
        if (this.commonProperties != null) {
            Set set = this.commonProperties.keySet();
            Iterator iterator = set.iterator();
            String string2 = null;
            String string3 = null;
            int n = ValidateUtils.VALIDATE_OK;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            while (iterator.hasNext() && n == ValidateUtils.VALIDATE_OK) {
                string2 = (String)iterator.next();
                if (!(this.commonProperties.get(string2) instanceof String)) continue;
                string3 = (String)this.commonProperties.get(string2);
                try {
                    if (string2.equalsIgnoreCase(KEYS_PER_SELECTOR)) {
                        n4 = 0;
                        n2 = ValidateUtils.KEYS_PER_SELECTOR_MIN;
                        n3 = ValidateUtils.KEYS_PER_SELECTOR_MAX;
                        maxKeysPerSelector = new Integer(string3);
                        n = ValidateUtils.testKeysPerSelector(maxKeysPerSelector);
                        continue;
                    }
                    if (string2.equalsIgnoreCase(SELECTOR_IDLE_TIMEOUT)) {
                        n4 = 0;
                        n2 = ValidateUtils.CHANNEL_SELECTOR_IDLE_TIMEOUT_MIN;
                        n3 = ValidateUtils.CHANNEL_SELECTOR_IDLE_TIMEOUT_MAX;
                        channelSelectorIdleTimeout = new Integer(string3);
                        n = ValidateUtils.testChannelSelectorIdleTimeout(channelSelectorIdleTimeout);
                        continue;
                    }
                    if (string2.equalsIgnoreCase(SELECTOR_TERM_TIMEOUT)) {
                        n4 = 0;
                        n2 = ValidateUtils.CHANNEL_SELECTOR_WAIT_TO_TERMINATE_MIN;
                        n3 = ValidateUtils.CHANNEL_SELECTOR_WAIT_TO_TERMINATE_MAX;
                        channelSelectorWaitToTerminate = new Integer(string3);
                        n = ValidateUtils.testChannelSelectorWaitToTerminate(channelSelectorWaitToTerminate);
                        if (n != ValidateUtils.VALIDATE_OK) continue;
                        channelSelectorWaitToTerminate *= 1000;
                        continue;
                    }
                    if (string2.equalsIgnoreCase(CANCEL_KEY_ON_CLOSE)) {
                        if (bl) continue;
                        n4 = 2;
                        cancelKeyOnClose = new Integer(string3);
                        n = ValidateUtils.testBooleanFormat2(cancelKeyOnClose);
                        continue;
                    }
                    if (string2.equalsIgnoreCase(SELECTOR_YIELD)) {
                        n4 = 2;
                        selectorYield = new Integer(string3);
                        n = ValidateUtils.testBooleanFormat2(selectorYield);
                        continue;
                    }
                    if (string2.equalsIgnoreCase(SELECTOR_WAKEUP)) {
                        n4 = 0;
                        n2 = ValidateUtils.SELECTOR_WAKEUP_OPTION_MIN;
                        n3 = ValidateUtils.SELECTOR_WAKEUP_OPTION_MAX;
                        selectorWakeup = new Integer(string3);
                        n = ValidateUtils.testChannelSelectorWakeupOption(selectorWakeup);
                        continue;
                    }
                    if (string2.equalsIgnoreCase(COMBINE_SELECTORS)) {
                        n4 = 2;
                        combineSelectors = new Integer(string3);
                        n = ValidateUtils.testBooleanFormat2(combineSelectors);
                        continue;
                    }
                    if (string2.equals(NEW_SELECTOR_THRESHOLD)) {
                        n4 = 0;
                        n2 = ValidateUtils.MIN_CONNECTION_THRESHOLD;
                        n3 = ValidateUtils.MAX_CONNECTION_THRESHOLD;
                        connectionThreshold = new Integer(string3);
                        n = ValidateUtils.testConnectionThreshold(connectionThreshold);
                        continue;
                    }
                    if (string2.equals(MAX_SELECTOR_THREADS)) {
                        n4 = 0;
                        n2 = ValidateUtils.MIN_SELECTOR_THREADS;
                        n3 = ValidateUtils.MAX_SELECTOR_THREADS;
                        maxSelectorThreads = new Integer(string3);
                        n = ValidateUtils.testMaxSelectorThreads(maxSelectorThreads);
                        continue;
                    }
                    if (string2.equals(INBOUND_READ_SELECTORS_TO_STARTS)) {
                        n4 = 0;
                        n2 = ValidateUtils.MIN_INBOUND_READ_SELECTORS_TO_START;
                        n3 = ValidateUtils.MAX_INBOUND_READ_SELECTORS_TO_START;
                        inboundReadSelectorsToStart = new Integer(string3);
                        n = ValidateUtils.testInboundReadSelectorsToStart(inboundReadSelectorsToStart);
                        continue;
                    }
                    Tr.warning((TraceComponent)tc, (String)"CONFIG_KEY_NOT_VALID", (Object)new Object[]{this.channelName, string2, string3});
                }
                catch (NumberFormatException numberFormatException) {
                    Tr.error((TraceComponent)tc, (String)"CONFIG_VALUE_NUMBER_EXCEPTION", (Object)new Object[]{this.channelName, string2, string3});
                    ChannelFactoryException channelFactoryException = new ChannelFactoryException("The TCP Factory caught a NumberFormatException processing property, Channel Name: " + this.channelName + " Property name: " + string2 + " value: " + string3, (Throwable)numberFormatException);
                    FFDCFilter.processException((Throwable)channelFactoryException, (String)CLASS_NAME, (String)"101", (Object)this);
                    throw channelFactoryException;
                }
            }
            if (n != ValidateUtils.VALIDATE_OK) {
                ChannelFactoryException channelFactoryException = null;
                if (n4 == 0) {
                    Tr.error((TraceComponent)tc, (String)"CONFIG_VALUE_NOT_VALID_INT", (Object)new Object[]{this.channelName, string2, string3, "" + n2, "" + n3});
                    channelFactoryException = new ChannelFactoryException("A TCP Channel has been constructed with incorrect configuration property value, Channel Name: " + this.channelName + " name: " + string2 + " value: " + string3 + "minimum Value: " + n2 + "maximum Value: " + n3);
                } else if (n4 == 2) {
                    Tr.error((TraceComponent)tc, (String)"CONFIG_VALUE_NOT_VALID_BOOLEAN2", (Object)new Object[]{this.channelName, string2, string3});
                    channelFactoryException = new ChannelFactoryException("A TCP Channel has been constructed with incorrect configuration property value, Channel Name: " + this.channelName + " name: " + string2 + " value: " + string3 + " Valid Range: 0 - False, 1 - True");
                } else if (string3 == null) {
                    Tr.error((TraceComponent)tc, (String)"CONFIG_VALUE_NOT_VALID_NULL_STRING", (Object)new Object[]{this.channelName, string2});
                    channelFactoryException = new ChannelFactoryException("A TCP Channel has been constructed with incorrect configuration property value, Channel Name: " + this.channelName + " name: " + string2 + " value: null");
                } else {
                    Tr.error((TraceComponent)tc, (String)"CONFIG_VALUE_NOT_VALID_STRING", (Object)new Object[]{this.channelName, string2, string3});
                    channelFactoryException = new ChannelFactoryException("A TCP Channel has been constructed with incorrect configuration property value, Channel Name: " + this.channelName + " name: " + string2 + " value: " + string3);
                }
                FFDCFilter.processException((Throwable)channelFactoryException, (String)CLASS_NAME, (String)"102", (Object)this);
                throw channelFactoryException;
            }
        }
    }

    protected static int getMaxKeysPerSelector() {
        return maxKeysPerSelector;
    }

    protected static int getChannelSelectorIdleTimeout() {
        return channelSelectorIdleTimeout;
    }

    protected static int getChannelSelectorWaitToTerminate() {
        return channelSelectorWaitToTerminate;
    }

    protected static int getSelectorYield() {
        return selectorYield;
    }

    protected static int getCancelKeyOnClose() {
        return cancelKeyOnClose;
    }

    protected static int getSelectorWakeup() {
        return selectorWakeup;
    }

    protected static int getCombineSelectors() {
        return combineSelectors;
    }

    protected static int getMaxSelectorThreads() {
        return maxSelectorThreads;
    }

    protected static int getNewSelectorConnectionThreshold() {
        return connectionThreshold;
    }

    protected static int getInboundReadSelectorsToStart() {
        return inboundReadSelectorsToStart;
    }

    protected void outputConfigToTrace() {
        Tr.debug((TraceComponent)tc, (String)"Config parameters for TCP Channel Factory: ");
        Tr.debug((TraceComponent)tc, (String)("maxKeysPerSelector: " + maxKeysPerSelector));
        Tr.debug((TraceComponent)tc, (String)("channelSelectorIdleTimeout: " + channelSelectorIdleTimeout));
        Tr.debug((TraceComponent)tc, (String)("channelSelectorWaitToTerminate: " + channelSelectorWaitToTerminate));
        Tr.debug((TraceComponent)tc, (String)("selectorYield: " + selectorYield));
        Tr.debug((TraceComponent)tc, (String)("cancelKeyOnClose: " + cancelKeyOnClose));
        Tr.debug((TraceComponent)tc, (String)("combineSelectors: " + combineSelectors));
        Tr.debug((TraceComponent)tc, (String)("maxRunnableSelectorThreads: " + maxSelectorThreads));
        Tr.debug((TraceComponent)tc, (String)("newSelectorConnectionThreshold: " + connectionThreshold));
        Tr.debug((TraceComponent)tc, (String)("inboundReadSelectorsToStart: " + inboundReadSelectorsToStart));
    }

    protected String getFFDCDumpData(StringBuffer stringBuffer) {
        StringBuffer stringBuffer2 = stringBuffer == null ? new StringBuffer() : stringBuffer;
        stringBuffer2 = TCPChannelDiagnosticModule.formatFFDCString(KEYS_PER_SELECTOR, String.valueOf(maxKeysPerSelector), stringBuffer2);
        stringBuffer2 = TCPChannelDiagnosticModule.formatFFDCString(SELECTOR_IDLE_TIMEOUT, String.valueOf(channelSelectorIdleTimeout), stringBuffer2);
        stringBuffer2 = TCPChannelDiagnosticModule.formatFFDCString(SELECTOR_TERM_TIMEOUT, String.valueOf(channelSelectorWaitToTerminate), stringBuffer2);
        stringBuffer2 = TCPChannelDiagnosticModule.formatFFDCString(SELECTOR_YIELD, String.valueOf(selectorYield), stringBuffer2);
        stringBuffer2 = TCPChannelDiagnosticModule.formatFFDCString(CANCEL_KEY_ON_CLOSE, String.valueOf(cancelKeyOnClose), stringBuffer2);
        stringBuffer2 = TCPChannelDiagnosticModule.formatFFDCString(COMBINE_SELECTORS, String.valueOf(combineSelectors), stringBuffer2);
        stringBuffer2 = TCPChannelDiagnosticModule.formatFFDCString(MAX_SELECTOR_THREADS, String.valueOf(maxSelectorThreads), stringBuffer2);
        stringBuffer2 = TCPChannelDiagnosticModule.formatFFDCString(NEW_SELECTOR_THRESHOLD, String.valueOf(connectionThreshold), stringBuffer2);
        stringBuffer2 = TCPChannelDiagnosticModule.formatFFDCString(INBOUND_READ_SELECTORS_TO_STARTS, String.valueOf(inboundReadSelectorsToStart), stringBuffer2);
        return stringBuffer2.toString();
    }

    protected String getFFDCDumpData() {
        return this.getFFDCDumpData(null);
    }

    protected static boolean isSun(String string) {
        return string.indexOf("SunOS") != -1 || string.indexOf("Solaris") != -1;
    }

    protected static boolean isWindows(String string) {
        return string.toLowerCase().startsWith("windows");
    }

    protected static boolean isISeries(String string) {
        return string.equalsIgnoreCase("os/400");
    }
}

