/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tcp.channel.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.buffermgmt.impl.WsByteBufferPoolManagerImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.tcp.channel.impl.ConnectionManager;
import com.ibm.ws.tcp.channel.impl.SimpleSync;
import com.ibm.ws.tcp.channel.impl.SocketIOChannel;
import com.ibm.ws.tcp.channel.impl.TCPChannel;
import com.ibm.ws.tcp.channel.impl.TCPChannelConfiguration;
import com.ibm.ws.tcp.channel.impl.TCPChannelDiagnosticModule;
import com.ibm.ws.tcp.channel.impl.TCPReadRequestContextImpl;
import com.ibm.ws.tcp.channel.impl.TCPWriteRequestContextImpl;
import com.ibm.ws.tcp.channel.impl.WorkQueueManager;
import com.ibm.ws.util.ThreadPool;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.channel.InboundConnectionLink;
import com.ibm.wsspi.channel.OutboundConnectionLink;
import com.ibm.wsspi.channel.base.OutboundConnectorLink;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.tcp.channel.SSLConnectionContext;
import com.ibm.wsspi.tcp.channel.TCPConnectRequestContext;
import com.ibm.wsspi.tcp.channel.TCPConnectionContext;
import com.ibm.wsspi.tcp.channel.TCPReadCompletedCallback;
import com.ibm.wsspi.tcp.channel.TCPReadRequestContext;
import com.ibm.wsspi.tcp.channel.TCPWriteCompletedCallback;
import com.ibm.wsspi.tcp.channel.TCPWriteRequestContext;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.util.Map;

public class TCPConnLink
extends OutboundConnectorLink
implements InboundConnectionLink,
OutboundConnectionLink,
TCPConnectionContext {
    private TCPChannelConfiguration config;
    private WorkQueueManager workQueueMgr = null;
    private TCPChannel tcpChannel = null;
    private boolean pleaseCloseSoon;
    private int numReads = 0;
    private int numWrites = 0;
    private ThreadPool oThreadPool;
    private TCPReadRequestContextImpl reader;
    private TCPWriteRequestContextImpl writer;
    public static final String TCP_READ_CONTEXT = "TCP_READ_CONTEXT";
    public static final String TCP_WRITE_CONTEXT = "TCP_WRITE_CONTEXT";
    private SocketIOChannel socketIOChannel;
    protected SimpleSync syncObject = null;
    protected Exception syncError = null;
    public static final String PROXY_TARGET_HOST_PORT = "PROXY_TARGET_HOST_PORT";
    public static final String PROXY_TARGET_USER_PASS = "PROXY_TARGET_USER_PASS";
    private static byte[] PROXY_CONNECT = null;
    private static byte[] PROXY_HTTPVERSION = null;
    private static byte[] PROXY_AUTHORIZATION = null;
    private static final byte[] PROXY_CRLF = new byte[]{13, 10};
    private ProxyWriteCallback proxyWriteCB = null;
    private ProxyReadCallback proxyReadCB = null;
    private boolean isProxyResponseValid = false;
    private int channelBlockingType = 0;
    private boolean callCompleteLocal = false;
    private boolean closed = false;
    protected static final int STATUS_NOT_DONE = 0;
    protected static final int STATUS_DONE = 1;
    protected static final int STATUS_ERROR = 2;
    protected static final TraceComponent tc = Tr.register((Class)TCPConnLink.class, (String)"TCPChannel", (String)"com.ibm.ws.tcp.channel.resources.tcpchannelmessages");

    public TCPConnLink(WorkQueueManager workQueueManager, VirtualConnection virtualConnection, TCPChannel tCPChannel, TCPChannelConfiguration tCPChannelConfiguration, ThreadPool threadPool) {
        this.init(virtualConnection);
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"TCPConnLink");
        }
        this.workQueueMgr = workQueueManager;
        this.tcpChannel = tCPChannel;
        this.config = tCPChannelConfiguration;
        this.oThreadPool = threadPool;
        this.channelBlockingType = tCPChannelConfiguration.getBlockingChannel();
        this.reader = new TCPReadRequestContextImpl(this);
        this.writer = new TCPWriteRequestContextImpl(this);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"TCPConnLink");
        }
    }

    protected ThreadPool getThreadPool() {
        return this.oThreadPool;
    }

    public boolean equals(Object object) {
        return this == object;
    }

    public void ready(VirtualConnection virtualConnection) {
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"This should not be called because the TCPConnLink is always ready since it is the first in the chain.");
        }
    }

    public Object getChannelAccessor() {
        return this;
    }

    public TCPChannel getTCPChannel() {
        return this.tcpChannel;
    }

    public TCPReadRequestContext getReadInterface() {
        return this.reader;
    }

    public TCPWriteRequestContext getWriteInterface() {
        return this.writer;
    }

    protected TCPReadRequestContextImpl getTCPReadConnLink() {
        return this.reader;
    }

    protected TCPWriteRequestContextImpl getTCPWriteConnLink() {
        return this.writer;
    }

    public void connect(Object object) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"connect");
        }
        if (!this.config.isDispatchWorkToThreads()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Can't perform sync. Dispatch to Worker threads = false");
            }
            throw new IOException("Can't perform read. Dispatch to Worker threads = false");
        }
        this.syncObject = new SimpleSync();
        this.isProxyResponseValid = false;
        this.syncError = null;
        this.connectCommon((TCPConnectRequestContext)object);
        if (this.syncError != null) {
            throw this.syncError;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"connect");
        }
    }

    public void connectAsynch(Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"connectAsynch");
        }
        this.syncObject = null;
        if (this.channelBlockingType == 1) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"SocketChannel: ConnectAsynch failed, can not call connectAsynch on a Blocking Channel ");
            }
            IOException iOException = new IOException("ConnectAsynch failed, can not call connectAsynch on a Blocking Channel ");
            this.connectFailed(iOException);
        } else {
            this.isProxyResponseValid = false;
            this.connectCommon((TCPConnectRequestContext)object);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"connectAsynch");
        }
    }

    public void connectCommon(TCPConnectRequestContext tCPConnectRequestContext) {
        ConnectionManager connectionManager = this.tcpChannel.getConnMgr();
        TCPConnectRequestContext tCPConnectRequestContext2 = tCPConnectRequestContext;
        SocketIOChannel socketIOChannel = null;
        if (this.socketIOChannel != null) {
            this.socketIOChannel.close();
            this.socketIOChannel = null;
        }
        try {
            this.callCompleteLocal = false;
            socketIOChannel = connectionManager.getConnection(tCPConnectRequestContext2, this, this.syncObject);
            if (this.callCompleteLocal) {
                this.connectComplete(socketIOChannel);
            }
        }
        catch (Exception exception) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("SocketChannel connect failed, local: " + tCPConnectRequestContext2.getLocalAddress() + " remote: " + tCPConnectRequestContext2.getRemoteAddress()));
            }
            this.connectFailed(exception);
        }
    }

    protected void connectComplete(SocketIOChannel socketIOChannel) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"connectComplete");
        }
        this.setSocketIOChannel(socketIOChannel);
        Object v = this.getVirtualConnection().getStateMap().get("FORWARD_PROXY_CONNECT");
        if (null != v) {
            boolean bl = false;
            try {
                bl = this.setForwardProxyBuffers((Map)v);
            }
            catch (ClassCastException classCastException) {
                FFDCFilter.processException((Throwable)classCastException, (String)"com.ibm.ws.tcp.channel.impl.TCPConnLink.connectComplete", (String)"300");
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Incorrect forward proxy setup: " + classCastException));
                }
                this.connectFailed(classCastException);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"connectComplete");
                }
                return;
            }
            if (bl) {
                if (!this.isAsyncConnect()) {
                    try {
                        this.writer.write(-1L, 0);
                        this.releaseProxyWriteBuffer();
                        this.proxyReadHandshake();
                    }
                    catch (IOException iOException) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"connectComplete: could not complete sync handshake");
                        }
                        this.releaseProxyWriteBuffer();
                        this.connectFailed(iOException);
                    }
                } else {
                    this.proxyWriteCB = new ProxyWriteCallback();
                    this.vc = this.writer.write(-1L, this.proxyWriteCB, false, 0);
                    if (null != this.vc) {
                        this.proxyWriteCB.complete(this.vc, this.writer);
                    }
                }
            }
        } else if (this.syncObject == null) {
            this.getApplicationCallback().ready(this.vc);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"connectComplete");
        }
    }

    protected boolean isAsyncConnect() {
        return null == this.syncObject;
    }

    protected void setCallCompleteLocal(boolean bl) {
        this.callCompleteLocal = bl;
    }

    protected void proxyReadHandshake() {
        this.reader.setJITAllocateSize(1024);
        if (this.isAsyncConnect()) {
            this.proxyReadCB = new ProxyReadCallback();
            this.readProxyResponse(this.vc);
        } else {
            int n = 0;
            while (n == 0) {
                this.readProxyResponse(this.vc);
                n = this.checkResponse(this.reader);
            }
            if (n == 2) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"could not complete proxy handshake, read request failed");
                }
                this.releaseProxyReadBuffer();
                if (null == this.syncError) {
                    this.connectFailed(new IOException("Invalid Proxy Server Response "));
                }
            }
        }
    }

    protected int checkResponse(TCPReadRequestContext tCPReadRequestContext) {
        WsByteBuffer[] wsByteBufferArray = tCPReadRequestContext.getBuffers();
        if (null != wsByteBufferArray) {
            int n = this.validateProxyResponse(wsByteBufferArray);
            if (1 == n) {
                this.releaseProxyReadBuffer();
            }
            return n;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"could not complete proxy handshake, proxy response buffers are null");
        }
        return 2;
    }

    protected void releaseProxyWriteBuffer() {
        WsByteBuffer wsByteBuffer = this.writer.getBuffer();
        if (null != wsByteBuffer) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Releasing proxy write buffer: " + wsByteBuffer));
            }
            wsByteBuffer.release();
            this.writer.setBuffer(null);
        }
    }

    protected void releaseProxyReadBuffer() {
        WsByteBuffer wsByteBuffer = this.reader.getBuffer();
        if (null != wsByteBuffer) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Releasing proxy read buffer: " + wsByteBuffer));
            }
            wsByteBuffer.release();
            this.reader.setBuffer(null);
        }
    }

    protected void connectFailed(Exception exception) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"connectFailed");
        }
        if (this.isAsyncConnect()) {
            this.close(this.getVirtualConnection(), exception);
        } else {
            this.syncError = exception;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"connectFailed");
        }
    }

    private int validateProxyResponse(WsByteBuffer[] wsByteBufferArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"validateProxyResponse");
        }
        int n = 0;
        for (int i = 0; i < wsByteBufferArray.length; ++i) {
            wsByteBufferArray[i].flip();
            byte[] byArray = new byte[wsByteBufferArray[i].limit()];
            wsByteBufferArray[i].get(byArray);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("buffer: [" + new String(byArray) + "]"));
            }
            if (!this.isProxyResponseValid) {
                this.isProxyResponseValid = this.containsHTTP200(byArray);
                if (!this.isProxyResponseValid) {
                    n = 2;
                    break;
                }
            }
            if (this.containsCRLF(byArray)) {
                n = 1;
                break;
            }
            wsByteBufferArray[i].clear();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("validateProxyResponse, rc=" + n));
        }
        return n;
    }

    private boolean containsCRLF(byte[] byArray) {
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            if (13 == byArray[i] || 10 == byArray[i]) {
                if (4 != ++n) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"containsCRLF: true");
                }
                return true;
            }
            n = 0;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("containsCRLF: false count=" + n));
        }
        return false;
    }

    private boolean containsHTTP200(byte[] byArray) {
        boolean bl = true;
        if (byArray.length < 12 || byArray[0] != 72 || byArray[1] != 84 || byArray[2] != 84 || byArray[3] != 80 || byArray[9] != 50 || byArray[10] != 48 || byArray[11] != 48) {
            bl = false;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("containsHTTP200: " + bl));
        }
        return bl;
    }

    private boolean setForwardProxyBuffers(Map map) {
        byte[] byArray = (byte[])map.get(PROXY_TARGET_HOST_PORT);
        if (null == byArray) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Proxy tunnel attempt missing target host");
            }
            this.connectFailed(new IOException("Missing forward proxy target host"));
            return false;
        }
        byte[] byArray2 = (byte[])map.get(PROXY_TARGET_USER_PASS);
        int n = 100 + byArray.length + (null != byArray2 ? byArray2.length : 0);
        WsByteBuffer wsByteBuffer = WsByteBufferPoolManagerImpl.getRef().allocate(n);
        wsByteBuffer.put(PROXY_CONNECT);
        wsByteBuffer.put(byArray);
        wsByteBuffer.put(PROXY_HTTPVERSION);
        if (null != byArray2) {
            wsByteBuffer.put(PROXY_AUTHORIZATION);
            wsByteBuffer.put(byArray2);
            wsByteBuffer.put(PROXY_CRLF);
        }
        wsByteBuffer.put(PROXY_CRLF);
        wsByteBuffer.flip();
        if (tc.isDebugEnabled()) {
            byte[] byArray3 = new byte[wsByteBuffer.limit()];
            wsByteBuffer.get(byArray3);
            Tr.debug((TraceComponent)tc, (String)("ForwardProxyBuffers[" + new String(byArray3) + "]"));
            wsByteBuffer.position(0);
        }
        this.writer.setBuffer(wsByteBuffer);
        return true;
    }

    protected void readProxyResponse(VirtualConnection virtualConnection) {
        int n = 1;
        if (!this.isProxyResponseValid) {
            n = 12;
        }
        if (this.isAsyncConnect()) {
            virtualConnection = this.reader.read(n, this.proxyReadCB, false, 0);
            if (null != virtualConnection) {
                this.proxyReadCB.complete(virtualConnection, this.reader);
            }
        } else {
            try {
                this.reader.read(n, 0);
            }
            catch (IOException iOException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"could not complete proxy handshake, read request failed");
                }
                this.releaseProxyReadBuffer();
                this.connectFailed(iOException);
            }
        }
    }

    protected void setSocketIOChannel(SocketIOChannel socketIOChannel) {
        this.socketIOChannel = socketIOChannel;
    }

    protected SocketIOChannel getSocketIOChannel() {
        return this.socketIOChannel;
    }

    protected WorkQueueManager getWorkQueueManager() {
        return this.workQueueMgr;
    }

    public TCPChannelConfiguration getConfig() {
        return this.config;
    }

    public InetAddress getRemoteAddress() {
        return this.socketIOChannel.getSocket().getInetAddress();
    }

    public int getRemotePort() {
        return this.socketIOChannel.getSocket().getPort();
    }

    public InetAddress getLocalAddress() {
        return this.socketIOChannel.getSocket().getLocalAddress();
    }

    public int getLocalPort() {
        return this.socketIOChannel.getSocket().getLocalPort();
    }

    public SSLConnectionContext getSSLContext() {
        return null;
    }

    protected int getNumReads() {
        return this.numReads;
    }

    protected int getNumWrites() {
        return this.numWrites;
    }

    protected void incrementNumReads() {
        ++this.numReads;
    }

    protected void incrementNumWrites() {
        ++this.numWrites;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(VirtualConnection virtualConnection, Exception exception) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"close()");
        }
        boolean bl = true;
        TCPConnLink tCPConnLink = this;
        synchronized (tCPConnLink) {
            if (this.closed) {
                bl = false;
            }
            this.closed = true;
        }
        if (bl) {
            super.close(virtualConnection, exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"close()");
        }
    }

    public void destroy(Exception exception) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"destroy(Exception)");
        }
        if (this.socketIOChannel != null) {
            this.socketIOChannel.close();
            this.tcpChannel.decrementConnectionCount();
        }
        super.destroy(exception);
        this.tcpChannel.releaseConnectionLink(this);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"destroy(Exception)");
        }
    }

    protected String getFFDCDumpData(StringBuffer stringBuffer) {
        StringBuffer stringBuffer2 = stringBuffer == null ? new StringBuffer() : stringBuffer;
        stringBuffer2 = TCPChannelDiagnosticModule.formatFFDCString("pleaseCloseSoon", String.valueOf(this.pleaseCloseSoon), stringBuffer2);
        stringBuffer2 = TCPChannelDiagnosticModule.formatFFDCString("getLocalAddress()", String.valueOf(this.getLocalAddress()), stringBuffer2);
        stringBuffer2 = TCPChannelDiagnosticModule.formatFFDCString("getLocalPort()", String.valueOf(this.getLocalPort()), stringBuffer2);
        stringBuffer2 = TCPChannelDiagnosticModule.formatFFDCString("getRemoteAddress()", String.valueOf(this.getRemoteAddress()), stringBuffer2);
        stringBuffer2 = TCPChannelDiagnosticModule.formatFFDCString("getRemotePort()", String.valueOf(this.getRemotePort()), stringBuffer2);
        return stringBuffer2.toString();
    }

    protected String getFFDCDumpData() {
        return this.getFFDCDumpData(null);
    }

    static {
        try {
            PROXY_CONNECT = "CONNECT ".getBytes("ISO-8859-1");
            PROXY_HTTPVERSION = " HTTP/1.0\r\n".getBytes("ISO-8859-1");
            PROXY_AUTHORIZATION = "Proxy-authorization: basic ".getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("ISO-8859-1 encoding not supported.  Exception: " + unsupportedEncodingException));
            }
            PROXY_CONNECT = "CONNECT ".getBytes();
            PROXY_HTTPVERSION = " HTTP/1.0\r\n".getBytes();
            PROXY_AUTHORIZATION = "Proxy-authorization: basic ".getBytes();
        }
    }

    private class ProxyReadCallback
    implements TCPReadCompletedCallback {
        private ProxyReadCallback() {
        }

        public void complete(VirtualConnection virtualConnection, TCPReadRequestContext tCPReadRequestContext) {
            int n;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("ProxyReadCallback --> complete for " + virtualConnection));
            }
            if ((n = TCPConnLink.this.checkResponse(tCPReadRequestContext)) == 1) {
                TCPConnLink.this.getApplicationCallback().ready(virtualConnection);
            } else if (n == 0) {
                TCPConnLink.this.readProxyResponse(virtualConnection);
            } else {
                TCPConnLink.this.releaseProxyReadBuffer();
                TCPConnLink.this.connectFailed(new IOException("Invalid Proxy Server Response "));
            }
        }

        public void error(VirtualConnection virtualConnection, TCPReadRequestContext tCPReadRequestContext, IOException iOException) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("ProxyReadCallback--> error for " + virtualConnection));
                Tr.debug((TraceComponent)tc, (String)("ioe: " + iOException));
            }
            TCPConnLink.this.releaseProxyReadBuffer();
            TCPConnLink.this.connectFailed(new IOException("Proxy Server Response read failed"));
        }
    }

    private class ProxyWriteCallback
    implements TCPWriteCompletedCallback {
        private ProxyWriteCallback() {
        }

        public void complete(VirtualConnection virtualConnection, TCPWriteRequestContext tCPWriteRequestContext) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("ProxyWriteCallback --> complete for " + virtualConnection));
            }
            TCPConnLink.this.releaseProxyWriteBuffer();
            TCPConnLink.this.proxyReadHandshake();
        }

        public void error(VirtualConnection virtualConnection, TCPWriteRequestContext tCPWriteRequestContext, IOException iOException) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("ProxyWriteCallback--> error for " + virtualConnection));
                Tr.debug((TraceComponent)tc, (String)("ioe: " + iOException));
            }
            TCPConnLink.this.releaseProxyWriteBuffer();
            TCPConnLink.this.connectFailed(new IOException("Forward Proxy buffers CONNECT failed"));
        }
    }
}

