/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tcp.channel.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.tcp.channel.impl.NBAcceptChannelSelector;
import com.ibm.ws.tcp.channel.impl.TCPChannelConfiguration;
import com.ibm.ws.tcp.channel.impl.TCPFactoryConfiguration;
import com.ibm.ws.tcp.channel.impl.TCPPort;
import com.ibm.wsspi.channel.framework.exception.RetryableChannelException;
import java.io.IOException;
import java.util.HashMap;

public class NBAccept {
    static final String CLASS_NAME = "com.ibm.ws.tcp.channel.impl.NBAccept";
    static final TraceComponent tc = Tr.register((Class)NBAccept.class, (String)"TCPChannel", (String)"com.ibm.ws.tcp.channel.resources.tcpchannelmessages");
    private NBAcceptChannelSelector sharedAccept = null;
    private Thread sharedThread = null;
    private boolean selectorYield = true;
    private Object workSync = new Object();
    int acceptType = 0;
    private HashMap endPointToAccept = null;
    public static final int REGISTER_ENDPOINT = 1;
    public static final int REMOVE_ENDPOINT = 0;

    public NBAccept(TCPChannelConfiguration tCPChannelConfiguration) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"NBAccept");
        }
        this.endPointToAccept = new HashMap();
        this.acceptType = tCPChannelConfiguration.getAcceptThread();
        this.selectorYield = TCPFactoryConfiguration.getSelectorYield() != 0;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"NBAccept");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerPort(TCPPort tCPPort) throws IOException, RetryableChannelException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"registerPort");
        }
        NBAccept nBAccept = this;
        synchronized (nBAccept) {
            EndPointActionInfo endPointActionInfo = new EndPointActionInfo(1, tCPPort, this.workSync);
            if (this.acceptType == 0) {
                if (this.sharedAccept == null) {
                    this.sharedAccept = new NBAcceptChannelSelector(this.selectorYield);
                    this.sharedThread = new Thread(this.sharedAccept);
                    this.sharedThread.setName("Shared TCPChannel NonBlocking Accept Thread");
                    this.sharedThread.setDaemon(true);
                    this.sharedThread.start();
                }
                Object object = this.workSync;
                synchronized (object) {
                    try {
                        this.sharedAccept.addWork(endPointActionInfo);
                        this.workSync.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                this.endPointToAccept.put(tCPPort, this.sharedAccept);
            } else {
                NBAcceptChannelSelector nBAcceptChannelSelector = new NBAcceptChannelSelector(this.selectorYield);
                Thread thread = new Thread(nBAcceptChannelSelector);
                thread.setName("Dedicated TCPChannel NonBlocking Accept Thread:" + tCPPort.getListenPort());
                thread.setDaemon(true);
                thread.start();
                Object object = this.workSync;
                synchronized (object) {
                    try {
                        nBAcceptChannelSelector.addWork(endPointActionInfo);
                        this.workSync.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                this.endPointToAccept.put(tCPPort, nBAcceptChannelSelector);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"registerPort");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePort(TCPPort tCPPort) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removePort ");
        }
        NBAccept nBAccept = this;
        synchronized (nBAccept) {
            NBAcceptChannelSelector nBAcceptChannelSelector = (NBAcceptChannelSelector)this.endPointToAccept.get(tCPPort);
            if (nBAcceptChannelSelector != null) {
                EndPointActionInfo endPointActionInfo = new EndPointActionInfo(0, tCPPort, this.workSync);
                Object object = this.workSync;
                synchronized (object) {
                    nBAcceptChannelSelector.addWork(endPointActionInfo);
                    try {
                        this.workSync.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (nBAcceptChannelSelector == this.sharedAccept && nBAcceptChannelSelector.getUsageCount() <= 0) {
                    this.sharedAccept = null;
                }
            } else {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("TCP Port to be removed is not registered.");
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Throwing IllegalArgumentException");
                }
                FFDCFilter.processException((Throwable)illegalArgumentException, (String)"com.ibm.ws.tcp.channel.impl.NBAccept.removeEndPoint", (String)"387", (Object)this);
                throw illegalArgumentException;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removePort");
        }
    }

    protected class EndPointActionInfo {
        protected int action;
        protected TCPPort endPoint;
        Object syncObject = null;

        EndPointActionInfo(int n, TCPPort tCPPort, Object object) {
            this.action = n;
            this.endPoint = tCPPort;
            this.syncObject = object;
        }
    }
}

