/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tcp.channel.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.tcp.channel.impl.CancelRequest;
import com.ibm.ws.tcp.channel.impl.TCPChannelLinkedList;
import com.ibm.ws.tcp.channel.impl.TCPFactoryConfiguration;
import com.ibm.ws.timeutils.QuickApproxTime;
import com.ibm.wsspi.channel.framework.exception.ChannelException;
import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.ArrayList;
import java.util.Iterator;

public abstract class ChannelSelector
implements Runnable {
    private static final String CLASS_NAME = "com.ibm.ws.tcp.channel.impl.ChannelSelector";
    private static final TraceComponent tc = Tr.register((Class)ChannelSelector.class, (String)"TCPChannel", (String)"com.ibm.ws.tcp.channel.resources.tcpchannelmessages");
    protected volatile boolean quit = false;
    protected Selector selector = null;
    protected boolean selectorYield = false;
    protected long nextTimeoutTime;
    protected boolean selectorContainsRequestsWithTimeouts;
    boolean waitingToQuit = false;
    protected long currentTime;
    private ArrayList cancelList = new ArrayList();
    protected TCPChannelLinkedList ourWorkQueue = new TCPChannelLinkedList();
    protected boolean wakeupPending = false;
    boolean checkCancel = false;

    public ChannelSelector(boolean bl, boolean bl2) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"ChannelSelector");
        }
        this.selector = Selector.open();
        this.selectorYield = bl;
        this.checkCancel = bl2;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"ChannelSelector");
        }
    }

    public void run() {
        boolean bl = false;
        boolean bl2 = false;
        long l = 0L;
        int n = 0;
        int n2 = 0;
        boolean bl3 = true;
        long l2 = 0L;
        int n3 = -1;
        long l3 = 0L;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"run");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("selector thread started for selector " + Thread.currentThread().getName()));
        }
        this.currentTime = QuickApproxTime.getRef().getApproxTime();
        this.nextTimeoutTime = this.currentTime + (long)TCPFactoryConfiguration.getChannelSelectorIdleTimeout();
        this.selectorContainsRequestsWithTimeouts = false;
        while (!this.quit) {
            ChannelException channelException;
            try {
                bl3 = true;
                if (this.selectorYield) {
                    Thread.yield();
                }
                this.wakeupPending = false;
                if (this.checkCancel && bl2) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"selectNow() forced");
                    }
                    this.selector.selectNow();
                    bl2 = false;
                } else if (this.nextTimeoutTime > this.currentTime) {
                    l = this.nextTimeoutTime - this.currentTime;
                    if (l < 1000L) {
                        l = 1000L;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("select() with timeout = " + l));
                    }
                    this.selector.select(l);
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"selectNow()");
                    }
                    this.selector.selectNow();
                    bl3 = false;
                }
                this.wakeupPending = false;
                if (this.checkCancel && bl) {
                    this.notifyCancelRequests();
                    bl = false;
                }
                this.currentTime = QuickApproxTime.getRef().getApproxTime();
                if (this.checkCancel && (bl = this.processCancelRequests())) {
                    bl2 = true;
                    continue;
                }
                if (this.selector.selectedKeys().isEmpty() && bl3 && this.ourWorkQueue.isEmpty()) {
                    if (n == 10) {
                        l2 = this.currentTime;
                        n3 = this.selector.keys().size();
                    }
                    ++n;
                } else {
                    n = 0;
                }
                if (n == 20) {
                    if (Thread.interrupted()) {
                        if (tc.isEventEnabled()) {
                            Tr.event((TraceComponent)tc, (String)"Selector thread was interrupted - not supported");
                        }
                        channelException = new ChannelException("TCP Channel selector thread interrupted: " + Thread.currentThread().getName());
                        FFDCFilter.processException((Throwable)channelException, (String)CLASS_NAME, (String)"241", (Object)this);
                    }
                    if (this.currentTime < l2 + 10000L && this.selector.keys().size() == n3) {
                        if (tc.isEventEnabled()) {
                            Tr.event((TraceComponent)tc, (String)"Selector fired 20 times in a row with no keys selected - possible loop in JDK detected");
                        }
                        if (this.currentTime > l3 + 300000L) {
                            channelException = new ChannelException("TCP Channel detected a poossible loop on thread: " + Thread.currentThread().getName());
                            FFDCFilter.processException((Throwable)channelException, (String)CLASS_NAME, (String)"186", (Object)this);
                            if (tc.isDebugEnabled()) {
                                Iterator<SelectionKey> iterator = this.selector.keys().iterator();
                                while (iterator.hasNext()) {
                                    SelectionKey selectionKey = iterator.next();
                                    iterator.remove();
                                    Tr.debug((TraceComponent)tc, (String)(" selKey = " + selectionKey + " interestOps = " + selectionKey.interestOps()));
                                }
                            }
                            l3 = this.currentTime;
                        }
                    }
                    n = 0;
                }
                if (this.performRequest()) continue;
                this.updateCount();
                this.checkForTimeouts();
                this.updateSelector();
                n2 = 0;
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)CLASS_NAME, (String)"288", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("IOException Caught in ChannelSelector.run " + iOException));
                }
                ++n2;
            }
            catch (CancelledKeyException cancelledKeyException) {
                FFDCFilter.processException((Throwable)cancelledKeyException, (String)CLASS_NAME, (String)"285", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("CancelledKeyException Caught in ChannelSelector.run " + cancelledKeyException));
                }
                ++n2;
            }
            if (n2 >= 100) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (n2 < 400) continue;
            channelException = new ChannelException("TCP Channel detected continuous IOExceptions and is terminating on thread: " + Thread.currentThread().getName());
            FFDCFilter.processException((Throwable)channelException, (String)CLASS_NAME, (String)"312", (Object)this);
            System.exit(9);
        }
        this.channelSelectorClose();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"run");
        }
    }

    abstract void updateCount();

    protected void shutDown() {
        this.quit = true;
        this.selector.wakeup();
    }

    abstract void channelSelectorClose();

    abstract boolean performRequest();

    abstract void updateSelector();

    abstract void checkForTimeouts();

    protected void dumpKeys() {
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)(" keys in selector are: " + this.selector.keys().size()));
        }
    }

    abstract void addWork(Object var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyCancelRequests() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"notifyCancelRequests");
        }
        CancelRequest cancelRequest = null;
        ArrayList arrayList = this.cancelList;
        synchronized (arrayList) {
            for (int i = 0; i < this.cancelList.size(); ++i) {
                cancelRequest = (CancelRequest)this.cancelList.get(i);
                if (cancelRequest.state != 2 || cancelRequest.waitObject == null) continue;
                Object object = cancelRequest.waitObject;
                synchronized (object) {
                    cancelRequest.state = 0;
                    cancelRequest.waitObject.notify();
                }
                this.cancelList.remove(i);
                --i;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"notifyCancelRequests");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processCancelRequests() {
        if (this.cancelList.size() == 0) {
            return false;
        }
        boolean bl = false;
        ArrayList arrayList = this.cancelList;
        synchronized (arrayList) {
            CancelRequest cancelRequest = null;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("processCancelRequests cancelling " + this.cancelList.size() + " keys"));
            }
            for (int i = 0; i < this.cancelList.size(); ++i) {
                cancelRequest = (CancelRequest)this.cancelList.get(i);
                if (cancelRequest.state != 1 || cancelRequest.key == null) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("cancelling key " + cancelRequest.key));
                }
                cancelRequest.key.cancel();
                cancelRequest.state = 2;
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addCancelRequest(CancelRequest cancelRequest) {
        ArrayList arrayList = this.cancelList;
        synchronized (arrayList) {
            this.cancelList.add(cancelRequest);
        }
        this.selector.wakeup();
    }

    protected void wakeup() {
        this.selector.wakeup();
    }

    protected void resetTimeout(long l) {
        if (l < this.nextTimeoutTime) {
            this.nextTimeoutTime = l;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"resetTimeout waking up selector");
            }
            this.selector.wakeup();
        }
    }

    protected String getFFDCDumpData() {
        StringBuffer stringBuffer = new StringBuffer("\n# of keys=" + this.selector.keys().size());
        stringBuffer.append("\n  quit: " + this.quit + "  waitingToQuit: " + this.waitingToQuit);
        try {
            Object[] objectArray = this.selector.keys().toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                SelectionKey selectionKey = (SelectionKey)objectArray[i];
                stringBuffer.append("\nkey: " + selectionKey.channel());
            }
        }
        catch (Exception exception) {
            stringBuffer.append("\nException Occurred Gathering Dump Data: " + exception);
        }
        return stringBuffer.toString();
    }
}

