/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tcp.channel.commands;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.InvalidParameterValueException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.CommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigDataId;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.models.config.serverindex.DistinguishedEndpointConstants;
import com.ibm.ws.channel.commands.CFCommand;
import com.ibm.ws.channel.commands.CFCommandUtils;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.management.ObjectName;

public class ListTCPEndPointsCommand
extends CFCommand {
    private static final TraceComponent tc;
    protected static final Set _distinguishedSet;

    public ListTCPEndPointsCommand(CommandMetadata commandMetadata) {
        super(commandMetadata);
    }

    public ListTCPEndPointsCommand(CommandData commandData) throws CommandNotFoundException {
        super(commandData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void validate() throws CommandValidationException {
        super.validate();
        ObjectName objectName = (ObjectName)this.getTargetObject();
        boolean bl = false;
        try {
            try {
                bl = this.checkType(objectName, new String[]{"TCPInboundChannel", "TransportChannelService"}, false);
            }
            catch (Exception exception) {
                bl = false;
                Object var5_4 = null;
                if (bl) return;
                throw new InvalidParameterValueException(this.getName(), "target", (Object)objectName);
            }
            Object var5_3 = null;
            if (bl) return;
            throw new InvalidParameterValueException(this.getName(), "target", (Object)objectName);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (bl) throw throwable;
            throw new InvalidParameterValueException(this.getName(), "target", (Object)objectName);
        }
    }

    public void execute() {
        CommandResultImpl commandResultImpl = new CommandResultImpl();
        try {
            this.validate();
            commandResultImpl.setResult((Object)this.getNamedEndPoints((ObjectName)this.getTargetObject()));
        }
        catch (Exception exception) {
            commandResultImpl.setException((Throwable)exception);
        }
        this.setCommandResult((CommandResult)commandResultImpl);
    }

    protected List getNamedEndPoints(ObjectName objectName) throws Exception {
        Boolean bl;
        Boolean bl2;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getNamedEndPoints", (Object)objectName);
        }
        if ((bl2 = (Boolean)this.getParameter("excludeDistinguished")) == null) {
            bl2 = Boolean.FALSE;
        }
        if ((bl = (Boolean)this.getParameter("unusedOnly")) == null) {
            bl = Boolean.FALSE;
        }
        Properties properties = ConfigServiceHelper.getObjectLocation((ObjectName)objectName);
        String string = properties.getProperty("server");
        String string2 = ConfigServiceHelper.getConfigDataId((ObjectName)objectName).getContextUri();
        StringBuffer stringBuffer = new StringBuffer(string2.substring(0, string2.lastIndexOf(47, string2.lastIndexOf(47) - 1)));
        ConfigDataId configDataId = ConfigServiceHelper.getConfigDataId((ObjectName)objectName);
        ConfigService configService = this.getConfigService();
        Session session = this.getConfigSession();
        ConfigDataId configDataId2 = new ConfigDataId(stringBuffer.toString(), "serverindex.xml");
        ObjectName objectName2 = ConfigServiceHelper.createObjectName((ConfigDataId)configDataId2);
        ObjectName objectName3 = ConfigServiceHelper.createObjectName(null, (String)"ServerEntry");
        ObjectName[] objectNameArray = configService.queryConfigObjects(session, objectName2, objectName3, null);
        for (int i = 0; i < objectNameArray.length; ++i) {
            Object object;
            Serializable serializable;
            Object object2;
            ObjectName objectName4 = objectNameArray[i];
            String string3 = configService.getAttribute(session, objectName4, "serverName").toString();
            if (!string3.equals(string)) continue;
            ArrayList arrayList = (ArrayList)configService.getAttribute(session, objectName4, "specialEndpoints", false);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("ALL EndPoints: " + arrayList));
            }
            if (bl2.booleanValue() && arrayList != null) {
                object2 = arrayList.iterator();
                while (object2.hasNext()) {
                    serializable = (ObjectName)object2.next();
                    object = (String)configService.getAttribute(session, serializable, "endPointName");
                    if (object == null || !_distinguishedSet.contains(object)) continue;
                    object2.remove();
                }
            }
            if (bl.booleanValue() && arrayList != null) {
                serializable = new HashMap();
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    object = (ObjectName)iterator.next();
                    object2 = (String)configService.getAttribute(session, (ObjectName)object, "endPointName");
                    serializable.put(object2, object);
                }
                stringBuffer.append("/servers/");
                stringBuffer.append(string);
                objectName2 = ConfigServiceHelper.createObjectName((ConfigDataId)new ConfigDataId(stringBuffer.toString(), "server.xml"));
                objectName3 = ConfigServiceHelper.createObjectName(null, (String)"TCPInboundChannel");
                boolean bl3 = this.checkType(objectName, "TCPInboundChannel", false);
                ObjectName[] objectNameArray2 = configService.queryConfigObjects(session, objectName2, objectName3, null);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("# of siblings/channels: " + objectNameArray2.length));
                }
                for (int j = 0; j < objectNameArray2.length; ++j) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("current channel is: " + ListTCPEndPointsCommand.convertON((ObjectName)objectNameArray2[j])));
                    }
                    ConfigDataId configDataId3 = ConfigServiceHelper.getConfigDataId((ObjectName)objectNameArray2[j]);
                    if (bl3 && configDataId3.equals((Object)configDataId)) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)"found channel equal to target, continuing...");
                        continue;
                    }
                    String string4 = (String)configService.getAttribute(session, objectNameArray2[j], "endPointName");
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("current channels's endPoint is: " + string4));
                    }
                    if (string4 == null || !serializable.containsKey(string4)) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("removing " + string4 + ": " + serializable.get(string4)));
                    }
                    serializable.remove(string4);
                }
                arrayList = new ArrayList(serializable.values());
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getNamedEndPoints", (Object)arrayList);
            }
            return arrayList;
        }
        return null;
    }

    static {
        HashSet<String> hashSet;
        block3: {
            tc = CFCommandUtils.register((Class)ListTCPEndPointsCommand.class);
            hashSet = new HashSet<String>();
            try {
                Field[] fieldArray = DistinguishedEndpointConstants.class.getDeclaredFields();
                for (int i = 0; fieldArray != null && i < fieldArray.length; ++i) {
                    String string = (String)fieldArray[i].get(null);
                    if (string == null || string.equals("DCS_UNICAST_ADDRESS")) continue;
                    hashSet.add(string);
                }
            }
            catch (Throwable throwable) {
                if (!tc.isDebugEnabled()) break block3;
                Tr.debug((TraceComponent)tc, (String)"caught throwable whilst generating distinguishedEndPoint set:", (Object)throwable);
            }
        }
        _distinguishedSet = Collections.unmodifiableSet(hashSet);
    }
}

