/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tcp.channel.commands;

import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.InvalidParameterValueException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.CommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigDataId;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.channel.commands.CFCommand;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.management.ObjectName;

public class GetTCPEndPointCommand
extends CFCommand {
    public GetTCPEndPointCommand(CommandMetadata commandMetadata) {
        super(commandMetadata);
    }

    public GetTCPEndPointCommand(CommandData commandData) throws CommandNotFoundException {
        super(commandData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void validate() throws CommandValidationException {
        super.validate();
        ObjectName objectName = (ObjectName)this.getTargetObject();
        boolean bl = false;
        try {
            try {
                bl = this.checkType(objectName, new String[]{"TCPInboundChannel", "Chain"}, false);
            }
            catch (Exception exception) {
                bl = false;
                Object var5_4 = null;
                if (bl) return;
                throw new InvalidParameterValueException(this.getName(), "target", (Object)objectName);
            }
            Object var5_3 = null;
            if (bl) return;
            throw new InvalidParameterValueException(this.getName(), "target", (Object)objectName);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (bl) throw throwable;
            throw new InvalidParameterValueException(this.getName(), "target", (Object)objectName);
        }
    }

    public void execute() {
        CommandResultImpl commandResultImpl = new CommandResultImpl();
        try {
            this.validate();
            commandResultImpl.setResult((Object)this.getNamedEndPoint((ObjectName)this.getTargetObject()));
        }
        catch (Exception exception) {
            commandResultImpl.setException((Throwable)exception);
        }
        this.setCommandResult((CommandResult)commandResultImpl);
    }

    protected ObjectName getNamedEndPoint(ObjectName objectName) throws Exception {
        ConfigService configService = this.getConfigService();
        Session session = this.getConfigSession();
        if (this.checkType(objectName, "Chain", false)) {
            List list = (List)configService.getAttribute(session, objectName, "transportChannels");
            if (list == null || list.isEmpty()) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("chain ");
                stringBuffer.append(GetTCPEndPointCommand.convertON((ObjectName)objectName));
                stringBuffer.append(" does not contain any channels; command execution aborted");
                throw new CommandException(stringBuffer.toString());
            }
            ObjectName objectName2 = (ObjectName)list.get(0);
            if (!this.checkType(objectName2, "TCPInboundChannel", false)) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("chain ");
                stringBuffer.append(GetTCPEndPointCommand.convertON((ObjectName)objectName));
                stringBuffer.append(" does not contain a TCPInboundChannel at position 0; command execution aborted");
                throw new CommandException(stringBuffer.toString());
            }
            return this.getNamedEndPoint(objectName2);
        }
        Properties properties = ConfigServiceHelper.getObjectLocation((ObjectName)objectName);
        String string = properties.getProperty("server");
        String string2 = ConfigServiceHelper.getConfigDataId((ObjectName)objectName).getContextUri();
        StringBuffer stringBuffer = new StringBuffer(string2.substring(0, string2.lastIndexOf(47, string2.lastIndexOf(47) - 1)));
        String string3 = (String)configService.getAttribute(session, objectName, "endPointName");
        ConfigDataId configDataId = new ConfigDataId(stringBuffer.toString(), "serverindex.xml");
        ObjectName objectName3 = ConfigServiceHelper.createObjectName((ConfigDataId)configDataId);
        ObjectName objectName4 = ConfigServiceHelper.createObjectName(null, (String)"ServerEntry");
        ObjectName[] objectNameArray = configService.queryConfigObjects(session, objectName3, objectName4, null);
        if (string3 == null || string3.trim().length() == 0) {
            StringBuffer stringBuffer2 = new StringBuffer();
            stringBuffer2.append("target ");
            stringBuffer2.append(GetTCPEndPointCommand.convertON((ObjectName)objectName));
            stringBuffer2.append(" does not have an endPointName; command execution aborted");
            throw new CommandException(stringBuffer2.toString());
        }
        for (int i = 0; i < objectNameArray.length; ++i) {
            Comparable<StringBuffer> comparable;
            if (!string.equals(configService.getAttribute(session, objectNameArray[i], "serverName"))) continue;
            List list = (List)configService.getAttribute(session, objectNameArray[i], "specialEndpoints", false);
            if (list == null || list.isEmpty()) {
                comparable = new StringBuffer();
                ((StringBuffer)comparable).append("server entry ");
                ((StringBuffer)comparable).append(GetTCPEndPointCommand.convertON((ObjectName)objectNameArray[i]));
                ((StringBuffer)comparable).append(" does not contain specialEndPoints; command execution aborted");
                throw new CommandException(((StringBuffer)comparable).toString());
            }
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                comparable = (ObjectName)iterator.next();
                if (!string3.equals(configService.getAttribute(session, comparable, "endPointName"))) continue;
                return comparable;
            }
        }
        return null;
    }
}

