/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.compression;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.compression.WsByteArray;
import com.ibm.ws.compression.WsByteArrayPool;
import java.util.ArrayList;
import java.util.List;

public class WsByteArrayPoolManagerImpl {
    private static final TraceComponent tc = Tr.register((Class)WsByteArrayPoolManagerImpl.class, (String)"Compression", (String)"com.ibm.ws.compression");
    private static WsByteArrayPoolManagerImpl instance;
    private List pools = new ArrayList();
    private List poolSizes = new ArrayList();
    private int intNumberOfPools = 0;

    private WsByteArrayPoolManagerImpl() {
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"Creating WsByteArrayPoolManagerImpl");
        }
        this.initialize();
    }

    private static synchronized void createSingleton() {
        if (null == instance) {
            instance = new WsByteArrayPoolManagerImpl();
        }
    }

    public static WsByteArrayPoolManagerImpl getInstance() {
        if (null == instance) {
            WsByteArrayPoolManagerImpl.createSingleton();
        }
        return instance;
    }

    private void initialize() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        arrayList.add(new Integer(1024));
        arrayList2.add(new Integer(1000));
        arrayList.add(new Integer(8192));
        arrayList2.add(new Integer(1000));
        this.initialize(arrayList, arrayList2);
    }

    private void initialize(List list, List list2) {
        if (list.size() != list2.size()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"ERROR: array sizes are not equal");
            }
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            Integer n = (Integer)list.get(i);
            int n2 = n;
            int n3 = (Integer)list2.get(i);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("create a pool with size,depth of: " + n2 + "," + n3));
            }
            WsByteArrayPool wsByteArrayPool = new WsByteArrayPool(n2, n3);
            this.pools.add(wsByteArrayPool);
            this.poolSizes.add(n);
            ++this.intNumberOfPools;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Number of Pools created: " + this.intNumberOfPools));
        }
    }

    public WsByteArray allocate(int n) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("size of desired alloc is: " + n));
        }
        for (int i = 0; i < this.intNumberOfPools; ++i) {
            int n2 = (Integer)this.poolSizes.get(i);
            if (n > n2) continue;
            WsByteArrayPool wsByteArrayPool = (WsByteArrayPool)this.pools.get(i);
            WsByteArray wsByteArray = wsByteArrayPool.getEntry();
            wsByteArray.setPool(wsByteArrayPool);
            if (null == wsByteArray.getByteArray()) {
                wsByteArray.setByteArray(new byte[n2]);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("ID of the entry is: " + wsByteArray.getID()));
            }
            return wsByteArray;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"entry bigger than our pools, allocate without pooling");
        }
        WsByteArray wsByteArray = new WsByteArray();
        wsByteArray.setByteArray(new byte[n]);
        return wsByteArray;
    }

    public void release(WsByteArrayPool wsByteArrayPool, WsByteArray wsByteArray) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Releasing: " + wsByteArray.getID()));
        }
        wsByteArrayPool.release(wsByteArray);
    }
}

