/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.buffermgmt.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.buffermgmt.impl.PooledWsByteBufferImpl;
import com.ibm.ws.buffermgmt.impl.WsBBConfigException;
import com.ibm.ws.buffermgmt.impl.WsByteBufferImpl;
import com.ibm.ws.buffermgmt.impl.WsByteBufferPool;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.buffermgmt.WsByteBufferPoolManager;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class WsByteBufferPoolManagerImpl
implements WsByteBufferPoolManager {
    private static final String CLASS_NAME = "com.ibm.ws.buffermgmt.impl.WsByteBufferPoolManagerImpl";
    private static int CONFIG_DEFAULT = -1;
    private static int MEMORY_LEAK_INTERVAL_MIN = 0;
    private static int MEMORY_LEAK_INTERVAL_MAX = 3600;
    private static int VALIDATE_OK = 0;
    private static int VALIDATE_ERROR = 1;
    private static WsByteBufferPoolManager instanceRef = null;
    private ArrayList pools = new ArrayList();
    private ArrayList poolsDirect = new ArrayList();
    private ArrayList poolSizes = new ArrayList();
    private int intNumberOfPools = 0;
    private static int[] defaultPoolSizes = new int[]{32, 1024, 8192, 16384, 24576, 32768, 49152, 65536};
    private static int[] defaultPoolDepths = new int[]{100, 100, 100, 20, 20, 20, 20, 20};
    public static final String MEM_LEAK_INTERVAL = "memoryLeakDetectionInterval";
    public static final String MEM_LEAK_FILE = "memoryLeakOutputFile";
    public static final String TRUSTED_USERS = "trustedUsers";
    public static final String POOL_SIZES = "poolSizes";
    public static final String POOL_DEPTHS = "poolDepths";
    private static final TraceComponent tc = Tr.register((Class)WsByteBufferPoolManagerImpl.class, (String)"WsByteBuffer", (String)"com.ibm.ws.buffermgmt.resources.wsbytebuffermessages");
    int trustedUsersConfig = -1;
    boolean trustedUsers = true;
    long lastTimeCheck = 0L;
    int leakDetectionInterval = -1;
    String leakDetectionOutput = null;
    Object leakDetectionSyncObject = new Object();

    public WsByteBufferPoolManagerImpl(Map map) throws WsBBConfigException {
        Set set = map.keySet();
        Iterator iterator = set.iterator();
        String string = null;
        String string2 = null;
        int n = VALIDATE_OK;
        int n2 = -1;
        String string3 = "";
        int[] nArray = null;
        int[] nArray2 = null;
        String string4 = "";
        String string5 = "";
        try {
            while (iterator.hasNext() && n == VALIDATE_OK) {
                string = (String)iterator.next();
                string2 = (String)map.get(string);
                if (string.equalsIgnoreCase(MEM_LEAK_INTERVAL)) {
                    n2 = new Integer(string2);
                    n = this.testMemoryLeakDetectionInterval(n2);
                    if (n != VALIDATE_OK) continue;
                    n2 *= 1000;
                    continue;
                }
                if (string.equalsIgnoreCase(MEM_LEAK_FILE)) {
                    string3 = string2;
                    if (string3 != null) continue;
                    n = VALIDATE_ERROR;
                    continue;
                }
                if (string.equalsIgnoreCase(TRUSTED_USERS)) {
                    this.trustedUsersConfig = new Integer(string2);
                    if (this.trustedUsersConfig == 0) {
                        this.trustedUsers = false;
                        continue;
                    }
                    this.trustedUsers = true;
                    continue;
                }
                if (string.equalsIgnoreCase(POOL_SIZES)) {
                    string4 = string2;
                    nArray = this.convertStringToInts(string4, ",");
                    if (nArray != null) continue;
                    n = VALIDATE_ERROR;
                    continue;
                }
                if (string.equalsIgnoreCase(POOL_DEPTHS)) {
                    string5 = string2;
                    nArray2 = this.convertStringToInts(string5, ",");
                    if (nArray2 != null) continue;
                    n = VALIDATE_ERROR;
                    continue;
                }
                Tr.warning((TraceComponent)tc, (String)"UNRECOGNIZED_CUSTOM_PROPERTY", (Object)new Object[]{string});
            }
        }
        catch (NumberFormatException numberFormatException) {
            Tr.error((TraceComponent)tc, (String)"CONFIG_VALUE_NUMBER_EXCEPTION", (Object)new Object[]{string, string2});
            WsBBConfigException wsBBConfigException = new WsBBConfigException("The WsByteBuffer Component caught a NumberFormatException processing property, name: " + string + " value: " + string2, numberFormatException);
            FFDCFilter.processException((Throwable)wsBBConfigException, (String)CLASS_NAME, (String)"102", (Object)this);
            throw wsBBConfigException;
        }
        if (n != VALIDATE_OK) {
            Tr.error((TraceComponent)tc, (String)"NOT_VALID_CUSTOM_PROPERTY", (Object)new Object[]{string, string2});
            WsBBConfigException wsBBConfigException = new WsBBConfigException("The custom property has a value that is not valid, name: " + string + " value: " + string2);
            FFDCFilter.processException((Throwable)wsBBConfigException, (String)CLASS_NAME, (String)"103", (Object)this);
            throw wsBBConfigException;
        }
        if (n2 != -1) {
            if (string3 != null) {
                try {
                    this.setLeakDetectionSettings(n2, string3);
                }
                catch (IOException iOException) {
                    Tr.error((TraceComponent)tc, (String)"NOT_VALID_CUSTOM_PROPERTY", (Object)new Object[]{MEM_LEAK_FILE, string3});
                    WsBBConfigException wsBBConfigException = new WsBBConfigException("The custom property has a value that is not valid, name: " + string + " value: " + string2);
                    FFDCFilter.processException((Throwable)wsBBConfigException, (String)CLASS_NAME, (String)"104", (Object)this);
                    throw wsBBConfigException;
                }
            } else {
                Tr.error((TraceComponent)tc, (String)"NOT_VALID_CUSTOM_PROPERTY", (Object)new Object[]{MEM_LEAK_FILE, "null"});
                WsBBConfigException wsBBConfigException = new WsBBConfigException("The custom property has a value that is not valid, name: " + string + " value: " + string2);
                FFDCFilter.processException((Throwable)wsBBConfigException, (String)CLASS_NAME, (String)"104", (Object)this);
                throw wsBBConfigException;
            }
        }
        if (nArray == null || nArray2 == null) {
            this.initialize(defaultPoolSizes, defaultPoolDepths);
        } else {
            if (nArray.length != nArray2.length) {
                Tr.error((TraceComponent)tc, (String)"POOL_MISMATCH", (Object)new Object[]{string4, string5});
                WsBBConfigException wsBBConfigException = new WsBBConfigException("The WsByteBuffer Pool Sizes and Pool Depths specification do not have the same number of entries,  Sizes: " + string4 + "Depths: " + string5);
                FFDCFilter.processException((Throwable)wsBBConfigException, (String)CLASS_NAME, (String)"104", (Object)this);
                throw wsBBConfigException;
            }
            this.initialize(nArray, nArray2);
        }
        instanceRef = this;
    }

    public WsByteBufferPoolManagerImpl() throws WsBBConfigException {
        this(new HashMap());
    }

    private static synchronized void createSingleton() {
        if (null == instanceRef) {
            try {
                instanceRef = new WsByteBufferPoolManagerImpl();
            }
            catch (WsBBConfigException wsBBConfigException) {
                // empty catch block
            }
        }
    }

    public static WsByteBufferPoolManager getRef() {
        if (instanceRef == null) {
            WsByteBufferPoolManagerImpl.createSingleton();
        }
        return instanceRef;
    }

    public void initialize(int[] nArray, int[] nArray2) {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initialize");
        }
        if (nArray.length != nArray2.length) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"ERROR: array sizes are not equal");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"initialize");
            }
            return;
        }
        int n2 = nArray.length;
        int[] nArray3 = new int[n2];
        int[] nArray4 = new int[n2];
        for (n = 0; n < n2; ++n) {
            int n3;
            int n4 = nArray[n];
            int n5 = nArray2[n];
            for (n3 = n - 1; n3 >= 0; --n3) {
                int n6 = nArray3[n3];
                if (n4 > n6) {
                    nArray3[n3 + 1] = n4;
                    nArray4[n3 + 1] = n5;
                    break;
                }
                nArray3[n3 + 1] = n6;
                nArray4[n3 + 1] = nArray4[n3];
            }
            if (n3 >= 0) continue;
            nArray3[0] = n4;
            nArray4[0] = n5;
        }
        for (n = 0; n < n2; ++n) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("create a Direct and a Non-Direct WsByteBuffer pool with size,depth of: " + nArray3[n] + "," + nArray4[n]));
            }
            boolean bl = this.leakDetectionInterval != -1;
            WsByteBufferPool wsByteBufferPool = new WsByteBufferPool(nArray3[n], nArray4[n], nArray4[n], bl);
            WsByteBufferPool wsByteBufferPool2 = new WsByteBufferPool(nArray3[n], nArray4[n], nArray4[n], bl);
            this.pools.add(wsByteBufferPool);
            this.poolsDirect.add(wsByteBufferPool2);
            this.poolSizes.add(new Integer(nArray3[n]));
            ++this.intNumberOfPools;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Number of Direct and Non-Direct WsByteBuffer Pools created: " + this.intNumberOfPools));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initialize");
        }
    }

    public void setLeakDetectionSettings(int n, String string) throws IOException {
        this.leakDetectionInterval = n;
        this.leakDetectionOutput = string;
        if (this.leakDetectionInterval > -1 && this.leakDetectionOutput != null) {
            FileWriter fileWriter = new FileWriter(this.leakDetectionOutput, false);
            fileWriter.close();
        }
    }

    private int testMemoryLeakDetectionInterval(int n) {
        if (n == CONFIG_DEFAULT) {
            return VALIDATE_OK;
        }
        if (n < MEMORY_LEAK_INTERVAL_MIN || n > MEMORY_LEAK_INTERVAL_MAX) {
            return VALIDATE_ERROR;
        }
        return VALIDATE_OK;
    }

    private int[] convertStringToInts(String string, String string2) {
        String string3;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 1;
        int n5 = string.length();
        while ((n = string.indexOf(string2, n)) != -1) {
            ++n4;
            if (++n != n5) continue;
            return null;
        }
        int[] nArray = new int[n4];
        n = 0;
        while (true) {
            if ((n2 = string.indexOf(string2, n + 1)) == -1) break;
            string3 = string.substring(n, n2);
            try {
                nArray[n3] = Integer.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
            ++n3;
            n = n2 + 1;
        }
        string3 = string.substring(n);
        nArray[n3] = Integer.parseInt(string3);
        return nArray;
    }

    public int getLeakDetectionInterval() {
        return this.leakDetectionInterval;
    }

    public Object getLeakDetectionSyncObject() {
        return this.leakDetectionSyncObject;
    }

    public WsByteBuffer allocate(int n) {
        return this.allocateCommon(n, false);
    }

    public WsByteBuffer allocateDirect(int n) {
        return this.allocateCommon(n, true);
    }

    public WsByteBuffer allocateCommon(int n, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"allocate");
        }
        if (this.leakDetectionInterval > -1) {
            this.lookForLeaks(false);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Desired allocation size: " + n));
        }
        for (int i = 0; i < this.intNumberOfPools; ++i) {
            ByteBuffer byteBuffer;
            int n2 = (Integer)this.poolSizes.get(i);
            if (n > n2) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("found a pool of size: " + n2));
            }
            WsByteBufferPool wsByteBufferPool = null;
            wsByteBufferPool = bl ? (WsByteBufferPool)this.poolsDirect.get(i) : (WsByteBufferPool)this.pools.get(i);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"get (or allocate) an entry from the pool");
            }
            PooledWsByteBufferImpl pooledWsByteBufferImpl = wsByteBufferPool.getEntry();
            pooledWsByteBufferImpl.resetReleaseCalled();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"check if there is a ByteBuffer in this entry");
            }
            if ((byteBuffer = pooledWsByteBufferImpl.getWrappedByteBuffer()) == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"no ByteBuffer so alloc a new one");
                }
                if (bl) {
                    byteBuffer = ByteBuffer.allocateDirect(n2);
                    pooledWsByteBufferImpl.setIsDirectPool(true);
                } else {
                    byteBuffer = ByteBuffer.allocate(n2);
                    pooledWsByteBufferImpl.setIsDirectPool(false);
                }
                pooledWsByteBufferImpl.setByteBuffer(byteBuffer);
                pooledWsByteBufferImpl.pool = wsByteBufferPool;
                pooledWsByteBufferImpl.setPoolManagerRef(this);
            } else {
                byteBuffer.clear();
                byteBuffer.order(ByteOrder.BIG_ENDIAN);
                pooledWsByteBufferImpl.intReferenceCount = 1;
            }
            pooledWsByteBufferImpl.limit(n);
            if (tc.isDebugEnabled() || this.leakDetectionInterval > -1) {
                Throwable throwable = new Throwable();
                StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
                if (tc.isDebugEnabled()) {
                    if (stackTraceElementArray.length >= 3) {
                        Tr.debug((TraceComponent)tc, (String)("BUFFER OBTAINED: Allocate: Calling Element: " + stackTraceElementArray[2] + " Main ID: " + pooledWsByteBufferImpl.getID()));
                    }
                    Tr.debug((TraceComponent)tc, (String)("size of desired alloc is: " + n));
                    Tr.debug((TraceComponent)tc, (String)("Buffer allocated: " + pooledWsByteBufferImpl));
                }
                if (this.leakDetectionInterval > -1) {
                    String string = this.fillOutStackTrace(" (Allocate) ", stackTraceElementArray);
                    pooledWsByteBufferImpl.setOwnerID(string);
                    pooledWsByteBufferImpl.addWsByteBuffer(pooledWsByteBufferImpl);
                    pooledWsByteBufferImpl.addOwner(pooledWsByteBufferImpl.getOwnerID());
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"allocate");
            }
            return pooledWsByteBufferImpl;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"entry bigger than our pools, allocate without pooling");
        }
        WsByteBufferImpl wsByteBufferImpl = new WsByteBufferImpl();
        wsByteBufferImpl.setPoolManagerRef(this);
        if (bl) {
            wsByteBufferImpl.setByteBuffer(ByteBuffer.allocateDirect(n));
        } else {
            wsByteBufferImpl.setByteBuffer(ByteBuffer.allocate(n));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"allocate");
        }
        return wsByteBufferImpl;
    }

    public WsByteBuffer wrap(byte[] byArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"wrap");
        }
        WsByteBufferImpl wsByteBufferImpl = new WsByteBufferImpl();
        wsByteBufferImpl.setByteBuffer(ByteBuffer.wrap(byArray));
        wsByteBufferImpl.setPoolManagerRef(this);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"wrap");
        }
        return wsByteBufferImpl;
    }

    public WsByteBuffer wrap(byte[] byArray, int n, int n2) throws IndexOutOfBoundsException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("wrap(byte[], int, int): offset= " + n + ", length= " + n2));
        }
        WsByteBufferImpl wsByteBufferImpl = new WsByteBufferImpl();
        wsByteBufferImpl.setByteBuffer(ByteBuffer.wrap(byArray, n, n2));
        wsByteBufferImpl.setPoolManagerRef(this);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"wrap(byte[], int, int)");
        }
        return wsByteBufferImpl;
    }

    public void release(PooledWsByteBufferImpl pooledWsByteBufferImpl, boolean bl, WsByteBufferPool wsByteBufferPool) {
        Object object = pooledWsByteBufferImpl.getID();
        WsByteBufferPool wsByteBufferPool2 = wsByteBufferPool;
        wsByteBufferPool2.release(pooledWsByteBufferImpl, object);
    }

    public WsByteBuffer duplicate(WsByteBuffer wsByteBuffer) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"duplicate");
        }
        if (this.leakDetectionInterval > -1) {
            this.lookForLeaks(false);
        }
        WsByteBufferImpl wsByteBufferImpl = null;
        WsByteBufferImpl wsByteBufferImpl2 = (WsByteBufferImpl)wsByteBuffer;
        wsByteBufferImpl = new WsByteBufferImpl();
        wsByteBufferImpl.setPoolManagerRef(this);
        if (wsByteBufferImpl2.getWsBBRoot() != null) {
            wsByteBufferImpl.setWsBBRoot(wsByteBufferImpl2.getWsBBRoot());
            ++wsByteBufferImpl2.getWsBBRoot().intReferenceCount;
        }
        wsByteBufferImpl2.updateDuplicate(wsByteBufferImpl);
        if (tc.isDebugEnabled() || this.leakDetectionInterval > -1) {
            Throwable throwable = new Throwable();
            StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
            if (tc.isDebugEnabled() && stackTraceElementArray.length >= 3) {
                if (wsByteBufferImpl2.getWsBBRoot() == null) {
                    Tr.debug((TraceComponent)tc, (String)("BUFFER OBTAINED: Duplicate: Calling Element: " + stackTraceElementArray[2] + " Main ID: none"));
                } else {
                    Tr.debug((TraceComponent)tc, (String)("BUFFER OBTAINED: Duplicate: Calling Element: " + stackTraceElementArray[2] + " Main ID: " + wsByteBufferImpl2.getWsBBRoot().getID()));
                }
            }
            if (this.leakDetectionInterval > -1) {
                String string = this.fillOutStackTrace(" (Duplicate) ", stackTraceElementArray);
                wsByteBufferImpl.setOwnerID(string);
            }
            if (wsByteBufferImpl.getWsBBRoot() != null && this.leakDetectionInterval > -1) {
                wsByteBufferImpl.getWsBBRoot().addWsByteBuffer(wsByteBufferImpl);
                wsByteBufferImpl.getWsBBRoot().owners.put(wsByteBufferImpl.getOwnerID(), wsByteBufferImpl.getOwnerID());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"duplicate");
        }
        return wsByteBufferImpl;
    }

    public WsByteBuffer slice(WsByteBuffer wsByteBuffer) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"slice");
        }
        if (this.leakDetectionInterval > -1) {
            this.lookForLeaks(false);
        }
        WsByteBufferImpl wsByteBufferImpl = null;
        WsByteBufferImpl wsByteBufferImpl2 = (WsByteBufferImpl)wsByteBuffer;
        wsByteBufferImpl = new WsByteBufferImpl();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"update buffer with pool mgr info");
        }
        wsByteBufferImpl.setPoolManagerRef(this);
        if (wsByteBufferImpl2.getWsBBRoot() != null) {
            wsByteBufferImpl.setWsBBRoot(wsByteBufferImpl2.getWsBBRoot());
            ++wsByteBufferImpl2.getWsBBRoot().intReferenceCount;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"update buffer with buffer specific data");
        }
        wsByteBufferImpl2.updateSlice(wsByteBufferImpl);
        if (tc.isDebugEnabled() || this.leakDetectionInterval > -1) {
            Throwable throwable = new Throwable();
            StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
            if (tc.isDebugEnabled() && stackTraceElementArray.length >= 3) {
                if (wsByteBufferImpl2.getWsBBRoot() == null) {
                    Tr.debug((TraceComponent)tc, (String)("BUFFER OBTAINED: Slice: Calling Element: " + stackTraceElementArray[2] + " Main ID: none"));
                } else {
                    Tr.debug((TraceComponent)tc, (String)("BUFFER OBTAINED: Slice: Calling Element: " + stackTraceElementArray[2] + " Main ID: " + wsByteBufferImpl2.getWsBBRoot().getID()));
                }
            }
            if (this.leakDetectionInterval > -1) {
                String string = this.fillOutStackTrace(" (Slice) ", stackTraceElementArray);
                wsByteBufferImpl.setOwnerID(string);
            }
            if (wsByteBufferImpl.getWsBBRoot() != null && this.leakDetectionInterval > -1) {
                wsByteBufferImpl.getWsBBRoot().addWsByteBuffer(wsByteBufferImpl);
                wsByteBufferImpl.getWsBBRoot().owners.put(wsByteBufferImpl.getOwnerID(), wsByteBufferImpl.getOwnerID());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"slice");
        }
        return wsByteBufferImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lookForLeaks(boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"lookForLeaks");
        }
        if (this.leakDetectionInterval < -1) {
            return;
        }
        Object object = this.leakDetectionSyncObject;
        synchronized (object) {
            try {
                FileWriter fileWriter;
                String string;
                Iterator iterator;
                Hashtable hashtable;
                PooledWsByteBufferImpl pooledWsByteBufferImpl;
                int n;
                Object[] objectArray;
                WsByteBufferImpl wsByteBufferImpl;
                WsByteBufferPool wsByteBufferPool;
                int n2;
                long l = System.currentTimeMillis();
                if (!bl) {
                    if (this.lastTimeCheck == 0L) {
                        this.lastTimeCheck = l;
                        return;
                    }
                    if (l - this.lastTimeCheck < (long)this.leakDetectionInterval) {
                        return;
                    }
                }
                this.lastTimeCheck = l;
                int n3 = 1;
                for (n2 = 0; n2 < this.intNumberOfPools; ++n2) {
                    wsByteBufferPool = (WsByteBufferPool)this.pools.get(n2);
                    wsByteBufferImpl = null;
                    objectArray = wsByteBufferPool.getInUse();
                    if (objectArray == null) continue;
                    for (n = 0; n < objectArray.length; ++n) {
                        pooledWsByteBufferImpl = (PooledWsByteBufferImpl)objectArray[n];
                        if (pooledWsByteBufferImpl.getallBuffers() == null) continue;
                        hashtable = (Hashtable)pooledWsByteBufferImpl.getallBuffers().clone();
                        iterator = hashtable.values().iterator();
                        while (iterator.hasNext()) {
                            wsByteBufferImpl = (WsByteBufferImpl)iterator.next();
                            if (l - wsByteBufferImpl.getLastAccessTime() <= (long)this.leakDetectionInterval) continue;
                            string = n3 + " Possible Leak Entry: Buffer ID - " + pooledWsByteBufferImpl.getID() + "\nNon-Direct Buffer Pool" + "\n" + pooledWsByteBufferImpl.toString(wsByteBufferImpl.getOwnerID());
                            try {
                                fileWriter = new FileWriter(this.leakDetectionOutput, true);
                                if (n3 == 1) {
                                    fileWriter.write("\n\n\n****  " + new Date() + "  ***\n");
                                } else {
                                    fileWriter.write("\n----------\n");
                                }
                                fileWriter.write(string);
                                fileWriter.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            ++n3;
                        }
                    }
                }
                for (n2 = 0; n2 < this.intNumberOfPools; ++n2) {
                    wsByteBufferPool = (WsByteBufferPool)this.poolsDirect.get(n2);
                    wsByteBufferImpl = null;
                    objectArray = wsByteBufferPool.getInUse();
                    if (objectArray == null) continue;
                    for (n = 0; n < objectArray.length; ++n) {
                        pooledWsByteBufferImpl = (PooledWsByteBufferImpl)objectArray[n];
                        if (pooledWsByteBufferImpl.getallBuffers() == null) continue;
                        hashtable = (Hashtable)pooledWsByteBufferImpl.getallBuffers().clone();
                        iterator = hashtable.values().iterator();
                        while (iterator.hasNext()) {
                            wsByteBufferImpl = (WsByteBufferImpl)iterator.next();
                            if (l - wsByteBufferImpl.getLastAccessTime() <= (long)this.leakDetectionInterval) continue;
                            string = n3 + " Possible Leak Entry: Buffer ID - " + pooledWsByteBufferImpl.getID() + "\nDirect Buffer Pool" + "\n" + pooledWsByteBufferImpl.toString(wsByteBufferImpl.getOwnerID());
                            try {
                                fileWriter = new FileWriter(this.leakDetectionOutput, true);
                                if (n3 == 1) {
                                    fileWriter.write("\n\n\n****  " + new Date() + "  ***\n");
                                } else {
                                    fileWriter.write("\n----------\n");
                                }
                                fileWriter.write(string);
                                fileWriter.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            ++n3;
                        }
                    }
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"lookForLeaks");
                }
            }
            catch (NullPointerException nullPointerException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"WsByteBuffer Leak Detection Caught an NPE looking through the inUse tables");
                }
                RuntimeException runtimeException = new RuntimeException("WsByteBuffer Leak Detection Caught an NPE looking through the inUse table", nullPointerException);
                FFDCFilter.processException((Throwable)runtimeException, (String)CLASS_NAME, (String)"932", (Object)this);
                throw runtimeException;
            }
        }
    }

    private String fillOutStackTrace(String string, StackTraceElement[] stackTraceElementArray) {
        String string2 = string;
        if (stackTraceElementArray.length >= 3) {
            for (int i = 2; i < stackTraceElementArray.length && i < 12; ++i) {
                string2 = string2.concat("\n" + stackTraceElementArray[i].toString());
            }
            return string2;
        }
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            string2 = string2.concat("\n" + stackTraceElementArray[i].toString());
        }
        return string2;
    }

    protected boolean isTrustedUsers() {
        return this.trustedUsers;
    }
}

