/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.buffermgmt.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.buffermgmt.impl.FastSyncHashBucket;
import com.ibm.ws.buffermgmt.impl.FastSyncHashEntry;
import java.util.ArrayList;

public class FastSynchHashTable {
    protected int xVar = 1000;
    static final int yVar = 3;
    protected FastSyncHashBucket[][] mainTable;
    private static final TraceComponent tc = Tr.register((Class)FastSynchHashTable.class, (String)"WsByteBuffer", (String)"com.ibm.ws.buffermgmt.resources.wsbytebuffermessages");

    public FastSynchHashTable(int n) {
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Created FastSyncHashTable(int): " + n));
        }
        this.xVar = n / 3 + 1;
        this.initBuckets();
    }

    public FastSynchHashTable() {
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"Created FastSyncHashTable()");
        }
        this.initBuckets();
    }

    private void initBuckets() {
        this.mainTable = new FastSyncHashBucket[this.xVar][3];
        for (int i = 0; i < this.xVar; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.mainTable[i][j] = new FastSyncHashBucket();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initBuckets()");
        }
    }

    public Object get(int n) {
        return this.syncGetValueFromBucket(this.getBucket(n), n, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object syncGetValueFromBucket(FastSyncHashBucket fastSyncHashBucket, int n, boolean bl) {
        FastSyncHashEntry fastSyncHashEntry = null;
        FastSyncHashEntry fastSyncHashEntry2 = null;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("syncGetValueFromBucket: key, remove " + n + " " + bl));
        }
        FastSyncHashBucket fastSyncHashBucket2 = fastSyncHashBucket;
        synchronized (fastSyncHashBucket2) {
            fastSyncHashEntry = fastSyncHashBucket.root;
            while (fastSyncHashEntry != null) {
                if (fastSyncHashEntry.key == n) {
                    if (bl) {
                        if (fastSyncHashEntry2 == null) {
                            fastSyncHashBucket.root = fastSyncHashEntry.next;
                        } else {
                            fastSyncHashEntry2.next = fastSyncHashEntry.next;
                        }
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"syncGetValueFromBucket: found value in bucket");
                    }
                    return fastSyncHashEntry.value;
                }
                fastSyncHashEntry2 = fastSyncHashEntry;
                fastSyncHashEntry = fastSyncHashEntry.next;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"syncGetValueFromBucket-returned null");
        }
        return null;
    }

    public Object put(int n, Object object) {
        FastSyncHashBucket fastSyncHashBucket;
        Object object2;
        if (tc.isEventEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"put");
        }
        if (object == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"value == null");
            }
            throw new NullPointerException();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("key " + n));
        }
        if ((object2 = this.syncGetValueFromBucket(fastSyncHashBucket = this.getBucket(n), n, false)) != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"put: key is already defined in bucket...returning value from bucket and new key value will be discarded.");
            }
            return object2;
        }
        FastSyncHashEntry fastSyncHashEntry = new FastSyncHashEntry(n, object);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"put: put new key and value into bucket");
        }
        return this.syncPutIntoBucket(fastSyncHashBucket, fastSyncHashEntry);
    }

    public Object forcePut(int n, Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"forcePut(int,Object):");
        }
        if (object == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"value is null");
            }
            throw new NullPointerException();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("key: " + n));
        }
        FastSyncHashBucket fastSyncHashBucket = this.getBucket(n);
        this.syncGetValueFromBucket(fastSyncHashBucket, n, true);
        FastSyncHashEntry fastSyncHashEntry = new FastSyncHashEntry(n, object);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"forcePut:  put new hash and key in bucket");
        }
        return this.syncPutIntoBucket(fastSyncHashBucket, fastSyncHashEntry);
    }

    private FastSyncHashBucket getBucket(int n) {
        return this.mainTable[(n & Integer.MAX_VALUE) % this.xVar][(n & Integer.MAX_VALUE) % 3];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object syncPutIntoBucket(FastSyncHashBucket fastSyncHashBucket, FastSyncHashEntry fastSyncHashEntry) {
        FastSyncHashEntry fastSyncHashEntry2 = null;
        FastSyncHashEntry fastSyncHashEntry3 = null;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"syncPutIntoBucket");
        }
        FastSyncHashBucket fastSyncHashBucket2 = fastSyncHashBucket;
        synchronized (fastSyncHashBucket2) {
            fastSyncHashEntry2 = fastSyncHashBucket.root;
            while (fastSyncHashEntry2 != null) {
                if (fastSyncHashEntry2.key == fastSyncHashEntry.key) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"syncPutIntoBucket: key/hash pair is already in the bucket");
                    }
                    return fastSyncHashEntry2.value;
                }
                fastSyncHashEntry3 = fastSyncHashEntry2;
                fastSyncHashEntry2 = fastSyncHashEntry2.next;
            }
            if (fastSyncHashEntry3 == null) {
                if (fastSyncHashBucket.root == null) {
                    fastSyncHashBucket.root = fastSyncHashEntry;
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"syncPutIntoBucket: Adding new entry at the beginning (root)");
                    }
                    return fastSyncHashEntry.value;
                }
                fastSyncHashEntry3 = fastSyncHashBucket.root;
                while (fastSyncHashEntry3.next != null) {
                    fastSyncHashEntry3 = fastSyncHashEntry3.next;
                }
            }
            fastSyncHashEntry3.next = fastSyncHashEntry;
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"syncPutIntoBucket: Adding new entry at the end");
            }
            return fastSyncHashEntry.value;
        }
    }

    public Object remove(int n) {
        return this.syncGetValueFromBucket(this.getBucket(n), n, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getAllEntryValues() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        FastSyncHashBucket fastSyncHashBucket = null;
        FastSyncHashEntry fastSyncHashEntry = null;
        for (int i = 0; i < this.xVar; ++i) {
            for (int j = 0; j < 3; ++j) {
                FastSyncHashBucket fastSyncHashBucket2 = fastSyncHashBucket = this.mainTable[i][j];
                synchronized (fastSyncHashBucket2) {
                    fastSyncHashEntry = fastSyncHashBucket.root;
                    while (fastSyncHashEntry != null) {
                        arrayList.add(fastSyncHashEntry.value);
                        fastSyncHashEntry = fastSyncHashEntry.next;
                    }
                    continue;
                }
            }
        }
        return arrayList.toArray();
    }
}

