/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.zwlmclassifier;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sib.admin.DestinationDefinition;
import com.ibm.ws.sib.admin.JsMessagingEngine;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.ws.sib.zwlmclassifier.RuleType;
import com.ibm.ws.sib.zwlmclassifier.WlmClassifier;
import com.ibm.ws.sib.zwlmclassifier.WlmClassifierHandler;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.wsspi.sib.core.SIBusMessage;
import com.ibm.wsspi.sib.exitpoint.ra.RAExitPoint;
import com.ibm.wsspi.sib.exitpoint.ra.RAType;
import java.util.Map;
import javax.resource.spi.ActivationSpec;

public class WlmClassifierHandlerImpl
implements WlmClassifierHandler {
    private static final TraceComponent TC = SibTr.register((Class)WlmClassifierHandlerImpl.class, (String)"SIBWlmClassifier", (String)"com.ibm.ws.sib.zwlmclassifier.CWSJWMessages");
    static boolean IS_ZOS;

    public boolean handle(RAType rAType, RAExitPoint rAExitPoint, ActivationSpec activationSpec, String string, String string2, String string3, SIBusMessage sIBusMessage, Map map) {
        if (TC.isEntryEnabled()) {
            SibTr.entry((TraceComponent)TC, (String)"handle", (Object)new Object[]{"type=" + rAType, "exitPoint=" + rAExitPoint, "busName=" + string, "meName=" + string2, "destinationName=" + string3, "isZOS=" + Boolean.toString(IS_ZOS)});
        }
        if (IS_ZOS && rAExitPoint == RAExitPoint.PRE_DISPATCH) {
            if (rAType == RAType.JMS) {
                this.classify(RuleType.JMS_RA, string, string3, sIBusMessage, map);
            } else if (rAType == RAType.CORE) {
                this.classify(RuleType.CORE_SPI_RA, string, string3, sIBusMessage, map);
            }
        }
        if (TC.isEntryEnabled()) {
            SibTr.exit((TraceComponent)TC, (String)"handle");
        }
        return true;
    }

    public void failure(RAType rAType, RAExitPoint rAExitPoint, ActivationSpec activationSpec, String string, String string2, String string3, SIBusMessage sIBusMessage, Map map) {
    }

    public void preDispatch(SIBusMessage sIBusMessage, DestinationDefinition destinationDefinition, JsMessagingEngine jsMessagingEngine, Map map) {
        if (TC.isEntryEnabled()) {
            SibTr.entry((TraceComponent)TC, (String)"preDispatch", (Object)new Object[]{"busName=" + jsMessagingEngine.getBusName(), "destinationName=" + destinationDefinition.getName(), "isZOS=" + Boolean.toString(IS_ZOS)});
        }
        if (IS_ZOS) {
            this.classify(RuleType.DESTINATION_MEDIATION, jsMessagingEngine.getBusName(), destinationDefinition.getName(), sIBusMessage, map);
        }
        if (TC.isEntryEnabled()) {
            SibTr.exit((TraceComponent)TC, (String)"preDispatch");
        }
    }

    public boolean start(SIBusMessage sIBusMessage, DestinationDefinition destinationDefinition, JsMessagingEngine jsMessagingEngine, Map map) {
        return true;
    }

    public void complete(Map map) {
    }

    public void fail(Map map) {
    }

    private void classify(RuleType ruleType, String string, String string2, SIBusMessage sIBusMessage, Map map) {
        if (TC.isEntryEnabled()) {
            SibTr.entry((TraceComponent)TC, (String)"classify", (Object)new Object[]{"ruleType=" + ruleType, "busName=" + string, "destinationName=" + string2});
        }
        String string3 = WlmClassifier.getInstance().classify(ruleType, sIBusMessage, string, string2);
        if (TC.isDebugEnabled()) {
            SibTr.debug((TraceComponent)TC, (String)"classify", (Object)("Adding this to context map: WLM_TRANSACTION_CLASS=" + string3));
        }
        map.put("WLM_TRANSACTION_CLASS", string3);
        if (TC.isEntryEnabled()) {
            SibTr.exit((TraceComponent)TC, (String)"classify", (Object)("transactionClass=" + string3));
        }
    }

    static {
        if (TC.isDebugEnabled()) {
            SibTr.debug((TraceComponent)TC, (String)"Source info: @(#)SIB/ws/code/sib.zwlmclassifier.impl/src/com/ibm/ws/sib/zwlmclassifier/WlmClassifierHandlerImpl.java, SIB.zwlmclassifier, WAS602.SIB, o0610.11 1.7");
        }
        IS_ZOS = PlatformHelperFactory.getPlatformHelper().isZOS();
    }
}

