/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.zwlmclassifier;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sib.matchspace.Selector;
import com.ibm.ws.sib.utils.ras.SibTr;

public class Rule {
    private static final TraceComponent TC = SibTr.register((Class)Rule.class, (String)"SIBWlmClassifier", (String)"com.ibm.ws.sib.zwlmclassifier.CWSJWMessages");
    private String transactionClass;
    private String selector;
    private String busName;
    private String destinationName;
    private String discriminator;
    private String description;
    private Selector selectorObject = null;
    private Selector discriminatorObject = null;

    public Rule(String string, String string2, String string3, String string4, String string5, String string6) {
        if (TC.isEntryEnabled()) {
            SibTr.entry((TraceComponent)TC, (String)"constructor", (Object)new Object[]{"transaction_class=" + string, "selector=" + string2, "busName=" + string3, "destinationName=" + string4, "discriminator=" + string5, "description=" + string6});
        }
        this.setTransactionClass(string);
        this.setSelectorAsString(string2);
        this.setBusName(string3);
        this.setDestinationName(string4);
        this.setDiscriminatorAsString(string5);
        this.setDescription(string6);
        if (TC.isEntryEnabled()) {
            SibTr.exit((TraceComponent)TC, (String)"constructor");
        }
    }

    public String getTransactionClass() {
        return this.transactionClass;
    }

    private void setTransactionClass(String string) {
        this.transactionClass = Rule.nullOrBlank(string) ? "SIBUS" : string;
    }

    public String getSelectorAsString() {
        return this.selector;
    }

    private void setSelectorAsString(String string) {
        this.selector = Rule.normalise(string);
    }

    public String getBusName() {
        return this.busName;
    }

    private void setBusName(String string) {
        this.busName = Rule.normalise(string);
    }

    public String getDestinationName() {
        return this.destinationName;
    }

    private void setDestinationName(String string) {
        this.destinationName = Rule.normalise(string);
    }

    public String getDiscriminatorAsString() {
        return this.discriminator;
    }

    private void setDiscriminatorAsString(String string) {
        this.discriminator = Rule.normalise(string);
    }

    public String getDescription() {
        return this.description;
    }

    private void setDescription(String string) {
        this.description = Rule.normalise(string);
    }

    public Selector getSelectorAsObject() {
        return this.selectorObject;
    }

    public void setSelectorAsObject(Selector selector) {
        this.selectorObject = selector;
    }

    public Selector getDiscriminatorAsObject() {
        return this.discriminatorObject;
    }

    public void setDiscriminatorAsObject(Selector selector) {
        this.discriminatorObject = selector;
    }

    public boolean matchesBusAndDestination(String string, String string2) {
        return Rule.nullOrEquals(this.getBusName(), string) && Rule.nullOrEquals(this.getDestinationName(), string2);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(500);
        stringBuffer.append("class=\"");
        stringBuffer.append(this.getTransactionClass());
        stringBuffer.append("\", selector=\"");
        if (null != this.getSelectorAsString()) {
            stringBuffer.append(this.getSelectorAsString());
        }
        stringBuffer.append("\", bus=\"");
        if (null != this.getBusName()) {
            stringBuffer.append(this.getBusName());
        }
        stringBuffer.append("\", destination=\"");
        if (null != this.getDestinationName()) {
            stringBuffer.append(this.getDestinationName());
        }
        stringBuffer.append("\", discriminator=\"");
        if (null != this.getDiscriminatorAsString()) {
            stringBuffer.append(this.getDiscriminatorAsString());
        }
        stringBuffer.append("\", description=\"");
        if (null != this.getDescription()) {
            stringBuffer.append(this.getDescription());
        }
        stringBuffer.append("\"");
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (null == object) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        Rule rule = (Rule)object;
        if (!rule.getTransactionClass().equals(this.getTransactionClass())) {
            return false;
        }
        if (!Rule.equals(rule.getSelectorAsString(), this.getSelectorAsString())) {
            return false;
        }
        if (!Rule.equals(rule.getBusName(), this.getBusName())) {
            return false;
        }
        if (!Rule.equals(rule.getDestinationName(), this.getDestinationName())) {
            return false;
        }
        if (!Rule.equals(rule.getDiscriminatorAsString(), this.getDiscriminatorAsString())) {
            return false;
        }
        return Rule.equals(rule.getDescription(), this.getDescription());
    }

    private static boolean equals(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (null == object || null == object2) {
            return false;
        }
        return object.equals(object2);
    }

    private static boolean nullOrEquals(String string, String string2) {
        return null == string || string.equals(string2);
    }

    private static boolean nullOrBlank(String string) {
        return null == string || string.trim().equals("");
    }

    private static String normalise(String string) {
        return Rule.nullOrBlank(string) ? null : string;
    }

    static {
        if (TC.isDebugEnabled()) {
            SibTr.debug((TraceComponent)TC, (String)"Source info: @(#)SIB/ws/code/sib.zwlmclassifier.impl/src/com/ibm/ws/sib/zwlmclassifier/Rule.java, SIB.zwlmclassifier, WAS602.SIB, o0610.11 1.7");
        }
    }
}

