/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.trm.wlm.server;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.sib.trm.TrmMeMainImpl;
import com.ibm.ws.sib.trm.client.Utils;
import com.ibm.ws.sib.trm.contact.ConnectNeighbour;
import com.ibm.ws.sib.trm.contact.Neighbourhood;
import com.ibm.ws.sib.trm.dlm.Capability;
import com.ibm.ws.sib.trm.dlm.DestinationLocationChangeListener;
import com.ibm.ws.sib.trm.dlm.DestinationLocationManager;
import com.ibm.ws.sib.trm.dlm.Selection;
import com.ibm.ws.sib.trm.links.LinkChangeListener;
import com.ibm.ws.sib.trm.links.LinkSelection;
import com.ibm.ws.sib.trm.wlm.server.DestEventQueue;
import com.ibm.ws.sib.trm.wlm.server.Identities;
import com.ibm.ws.sib.trm.wlm.server.Join;
import com.ibm.ws.sib.trm.wlm.server.Leave;
import com.ibm.ws.sib.trm.wlm.server.Select;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.channel.framework.CFEndPoint;
import com.ibm.wsspi.cluster.ClusterObserver;
import com.ibm.wsspi.cluster.ClusterService;
import com.ibm.wsspi.cluster.ClusterServiceFactory;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.cluster.Target;
import com.ibm.wsspi.cluster.selection.SelectionCallback;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public final class Manager
implements ClusterObserver,
DestinationLocationManager {
    public static final String $ssccid = "@(#) 1.93 SIB/ws/code/sib.trm.impl/src/com/ibm/ws/sib/trm/wlm/server/Manager.java, SIB.trm, WAS602.SIB 05/07/12 06:34:30 [7/19/05 12:16:56]";
    private static final String className = Manager.class.getName();
    private static final TraceComponent tc = SibTr.register((String)className, (String)"SIBTrm", (String)"com.ibm.ws.sib.trm.CWSITMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.trm.CWSITMessages");
    private final TrmMeMainImpl meMain;
    private boolean active = false;
    private final ClusterService clusterService = ClusterServiceFactory.getClusterService();
    private final Identities identities;
    private final Join join;
    private final Leave leave;
    private final DestEventQueue destEventHandler;
    private Map meUuidCache = new HashMap();
    private DestinationLocationChangeListener listener = null;
    private LinkChangeListener linkChangeListener = null;
    static final String ls;

    public Manager(TrmMeMainImpl trmMeMainImpl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"Manager");
        }
        this.meMain = trmMeMainImpl;
        this.identities = new Identities(this.meMain);
        this.join = new Join(this.meMain);
        this.leave = new Leave(this.meMain);
        this.destEventHandler = new DestEventQueue(this.join, this.leave);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"Manager");
        }
    }

    public void start() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"start");
        }
        this.join.toBus();
        boolean bl = this.meMain.inRecoveryMode();
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("Recovery mode=" + bl));
        }
        if (!bl) {
            this.join.toSubnet();
        }
        this.join.toBusMember();
        this.join.toUuidToLongName();
        this.join.toShortToLongName();
        this.join.toShortNameToUuid();
        String[] stringArray = this.meMain.getUserGroups();
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            this.join.toCustom(stringArray[i]);
        }
        this.destEventHandler.deQueueDestinationEvents();
        if (!bl) {
            this.active = true;
            this.clusterService.registerInterest((ClusterObserver)this, this.identities.getDestinationsIdentity(), "member.added");
            this.clusterService.registerInterest((ClusterObserver)this, this.identities.getDestinationsIdentity(), "member.removed");
            this.clusterService.registerInterest((ClusterObserver)this, this.identities.getLinksIdentity(), "member.added");
            this.clusterService.registerInterest((ClusterObserver)this, this.identities.getLinksIdentity(), "member.removed");
            this.clusterService.registerInterest((ClusterObserver)this, this.identities.getSubnetIdentity(), "member.added");
            this.clusterService.registerInterest((ClusterObserver)this, this.identities.getSubnetIdentity(), "member.removed");
            this.processConnections();
            this.initialiseDestinations();
            this.initialiseLinks();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"start");
        }
    }

    public void stop() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"stop");
        }
        this.active = false;
        this.destEventHandler.initializeQueuing();
        String[] stringArray = this.meMain.getUserGroups();
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            this.leave.fromCustom(stringArray[i]);
        }
        this.leave.fromShortNameToUuid();
        this.leave.fromShortToLongName();
        this.leave.fromUuidToLongName();
        this.leave.fromBusMember();
        this.leave.fromSubnet();
        this.leave.fromBus();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"stop");
        }
    }

    public SIBUuid8 resolve(String string, String string2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"resolve");
        }
        SIBUuid8 sIBUuid8 = null;
        Target target = Select.serverMeShortName(string, string2);
        if (target != null) {
            Identity identity = target.getClusterIdentities()[1];
            Map map = identity.getProperties();
            String string3 = (String)map.get("uuid");
            sIBUuid8 = new SIBUuid8(string3);
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("rc=" + sIBUuid8));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"resolve");
        }
        return sIBUuid8;
    }

    public CFEndPoint resolve(String string, String string2, String string3, String string4) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"resolve");
        }
        CFEndPoint cFEndPoint = null;
        com.ibm.ws.sib.trm.wlm.client.Selection selection = Select.meLongName((String)string, (String)string2, (String)string3, (String)string4);
        if (selection != null) {
            cFEndPoint = selection.getEndPoint();
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("rc=" + cFEndPoint));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"resolve");
        }
        return cFEndPoint;
    }

    public void registerBridge(String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"registerBridge");
        }
        this.join.toBridge(string);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"registerBridge");
        }
    }

    public void deregisterBridge(String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deregisterBridge");
        }
        this.leave.fromBridge(string);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deregisterBridge");
        }
    }

    public void registerLink(SIBUuid12 sIBUuid12, SIBUuid8 sIBUuid8) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"registerLink");
        }
        this.join.toLink(sIBUuid12, this.meMain.getUuid(), sIBUuid8);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"registerLink");
        }
    }

    public void deregisterLink(SIBUuid12 sIBUuid12) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deregisterLink");
        }
        this.leave.fromLink(sIBUuid12);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deregisterLink");
        }
    }

    public LinkSelection selectLink(SIBUuid12 sIBUuid12) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"selectLink");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("linkUuid=" + sIBUuid12));
        }
        LinkSelection linkSelection = null;
        LCL_WLMCallback lCL_WLMCallback = null;
        if (this.linkChangeListener != null) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("A LinkChangeListener has been registered with this Manager object: " + this.linkChangeListener));
            }
            lCL_WLMCallback = new LCL_WLMCallback(this.linkChangeListener, sIBUuid12);
        } else if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Null linkChangeListener");
        }
        Target target = Select.serverFromLink(sIBUuid12, lCL_WLMCallback);
        linkSelection = Manager.getLinkSelectionFromTarget(target);
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("rc=" + linkSelection));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"selectLink");
        }
        return linkSelection;
    }

    private static LinkSelection getLinkSelectionFromTarget(Target target) {
        Identity[] identityArray;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getLinkSelectionFromTarget", (Object)target);
        }
        LinkSelection linkSelection = null;
        if (target != null && (identityArray = target.getClusterIdentities()).length > 1) {
            Map map = identityArray[1].getProperties();
            SIBUuid8 sIBUuid8 = null;
            String string = (String)map.get("outboundMeUuid");
            if (string != null) {
                sIBUuid8 = new SIBUuid8(string);
            }
            SIBUuid8 sIBUuid82 = null;
            String string2 = (String)map.get("inboundMeUuid");
            if (string2 != null) {
                sIBUuid82 = new SIBUuid8(string2);
            }
            linkSelection = new LinkSelection(sIBUuid8, sIBUuid82);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getLinkSelectionFromTarget", linkSelection);
        }
        return linkSelection;
    }

    public void notify(Identity identity, String string, Object object) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"notify");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("id=" + identity + ",type=" + string + ",info=" + object));
        }
        if (this.active) {
            if (identity == this.identities.getDestinationsIdentity()) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Change in destinations membership");
                }
                if (string.equals("member.added")) {
                    Identity identity2 = (Identity)object;
                    Map map = identity2.getProperties();
                    if (((String)map.get("type")).equals("WSAF_SIB_DESTINATION_UUID")) {
                        SIBUuid12 sIBUuid12 = new SIBUuid12((String)map.get("uuid"));
                        Capability capability = Capability.get((String)map.get("capability"));
                        Identity identity3 = Identities.getDestinationUuidIdentity(sIBUuid12, capability);
                        this.clusterService.registerInterest((ClusterObserver)this, identity3, "member.added");
                        this.clusterService.registerInterest((ClusterObserver)this, identity3, "member.removed");
                        this.destinationChange(sIBUuid12, capability);
                    } else if (tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)("Unrecognised member:" + object));
                    }
                }
            } else if (identity == this.identities.getLinksIdentity()) {
                Identity identity4;
                Map map;
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Change in links membership");
                }
                if (((String)(map = (identity4 = (Identity)object).getProperties()).get("type")).equals("WSAF_SIB_LINK_UUID")) {
                    String string2 = (String)map.get("uuid");
                    SIBUuid12 sIBUuid12 = new SIBUuid12(string2);
                    if (string.equals("member.added")) {
                        LinkSelection linkSelection = this.selectLink(sIBUuid12);
                        if (linkSelection != null) {
                            if (this.linkChangeListener != null) {
                                if (tc.isDebugEnabled()) {
                                    SibTr.debug((TraceComponent)tc, (String)("Calling link change listener with: " + sIBUuid12 + "," + linkSelection.getOutboundMeUuid() + "," + linkSelection.getInboundMeUuid()));
                                }
                                this.linkChangeListener.linkChange(sIBUuid12, linkSelection.getOutboundMeUuid(), linkSelection.getInboundMeUuid());
                            } else if (tc.isDebugEnabled()) {
                                SibTr.debug((TraceComponent)tc, (String)"Link Change Listener is null");
                            }
                        } else if (tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)tc, (String)"*** No cluster member found!");
                        }
                    } else if (this.linkChangeListener != null) {
                        if (tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)tc, (String)("Calling link change listener with: " + sIBUuid12 + "," + null + "," + null));
                        }
                        this.linkChangeListener.linkChange(sIBUuid12, null, null);
                    } else if (tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)"Link Change Listener is null");
                    }
                } else if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("Unrecognised member:" + object));
                }
            } else if (identity == this.identities.getSubnetIdentity()) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("Change in subnet " + string));
                }
                if (string.equals("member.added")) {
                    this.processConnections();
                } else if (string.equals("member.removed")) {
                    Neighbourhood neighbourhood = this.meMain.getNeighbourhood();
                    Identity identity5 = (Identity)object;
                    Map map = identity5.getProperties();
                    if (((String)map.get("type")).equals("WSAF_SIB_ME_LONG_NAME")) {
                        String string3 = (String)map.get("name");
                        ConnectNeighbour connectNeighbour = neighbourhood.getConnect(string3);
                        if (connectNeighbour != null) {
                            if (tc.isDebugEnabled()) {
                                SibTr.debug((TraceComponent)tc, (String)Utils.messagingEngineDied((String)connectNeighbour.toShortString()));
                            }
                            neighbourhood.remove(connectNeighbour);
                        } else if (tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)tc, (String)("Neighbour " + string3 + " not found in neighbourhood"));
                        }
                    } else if (tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)("Unrecognised member:" + object));
                    }
                }
            } else {
                Map map = identity.getProperties();
                if (((String)map.get("type")).equals("WSAF_SIB_DESTINATION_UUID")) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)"Change in single destination membership");
                    }
                    SIBUuid12 sIBUuid12 = new SIBUuid12((String)map.get("uuid"));
                    Capability capability = Capability.get((String)map.get("capability"));
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)("Destination uuid=" + sIBUuid12 + ",capability=" + capability));
                    }
                    HashSet<SIBUuid8> hashSet = new HashSet<SIBUuid8>();
                    HashSet<SIBUuid8> hashSet2 = new HashSet<SIBUuid8>();
                    map = ((Identity)object).getProperties();
                    if (((String)map.get("type")).equals("WSAF_SIB_ME_UUID")) {
                        String string4 = (String)map.get("uuid");
                        if (string.equals("member.added")) {
                            hashSet.add(new SIBUuid8(string4));
                        } else if (string.equals("member.removed")) {
                            hashSet2.add(new SIBUuid8(string4));
                        }
                        if (tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)tc, (String)("available=" + hashSet + ",unavailable=" + hashSet2));
                        }
                        if (this.listener != null) {
                            this.listener.destinationLocationChange(sIBUuid12, hashSet, hashSet2, capability);
                        } else if (tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)tc, (String)"No registered listener");
                        }
                    } else if (tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)("Unrecognised member:" + object));
                    }
                } else if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("Unrecognised identity:" + identity));
                }
            }
        } else if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("active=" + this.active));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"notify");
        }
    }

    public void registerDestination(SIBUuid12 sIBUuid12) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"registerDestination");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("destUuid=" + sIBUuid12));
        }
        this.destEventHandler.registerDestination(sIBUuid12);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"registerDestination");
        }
    }

    public void deregisterDestination(SIBUuid12 sIBUuid12) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deregisterDestination");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("destUuid=" + sIBUuid12));
        }
        this.destEventHandler.deregisterDestination(sIBUuid12);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deregisterDestination");
        }
    }

    public void registerDestination(String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"registerDestination");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("destination=" + string));
        }
        this.destEventHandler.registerDestination(string);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"registerDestination");
        }
    }

    public void registerDestinationCapability(SIBUuid12 sIBUuid12, Capability capability) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"registerDestinationCapability");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("uuid=" + sIBUuid12 + ",capability=" + capability));
        }
        this.destEventHandler.registerDestinationCapability(sIBUuid12, capability);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"registerDestinationCapability");
        }
    }

    public void deregisterDestination(String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deregisterDestination");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("destination=" + string));
        }
        this.destEventHandler.deregisterDestination(string);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deregisterDestination");
        }
    }

    public void deregisterDestinationCapability(SIBUuid12 sIBUuid12, Capability capability) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deregisterDestinationCapability");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("uuid=" + sIBUuid12 + ",capability=" + capability));
        }
        this.destEventHandler.deregisterDestinationCapability(sIBUuid12, capability);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deregisterDestinationCapability");
        }
    }

    public Selection select(SIBUuid12 sIBUuid12, Set set, SIBUuid8 sIBUuid8, Capability capability) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"select");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("uuid=" + sIBUuid12 + ",acceptable=" + set + ",preferred=" + sIBUuid8 + ",capability=" + capability));
        }
        Selection selection = null;
        if (sIBUuid8 != null) {
            Target target = Select.serverMeUuid(sIBUuid8);
            if (target != null) {
                if (this.isLocalised(sIBUuid12, sIBUuid8, capability)) {
                    selection = new Selection(sIBUuid8, true);
                } else {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)"Preferred messaging engine does not localise required destination");
                    }
                    selection = this.select1(sIBUuid12, set, sIBUuid8, capability);
                }
            } else {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Preferred messaging engine not currently available");
                }
                selection = this.select1(sIBUuid12, set, sIBUuid8, capability);
            }
        } else {
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"No preferred messaging engine specified");
            }
            selection = this.select1(sIBUuid12, set, sIBUuid8, capability);
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("rc=" + selection));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"select");
        }
        return selection;
    }

    private SIBUuid8 getCachedUuid(String string) {
        SIBUuid8 sIBUuid8 = (SIBUuid8)this.meUuidCache.get(string);
        if (sIBUuid8 == null) {
            sIBUuid8 = new SIBUuid8(string);
            this.meUuidCache.put(string, sIBUuid8);
        }
        return sIBUuid8;
    }

    private Selection select1(SIBUuid12 sIBUuid12, Set set, SIBUuid8 sIBUuid8, Capability capability) {
        Target target;
        Selection selection = null;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"select1");
        }
        boolean bl = true;
        SIBUuid8 sIBUuid82 = this.meMain.getUuid();
        if (!this.isLocalised(sIBUuid12, sIBUuid82, capability)) {
            bl = false;
        }
        if ((target = Select.serverFromDestination(sIBUuid12, capability, bl)) != null) {
            Identity[] identityArray = target.getClusterIdentities();
            if (identityArray.length > 1) {
                Map map = identityArray[1].getProperties();
                String string = (String)map.get("uuid");
                SIBUuid8 sIBUuid83 = this.getCachedUuid(string);
                if (set.contains(sIBUuid83)) {
                    selection = new Selection(sIBUuid83, true);
                } else {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)"Selected messaging engine not in acceptable set");
                    }
                    Identity[] identityArray2 = this.clusterService.getMemberIdentities(Identities.getDestinationUuidIdentity(sIBUuid12, capability));
                    for (int i = 0; i < identityArray2.length && selection == null; ++i) {
                        Map map2 = identityArray2[i].getProperties();
                        String string2 = (String)map2.get("uuid");
                        SIBUuid8 sIBUuid84 = this.getCachedUuid(string2);
                        if (!set.contains(sIBUuid84)) continue;
                        if (tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)tc, (String)"Found a messaging engine localising destination and in acceptable set");
                        }
                        selection = new Selection(sIBUuid84, true);
                    }
                    if (selection == null) {
                        if (tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)tc, (String)"Could not find a messaging engine localising destination and in the acceptable set");
                        }
                        selection = this.select2(sIBUuid12, set, sIBUuid8);
                    }
                }
            } else {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Required destination not localised by any messaging engines");
                }
                selection = this.select2(sIBUuid12, set, sIBUuid8);
            }
        } else {
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Required destination not known");
            }
            selection = this.select2(sIBUuid12, set, sIBUuid8);
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("rc=" + selection));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"select1");
        }
        return selection;
    }

    private Selection select2(SIBUuid12 sIBUuid12, Set set, SIBUuid8 sIBUuid8) {
        Selection selection = null;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"select2");
        }
        if (sIBUuid8 != null) {
            selection = new Selection(sIBUuid8, false);
        } else if (set != null && !set.isEmpty()) {
            Object[] objectArray = set.toArray();
            int n = Math.abs(new Random().nextInt() % objectArray.length);
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Random=" + n));
            }
            SIBUuid8 sIBUuid82 = (SIBUuid8)objectArray[n];
            selection = new Selection(sIBUuid82, false);
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("rc=" + selection));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"select2");
        }
        return selection;
    }

    public void setChangeListener(DestinationLocationChangeListener destinationLocationChangeListener) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setChangeListener");
        }
        this.listener = destinationLocationChangeListener;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setChangeListener");
        }
    }

    public void setLinkChangeListener(LinkChangeListener linkChangeListener) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setLinkChangeListener");
        }
        this.linkChangeListener = linkChangeListener;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setLinkChangeListener");
        }
    }

    public boolean isLocalised(SIBUuid12 sIBUuid12, SIBUuid8 sIBUuid8, Capability capability) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isLocalised");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("destUuid=" + sIBUuid12 + ",meUuid=" + sIBUuid8 + ",capability=" + capability));
        }
        Identity identity = Identities.getMeUuidIdentity(sIBUuid8);
        Identity[] identityArray = this.clusterService.getMemberIdentities(Identities.getDestinationUuidIdentity(sIBUuid12, capability));
        boolean bl = false;
        for (int i = 0; i < identityArray.length && !bl; ++i) {
            bl = identity == identityArray[i];
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("found=" + bl));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isLocalised");
        }
        return bl;
    }

    private void processConnections() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processConnections");
        }
        Identity[] identityArray = this.clusterService.getMemberIdentities(this.identities.getSubnetIdentity());
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("Subnet has " + identityArray.length + " member(s)"));
        }
        String string = this.meMain.getName();
        Neighbourhood neighbourhood = this.meMain.getNeighbourhood();
        for (int i = 0; i < identityArray.length; ++i) {
            String string2 = (String)identityArray[i].getProperties().get("name");
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Retrieved entry for: " + string2));
            }
            if (string2.equals(string) || neighbourhood.getConnect(string2) != null) continue;
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Discovered new messaging engine: " + string2));
            }
            neighbourhood.addNeighbour(new ConnectNeighbour(this.meMain, string2));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processConnections");
        }
    }

    private void initialiseDestinations() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"initialiseDestinations");
        }
        Identity[] identityArray = this.clusterService.getMemberIdentities(this.identities.getDestinationsIdentity());
        for (int i = 0; i < identityArray.length; ++i) {
            SIBUuid12 sIBUuid12 = new SIBUuid12((String)identityArray[i].getProperties().get("uuid"));
            Capability capability = Capability.get((String)identityArray[i].getProperties().get("capability"));
            Identity identity = Identities.getDestinationUuidIdentity(sIBUuid12, capability);
            this.clusterService.registerInterest((ClusterObserver)this, identity, "member.added");
            this.clusterService.registerInterest((ClusterObserver)this, identity, "member.removed");
            this.destinationChange(sIBUuid12, capability);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"initialiseDestinations");
        }
    }

    private void destinationChange(SIBUuid12 sIBUuid12, Capability capability) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"destinationChange");
        }
        HashSet<SIBUuid8> hashSet = new HashSet<SIBUuid8>();
        HashSet hashSet2 = new HashSet();
        Identity identity = Identities.getDestinationUuidIdentity(sIBUuid12, capability);
        Identity[] identityArray = this.clusterService.getMemberIdentities(identity);
        for (int i = 0; i < identityArray.length; ++i) {
            hashSet.add(new SIBUuid8((String)identityArray[i].getProperties().get("uuid")));
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("available=" + hashSet + ",unavailable=" + hashSet2));
        }
        if (!hashSet.isEmpty() || !hashSet2.isEmpty()) {
            if (this.listener != null) {
                this.listener.destinationLocationChange(sIBUuid12, hashSet, hashSet2, capability);
            } else if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"No registered listener");
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"destinationChange");
        }
    }

    private void initialiseLinks() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"initialiseLinks");
        }
        Identity[] identityArray = this.clusterService.getMemberIdentities(this.identities.getLinksIdentity());
        for (int i = 0; i < identityArray.length; ++i) {
            SIBUuid12 sIBUuid12 = new SIBUuid12((String)identityArray[i].getProperties().get("uuid"));
            LinkSelection linkSelection = this.selectLink(sIBUuid12);
            if (linkSelection != null) {
                if (this.linkChangeListener != null) {
                    this.linkChangeListener.linkChange(sIBUuid12, linkSelection.getOutboundMeUuid(), linkSelection.getInboundMeUuid());
                    continue;
                }
                if (!tc.isDebugEnabled()) continue;
                SibTr.debug((TraceComponent)tc, (String)"Link Change Listener is null");
                continue;
            }
            if (!tc.isDebugEnabled()) continue;
            SibTr.debug((TraceComponent)tc, (String)"*** No cluster member found!");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"initialiseLinks");
        }
    }

    public String dump(Map map) {
        StringBuffer stringBuffer = new StringBuffer();
        Identity identity = this.clusterService.getIdentity(map);
        stringBuffer.append(ls);
        stringBuffer.append("Cluster identity: " + identity + ls);
        stringBuffer.append("Cluster members:" + ls);
        Identity[] identityArray = this.clusterService.getMemberIdentities(identity);
        for (int i = 0; i < identityArray.length; ++i) {
            stringBuffer.append("    " + identityArray[i] + ls);
        }
        return stringBuffer.toString();
    }

    public String dump() {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(ls + "====================== Messaging Engine ======================" + ls);
        stringBuffer.append(this.dump(this.identities.getBusIdentity().getProperties()));
        stringBuffer.append(this.dump(this.identities.getSubnetIdentity().getProperties()));
        stringBuffer.append(this.dump(this.identities.getBusMemberIdentity().getProperties()));
        stringBuffer.append(this.dump(this.identities.getMeUuidIdentity().getProperties()));
        stringBuffer.append(this.dump(this.identities.getMeShortNameIdentity().getProperties()));
        stringBuffer.append(this.dump(this.identities.getMeUuidIdentity().getProperties()));
        String[] stringArray = this.meMain.getUserGroups();
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            stringBuffer.append(this.dump(this.identities.getCustomIdentity(stringArray[i]).getProperties()));
        }
        stringBuffer.append(ls + "======================== Destinations ========================" + ls);
        Identity identity = this.identities.getDestinationsIdentity();
        stringBuffer.append(this.dump(identity.getProperties()));
        Identity[] identityArray = this.clusterService.getMemberIdentities(identity);
        for (int i = 0; i < identityArray.length; ++i) {
            String string2 = (String)identityArray[i].getProperties().get("uuid");
            string = (String)identityArray[i].getProperties().get("capability");
            stringBuffer.append(this.dump(Identities.getDestinationUuidIdentity(new SIBUuid12(string2), Capability.get(string)).getProperties()));
        }
        stringBuffer.append(ls + "=========================== Links ============================" + ls);
        Identity identity2 = this.identities.getLinksIdentity();
        stringBuffer.append(this.dump(identity2.getProperties()));
        identityArray = this.clusterService.getMemberIdentities(identity2);
        for (int i = 0; i < identityArray.length; ++i) {
            string = (String)identityArray[i].getProperties().get("uuid");
            stringBuffer.append(this.dump(Identities.getLinkUuidIdentity(new SIBUuid12(string)).getProperties()));
        }
        return stringBuffer.toString();
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source Info: @(#) 1.93 SIB/ws/code/sib.trm.impl/src/com/ibm/ws/sib/trm/wlm/server/Manager.java, SIB.trm, WAS602.SIB 05/07/12 06:34:30 [7/19/05 12:16:56] updated in PK08962");
        }
        ls = System.getProperty("line.separator");
    }

    private static class LCL_WLMCallback
    implements SelectionCallback {
        private static final TraceComponent callbackTC = SibTr.register((String)"LCL_WLMCallback", (String)"SIBTrm", (String)"com.ibm.ws.sib.trm.CWSITMessages");
        private LinkChangeListener myLinkChangeListener;
        private SIBUuid12 myLinkUuid;

        public LCL_WLMCallback(LinkChangeListener linkChangeListener, SIBUuid12 sIBUuid12) {
            if (callbackTC.isEntryEnabled()) {
                SibTr.entry((TraceComponent)callbackTC, (String)"LCL_WLMCallback", (Object)new Object[]{linkChangeListener, sIBUuid12});
            }
            this.myLinkChangeListener = linkChangeListener;
            this.myLinkUuid = sIBUuid12;
            if (callbackTC.isEntryEnabled()) {
                SibTr.exit((TraceComponent)callbackTC, (String)"LCL_WLMCallback");
            }
        }

        public void callback(Target target, Object object) {
            LinkSelection linkSelection;
            if (callbackTC.isEntryEnabled()) {
                SibTr.entry((TraceComponent)callbackTC, (String)"callback", (Object)new Object[]{target, object});
            }
            if ((linkSelection = Manager.getLinkSelectionFromTarget(target)) != null) {
                SIBUuid8 sIBUuid8 = linkSelection.getInboundMeUuid();
                SIBUuid8 sIBUuid82 = linkSelection.getOutboundMeUuid();
                if (callbackTC.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)callbackTC, (String)"About to invoke LinkChangeListener as a result of WLM callback");
                }
                if (callbackTC.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)callbackTC, (String)("      LinkUUID: " + this.myLinkUuid));
                }
                if (callbackTC.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)callbackTC, (String)(" InboundMEUuid: " + sIBUuid8));
                }
                if (callbackTC.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)callbackTC, (String)("OutboundMEUuid: " + sIBUuid82));
                }
                this.myLinkChangeListener.linkChange(this.myLinkUuid, sIBUuid82, sIBUuid8);
                if (callbackTC.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)callbackTC, (String)"LinkChangeListener invocation complete");
                }
            } else if (callbackTC.isDebugEnabled()) {
                SibTr.debug((TraceComponent)callbackTC, (String)"LinkSelection is null - cannot drive LinkChangeListener");
            }
            if (callbackTC.isEntryEnabled()) {
                SibTr.exit((TraceComponent)callbackTC, (String)"callback");
            }
        }
    }
}

