/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.trm.topology;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.JsEngineComponent;
import com.ibm.ws.sib.mfp.JsDestinationAddress;
import com.ibm.ws.sib.mfp.JsDestinationAddressFactory;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.processor.MPCoreConnection;
import com.ibm.ws.sib.processor.SIMPFactory;
import com.ibm.ws.sib.security.auth.AuthUtils;
import com.ibm.ws.sib.security.auth.AuthUtilsFactory;
import com.ibm.ws.sib.trm.TrmMeMainImpl;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.DestinationType;
import com.ibm.wsspi.sib.core.ProducerSession;
import com.ibm.wsspi.sib.core.SIBusMessage;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.SICoreConnectionFactory;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;

public final class Sender {
    public static final String $ssccid = "@(#) 1.28 SIB/ws/code/sib.trm.impl/src/com/ibm/ws/sib/trm/topology/Sender.java, SIB.trm, WAS602.SIB, o0610.11 05/02/23 09:14:40 [3/13/06 13:39:19]";
    private static final String className = Sender.class.getName();
    private static final TraceComponent tc = SibTr.register((String)className, (String)"SIBTrm", (String)"com.ibm.ws.sib.trm.CWSITMessages");
    private TrmMeMainImpl meMain;
    private MPCoreConnection mpCoreConnection;
    private Map producerSessions = new HashMap();

    public Sender(TrmMeMainImpl trmMeMainImpl) {
        this.meMain = trmMeMainImpl;
    }

    private void createCoreConnection() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createCoreConnection");
        }
        if (this.mpCoreConnection == null) {
            JsEngineComponent jsEngineComponent = this.meMain.getMessagingEngine().getMessageProcessor();
            SIMPFactory sIMPFactory = (SIMPFactory)jsEngineComponent;
            SICoreConnectionFactory sICoreConnectionFactory = (SICoreConnectionFactory)jsEngineComponent;
            AuthUtilsFactory authUtilsFactory = AuthUtilsFactory.getInstance();
            AuthUtils authUtils = authUtilsFactory.createNewAuthUtils();
            Subject subject = authUtils.getSIBServerSubject();
            try {
                SICoreConnection sICoreConnection = sICoreConnectionFactory.createConnection(subject, null);
                this.mpCoreConnection = (MPCoreConnection)sICoreConnection;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)(className + ".createCoreConnection"), (String)"1", (Object)this);
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Unable to create a SICoreConnection");
                }
                SibTr.exception((TraceComponent)tc, (Exception)exception);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createCoreConnection");
        }
    }

    private ProducerSession getProducerSession(SIBUuid8 sIBUuid8, String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getProducerSession");
        }
        if (this.mpCoreConnection == null) {
            this.createCoreConnection();
        }
        ProducerSession producerSession = null;
        if (this.mpCoreConnection != null) {
            producerSession = (ProducerSession)this.producerSessions.get(sIBUuid8);
            if (producerSession == null) {
                try {
                    JsDestinationAddressFactory jsDestinationAddressFactory = (JsDestinationAddressFactory)JsDestinationAddressFactory.getInstance();
                    JsDestinationAddress jsDestinationAddress = jsDestinationAddressFactory.createJsSystemDestinationAddress("TRM", sIBUuid8, string);
                    producerSession = this.mpCoreConnection.createSystemProducerSession((SIDestinationAddress)jsDestinationAddress, null, DestinationType.QUEUE, null, null);
                    this.producerSessions.put(sIBUuid8, producerSession);
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)"New producer session added to cache");
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)(className + ".getProducerSession"), (String)"2", (Object)this);
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)"Unable to create a SystemProducerSession");
                    }
                    SibTr.exception((TraceComponent)tc, (Exception)exception);
                }
            } else if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Retrieved existing producer session from cache");
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getProducerSession");
        }
        return producerSession;
    }

    public void send(JsMessage jsMessage, SIBUuid8 sIBUuid8, String string) {
        ProducerSession producerSession;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"send");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("uuid=" + sIBUuid8 + "bus=" + string));
        }
        if ((producerSession = this.getProducerSession(sIBUuid8, string)) != null) {
            try {
                producerSession.send((SIBusMessage)jsMessage, null);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)(className + ".send"), (String)"3", (Object)this);
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Unable to send the message");
                }
                SibTr.exception((TraceComponent)tc, (Exception)exception);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"send");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#) 1.28 SIB/ws/code/sib.trm.impl/src/com/ibm/ws/sib/trm/topology/Sender.java, SIB.trm, WAS602.SIB, o0610.11 05/02/23 09:14:40 [3/13/06 13:39:19]");
        }
    }
}

