/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.trm.topology;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.JsEngineComponent;
import com.ibm.ws.sib.mfp.IncorrectMessageTypeException;
import com.ibm.ws.sib.mfp.JsDestinationAddress;
import com.ibm.ws.sib.mfp.JsDestinationAddressFactory;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.mfp.trm.TrmMessage;
import com.ibm.ws.sib.mfp.trm.TrmMessageType;
import com.ibm.ws.sib.mfp.trm.TrmRouteData;
import com.ibm.ws.sib.processor.MPCoreConnection;
import com.ibm.ws.sib.processor.SIMPFactory;
import com.ibm.ws.sib.processor.exceptions.SIMPDestinationAlreadyExistsException;
import com.ibm.ws.sib.security.auth.AuthUtils;
import com.ibm.ws.sib.security.auth.AuthUtilsFactory;
import com.ibm.ws.sib.trm.TrmMeMainImpl;
import com.ibm.ws.sib.trm.contact.Neighbour;
import com.ibm.ws.sib.trm.topology.Cellule;
import com.ibm.ws.sib.trm.topology.CelluleRouteMap;
import com.ibm.ws.sib.trm.topology.InvalidBytesException;
import com.ibm.ws.sib.trm.topology.LinkCellule;
import com.ibm.ws.sib.trm.topology.MessagingEngine;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.AsynchConsumerCallback;
import com.ibm.wsspi.sib.core.ConsumerSession;
import com.ibm.wsspi.sib.core.DestinationType;
import com.ibm.wsspi.sib.core.LockedMessageEnumeration;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.SICoreConnectionFactory;
import java.util.List;
import javax.security.auth.Subject;

public final class Receiver
implements AsynchConsumerCallback {
    public static final String $ssccid = "@(#) 1.38 SIB/ws/code/sib.trm.impl/src/com/ibm/ws/sib/trm/topology/Receiver.java, SIB.trm, WAS602.SIB, o0610.11 05/02/23 09:14:11 [3/13/06 13:39:19]";
    private static final String className = Receiver.class.getName();
    private static final TraceComponent tc = SibTr.register((String)className, (String)"SIBTrm", (String)"com.ibm.ws.sib.trm.CWSITMessages");
    private TrmMeMainImpl meMain;
    private MPCoreConnection mpCoreConnection;
    private ConsumerSession consumerSession;

    public Receiver(TrmMeMainImpl trmMeMainImpl) {
        this.meMain = trmMeMainImpl;
    }

    private void createCoreConnection() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createCoreConnection");
        }
        if (this.mpCoreConnection == null) {
            JsEngineComponent jsEngineComponent = this.meMain.getMessagingEngine().getMessageProcessor();
            SIMPFactory sIMPFactory = (SIMPFactory)jsEngineComponent;
            SICoreConnectionFactory sICoreConnectionFactory = (SICoreConnectionFactory)jsEngineComponent;
            AuthUtilsFactory authUtilsFactory = AuthUtilsFactory.getInstance();
            AuthUtils authUtils = authUtilsFactory.createNewAuthUtils();
            Subject subject = authUtils.getSIBServerSubject();
            try {
                SICoreConnection sICoreConnection = sICoreConnectionFactory.createConnection(subject, null);
                this.mpCoreConnection = (MPCoreConnection)sICoreConnection;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)(className + ".createCoreConnection"), (String)"1", (Object)this);
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Unable to create a SICoreConnection");
                }
                SibTr.exception((TraceComponent)tc, (Exception)exception);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createCoreConnection");
        }
    }

    private void createConsumerSession() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createConsumerSession");
        }
        if (this.consumerSession == null) {
            if (this.mpCoreConnection == null) {
                this.createCoreConnection();
            }
            if (this.mpCoreConnection != null) {
                try {
                    JsDestinationAddress jsDestinationAddress = null;
                    try {
                        jsDestinationAddress = this.mpCoreConnection.createSystemDestination("TRM");
                        if (tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)tc, (String)("New system destination " + jsDestinationAddress + " created"));
                        }
                    }
                    catch (SIMPDestinationAlreadyExistsException sIMPDestinationAlreadyExistsException) {
                        JsDestinationAddressFactory jsDestinationAddressFactory = (JsDestinationAddressFactory)JsDestinationAddressFactory.getInstance();
                        jsDestinationAddress = jsDestinationAddressFactory.createJsSystemDestinationAddress("TRM", this.meMain.getUuid());
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, (String)(className + ".createSystemConsumerSession"), (String)"2", (Object)this);
                        if (tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)tc, (String)"Unable to create a new System Destination");
                        }
                        SibTr.exception((TraceComponent)tc, (Exception)exception);
                    }
                    if (jsDestinationAddress != null) {
                        if (tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)tc, (String)("Using system destination " + jsDestinationAddress));
                        }
                        this.consumerSession = this.mpCoreConnection.createSystemConsumerSession((SIDestinationAddress)jsDestinationAddress, DestinationType.QUEUE, null, null, false, false, null, false);
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)(className + ".createSystemConsumerSession"), (String)"3", (Object)this);
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)"Unable to create a SystemConsumerSession");
                    }
                    SibTr.exception((TraceComponent)tc, (Exception)exception);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createConsumerSession");
        }
    }

    public void start() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"start");
        }
        if (this.consumerSession == null) {
            this.createConsumerSession();
        }
        if (this.consumerSession != null) {
            try {
                this.consumerSession.registerAsynchConsumerCallback((AsynchConsumerCallback)this, 1, 0L, 1, null);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)(className + ".start"), (String)"4", (Object)this);
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Unable to registerAsynchConsumerCallback");
                }
                SibTr.exception((TraceComponent)tc, (Exception)exception);
            }
            try {
                this.consumerSession.start(false);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)(className + ".start"), (String)"5", (Object)this);
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Unable to activateAsynchConsumer");
                }
                SibTr.exception((TraceComponent)tc, (Exception)exception);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"start");
        }
    }

    public void consumeMessages(LockedMessageEnumeration lockedMessageEnumeration) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"consumeMessages");
        }
        try {
            while (lockedMessageEnumeration.getRemainingMessageCount() > 0) {
                JsMessage jsMessage = (JsMessage)lockedMessageEnumeration.nextLocked();
                lockedMessageEnumeration.deleteSeen(null);
                TrmMessage trmMessage = null;
                try {
                    trmMessage = jsMessage.makeInboundTrmMessage();
                }
                catch (IncorrectMessageTypeException incorrectMessageTypeException) {
                    FFDCFilter.processException((Throwable)incorrectMessageTypeException, (String)(className + ".consumeMessages"), (String)"6", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)incorrectMessageTypeException));
                }
                if (trmMessage == null || trmMessage.getTrmMessageType() != TrmMessageType.ROUTE_DATA) continue;
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("Message type = " + trmMessage.getTrmMessageType()));
                }
                TrmRouteData trmRouteData = (TrmRouteData)trmMessage;
                SIBUuid8 sIBUuid8 = trmRouteData.getOriginator();
                Neighbour neighbour = this.meMain.getNeighbourhood().getNeighbour(new MessagingEngine(sIBUuid8));
                if (neighbour != null) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)("Topology update message received from " + neighbour.toShortString()));
                    }
                    if (neighbour.getRecvMagicNumber() == trmRouteData.getMagicNumber()) {
                        List list = trmRouteData.getCellules();
                        List list2 = trmRouteData.getCosts();
                        CelluleRouteMap celluleRouteMap = new CelluleRouteMap(this.meMain);
                        for (int i = 0; i < list.size(); ++i) {
                            byte[] byArray = (byte[])list.get(i);
                            try {
                                if (Cellule.isMessagingEngine(byArray)) {
                                    celluleRouteMap.put(new MessagingEngine(byArray), (Integer)list2.get(i));
                                    continue;
                                }
                                celluleRouteMap.put(new LinkCellule(byArray), (Integer)list2.get(i));
                                continue;
                            }
                            catch (InvalidBytesException invalidBytesException) {
                                FFDCFilter.processException((Throwable)invalidBytesException, (String)(className + ".consumeMessages"), (String)"7", (Object)this);
                                SibTr.exception((TraceComponent)tc, (Exception)invalidBytesException);
                            }
                        }
                        if (tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)tc, (String)("Received routes: " + celluleRouteMap));
                        }
                        neighbour.setRecvRouteMap(celluleRouteMap);
                        continue;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    SibTr.debug((TraceComponent)tc, (String)"Magic number wrong so ignoring message");
                    continue;
                }
                if (!tc.isDebugEnabled()) continue;
                SibTr.debug((TraceComponent)tc, (String)("Unable to find a matching neighbour in the neighbourhood for uuid=" + sIBUuid8));
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)(className + ".consumeMessages"), (String)"8", (Object)this);
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Unable to consumeMessages");
            }
            SibTr.exception((TraceComponent)tc, (Exception)exception);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"consumeMessages");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#) 1.38 SIB/ws/code/sib.trm.impl/src/com/ibm/ws/sib/trm/topology/Receiver.java, SIB.trm, WAS602.SIB, o0610.11 05/02/23 09:14:11 [3/13/06 13:39:19]");
        }
    }
}

