/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.trm.links.ibl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.sib.trm.TrmMeMainImpl;
import com.ibm.ws.sib.trm.contact.BridgeNeighbour;
import com.ibm.ws.sib.trm.links.LinkException;
import com.ibm.ws.sib.trm.links.ibl.InterBusLinkConfig;
import com.ibm.ws.sib.trm.links.ibl.InterBusLinkManager;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.HashSet;
import java.util.Set;

public final class InterBusLinkManagerImpl
implements InterBusLinkManager {
    public static final String $ssccid = "@(#) 1.19 SIB/ws/code/sib.trm.impl/src/com/ibm/ws/sib/trm/links/ibl/InterBusLinkManagerImpl.java, SIB.trm, WAS602.SIB, o0610.11 05/04/20 12:20:57 [3/13/06 13:39:08]";
    private static final String className = InterBusLinkManagerImpl.class.getName();
    private static final TraceComponent tc = SibTr.register((String)className, (String)"SIBTrm", (String)"com.ibm.ws.sib.trm.CWSITMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.trm.CWSITMessages");
    private TrmMeMainImpl meMain;
    private Set uuids = new HashSet();

    public InterBusLinkManagerImpl(TrmMeMainImpl trmMeMainImpl) {
        this.meMain = trmMeMainImpl;
    }

    public void define(InterBusLinkConfig interBusLinkConfig) throws LinkException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"define");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("interBusLinkConfig=" + interBusLinkConfig));
        }
        if (this.isDefined(interBusLinkConfig.getUuid())) {
            throw new LinkException(nls.getFormattedMessage("ALREADY_DEFINED_CWSIT0075", new Object[]{interBusLinkConfig.getUuid().toString()}, null));
        }
        this.uuids.add(interBusLinkConfig.getUuid());
        String string = interBusLinkConfig.getTransportChain();
        if (string != null && string.equals("")) {
            string = null;
        }
        if (string == null) {
            string = "InboundBasicMessaging";
        }
        BridgeNeighbour bridgeNeighbour = new BridgeNeighbour(interBusLinkConfig.getBootstrapEPs(), interBusLinkConfig.getBus(), this.meMain, interBusLinkConfig.getName(), interBusLinkConfig.getLink(), string, interBusLinkConfig.getUserid(), interBusLinkConfig.getPassword(), interBusLinkConfig.getUuid(), interBusLinkConfig.getRuntimeEventListener());
        if (interBusLinkConfig.getInitialState()) {
            bridgeNeighbour.start();
        } else {
            bridgeNeighbour.stop();
        }
        this.meMain.getNeighbourhood().addNeighbour(bridgeNeighbour);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"define");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void undefine(SIBUuid12 sIBUuid12) throws LinkException {
        block9: {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"undefine");
            }
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("linkUuid=" + sIBUuid12));
            }
            if (this.isDefined(sIBUuid12)) {
                BridgeNeighbour bridgeNeighbour = this.meMain.getNeighbourhood().getBridge(sIBUuid12);
                if (bridgeNeighbour != null) {
                    this.meMain.getNeighbourhood().remove(bridgeNeighbour);
                    this.uuids.remove(sIBUuid12);
                    break block9;
                } else {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)"*** Could not find neighbour!");
                    }
                    IllegalStateException illegalStateException = new IllegalStateException(nls.getFormattedMessage("NEIGHBOUR_NOT_FOUND_CWSIT0081", new Object[]{sIBUuid12.toString()}, null));
                    if (tc.isDebugEnabled()) {
                        SibTr.exception((TraceComponent)tc, (Exception)illegalStateException);
                    }
                    throw illegalStateException;
                }
            }
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Ingoring request to undefine a link that doesn't exist: " + sIBUuid12));
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"undefine");
        }
    }

    public void start(SIBUuid12 sIBUuid12) throws LinkException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"start");
        }
        if (!this.isDefined(sIBUuid12)) {
            throw new LinkException(nls.getFormattedMessage("UNDEFINED_CWSIT0076", new Object[]{sIBUuid12.toString()}, null));
        }
        BridgeNeighbour bridgeNeighbour = this.meMain.getNeighbourhood().getBridge(sIBUuid12);
        if (bridgeNeighbour != null) {
            if (!bridgeNeighbour.isStarted()) {
                this.meMain.getNeighbourhood().startNeighbour(bridgeNeighbour);
            }
        } else {
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"*** Could not find neighbour!");
            }
            IllegalStateException illegalStateException = new IllegalStateException(nls.getFormattedMessage("NEIGHBOUR_NOT_FOUND_CWSIT0081", new Object[]{sIBUuid12.toString()}, null));
            if (tc.isDebugEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)illegalStateException);
            }
            throw illegalStateException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"start");
        }
    }

    public void stop(SIBUuid12 sIBUuid12) throws LinkException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"stop");
        }
        if (!this.isDefined(sIBUuid12)) {
            throw new LinkException(nls.getFormattedMessage("UNDEFINED_CWSIT0076", new Object[]{sIBUuid12.toString()}, null));
        }
        BridgeNeighbour bridgeNeighbour = this.meMain.getNeighbourhood().getBridge(sIBUuid12);
        if (bridgeNeighbour != null) {
            if (bridgeNeighbour.isStarted()) {
                this.meMain.getNeighbourhood().stopNeighbour(bridgeNeighbour);
            }
        } else {
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"*** Could not find neighbour!");
            }
            throw new IllegalStateException(nls.getFormattedMessage("NEIGHBOUR_NOT_FOUND_CWSIT0081", new Object[]{sIBUuid12.toString()}, null));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"stop");
        }
    }

    public boolean isDefined(SIBUuid12 sIBUuid12) {
        return this.uuids.contains(sIBUuid12);
    }

    public boolean isStarted(SIBUuid12 sIBUuid12) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isStarted");
        }
        boolean bl = false;
        if (this.isDefined(sIBUuid12)) {
            BridgeNeighbour bridgeNeighbour = this.meMain.getNeighbourhood().getBridge(sIBUuid12);
            if (bridgeNeighbour != null) {
                bl = bridgeNeighbour.isStarted();
            } else {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"*** Could not find neighbour!");
                }
                throw new IllegalStateException(nls.getFormattedMessage("NEIGHBOUR_NOT_FOUND_CWSIT0081", new Object[]{sIBUuid12.toString()}, null));
            }
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("rc=" + bl));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isStarted");
        }
        return bl;
    }

    public boolean isActive(SIBUuid12 sIBUuid12) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isActive");
        }
        boolean bl = false;
        if (this.isDefined(sIBUuid12)) {
            BridgeNeighbour bridgeNeighbour = this.meMain.getNeighbourhood().getBridge(sIBUuid12);
            if (bridgeNeighbour != null) {
                bl = bridgeNeighbour.isConnected();
            } else {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"*** Could not find neighbour!");
                }
                throw new IllegalStateException(nls.getFormattedMessage("NEIGHBOUR_NOT_FOUND_CWSIT0081", new Object[]{sIBUuid12.toString()}, null));
            }
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("rc=" + bl));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isActive");
        }
        return bl;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source Info: @(#) 1.19 SIB/ws/code/sib.trm.impl/src/com/ibm/ws/sib/trm/links/ibl/InterBusLinkManagerImpl.java, SIB.trm, WAS602.SIB, o0610.11 05/04/20 12:20:57 [3/13/06 13:39:08]");
        }
    }
}

