/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.trm.links;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.sib.trm.TrmMeMainImpl;
import com.ibm.ws.sib.trm.contact.BridgeNeighbour;
import com.ibm.ws.sib.trm.links.LinkChangeListener;
import com.ibm.ws.sib.trm.links.LinkException;
import com.ibm.ws.sib.trm.links.LinkManager;
import com.ibm.ws.sib.trm.links.LinkSelection;
import com.ibm.ws.sib.trm.topology.MessagingEngine;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;

public final class LinkManagerImpl
implements LinkManager {
    public static final String $ssccid = "@(#) 1.14 SIB/ws/code/sib.trm.impl/src/com/ibm/ws/sib/trm/links/LinkManagerImpl.java, SIB.trm, WAS602.SIB, o0610.11 05/02/23 09:13:02 [3/13/06 13:39:08]";
    private static final String className = LinkManagerImpl.class.getName();
    private static final TraceComponent tc = SibTr.register((String)className, (String)"SIBTrm", (String)"com.ibm.ws.sib.trm.CWSITMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.trm.CWSITMessages");
    private TrmMeMainImpl meMain;
    private LinkChangeListener linkChangeListener;

    public LinkManagerImpl(TrmMeMainImpl trmMeMainImpl) {
        this.meMain = trmMeMainImpl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void register(SIBUuid12 sIBUuid12) throws LinkException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"register");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("linkUuid=" + sIBUuid12));
        }
        SIBUuid8 sIBUuid8 = null;
        if (this.meMain.getMQLinkManager().isDefined(sIBUuid12)) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Registering an MQ link");
            }
        } else {
            BridgeNeighbour bridgeNeighbour;
            if (!this.meMain.getInterBusLinkManager().isDefined(sIBUuid12)) throw new LinkException(nls.getFormattedMessage("UNDEFINED_CWSIT0077", new Object[]{sIBUuid12.toString()}, null));
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Registering an inter-bus link");
            }
            if ((bridgeNeighbour = this.meMain.getNeighbourhood().getBridge(sIBUuid12)) != null) {
                if (!bridgeNeighbour.isStarted()) {
                    throw new LinkException(nls.getFormattedMessage("NOT_STARTED_CWSIT0078", new Object[]{sIBUuid12.toString()}, null));
                }
                if (!bridgeNeighbour.isConnected()) {
                    throw new LinkException(nls.getFormattedMessage("NOT_ACTIVE_CWSIT0079", new Object[]{sIBUuid12.toString()}, null));
                }
                MessagingEngine messagingEngine = bridgeNeighbour.getMessagingEngine();
                if (messagingEngine != null) {
                    sIBUuid8 = messagingEngine.getUuid();
                }
            } else {
                if (!tc.isDebugEnabled()) throw new IllegalStateException(nls.getFormattedMessage("NEIGHBOUR_NOT_FOUND_CWSIT0082", new Object[]{sIBUuid12.toString()}, null));
                SibTr.debug((TraceComponent)tc, (String)"*** Could not find neighbour!");
                throw new IllegalStateException(nls.getFormattedMessage("NEIGHBOUR_NOT_FOUND_CWSIT0082", new Object[]{sIBUuid12.toString()}, null));
            }
        }
        this.meMain.getWlmManager().registerLink(sIBUuid12, sIBUuid8);
        if (!tc.isEntryEnabled()) return;
        SibTr.exit((TraceComponent)tc, (String)"register");
    }

    public void deregister(SIBUuid12 sIBUuid12) throws LinkException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deregister");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("linkUuid=" + sIBUuid12));
        }
        if (this.meMain.getMQLinkManager().isDefined(sIBUuid12)) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Deregistering an MQ link");
            }
        } else if (this.meMain.getInterBusLinkManager().isDefined(sIBUuid12)) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Deregistering an inter-bus link");
            }
        } else {
            throw new LinkException(nls.getFormattedMessage("UNDEFINED_CWSIT0077", new Object[]{sIBUuid12.toString()}, null));
        }
        this.meMain.getWlmManager().deregisterLink(sIBUuid12);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deregister");
        }
    }

    public LinkSelection select(SIBUuid12 sIBUuid12) throws LinkException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"select");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("linkUuid=" + sIBUuid12));
        }
        LinkSelection linkSelection = this.meMain.getWlmManager().selectLink(sIBUuid12);
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("rc=" + linkSelection));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"select");
        }
        return linkSelection;
    }

    public void setChangeListener(LinkChangeListener linkChangeListener) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setChangeListener");
        }
        this.meMain.getWlmManager().setLinkChangeListener(linkChangeListener);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setChangeListener");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source Info: @(#) 1.14 SIB/ws/code/sib.trm.impl/src/com/ibm/ws/sib/trm/links/LinkManagerImpl.java, SIB.trm, WAS602.SIB, o0610.11 05/02/23 09:13:02 [3/13/06 13:39:08]");
        }
    }
}

