/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.trm.contact;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.Alarm;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.MEConnection;
import com.ibm.ws.sib.trm.TrmMeMainImpl;
import com.ibm.ws.sib.trm.client.Utils;
import com.ibm.ws.sib.trm.contact.Bridge;
import com.ibm.ws.sib.trm.contact.BridgeNeighbour;
import com.ibm.ws.sib.trm.contact.CommsErrorListener;
import com.ibm.ws.sib.trm.contact.Connect;
import com.ibm.ws.sib.trm.contact.ConnectNeighbour;
import com.ibm.ws.sib.trm.contact.Link;
import com.ibm.ws.sib.trm.contact.LinkNeighbour;
import com.ibm.ws.sib.trm.contact.Neighbour;
import com.ibm.ws.sib.trm.general.CommsType;
import com.ibm.ws.sib.trm.general.ServiceThread;
import com.ibm.ws.sib.trm.general.thread.Directable;
import com.ibm.ws.sib.trm.status.BridgeStatus;
import com.ibm.ws.sib.trm.status.BridgeStatusComparator;
import com.ibm.ws.sib.trm.status.ConnectionStatus;
import com.ibm.ws.sib.trm.status.ConnectionStatusComparator;
import com.ibm.ws.sib.trm.status.EngineStatus;
import com.ibm.ws.sib.trm.status.LinkStatus;
import com.ibm.ws.sib.trm.status.LinkStatusComparator;
import com.ibm.ws.sib.trm.status.Status;
import com.ibm.ws.sib.trm.topology.MessagingEngine;
import com.ibm.ws.sib.trm.topology.Receiver;
import com.ibm.ws.sib.trm.topology.TopologyManager;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public final class Neighbourhood
implements AlarmListener,
Directable,
CommsErrorListener {
    public static final String $ssccid = "@(#) 1.75 SIB/ws/code/sib.trm.impl/src/com/ibm/ws/sib/trm/contact/Neighbourhood.java, SIB.trm, WAS602.SIB, o0610.11 05/02/23 09:11:01 [3/13/06 13:39:07]";
    private static final String className = Neighbourhood.class.getName();
    private static final TraceComponent tc = SibTr.register((String)className, (String)"SIBTrm", (String)"com.ibm.ws.sib.trm.CWSITMessages");
    private ServiceThread serviceThread;
    private TopologyManager topologyManager;
    private TrmMeMainImpl meMain;
    private Set neighbours = new HashSet();
    private Connect connect;
    private Link link;
    private Bridge bridge;
    private int delay = 0;
    static final String trmRetry = "sib.trm.retry";
    private volatile Alarm alarm = null;
    static final String ls;

    public Neighbourhood(TrmMeMainImpl trmMeMainImpl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"Neighbourhood");
        }
        this.meMain = trmMeMainImpl;
        this.serviceThread = this.meMain.getServiceThread();
        this.topologyManager = this.meMain.getTopologyManager();
        this.connect = new Connect(this.meMain);
        this.link = new Link(this.meMain);
        this.bridge = new Bridge(this.meMain);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"Neighbourhood");
        }
    }

    public Set getNeighbours() {
        return this.neighbours;
    }

    public void start() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"start");
        }
        this.delay = new Integer(this.meMain.getTrmProperty(trmRetry, "30")) * 1000;
        this.startReceiver();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"start");
        }
    }

    public void stop() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"stop");
        }
        Iterator iterator = this.neighbours.iterator();
        while (iterator.hasNext()) {
            Neighbour neighbour = (Neighbour)iterator.next();
            this.stopNeighbour(neighbour);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"stop");
        }
    }

    public void startNeighbour(Neighbour neighbour) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"startNeighbour");
        }
        neighbour.start();
        this.scan();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"startNeighbour");
        }
    }

    public void stopNeighbour(Neighbour neighbour) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"stopNeighbour");
        }
        neighbour.stop();
        this.deactivateNeighbour(neighbour);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"stopNeighbour");
        }
    }

    public void deactivateNeighbour(Neighbour neighbour) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deactivateNeighbour");
        }
        this.serviceThread.put(this, new WorkItem("_deactivateNeighbour", new Object[]{neighbour}));
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deactivateNeighbour");
        }
    }

    public void _deactivateNeighbour(Object object) {
        Neighbour neighbour;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"_deactivateNeighbour");
        }
        if ((neighbour = (Neighbour)object).isActive()) {
            try {
                this.topologyManager.deactivate(neighbour);
                neighbour.getMEConnection().close();
            }
            catch (Exception exception) {
                SibTr.exception((TraceComponent)tc, (Exception)exception);
            }
            neighbour.setInactive();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"_deactivateNeighbour");
        }
    }

    public synchronized void remove(Neighbour neighbour) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"remove");
        }
        HashSet hashSet = (HashSet)((HashSet)this.neighbours).clone();
        hashSet.remove(neighbour);
        this.neighbours = hashSet;
        this.stopNeighbour(neighbour);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"remove");
        }
    }

    public synchronized void addNeighbour(Neighbour neighbour) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addNeighbour");
        }
        HashSet hashSet = (HashSet)((HashSet)this.neighbours).clone();
        hashSet.add(neighbour);
        this.neighbours = hashSet;
        this.scan();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addNeighbour");
        }
    }

    public void scan() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"scan");
        }
        this.serviceThread.put(this, new WorkItem("_scan"));
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"scan");
        }
    }

    public void _scan() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"_scan");
        }
        long l = System.currentTimeMillis();
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("current time=" + l));
        }
        Iterator iterator = this.neighbours.iterator();
        while (iterator.hasNext()) {
            Neighbour neighbour = (Neighbour)iterator.next();
            if (!neighbour.isStarted() || neighbour.isActive() || neighbour.getLastAttemptTime() + (long)this.delay > l) continue;
            if (neighbour.getType() == CommsType.CONNECTION) {
                this.connect.contact((ConnectNeighbour)neighbour);
                continue;
            }
            if (neighbour.getType() == CommsType.LINK) {
                if (((LinkNeighbour)neighbour).getChain() == null) continue;
                this.link.contact((LinkNeighbour)neighbour);
                continue;
            }
            if (neighbour.getType() != CommsType.BRIDGE || ((BridgeNeighbour)neighbour).getBootstrapEPs() == null) continue;
            this.bridge.contact((BridgeNeighbour)neighbour);
        }
        boolean bl = false;
        iterator = this.neighbours.iterator();
        while (iterator.hasNext() && !bl) {
            Neighbour neighbour = (Neighbour)iterator.next();
            if (!neighbour.isStarted()) continue;
            if (neighbour.getType() == CommsType.CONNECTION) {
                bl = !neighbour.isActive();
                continue;
            }
            if (neighbour.getType() == CommsType.LINK) {
                bl = ((LinkNeighbour)neighbour).getChain() != null && !neighbour.isActive();
                continue;
            }
            if (neighbour.getType() != CommsType.BRIDGE) continue;
            bl = ((BridgeNeighbour)neighbour).getBootstrapEPs() != null && !neighbour.isActive();
        }
        if (bl && this.alarm == null) {
            this.alarm = AlarmManager.createDeferrable((long)this.delay, (AlarmListener)this);
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)(this.delay / 1000 + " second timer started"));
            }
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("Neighbours:" + ls + this.dump()));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"_scan");
        }
    }

    public void alarm(Object object) {
        SibTr.push((Object)this.meMain.getMessagingEngine());
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"alarm");
        }
        this.alarm = null;
        this.serviceThread.put(this, new WorkItem("_scan"));
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"alarm");
        }
        SibTr.pop();
    }

    public void checkReachability(Neighbour neighbour, MEConnection mEConnection) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkReachability");
        }
        this.serviceThread.put(this, new WorkItem("_checkReachability", new Object[]{neighbour, mEConnection}));
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkReachability");
        }
    }

    public void _checkReachability(Object object, Object object2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"_checkReachability");
        }
        this.topologyManager.checkReachability((Neighbour)object, (MEConnection)object2);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"_checkReachability");
        }
    }

    public void topologyChange(Neighbour neighbour) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"topologyChange");
        }
        this.serviceThread.put(this, new WorkItem("_topologyChange", new Object[]{neighbour}));
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"topologyChange");
        }
    }

    public void _topologyChange(Object object) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"_topologyChange");
        }
        this.topologyManager.topologyChange((Neighbour)object);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"_topologyChange");
        }
    }

    private void startReceiver() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"startReceiver");
        }
        this.serviceThread.put(this, new WorkItem("_startReceiver"));
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"startReceiver");
        }
    }

    public void _startReceiver() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"_startReceiver");
        }
        new Receiver(this.meMain).start();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"_startReceiver");
        }
    }

    public ConnectNeighbour getConnect(String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getConnect");
        }
        ConnectNeighbour connectNeighbour = null;
        Iterator iterator = this.neighbours.iterator();
        while (iterator.hasNext() && connectNeighbour == null) {
            ConnectNeighbour connectNeighbour2;
            Neighbour neighbour = (Neighbour)iterator.next();
            if (neighbour.getType() != CommsType.CONNECTION || !(connectNeighbour2 = (ConnectNeighbour)neighbour).getName().equals(string)) continue;
            connectNeighbour = connectNeighbour2;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getConnect");
        }
        return connectNeighbour;
    }

    public LinkNeighbour getLink(String string, String string2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getLink");
        }
        LinkNeighbour linkNeighbour = null;
        Iterator iterator = this.neighbours.iterator();
        while (iterator.hasNext() && linkNeighbour == null) {
            LinkNeighbour linkNeighbour2;
            Neighbour neighbour = (Neighbour)iterator.next();
            if (neighbour.getType() != CommsType.LINK || !(linkNeighbour2 = (LinkNeighbour)neighbour).getName().equals(string) || !linkNeighbour2.getSubnet().equals(string2)) continue;
            linkNeighbour = linkNeighbour2;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getLink");
        }
        return linkNeighbour;
    }

    public BridgeNeighbour getBridge(String string, String string2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getBridge");
        }
        BridgeNeighbour bridgeNeighbour = null;
        Iterator iterator = this.neighbours.iterator();
        while (iterator.hasNext() && bridgeNeighbour == null) {
            BridgeNeighbour bridgeNeighbour2;
            Neighbour neighbour = (Neighbour)iterator.next();
            if (neighbour.getType() != CommsType.BRIDGE || !(bridgeNeighbour2 = (BridgeNeighbour)neighbour).getLink().equals(string) || !bridgeNeighbour2.getBus().equals(string2)) continue;
            bridgeNeighbour = bridgeNeighbour2;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getBridge");
        }
        return bridgeNeighbour;
    }

    public BridgeNeighbour getBridge(SIBUuid12 sIBUuid12) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getBridge");
        }
        BridgeNeighbour bridgeNeighbour = null;
        Iterator iterator = this.neighbours.iterator();
        while (iterator.hasNext() && bridgeNeighbour == null) {
            BridgeNeighbour bridgeNeighbour2;
            Neighbour neighbour = (Neighbour)iterator.next();
            if (neighbour.getType() != CommsType.BRIDGE || !(bridgeNeighbour2 = (BridgeNeighbour)neighbour).getUuid().equals((Object)sIBUuid12)) continue;
            bridgeNeighbour = bridgeNeighbour2;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getBridge");
        }
        return bridgeNeighbour;
    }

    public Neighbour getNeighbour(MEConnection mEConnection) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getNeighbour");
        }
        Neighbour neighbour = null;
        Iterator iterator = this.neighbours.iterator();
        while (iterator.hasNext() && neighbour == null) {
            Neighbour neighbour2 = (Neighbour)iterator.next();
            if (neighbour2.getMEConnection() != mEConnection) continue;
            neighbour = neighbour2;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getNeighbour");
        }
        return neighbour;
    }

    public Neighbour getNeighbour(MessagingEngine messagingEngine) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getNeighbour");
        }
        Neighbour neighbour = null;
        Iterator iterator = this.neighbours.iterator();
        while (iterator.hasNext() && neighbour == null) {
            Neighbour neighbour2 = (Neighbour)iterator.next();
            MessagingEngine messagingEngine2 = neighbour2.getMessagingEngine();
            if (messagingEngine2 == null || !messagingEngine2.equals(messagingEngine)) continue;
            neighbour = neighbour2;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getNeighbour");
        }
        return neighbour;
    }

    public List getConnected() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getConnected");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = this.neighbours.iterator();
        while (iterator.hasNext()) {
            Neighbour neighbour = (Neighbour)iterator.next();
            if (neighbour.getType() != CommsType.CONNECTION) continue;
            arrayList.add(neighbour.getName());
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getConnected");
        }
        return arrayList;
    }

    public List getLinked() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getLinked");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = this.neighbours.iterator();
        while (iterator.hasNext()) {
            Neighbour neighbour = (Neighbour)iterator.next();
            if (neighbour.getType() != CommsType.LINK) continue;
            arrayList.add(neighbour.getName());
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getLinked");
        }
        return arrayList;
    }

    public void error(MEConnection mEConnection, Throwable throwable) {
        Neighbour neighbour;
        SibTr.push((Object)this.meMain.getMessagingEngine());
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"error");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("mec=" + mEConnection));
            SibTr.exception((TraceComponent)tc, (Throwable)throwable);
        }
        if ((neighbour = this.getNeighbour(mEConnection)) != null) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)Utils.commsFailure((String)neighbour.toShortString()));
            }
            neighbour.failed();
            this.deactivateNeighbour(neighbour);
            this.scan();
        } else if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"No matchng neighbour found in neighbourhood!");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"error");
        }
        SibTr.pop();
    }

    public void direct(Object object) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"direct");
        }
        WorkItem workItem = (WorkItem)object;
        try {
            workItem.method.invoke((Object)this, workItem.args);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)(className + ".direct"), (String)"3", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)exception);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"direct");
        }
    }

    public EngineStatus getStatus() {
        Object object;
        Object object2;
        ConnectionStatus[] connectionStatusArray;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getStatus");
        }
        EngineStatus engineStatus = new EngineStatus();
        HashSet<Object> hashSet = new HashSet<Object>();
        HashSet<Object> hashSet2 = new HashSet<Object>();
        HashSet<Object> hashSet3 = new HashSet<Object>();
        Iterator iterator = this.neighbours.iterator();
        while (iterator.hasNext()) {
            connectionStatusArray = (ConnectionStatus[])iterator.next();
            object2 = null;
            if (connectionStatusArray.getType() == CommsType.CONNECTION) {
                object2 = new ConnectionStatus();
            } else if (connectionStatusArray.getType() == CommsType.LINK) {
                object2 = new LinkStatus();
                ((LinkStatus)object2).setRemoteSubnetName(((LinkNeighbour)connectionStatusArray).getSubnet());
            } else if (connectionStatusArray.getType() == CommsType.BRIDGE) {
                object2 = new BridgeStatus();
                ((BridgeStatus)object2).setRemoteBusName(((BridgeNeighbour)connectionStatusArray).getBus());
                ((BridgeStatus)object2).setLinkName(((BridgeNeighbour)connectionStatusArray).getLink());
            }
            ((Status)object2).setRemoteEngineName(connectionStatusArray.getName());
            object = connectionStatusArray.getMessagingEngine();
            if (object != null) {
                ((Status)object2).setRemoteEngineUuid(((MessagingEngine)object).getUuid());
            }
            if (connectionStatusArray.isStarted()) {
                ((Status)object2).setTimeStarted(connectionStatusArray.getTimeStarted());
                if (connectionStatusArray.isActive()) {
                    ((Status)object2).setStatus("Started ok");
                    ((Status)object2).setMEConnection(connectionStatusArray.getMEConnection());
                } else {
                    ((Status)object2).setStatus("Started nok");
                    ((Status)object2).setTimeFailed(connectionStatusArray.getTimeFailed());
                }
            } else {
                ((Status)object2).setStatus("Stopped");
                ((Status)object2).setTimeStopped(connectionStatusArray.getTimeStopped());
            }
            if (connectionStatusArray.getType() == CommsType.CONNECTION) {
                hashSet.add(object2);
                continue;
            }
            if (connectionStatusArray.getType() == CommsType.LINK) {
                hashSet2.add(object2);
                continue;
            }
            if (connectionStatusArray.getType() != CommsType.BRIDGE) continue;
            hashSet3.add(object2);
        }
        connectionStatusArray = new ConnectionStatus[hashSet.size()];
        object2 = new LinkStatus[hashSet2.size()];
        object = new BridgeStatus[hashSet3.size()];
        int n = 0;
        iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            connectionStatusArray[n++] = (ConnectionStatus)iterator.next();
        }
        n = 0;
        iterator = hashSet2.iterator();
        while (iterator.hasNext()) {
            object2[n++] = (LinkStatus)iterator.next();
        }
        n = 0;
        iterator = hashSet3.iterator();
        while (iterator.hasNext()) {
            object[n++] = (BridgeStatus)iterator.next();
        }
        Arrays.sort(connectionStatusArray, new ConnectionStatusComparator());
        Arrays.sort(object2, new LinkStatusComparator());
        Arrays.sort(object, new BridgeStatusComparator());
        engineStatus.setConnections(connectionStatusArray);
        engineStatus.setLinks((LinkStatus[])object2);
        engineStatus.setBridges((BridgeStatus[])object);
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)(System.getProperty("line.separator") + engineStatus.toString()));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getStatus");
        }
        return engineStatus;
    }

    public String dump() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(ls + "======================== Neighbourhood =======================" + ls);
        Iterator iterator = this.neighbours.iterator();
        while (iterator.hasNext()) {
            Neighbour neighbour = (Neighbour)iterator.next();
            stringBuffer.append(ls + neighbour.toString());
        }
        stringBuffer.append(ls);
        return stringBuffer.toString();
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#) 1.75 SIB/ws/code/sib.trm.impl/src/com/ibm/ws/sib/trm/contact/Neighbourhood.java, SIB.trm, WAS602.SIB, o0610.11 05/02/23 09:11:01 [3/13/06 13:39:07]");
        }
        ls = System.getProperty("line.separator");
    }

    private class WorkItem {
        Method method;
        Object[] args;
        private Class klass = class$com$ibm$ws$sib$trm$contact$Neighbourhood == null ? (class$com$ibm$ws$sib$trm$contact$Neighbourhood = Neighbourhood.class$("com.ibm.ws.sib.trm.contact.Neighbourhood")) : class$com$ibm$ws$sib$trm$contact$Neighbourhood;

        WorkItem(String string, Object[] objectArray) {
            int n = objectArray.length;
            Class[] classArray = new Class[n];
            Object object = new Object();
            for (int i = 0; i < n; ++i) {
                classArray[i] = object.getClass();
            }
            this.method = this.getMethod(string, classArray);
            this.args = objectArray;
        }

        WorkItem(String string) {
            this.method = this.getMethod(string, new Class[0]);
            this.args = new Object[0];
        }

        private Method getMethod(String string, Class[] classArray) {
            Method method = null;
            try {
                method = this.klass.getMethod(string, classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                FFDCFilter.processException((Throwable)noSuchMethodException, (String)(className + ".getMethod"), (String)"1", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)noSuchMethodException);
            }
            catch (SecurityException securityException) {
                FFDCFilter.processException((Throwable)securityException, (String)(className + ".getMethod"), (String)"2", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)securityException);
            }
            return method;
        }
    }
}

