/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.trm;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.sibresources.SIBus;
import com.ibm.websphere.security.auth.CredentialDestroyedException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.service.Server;
import com.ibm.ws.security.auth.j2c.WSDefaultPrincipalMapping;
import com.ibm.ws.security.cred.AuthDataCredential;
import com.ibm.ws.sib.admin.JsAdminService;
import com.ibm.ws.sib.admin.JsBus;
import com.ibm.ws.sib.admin.JsHealthState;
import com.ibm.ws.sib.admin.JsMessagingEngine;
import com.ibm.ws.sib.admin.RuntimeEventListener;
import com.ibm.ws.sib.processor.SIMPFactory;
import com.ibm.ws.sib.trm.TrmMeMain;
import com.ibm.ws.sib.trm.TrmMeMainClient;
import com.ibm.ws.sib.trm.contact.CommsErrorListener;
import com.ibm.ws.sib.trm.contact.Neighbourhood;
import com.ibm.ws.sib.trm.dlm.DestinationLocationManager;
import com.ibm.ws.sib.trm.general.ServiceThread;
import com.ibm.ws.sib.trm.general.TrmDiagnostics;
import com.ibm.ws.sib.trm.links.LinkManager;
import com.ibm.ws.sib.trm.links.LinkManagerImpl;
import com.ibm.ws.sib.trm.links.ibl.InterBusLinkManager;
import com.ibm.ws.sib.trm.links.ibl.InterBusLinkManagerImpl;
import com.ibm.ws.sib.trm.links.mql.MQLinkManager;
import com.ibm.ws.sib.trm.links.mql.MQLinkManagerImpl;
import com.ibm.ws.sib.trm.status.EngineStatus;
import com.ibm.ws.sib.trm.topology.RoutingManager;
import com.ibm.ws.sib.trm.topology.RoutingManagerImpl;
import com.ibm.ws.sib.trm.topology.TopologyManager;
import com.ibm.ws.sib.trm.wlm.server.Manager;
import com.ibm.ws.sib.utils.Runtime;
import com.ibm.ws.sib.utils.RuntimeInfo;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.FormattedWriter;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.security.auth.login.CredentialExpiredException;
import javax.security.auth.login.LoginException;

public final class TrmMeMainImpl
implements TrmMeMain,
TrmMeMainClient {
    public static final String $ssccid = "@(#) 1.140 SIB/ws/code/sib.trm.impl/src/com/ibm/ws/sib/trm/TrmMeMainImpl.java, SIB.trm, WAS602.SIB, o0610.11 05/05/09 13:52:31 [3/13/06 13:39:05]";
    private static final String className = TrmMeMainImpl.class.getName();
    private static final TraceComponent tc = SibTr.register((String)className, (String)"SIBTrm", (String)"com.ibm.ws.sib.trm.CWSITMessages");
    private static final String ATTRIBUTE_SUBNET = "subNet";
    private static final String ATTRIBUTE_CUSTOM_GROUPS = "customGroup";
    private static final String ATTRIBUTE_TRANSPORT_CHAIN = "protocol";
    private static final String ATTRIBUTE_INTERENGINEAUTHALIAS = "interEngineAuthAlias";
    private boolean started = false;
    private JsMessagingEngine jsme = null;
    private Neighbourhood neighbourhood = null;
    private ServiceThread serviceThread = null;
    private TopologyManager topologyManager = null;
    private RoutingManager routingManager = null;
    private Manager wlmManager = null;
    private Properties customProperties = new Properties();
    private String bus = "";
    private String subnet = "";
    private String name = "";
    private boolean recovery = false;
    private RuntimeEventListener runtimeEventListener = null;
    private boolean intraBusAuthAlias = true;
    private String userid = "";
    private String password = "";
    private String transportChain;
    private Set customGroups = new HashSet();
    private LinkManagerImpl linkManagerImpl;
    private MQLinkManagerImpl mqLinkManagerImpl;
    private InterBusLinkManagerImpl interBusLinkManagerImpl;
    private static final String TAG_TRM = "trm";

    public void initialize(JsMessagingEngine jsMessagingEngine) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"initialize");
        }
        this.jsme = jsMessagingEngine;
        this.bus = this.jsme.getBusName();
        this.name = this.jsme.getName();
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("bus=" + this.bus + " name=" + this.name));
        }
        TrmDiagnostics.initialise();
        this.linkManagerImpl = new LinkManagerImpl(this);
        this.mqLinkManagerImpl = new MQLinkManagerImpl(this);
        this.interBusLinkManagerImpl = new InterBusLinkManagerImpl(this);
        this.topologyManager = new TopologyManager(this);
        this.routingManager = new RoutingManagerImpl(this);
        this.serviceThread = new ServiceThread(this);
        this.neighbourhood = new Neighbourhood(this);
        this.wlmManager = new Manager(this);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"initialize");
        }
    }

    public void start(int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"start", (Object)("mode=" + n));
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("bus=" + this.bus + " subnet=" + this.subnet + " name=" + this.name));
        }
        if ((n & 2) == 2) {
            this.recovery = true;
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("recovery=" + this.recovery));
        }
        this.processConfig();
        SIMPFactory sIMPFactory = (SIMPFactory)this.jsme.getMessageProcessor();
        this.topologyManager.setListener(sIMPFactory.getTopologyListener());
        if (!this.serviceThread.isAlive()) {
            this.serviceThread.start();
        }
        this.neighbourhood.start();
        this.wlmManager.start();
        this.started = true;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"start");
        }
    }

    public void stop(int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"stop", (Object)("mode=" + n));
        }
        this.started = false;
        this.wlmManager.stop();
        if (this.neighbourhood != null) {
            this.neighbourhood.stop();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"stop");
        }
    }

    public void destroy() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"destroy");
        }
        this.neighbourhood = null;
        if (this.serviceThread != null) {
            this.serviceThread.end();
        }
        this.serviceThread = null;
        this.routingManager = null;
        this.topologyManager = null;
        this.linkManagerImpl = null;
        this.mqLinkManagerImpl = null;
        this.interBusLinkManagerImpl = null;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"destroy");
        }
    }

    public void setAttribute(String string, String string2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setAttribute");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("Attribute=" + string + " Value=" + string2));
        }
        if (string.equals(ATTRIBUTE_SUBNET)) {
            this.subnet = string2;
        } else if (string.equals(ATTRIBUTE_CUSTOM_GROUPS)) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "[, ]");
            while (stringTokenizer.hasMoreTokens()) {
                this.customGroups.add(stringTokenizer.nextToken());
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setAttribute");
        }
    }

    public void setCustomProperty(String string, String string2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setCustomProperty");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("Property=" + string + " Value=" + string2));
        }
        this.customProperties.put(string, string2);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setCustomProperty");
        }
    }

    public void serverStarted() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"serverStarted");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"serverStarted");
        }
    }

    public void serverStopping() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"serverStopping");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"serverStopping");
        }
    }

    public void busReloaded(SIBus sIBus, boolean bl, boolean bl2, boolean bl3) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"busReloaded");
        }
        if (bl) {
            this.processConfig();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"busReloaded");
        }
    }

    public void engineReloaded(JsMessagingEngine jsMessagingEngine) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"engineReloaded");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"engineReloaded");
        }
    }

    public JsHealthState getHealthState() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getHealthState");
        }
        JsHealthState jsHealthState = !this.started ? JsHealthState.getOK() : (this.serviceThread.isAlive() ? JsHealthState.getOK() : JsHealthState.getLocalError());
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("health=" + jsHealthState));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getHealthState");
        }
        return jsHealthState;
    }

    public void setRuntimeEventListener(RuntimeEventListener runtimeEventListener) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setRuntimeEventListener");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("runtimeEventListener=" + runtimeEventListener));
        }
        this.runtimeEventListener = runtimeEventListener;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setRuntimeEventListener");
        }
    }

    public RuntimeEventListener getRuntimeEventListener() {
        return this.runtimeEventListener;
    }

    private void processConfig() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processConfig");
        }
        String string = this.jsme.getBus().getAttribute(ATTRIBUTE_INTERENGINEAUTHALIAS);
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("interEngineAuthAlias=" + string));
        }
        if (string != null && !string.equals("")) {
            AuthDataCredential authDataCredential = null;
            try {
                authDataCredential = WSDefaultPrincipalMapping.getAuthData((String)string);
            }
            catch (LoginException loginException) {
                FFDCFilter.processException((Throwable)loginException, (String)(className + ".processConfig"), (String)"1", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)loginException);
            }
            if (authDataCredential != null && authDataCredential.getStatus() == 0) {
                try {
                    this.userid = authDataCredential.getUserName();
                    this.password = authDataCredential.getPassword();
                }
                catch (CredentialExpiredException credentialExpiredException) {
                    FFDCFilter.processException((Throwable)credentialExpiredException, (String)(className + ".processConfig"), (String)"2", (Object)this);
                    SibTr.warning((TraceComponent)tc, (String)"UNABLE_TO_OBTAIN_AUTHDATA_CWSIT0072", (Object)new Object[]{string});
                }
                catch (CredentialDestroyedException credentialDestroyedException) {
                    FFDCFilter.processException((Throwable)credentialDestroyedException, (String)(className + ".processConfig"), (String)"3", (Object)this);
                    SibTr.warning((TraceComponent)tc, (String)"UNABLE_TO_OBTAIN_AUTHDATA_CWSIT0072", (Object)new Object[]{string});
                }
            } else {
                SibTr.warning((TraceComponent)tc, (String)"UNABLE_TO_OBTAIN_AUTHDATA_CWSIT0072", (Object)new Object[]{string});
            }
        } else {
            this.intraBusAuthAlias = false;
            if (((JsBus)this.jsme.getBus()).isSecure()) {
                JsAdminService jsAdminService = JsAdminService.getInstance();
                if (!jsAdminService.isStandaloneServer()) {
                    SibTr.warning((TraceComponent)tc, (String)"NO_AUTHALIAS_CWSIT0073");
                } else if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"No Intra-Bus authentication alias defined, but we don't need it because this is single server.");
                }
            }
        }
        this.transportChain = this.jsme.getBus().getAttribute(ATTRIBUTE_TRANSPORT_CHAIN);
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("protocol=" + this.transportChain));
        }
        if (this.transportChain == null || this.transportChain.equals("")) {
            this.transportChain = "InboundBasicMessaging";
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Using default transport chain " + this.transportChain + " for me-me connections"));
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processConfig");
        }
    }

    public CommsErrorListener getCommsErrorListener() {
        return this.neighbourhood;
    }

    public RoutingManager getRoutingManager() {
        return this.routingManager;
    }

    public DestinationLocationManager getDestinationLocationManager() {
        return this.wlmManager;
    }

    public SIBUuid8 getMeUuid(String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMeUuid");
        }
        SIBUuid8 sIBUuid8 = null;
        if (this.started) {
            sIBUuid8 = this.wlmManager.resolve(this.bus, string);
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("rc=" + sIBUuid8));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getMeUuid");
        }
        return sIBUuid8;
    }

    public EngineStatus getStatus() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getStatus");
        }
        EngineStatus engineStatus = null;
        if (this.started) {
            engineStatus = this.neighbourhood.getStatus();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getStatus");
        }
        return engineStatus;
    }

    public boolean isStarted() {
        return this.started;
    }

    public LinkManager getLinkManager() {
        return this.linkManagerImpl;
    }

    public InterBusLinkManager getInterBusLinkManager() {
        return this.interBusLinkManagerImpl;
    }

    public MQLinkManager getMQLinkManager() {
        return this.mqLinkManagerImpl;
    }

    public void dump(FormattedWriter formattedWriter, String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"dump");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("arg=" + string));
        }
        String string2 = this.dump();
        if (string.equalsIgnoreCase("trace") && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)string2);
        }
        try {
            formattedWriter.startTag(TAG_TRM);
            formattedWriter.indent();
            formattedWriter.newLine();
            formattedWriter.startComment();
            formattedWriter.indent();
            formattedWriter.newLine();
            formattedWriter.write(string2);
            formattedWriter.outdent();
            formattedWriter.newLine();
            formattedWriter.endComment();
            formattedWriter.outdent();
            formattedWriter.newLine();
            formattedWriter.endTag(TAG_TRM);
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)(className + ".processConfig"), (String)"4", (Object)this);
            try {
                formattedWriter.write((Throwable)iOException);
            }
            catch (Exception exception) {
                // empty catch block
            }
            SibTr.exception((TraceComponent)tc, (Exception)iOException);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"dump");
        }
    }

    public String dump() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"dump");
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.dumpNeighbourhood());
        stringBuffer.append(this.wlmManager.dump());
        String string = stringBuffer.toString();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"dump");
        }
        return string;
    }

    public String dump(Map map) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"dump");
        }
        String string = this.wlmManager.dump(map);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"dump");
        }
        return string;
    }

    public String dumpNeighbourhood() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"dumpNeighbourhood");
        }
        String string = this.neighbourhood.dump();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"dumpNeighbourhood");
        }
        return string;
    }

    public String getBus() {
        return this.bus;
    }

    public String getSubnet() {
        return this.subnet;
    }

    public String getName() {
        return this.name;
    }

    public ServiceThread getServiceThread() {
        return this.serviceThread;
    }

    public JsMessagingEngine getMessagingEngine() {
        return this.jsme;
    }

    public Neighbourhood getNeighbourhood() {
        return this.neighbourhood;
    }

    public TopologyManager getTopologyManager() {
        return this.topologyManager;
    }

    public boolean isIntraBusAuthAlias() {
        return this.intraBusAuthAlias;
    }

    public String getUserid() {
        return this.userid;
    }

    public String getPassword() {
        return this.password;
    }

    public String getTransportChain() {
        return this.transportChain;
    }

    public SIBUuid8 getUuid() {
        return this.jsme.getUuid();
    }

    public String toShortString() {
        return this.bus + ":" + this.subnet + ":" + this.name;
    }

    public String getCluster() {
        String string = "";
        Server server = (Server)this.getService(Server.class);
        if (server != null) {
            string = server.getClusterName();
        }
        return string;
    }

    public String getNode() {
        String string = "";
        Server server = (Server)this.getService(Server.class);
        if (server != null) {
            string = server.getNodeName();
        }
        return string;
    }

    public String getServer() {
        String string = "";
        Server server = (Server)this.getService(Server.class);
        if (server != null) {
            string = server.getName();
        }
        return string;
    }

    public String[] getUserGroups() {
        return this.customGroups.toArray(new String[this.customGroups.size()]);
    }

    public Object getService(Class clazz) {
        return JsAdminService.getInstance().getService(clazz);
    }

    public Manager getWlmManager() {
        return this.wlmManager;
    }

    public String getTrmProperty(String string, String string2) {
        String string3;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTrmProperty");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("name=" + string + ",defValue=" + string2));
        }
        if ((string3 = this.customProperties.getProperty(string)) == null) {
            string3 = RuntimeInfo.getProperty((String)string);
        }
        if (string3 == null) {
            string3 = System.getProperty(string);
        }
        if (string3 == null) {
            string3 = string2;
        }
        if (string3 != string2) {
            Runtime.changedPropertyValue((String)string, (String)string3);
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("rc=" + string3));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getTrmProperty");
        }
        return string3;
    }

    public boolean inRecoveryMode() {
        return this.recovery;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source Info: @(#) 1.140 SIB/ws/code/sib.trm.impl/src/com/ibm/ws/sib/trm/TrmMeMainImpl.java, SIB.trm, WAS602.SIB, o0610.11 05/05/09 13:52:31 [3/13/06 13:39:05]");
        }
    }
}

