/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.security.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class TimedMap
implements Map {
    private static final long serialVersionUID = 4496813777386763606L;
    private static final TraceComponent _tc = SibTr.register((Class)TimedMap.class, null, null);
    private long _timeout;
    private Map _realMap = new HashMap();
    static /* synthetic */ Class class$com$ibm$ws$sib$security$impl$TimedMap$TimedValue;
    static /* synthetic */ Class class$com$ibm$ws$sib$security$impl$TimedMap$TimedMapEntry;

    public TimedMap(long l) {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"TimedMap", (Object)new Long(l));
        }
        this._timeout = l;
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"TimedMap", (Object)this);
        }
    }

    public Object get(Object object) {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"get", (Object)object);
        }
        TimedValue timedValue = (TimedValue)this._realMap.get(object);
        Object object2 = null;
        if (timedValue != null) {
            if (timedValue.hasExipred()) {
                this._realMap.remove(object);
                if (_tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)_tc, (String)("The value with the key " + object + " has expired"));
                }
            } else {
                object2 = timedValue.get();
            }
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"get", (Object)object2);
        }
        return object2;
    }

    public Object put(Object object, Object object2) {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"put", (Object)new Object[]{object, object2});
        }
        TimedValue timedValue = new TimedValue(object2, this._timeout);
        TimedValue timedValue2 = this._realMap.put(object, timedValue);
        Object object3 = null;
        if (timedValue2 != null && !timedValue2.hasExipred()) {
            object3 = timedValue2.get();
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"put", (Object)object3);
        }
        return object3;
    }

    public void putAll(Map map) {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"putAll", (Object)map);
        }
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            this.put(entry.getKey(), entry.getValue());
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"putAll");
        }
    }

    public Collection values() {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"values");
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(this._realMap.size());
        Iterator iterator = this._realMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            TimedValue timedValue = (TimedValue)entry.getValue();
            if (timedValue.hasExipred()) {
                iterator.remove();
                if (!_tc.isDebugEnabled()) continue;
                SibTr.debug((TraceComponent)_tc, (String)("The value with the key " + entry.getKey() + " has expired"));
                continue;
            }
            arrayList.add(timedValue.get());
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"values", arrayList);
        }
        return arrayList;
    }

    public Set entrySet() {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"entrySet");
        }
        Iterator iterator = this._realMap.entrySet().iterator();
        HashSet<TimedMapEntry> hashSet = new HashSet<TimedMapEntry>(this._realMap.size());
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            TimedValue timedValue = (TimedValue)entry.getValue();
            if (timedValue.hasExipred()) {
                iterator.remove();
                if (!_tc.isDebugEnabled()) continue;
                SibTr.debug((TraceComponent)_tc, (String)("The value with the key " + entry.getKey() + " has expired"));
                continue;
            }
            hashSet.add(new TimedMapEntry(entry.getKey(), this._timeout, timedValue));
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"entrySet", hashSet);
        }
        return hashSet;
    }

    public boolean containsValue(Object object) {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"containsValue", (Object)object);
        }
        this.purge();
        boolean bl = this._realMap.containsValue(new TimedValue(object, this._timeout));
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"containsValue", (Object)new Boolean(bl));
        }
        return bl;
    }

    public Object remove(Object object) {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"remove", (Object)object);
        }
        TimedValue timedValue = (TimedValue)this._realMap.remove(object);
        Object object2 = null;
        if (timedValue != null) {
            object2 = timedValue.get();
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"remove", (Object)object2);
        }
        return object2;
    }

    public void clear() {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"clear");
        }
        this._realMap.clear();
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"clear");
        }
    }

    public boolean containsKey(Object object) {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"containsKey", (Object)object);
        }
        this.purge();
        boolean bl = this._realMap.containsKey(object);
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"containsKey", (Object)new Boolean(bl));
        }
        return bl;
    }

    public boolean isEmpty() {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"isEmpty");
        }
        this.purge();
        boolean bl = this._realMap.isEmpty();
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"isEmpty", (Object)new Boolean(bl));
        }
        return bl;
    }

    public Set keySet() {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"keySet");
        }
        this.purge();
        Set set = this._realMap.keySet();
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"keySet", set);
        }
        return set;
    }

    public int size() {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"size");
        }
        this.purge();
        int n = this._realMap.size();
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"size", (Object)new Integer(n));
        }
        return n;
    }

    private void purge() {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"purge");
        }
        this.entrySet();
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"purge");
        }
    }

    public static final class TimedMapEntry
    implements Map.Entry {
        private Object _key;
        private TimedValue _value;
        private long _timeout;
        private static final int PRIME = 10003;
        private static final TraceComponent _tc2 = SibTr.register((Class)(class$com$ibm$ws$sib$security$impl$TimedMap$TimedMapEntry == null ? (class$com$ibm$ws$sib$security$impl$TimedMap$TimedMapEntry = TimedMap.class$("com.ibm.ws.sib.security.impl.TimedMap$TimedMapEntry")) : class$com$ibm$ws$sib$security$impl$TimedMap$TimedMapEntry), null, null);

        public TimedMapEntry(Object object, long l, TimedValue timedValue) {
            if (_tc2.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)_tc2, (String)"TimedMapEntry", (Object)new Object[]{object, new Long(l), timedValue});
            }
            this._key = object;
            this._value = timedValue;
            this._timeout = l;
            if (_tc2.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)_tc2, (String)"TimedMapEntry", (Object)this);
            }
        }

        public Object getKey() {
            if (_tc2.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)_tc2, (String)"getKey");
            }
            if (_tc2.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)_tc2, (String)"getKey", (Object)this._key);
            }
            return this._key;
        }

        public Object getValue() {
            if (_tc2.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)_tc2, (String)"getValue");
            }
            Object object = this._value.get();
            if (_tc2.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)_tc2, (String)"getValue", (Object)object);
            }
            return object;
        }

        public Object setValue(Object object) {
            if (_tc2.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)_tc2, (String)"setValue", (Object)object);
            }
            Object object2 = this._value.get();
            this._value.set(object, this._timeout);
            if (_tc2.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)_tc2, (String)"setValue", (Object)object2);
            }
            return object2;
        }

        public boolean equals(Object object) {
            TimedMapEntry timedMapEntry;
            if (object == null) {
                return false;
            }
            if (object == this) {
                return true;
            }
            if (object instanceof TimedMapEntry && this._key.equals((timedMapEntry = (TimedMapEntry)object).getKey())) {
                Object object2 = this._value.get();
                Object object3 = timedMapEntry._value.get();
                if (object2 == null && object3 == null) {
                    return true;
                }
                if (object2 == null || object3 == null) {
                    return false;
                }
                if (object2 == object3) {
                    return true;
                }
                return object2.equals(object3);
            }
            return false;
        }

        public int hashCode() {
            int n = this._key.hashCode();
            n = n * 10003 + this._value.hashCode();
            return n;
        }
    }

    private static final class TimedValue {
        private long _expireTime;
        private Object _value;
        private static final TraceComponent _tc2 = SibTr.register((Class)(class$com$ibm$ws$sib$security$impl$TimedMap$TimedValue == null ? (class$com$ibm$ws$sib$security$impl$TimedMap$TimedValue = TimedMap.class$("com.ibm.ws.sib.security.impl.TimedMap$TimedValue")) : class$com$ibm$ws$sib$security$impl$TimedMap$TimedValue), null, null);

        public TimedValue(Object object, long l) {
            if (_tc2.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)_tc2, (String)"TimedValue", (Object)new Object[]{object, new Long(l)});
            }
            this.set(object, l);
            if (_tc2.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)_tc2, (String)"TimedValue", (Object)this);
            }
        }

        public Object get() {
            if (_tc2.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)_tc2, (String)"get");
            }
            Object object = null;
            if (!this.hasExipred()) {
                object = this._value;
            }
            if (_tc2.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)_tc2, (String)"get", (Object)object);
            }
            return object;
        }

        public void set(Object object, long l) {
            if (_tc2.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)_tc2, (String)"set", (Object)new Object[]{object, new Long(l)});
            }
            this._value = object;
            this._expireTime = l + System.currentTimeMillis();
            if (_tc2.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)_tc2, (String)"set");
            }
        }

        public boolean hasExipred() {
            long l;
            boolean bl;
            if (_tc2.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)_tc2, (String)"hasExipred");
            }
            boolean bl2 = bl = (l = System.currentTimeMillis()) > this._expireTime;
            if (_tc2.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)_tc2, (String)"hasExipred", (Object)new Boolean(bl));
            }
            return bl;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (object == this) {
                return true;
            }
            if (object instanceof TimedValue) {
                return this._value.equals(((TimedValue)object)._value);
            }
            return false;
        }

        public int hashCode() {
            return this._value.hashCode();
        }
    }
}

