/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.security.context;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.sib.security.context.SecurityContextException;
import com.ibm.ws.sib.security.context.SecurityContextHelper;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.ws.threadContext.ThreadContext;
import com.ibm.ws.threadContext.ThreadContextImpl;
import javax.security.auth.AuthPermission;
import javax.security.auth.Subject;

public class SecurityContextHelperImpl
implements SecurityContextHelper {
    private static TraceComponent tc = SibTr.register((Class)SecurityContextHelperImpl.class, (String)"SIBSecurity", (String)"com.ibm.ws.sib.security.CWSIIMessages");
    private static TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.security.CWSIIMessages");
    private static final AuthPermission SET_CONTEXT_PERM = new AuthPermission("PlatformMessagingComponentSetContextPermission");
    private ThreadContext subjects = new ThreadContextImpl();
    private ContextManager contextMgr = null;

    public void pushRunAs(Subject subject) throws SecurityContextException {
        Object object;
        if (tc.isEntryEnabled()) {
            object = "<null>";
            if (subject != null) {
                object = "Subject hashcode=0x" + Integer.toHexString(subject.hashCode());
            }
            SibTr.entry((TraceComponent)tc, (String)"pushRunAs", (Object)object);
        }
        if ((object = System.getSecurityManager()) != null) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Performing Java 2 Security Permission Check ...");
                SibTr.debug((TraceComponent)tc, (String)("Expecting : " + SET_CONTEXT_PERM.toString()));
            }
            ((SecurityManager)object).checkPermission(SET_CONTEXT_PERM);
        }
        this.contextMgr = ContextManagerFactory.getInstance();
        try {
            Subject subject2 = this.contextMgr.pushInvocationSubject(subject);
            this.subjects.beginContext((Object)subject2);
        }
        catch (WSSecurityException wSSecurityException) {
            FFDCFilter.processException((Throwable)wSSecurityException, (String)"com.ibm.ws.sib.security.context.SecurityContextHelper.pushRunAs", (String)"1");
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"pushRunAs");
            }
            throw new SecurityContextException(wSSecurityException);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"pushRunAs");
        }
    }

    public Subject peekRunAs() throws SecurityContextException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"peekRunAs");
        }
        Subject subject = null;
        this.contextMgr = ContextManagerFactory.getInstance();
        try {
            subject = this.contextMgr.getInvocationSubject();
        }
        catch (WSSecurityException wSSecurityException) {
            FFDCFilter.processException((Throwable)wSSecurityException, (String)"com.ibm.ws.sib.security.context.SecurityContextHelper.peekRunAs", (String)"2");
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"peekRunAs");
            }
            throw new SecurityContextException(wSSecurityException);
        }
        if (tc.isEntryEnabled()) {
            String string = "<null>";
            if (subject != null) {
                string = "Subject hashcode=0x" + Integer.toHexString(subject.hashCode());
            }
            SibTr.exit((TraceComponent)tc, (String)"peekRunAs", (Object)string);
        }
        return subject;
    }

    public Subject popRunAs() throws SecurityContextException {
        Object object;
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"popRunAs");
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Performing Java 2 Security Permission Check ...");
                SibTr.debug((TraceComponent)tc, (String)("Expecting : " + SET_CONTEXT_PERM.toString()));
            }
            securityManager.checkPermission(SET_CONTEXT_PERM);
        }
        Subject subject = null;
        this.contextMgr = ContextManagerFactory.getInstance();
        try {
            object = (Subject)this.subjects.endContext();
            subject = this.contextMgr.pushInvocationSubject((Subject)object);
        }
        catch (WSSecurityException wSSecurityException) {
            FFDCFilter.processException((Throwable)wSSecurityException, (String)"com.ibm.ws.sib.security.context.SecurityContextHelper.popRunAs", (String)"3");
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"popRunAs");
            }
            throw new SecurityContextException(wSSecurityException);
        }
        if (tc.isEntryEnabled()) {
            object = "<null>";
            if (subject != null) {
                object = "Subject hashcode=0x" + Integer.toHexString(subject.hashCode());
            }
            SibTr.exit((TraceComponent)tc, (String)"popRunAs", (Object)object);
        }
        return subject;
    }
}

