/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.security.auth;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.security.auth.AuthUtilsImpl;
import com.ibm.ws.sib.security.auth.LocalAccessControl;
import com.ibm.ws.sib.security.auth.OperationType;
import com.ibm.ws.sib.security.auth.SIBAccessControl;
import com.ibm.ws.sib.security.auth.SIBAccessControlException;
import com.ibm.ws.sib.security.auth.TopicAuthorisations;
import com.ibm.ws.sib.utils.ras.SibTr;
import javax.security.auth.Subject;

public class SIBAccessControlImpl
implements SIBAccessControl {
    private static TraceComponent tc = SibTr.register((Class)SIBAccessControlImpl.class, (String)"SIBSecurity", (String)"com.ibm.ws.sib.security.CWSIIMessages");
    private static TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.security.CWSIIMessages");
    private AuthUtilsImpl authUtils = new AuthUtilsImpl();
    private String localBus = null;
    private boolean isBusSecure = true;
    private LocalAccessControl localCheck;

    SIBAccessControlImpl(String string) {
        this.localBus = string;
        this.isBusSecure = this.authUtils.isBusSecure(string);
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("Security for bus '" + string + "' is " + this.isBusSecure));
        }
        if (this.isBusSecure) {
            this.localCheck = new LocalAccessControl(string);
        }
    }

    public boolean checkBusAccess(Subject subject) throws SIBAccessControlException {
        String string;
        boolean bl = false;
        if (tc.isEntryEnabled()) {
            string = "<null>";
            if (subject != null) {
                string = "Subject hashcode=0x" + Integer.toHexString(subject.hashCode());
            }
            SibTr.entry((TraceComponent)tc, (String)"checkBusAccess(Subject ...)", (Object)string);
        }
        if (!this.isBusSecure) {
            bl = true;
        } else if (this.authUtils.isSIBServerSubject(subject)) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"user is SIB Server");
            }
            bl = true;
        } else {
            string = this.authUtils.getAuthenticatedUserName(subject);
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("user is '" + string + "'"));
            }
            if (this.localCheck == null) {
                throw new SIBAccessControlException("localAccessCheck is null");
            }
            bl = this.localCheck.localCheckBusAccess(string);
            if (!bl) {
                SibTr.audit((TraceComponent)tc, (String)"AUTHORISATION_FAAILURE_CWSII0150", (Object)new Object[]{string, this.localBus});
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkBusAccess(Subject ...)", (Object)new Boolean(bl));
        }
        return bl;
    }

    public boolean checkBusAccess(String string) throws SIBAccessControlException {
        boolean bl = false;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkBusAccess(String ...)", (Object)string);
        }
        if (!this.isBusSecure) {
            bl = true;
        } else {
            if (this.localCheck == null) {
                throw new SIBAccessControlException("localAccessCheck is null");
            }
            bl = this.localCheck.localCheckBusAccess(string);
            if (!bl) {
                SibTr.audit((TraceComponent)tc, (String)"AUTHORISATION_FAAILURE_CWSII0150", (Object)new Object[]{string, this.localBus});
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkBusAccess(String ...)", (Object)new Boolean(bl));
        }
        return bl;
    }

    public boolean checkDestinationAccess(Subject subject, String string, String string2, OperationType operationType) throws SIBAccessControlException {
        String string3;
        boolean bl = false;
        if (tc.isEntryEnabled()) {
            string3 = "<null>";
            if (subject != null) {
                string3 = "Subject hashcode=0x" + Integer.toHexString(subject.hashCode());
            }
            SibTr.entry((TraceComponent)tc, (String)"checkDestinationAccess(Subject...)", (Object)new Object[]{string3, string, string2, operationType});
        }
        if (!this.isBusSecure) {
            bl = true;
        } else if (this.authUtils.isSIBServerSubject(subject)) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"user is SIB Server");
            }
            bl = true;
        } else {
            string3 = this.authUtils.getAuthenticatedUserName(subject);
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("user is '" + string3 + "'"));
            }
            if (this.localCheck == null) {
                throw new SIBAccessControlException("localAccessCheck is null");
            }
            bl = this.localCheck.localCheckDestinationAccess(string3, string, string2, operationType);
            if (!bl) {
                SibTr.audit((TraceComponent)tc, (String)"AUTHORISATION_FAAILURE_CWSII0155", (Object)new Object[]{string3, string, string2, operationType.toString()});
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkDestinationAccess(Subject...)", (Object)new Boolean(bl));
        }
        return bl;
    }

    public boolean checkDestinationAccess(JsMessage jsMessage, String string, String string2, OperationType operationType) throws SIBAccessControlException {
        boolean bl = false;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkDestinationAccess(message...)", (Object)new Object[]{jsMessage.getSystemMessageId(), string, string2, operationType});
        }
        if (!this.isBusSecure) {
            bl = true;
        } else if (this.authUtils.sentBySIBServer(jsMessage)) {
            bl = true;
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"message sent by SIB Server");
            }
        } else if (this.localCheck != null) {
            String string3 = jsMessage.getSecurityUserid();
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("message sent by '" + string3 + "'"));
            }
            if (!(bl = this.localCheck.localCheckDestinationAccess(string3, string, string2, operationType))) {
                SibTr.audit((TraceComponent)tc, (String)"AUTHORISATION_FAAILURE_CWSII0155", (Object)new Object[]{string3, string, string2, operationType.toString()});
            }
        } else {
            throw new SIBAccessControlException("localAccessCheck is null");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkDestinationAccess(message...)", (Object)new Boolean(bl));
        }
        return bl;
    }

    public boolean checkDestinationAccess(String string, String string2, String string3, OperationType operationType) throws SIBAccessControlException {
        boolean bl = false;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkDestinationAccess(String...)", (Object)new Object[]{string, string2, string3, operationType});
        }
        if (!this.isBusSecure) {
            bl = true;
        } else {
            if (this.localCheck == null) {
                throw new SIBAccessControlException("localAccessCheck is null");
            }
            bl = this.localCheck.localCheckDestinationAccess(string, string2, string3, operationType);
            if (!bl) {
                SibTr.audit((TraceComponent)tc, (String)"AUTHORISATION_FAAILURE_CWSII0155", (Object)new Object[]{string, string2, string3, operationType.toString()});
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkDestinationAccess(String...)", (Object)new Boolean(bl));
        }
        return bl;
    }

    public void setSecurityIDInMessage(Subject subject, JsMessage jsMessage) {
        if (!this.isBusSecure) {
            jsMessage.setSecurityUserid(null);
            jsMessage.setSecurityUseridSentBySystem(false);
        } else {
            String string = this.authUtils.getAuthenticatedUserName(subject);
            boolean bl = this.authUtils.isSIBServerSubject(subject);
            if (tc.isDebugEnabled()) {
                if (bl) {
                    SibTr.debug((TraceComponent)tc, (String)("SIB Server ID set into message " + jsMessage.getSystemMessageId()));
                } else {
                    SibTr.debug((TraceComponent)tc, (String)("username '" + string + "' set into message " + jsMessage.getSystemMessageId()));
                }
            }
            jsMessage.setSecurityUserid(string);
            jsMessage.setSecurityUseridSentBySystem(bl);
        }
    }

    public void setSecurityIDInMessage(String string, JsMessage jsMessage) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setSecurityIDInMessage(String...)", (Object)new Object[]{string, jsMessage.getSystemMessageId()});
        }
        if (!this.isBusSecure) {
            jsMessage.setSecurityUserid(null);
            jsMessage.setSecurityUseridSentBySystem(false);
        } else {
            String string2 = jsMessage.getSecurityUserid();
            if (string2 == null && string != null || string2 != null && !string2.equals(string)) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("setting userId '" + string + "' in message"));
                }
                jsMessage.setSecurityUserid(string);
            } else if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("userId '" + string + "' is already in message, not changing it"));
            }
            if (jsMessage.isSecurityUseridSentBySystem()) {
                jsMessage.setSecurityUseridSentBySystem(false);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setSecurityIDInMessage(String...)");
        }
    }

    public String getSecurityIDFromMessage(JsMessage jsMessage) {
        String string;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getSecurityIDFromMessage()", (Object)jsMessage.getSystemMessageId());
        }
        if ((string = jsMessage.getSecurityUserid()) == null) {
            string = "";
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getSecurityIDFromMessage()", (Object)string);
        }
        return string;
    }

    public void listTopicAuthorisations(TopicAuthorisations topicAuthorisations) throws SIBAccessControlException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"listTopicAuthorisations");
        }
        if (this.isBusSecure) {
            if (this.localCheck != null) {
                if (topicAuthorisations != null) {
                    this.localCheck.localListTopicAuthorisations(topicAuthorisations);
                }
            } else {
                throw new SIBAccessControlException("localAccessCheck is null");
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"listTopicAuthorisations");
        }
    }
}

