/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.security.auth;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.EntryNotFoundException;
import com.ibm.websphere.security.UserRegistry;
import com.ibm.websphere.security.auth.WSPrincipal;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.core.SecurityContext;
import com.ibm.ws.sib.admin.JsAdminService;
import com.ibm.ws.sib.admin.JsBus;
import com.ibm.ws.sib.admin.SIBExceptionBusNotFound;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.security.auth.AuthUtils;
import com.ibm.ws.sib.security.auth.SIBPrincipal;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.security.token.WSSecurityPropagationHelper;
import java.security.Principal;
import java.util.Iterator;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;
import javax.security.auth.AuthPermission;
import javax.security.auth.Subject;

public class AuthUtilsImpl
implements AuthUtils {
    private static TraceComponent _tc = SibTr.register((Class)AuthUtilsImpl.class, (String)"SIBSecurity", (String)"com.ibm.ws.sib.security.CWSIIMessages");
    private static Subject _serverSubject = null;
    private static final AuthPermission GET_SUBJECT_PERM = new AuthPermission("SIBServerPermission");
    private UserRegistry _userReg = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Subject getSIBServerSubject() throws SecurityException {
        SecurityManager securityManager;
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"getSIBServerSubject");
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            if (_tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)_tc, (String)"Performing Java 2 Security Permission Check ...");
                SibTr.debug((TraceComponent)_tc, (String)("Expecting : " + GET_SUBJECT_PERM.toString()));
            }
            securityManager.checkPermission(GET_SUBJECT_PERM);
        }
        Object object = AuthUtilsImpl.class;
        synchronized (object) {
            if (_serverSubject == null) {
                _serverSubject = SubjectHelper.createBasicAuthSubject((String)"SIBRealm", (String)"SIBServer", (String)"");
                _serverSubject.getPrincipals().add(new SIBPrincipal("SIBServer", true, true));
            }
        }
        if (_tc.isEntryEnabled()) {
            object = "<null>";
            if (_serverSubject != null) {
                object = "Subject hashcode=0x" + Integer.toHexString(_serverSubject.hashCode());
            }
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"getSIBServerSubject", (Object)object);
        }
        return _serverSubject;
    }

    public String getUserName(Subject subject) {
        String string;
        if (_tc.isEntryEnabled()) {
            string = "<null>";
            if (_serverSubject != null) {
                string = "Subject hashcode=0x" + Integer.toHexString(_serverSubject.hashCode());
            }
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"getUserName", (Object)string);
        }
        string = null;
        boolean bl = false;
        if (subject != null) {
            Principal principal;
            Iterator iterator = subject.getPrincipals(SIBPrincipal.class).iterator();
            if (iterator.hasNext()) {
                principal = (Principal)iterator.next();
                string = principal.getName();
                bl = true;
            }
            if (!bl && (iterator = subject.getPrincipals(WSPrincipal.class).iterator()).hasNext()) {
                principal = (Principal)iterator.next();
                string = WSSecurityPropagationHelper.getUserFromUniqueID((String)principal.getName());
                bl = true;
            }
            if (!bl) {
                FFDCFilter.processException((Throwable)new Exception("Unable to find a user name in subject " + Integer.toHexString(subject.hashCode())), (String)"com.ibm.ws.sib.security.auth.AuthUtilsImpl.getUserName", (String)"204", (Object)this);
            }
        }
        if (string == null) {
            string = "";
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"getUserName", (Object)string);
        }
        return string;
    }

    public String[] getGroupsForUser(String string) throws Exception {
        Object object;
        String[] stringArray;
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"getGroupsForUser", (Object)string);
        }
        if (this._userReg == null) {
            stringArray = new InitialContext();
            object = stringArray.lookup("UserRegistry");
            this._userReg = (UserRegistry)PortableRemoteObject.narrow((Object)object, (Class)UserRegistry.class);
        }
        if (this._userReg != null) {
            stringArray = null;
            try {
                String string2;
                object = this._userReg.getGroupsForUser(string);
                int n = 0;
                if (object != null) {
                    n = object.size();
                }
                if ((string2 = this._userReg.getRealm()) == null) {
                    string2 = "";
                }
                int n2 = string2.length();
                stringArray = new String[n];
                for (int i = 0; i < n; ++i) {
                    String string3 = (String)object.get(i);
                    if (n2 != 0 && string3.startsWith(string2)) {
                        string3 = string3.substring(n2 + 1);
                    } else if (n2 == 0 && string3.startsWith("/")) {
                        string3 = string3.substring(1);
                    }
                    stringArray[i] = string3;
                }
            }
            catch (EntryNotFoundException entryNotFoundException) {
                // empty catch block
            }
            if (_tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)_tc, (String)"getGroupsForUser", (Object)stringArray);
            }
            return stringArray;
        }
        stringArray = new Exception("cannot obtain the UserRegistry object");
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"getGroupsForUser", (Object)stringArray);
        }
        throw stringArray;
    }

    public boolean isBusSecure(String string) {
        boolean bl;
        block7: {
            if (_tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)_tc, (String)"isBusSecure", (Object)string);
            }
            bl = true;
            JsAdminService jsAdminService = JsAdminService.getInstance();
            if (_tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)_tc, (String)("adminService = " + jsAdminService));
            }
            try {
                JsBus jsBus = jsAdminService.getBus(string);
                if (_tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)_tc, (String)("bus = " + jsBus));
                }
                bl = jsBus.isSecure();
                if (_tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)_tc, (String)("result = " + bl));
                }
            }
            catch (SIBExceptionBusNotFound sIBExceptionBusNotFound) {
                if (!_tc.isDebugEnabled()) break block7;
                SibTr.debug((TraceComponent)_tc, (String)"BusNotFound exception thrown");
            }
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"isBusSecure", (Object)new Boolean(bl));
        }
        return bl;
    }

    public boolean isServerSecure() {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"isServerSecure");
        }
        boolean bl = SecurityContext.isSecurityEnabled();
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"isServerSecure", (Object)new Boolean(bl));
        }
        return bl;
    }

    public boolean isSIBServerSubject(Subject subject) {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"isSIBServerSubject", (Object)subject);
        }
        boolean bl = false;
        if (_serverSubject != null) {
            boolean bl2 = bl = subject == _serverSubject;
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"isSIBServerSubject", (Object)new Boolean(bl));
        }
        return bl;
    }

    public boolean sentBySIBServer(JsMessage jsMessage) {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"sentBySIBServer", (Object)jsMessage);
        }
        boolean bl = false;
        String string = jsMessage.getSecurityUserid();
        if (string != null && string.equals("SIBServer") && (bl = jsMessage.isSecurityUseridSentBySystem()) && _tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)_tc, (String)"message sent by SIB Server");
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"sentBySIBServer", (Object)new Boolean(bl));
        }
        return bl;
    }

    public String getAuthenticatedUserName(Subject subject) {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"getAuthenticatedUserName", (Object)subject);
        }
        String string = null;
        if (subject != null) {
            boolean bl = false;
            Iterator iterator = subject.getPrincipals(SIBPrincipal.class).iterator();
            if (iterator.hasNext()) {
                SIBPrincipal sIBPrincipal = (SIBPrincipal)iterator.next();
                if (sIBPrincipal.isAuthenticated()) {
                    string = sIBPrincipal.getName();
                }
                bl = true;
            }
            if (!bl) {
                FFDCFilter.processException((Throwable)new Exception("Unable to find a user name in subject " + Integer.toHexString(subject.hashCode())), (String)"com.ibm.ws.sib.security.auth.AuthUtilsImpl.getAuthenticatedUserName", (String)"453", (Object)this);
            }
        }
        if (string == null) {
            string = "";
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"getAuthenticatedUserName", (Object)string);
        }
        return string;
    }
}

