/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.security.auth;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.JsAdminService;
import com.ibm.ws.sib.admin.JsBus;
import com.ibm.ws.sib.admin.SIBExceptionBusNotFound;
import com.ibm.ws.sib.utils.ras.SibTr;

public final class AuditLogger {
    private static final String ALL = "all";
    private static final String FAILURE = "failure";
    private static final String NONE = "none";
    private static final TraceComponent _tc = SibTr.register((Class)AuditLogger.class, (String)"SIBSecurity", (String)"com.ibm.ws.sib.security.CWSIIMessages");
    private static JsAdminService _admin = JsAdminService.getInstance();

    public static void authenticationSucceeded(String string, String string2) {
        if (ALL.equals(AuditLogger.getAuditMode(string))) {
            SibTr.audit((TraceComponent)_tc, (String)"AUTHENTICATION_SUCCESS_CWSII0060", (Object)new Object[]{string2, string});
        }
    }

    public static void authenticationFailed(String string, String string2) {
        String string3 = AuditLogger.getAuditMode(string);
        if (ALL.equals(string3) || FAILURE.equals(string3)) {
            SibTr.error((TraceComponent)_tc, (String)"AUTHENTICATION_FAILURE_CWSII0050", (Object)string2);
        }
    }

    private static String getAuditMode(String string) {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)_tc, (String)"getAuditMode", (Object)string);
        }
        String string2 = FAILURE;
        try {
            JsBus jsBus = _admin.getBus(string);
            if (jsBus.isSecure()) {
                String string3 = jsBus.getCustomProperty("audit.bus.authentication");
                if (string3 != null) {
                    string3 = string3.toLowerCase();
                }
                if (_tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)_tc, (String)("The audit mode for bus " + string + " is " + string3));
                }
                if (NONE.equals(string3) || ALL.equals(string3)) {
                    string2 = string3;
                }
            } else {
                string2 = NONE;
            }
        }
        catch (SIBExceptionBusNotFound sIBExceptionBusNotFound) {
            FFDCFilter.processException((Throwable)sIBExceptionBusNotFound, (String)"com.ibm.ws.sib.security.auth.AuditLogger.getAuditMode", (String)"74");
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)_tc, (String)"getAuditMode", (Object)string2);
        }
        return string2;
    }
}

