/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.ra.inbound.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sib.ra.impl.SibRaUtils;
import com.ibm.ws.sib.ra.inbound.impl.SibRaStringGenerator;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SIXAResource;
import java.util.Hashtable;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class SibRaXaResource
implements SIXAResource {
    protected final SIXAResource _siXaResource;
    private static TraceComponent TRACE = SibRaUtils.getTraceComponent(SibRaXaResource.class);
    private Xid _lastXidUsed = null;
    private static final Hashtable _transactionStates = new Hashtable();

    SibRaXaResource(SIXAResource sIXAResource) {
        this._siXaResource = sIXAResource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(Xid xid, boolean bl) throws XAException {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((TraceComponent)TRACE, (String)"commit", (Object)new Object[]{xid, bl});
        }
        this._siXaResource.commit(xid, bl);
        Hashtable hashtable = _transactionStates;
        synchronized (hashtable) {
            _transactionStates.put(xid, new Boolean(false));
            if (TRACE.isDebugEnabled()) {
                StringBuffer stringBuffer = new StringBuffer("After adding the xid ");
                stringBuffer.append(xid);
                stringBuffer.append(" the hashtable of transactionStates now contains ");
                stringBuffer.append(_transactionStates.size());
                stringBuffer.append(" entries");
                SibTr.debug((TraceComponent)TRACE, (String)stringBuffer.toString());
            }
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((TraceComponent)TRACE, (String)"commit");
        }
    }

    public void end(Xid xid, int n) throws XAException {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((TraceComponent)TRACE, (String)"end", (Object)new Object[]{xid, new Integer(n)});
        }
        this._siXaResource.end(xid, n);
        this._lastXidUsed = xid;
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((TraceComponent)TRACE, (String)"end");
        }
    }

    public void forget(Xid xid) throws XAException {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((TraceComponent)TRACE, (String)"forget", (Object)xid);
        }
        this._siXaResource.forget(xid);
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((TraceComponent)TRACE, (String)"forget");
        }
    }

    public int getTransactionTimeout() throws XAException {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((TraceComponent)TRACE, (String)"getTransactionTimeout");
        }
        int n = this._siXaResource.getTransactionTimeout();
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((TraceComponent)TRACE, (String)"getTransactionTimeout", (Object)new Integer(n));
        }
        return n;
    }

    public boolean isSameRM(XAResource xAResource) throws XAException {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((TraceComponent)TRACE, (String)"isSameRM", (Object)xAResource);
        }
        boolean bl = xAResource instanceof SibRaXaResource ? this._siXaResource.isSameRM((XAResource)((SibRaXaResource)((Object)xAResource)).getSiXaResource()) : this._siXaResource.isSameRM(xAResource);
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((TraceComponent)TRACE, (String)"isSameRM", (Object)bl);
        }
        return bl;
    }

    public int prepare(Xid xid) throws XAException {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((TraceComponent)TRACE, (String)"prepare", (Object)xid);
        }
        int n = this._siXaResource.prepare(xid);
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((TraceComponent)TRACE, (String)"prepare", (Object)new Integer(n));
        }
        return n;
    }

    public Xid[] recover(int n) throws XAException {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((TraceComponent)TRACE, (String)"recover", (Object)new Integer(n));
        }
        Xid[] xidArray = this._siXaResource.recover(n);
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((TraceComponent)TRACE, (String)"recover", (Object)xidArray);
        }
        return xidArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(Xid xid) throws XAException {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((TraceComponent)TRACE, (String)"rollback", (Object)xid);
        }
        this._siXaResource.rollback(xid);
        Hashtable hashtable = _transactionStates;
        synchronized (hashtable) {
            _transactionStates.put(xid, new Boolean(true));
            if (TRACE.isDebugEnabled()) {
                StringBuffer stringBuffer = new StringBuffer("After adding the xid ");
                stringBuffer.append(xid);
                stringBuffer.append(" the hashtable of transactionStates now contains ");
                stringBuffer.append(_transactionStates.size());
                stringBuffer.append(" entries");
                SibTr.debug((TraceComponent)TRACE, (String)stringBuffer.toString());
            }
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((TraceComponent)TRACE, (String)"rollback");
        }
    }

    public boolean setTransactionTimeout(int n) throws XAException {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((TraceComponent)TRACE, (String)"recover", (Object)new Integer(n));
        }
        boolean bl = this._siXaResource.setTransactionTimeout(n);
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((TraceComponent)TRACE, (String)"recover", (Object)bl);
        }
        return bl;
    }

    public void start(Xid xid, int n) throws XAException {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((TraceComponent)TRACE, (String)"start", (Object)new Object[]{xid, new Integer(n)});
        }
        this._siXaResource.start(xid, n);
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((TraceComponent)TRACE, (String)"start");
        }
    }

    public boolean isEnlisted() {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((TraceComponent)TRACE, (String)"isEnlisted");
        }
        boolean bl = this._siXaResource.isEnlisted();
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((TraceComponent)TRACE, (String)"isEnlisted", (Object)bl);
        }
        return bl;
    }

    SIXAResource getSiXaResource() {
        return this._siXaResource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isTransactionRolledBack() {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((TraceComponent)TRACE, (String)"isTransactionRolledBack");
        }
        boolean bl = true;
        Boolean bl2 = null;
        if (this._lastXidUsed != null) {
            Hashtable hashtable = _transactionStates;
            synchronized (hashtable) {
                bl2 = (Boolean)_transactionStates.remove(this._lastXidUsed);
                if (TRACE.isDebugEnabled()) {
                    StringBuffer stringBuffer = new StringBuffer("After removing the xid ");
                    stringBuffer.append(this._lastXidUsed);
                    stringBuffer.append(" the hashtable of transactionStates now contains ");
                    stringBuffer.append(_transactionStates.size());
                    stringBuffer.append(" entries");
                    SibTr.debug((TraceComponent)TRACE, (String)stringBuffer.toString());
                }
            }
        } else if (TRACE.isDebugEnabled()) {
            SibTr.debug((TraceComponent)TRACE, (String)"WARNING! No last Xid set");
        }
        if (bl2 != null) {
            bl = bl2;
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((TraceComponent)TRACE, (String)"isTransactionRolledBack", (Object)bl);
        }
        return bl;
    }

    public String toString() {
        SibRaStringGenerator sibRaStringGenerator = new SibRaStringGenerator(this);
        sibRaStringGenerator.addField("siXaResource", this._siXaResource);
        return sibRaStringGenerator.getStringRepresentation();
    }

    static {
        if (TRACE.isDebugEnabled()) {
            SibTr.debug((TraceComponent)TRACE, (String)"Source info: @(#)SIB/ws/code/sib.ra.impl/src/com/ibm/ws/sib/ra/inbound/impl/SibRaXaResource.java, SIB.ra, WAS602.SIB, o0610.11 1.3");
        }
    }
}

