/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.ra.inbound.impl;

final class SibRaStringGenerator {
    private final StringBuffer _buffer = new StringBuffer("[");
    private boolean _completed = false;

    SibRaStringGenerator(Object object) {
        this.addObjectIdentity(object);
    }

    void addParent(String string, Object object) throws IllegalStateException {
        this.checkNotCompleted();
        this._buffer.append(" <");
        this._buffer.append(string);
        this._buffer.append("=");
        this.addObjectIdentity(object);
        this._buffer.append(">");
    }

    void addField(String string, Object object) throws IllegalStateException {
        this.checkNotCompleted();
        this._buffer.append(" <");
        this._buffer.append(string);
        this._buffer.append("=");
        this._buffer.append(object);
        this._buffer.append(">");
    }

    void addField(String string, boolean bl) throws IllegalStateException {
        this.addField(string, Boolean.toString(bl));
    }

    void addPasswordField(String string, String string2) throws IllegalStateException {
        this.addField(string, string2 == null ? null : "*****");
    }

    void addField(String string, long l) throws IllegalStateException {
        this.addField(string, Long.toString(l));
    }

    String getStringRepresentation() {
        this._completed = true;
        this._buffer.append("]");
        return this._buffer.toString();
    }

    private void checkNotCompleted() throws IllegalStateException {
        if (this._completed) {
            throw new IllegalStateException();
        }
    }

    private void addObjectIdentity(Object object) {
        if (object == null) {
            this._buffer.append("null");
        } else {
            this._buffer.append(object.getClass().getName());
            this._buffer.append("@");
            this._buffer.append(Integer.toHexString(System.identityHashCode(object)));
        }
    }
}

