/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.ra.inbound.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.BaseDestinationDefinition;
import com.ibm.ws.sib.admin.DestinationAliasDefinition;
import com.ibm.ws.sib.admin.DestinationDefinition;
import com.ibm.ws.sib.admin.JsMessagingEngine;
import com.ibm.ws.sib.admin.SIBExceptionBase;
import com.ibm.ws.sib.admin.SIBExceptionDestinationNotFound;
import com.ibm.ws.sib.ra.SibRaEngineComponent;
import com.ibm.ws.sib.ra.SibRaMessagingEngineListener;
import com.ibm.ws.sib.ra.impl.SibRaUtils;
import com.ibm.ws.sib.ra.inbound.SibRaEndpointConfiguration;
import com.ibm.ws.sib.ra.inbound.SibRaEndpointInvoker;
import com.ibm.ws.sib.ra.inbound.impl.SibRaEndpointActivation;
import com.ibm.ws.sib.ra.inbound.impl.SibRaMessagingEngineConnection;
import com.ibm.ws.sib.ra.inbound.impl.SibRaResourceAdapterImpl;
import com.ibm.ws.sib.ra.inbound.impl.SibRaStringGenerator;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.ConsumerSession;
import com.ibm.wsspi.sib.core.DestinationType;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.spi.IllegalStateException;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.endpoint.MessageEndpointFactory;

final class SibRaStaticDestinationEndpointActivation
extends SibRaEndpointActivation {
    private static final Random _random = new Random();
    private SibRaMessagingEngineConnection _remoteConnection;
    private boolean _remoteDestination;
    private boolean _remoteMessagingEngine;
    private Timer _timer;
    private int RETRY_INTERVAL = 30000;
    private static final TraceComponent TRACE = SibRaUtils.getTraceComponent(SibRaStaticDestinationEndpointActivation.class);
    private static TraceNLS NLS = SibRaUtils.getTraceNls();
    private static final String CLASS_NAME = SibRaResourceAdapterImpl.class.getName();
    private static final String FFDC_PROBE_1 = "1";
    private static final String FFDC_PROBE_2 = "2";
    private static final String FFDC_PROBE_3 = "3";
    private static final String FFDC_PROBE_4 = "4";
    private static final String FFDC_PROBE_5 = "5";
    private static final String FFDC_PROBE_6 = "6";
    private static final String FFDC_PROBE_7 = "7";

    SibRaStaticDestinationEndpointActivation(SibRaResourceAdapterImpl sibRaResourceAdapterImpl, MessageEndpointFactory messageEndpointFactory, SibRaEndpointConfiguration sibRaEndpointConfiguration, SibRaEndpointInvoker sibRaEndpointInvoker) throws ResourceException {
        super(sibRaResourceAdapterImpl, messageEndpointFactory, sibRaEndpointConfiguration, sibRaEndpointInvoker);
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"SibRaStaticDestinationEndpointActivation", (Object)new Object[]{sibRaResourceAdapterImpl, messageEndpointFactory, sibRaEndpointConfiguration, sibRaEndpointInvoker});
        }
        this._timer = sibRaResourceAdapterImpl.getBootstrapContext().createTimer();
        JsMessagingEngine[] jsMessagingEngineArray = SibRaEngineComponent.getMessagingEngines((String)this._endpointConfiguration.getBusName());
        if (0 == jsMessagingEngineArray.length) {
            this._remoteDestination = true;
            this._remoteMessagingEngine = true;
            this.createRemoteListener(true);
        } else {
            JsMessagingEngine[] jsMessagingEngineArray2 = SibRaEngineComponent.registerMessagingEngineListener((SibRaMessagingEngineListener)this, (String)this._endpointConfiguration.getBusName());
            for (int i = 0; i < jsMessagingEngineArray2.length; ++i) {
                JsMessagingEngine jsMessagingEngine = jsMessagingEngineArray2[i];
                if (!this.isListenerRequired(jsMessagingEngine)) continue;
                this.createListener(jsMessagingEngine);
            }
            if (this._connections.size() == 0) {
                SibTr.warning((TraceComponent)TRACE, (String)"NO_ACTIVE_MES_CWSIV0759", (Object)new Object[]{this._endpointConfiguration.getBusName()});
            }
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((TraceComponent)TRACE, (String)"SibRaStaticDestinationEndpointActivation");
        }
    }

    protected synchronized void addMessagingEngine(JsMessagingEngine jsMessagingEngine) throws ResourceException {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"addMessagingEngine", (Object)jsMessagingEngine);
        }
        if (this.isListenerRequired(jsMessagingEngine)) {
            this.createListener(jsMessagingEngine);
            SibTr.info((TraceComponent)TRACE, (String)"NEW_CONSUMER_CWSIV0764", (Object)new Object[]{this._endpointConfiguration.getBusName(), jsMessagingEngine.getName(), this._endpointConfiguration.getDestination().getDestinationName()});
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"addMessagingEngine");
        }
    }

    void deactivate() {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"deactivate");
        }
        super.deactivate();
        if (this._remoteConnection != null) {
            this._remoteConnection.close();
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"deactivate");
        }
    }

    private boolean isListenerRequired(JsMessagingEngine jsMessagingEngine) throws ResourceException {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"isListenerRequired", (Object)jsMessagingEngine);
        }
        boolean bl = false;
        Set set = this.getRequiredMessagingEngines(jsMessagingEngine);
        if (set.size() > 0) {
            if (set.contains(jsMessagingEngine.getUuid().toString())) {
                bl = true;
            }
        } else if (this._connections.size() == 0) {
            bl = true;
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"isListenerRequired", (Object)bl);
        }
        return bl;
    }

    private static String validateDestination(JsMessagingEngine jsMessagingEngine, String string, String string2, DestinationType destinationType) throws NotSupportedException, ResourceAdapterInternalException {
        String string3;
        block11: {
            if (TRACE.isEntryEnabled()) {
                SibTr.entry((TraceComponent)TRACE, (String)"validateDestination", (Object)new Object[]{jsMessagingEngine, string, string2, destinationType});
            }
            String string4 = string == null || "".equals(string) ? jsMessagingEngine.getBusName() : string;
            try {
                BaseDestinationDefinition baseDestinationDefinition = jsMessagingEngine.getSIBDestination(string, string2);
                if (baseDestinationDefinition.isForeign()) {
                    throw new NotSupportedException(NLS.getFormattedMessage("FOREIGN_DESTINATION_CWSIV0754", new Object[]{string2, string4}, null));
                }
                if (baseDestinationDefinition.isLocal()) {
                    DestinationDefinition destinationDefinition = (DestinationDefinition)baseDestinationDefinition;
                    if (destinationType.equals(destinationDefinition.getDestinationType())) {
                        string3 = baseDestinationDefinition.getUUID().toString();
                        break block11;
                    }
                    throw new NotSupportedException(NLS.getFormattedMessage("INCORRECT_TYPE_CWSIV0755", new Object[]{string2, string4, destinationType, destinationDefinition.getDestinationType()}, null));
                }
                if (baseDestinationDefinition.isAlias()) {
                    DestinationAliasDefinition destinationAliasDefinition = (DestinationAliasDefinition)baseDestinationDefinition;
                    string3 = SibRaStaticDestinationEndpointActivation.validateDestination(jsMessagingEngine, destinationAliasDefinition.getTargetBus(), destinationAliasDefinition.getTargetName(), destinationType);
                    break block11;
                }
                throw new ResourceAdapterInternalException(NLS.getFormattedMessage("UNKNOWN_TYPE_CWSIV0756", new Object[]{string2, string4}, null));
            }
            catch (SIBExceptionDestinationNotFound sIBExceptionDestinationNotFound) {
                FFDCFilter.processException((Throwable)sIBExceptionDestinationNotFound, (String)(CLASS_NAME + "." + "validateDestination"), (String)FFDC_PROBE_1);
                if (TRACE.isEventEnabled()) {
                    SibTr.exception((TraceComponent)TRACE, (Exception)((Object)sIBExceptionDestinationNotFound));
                }
                throw new NotSupportedException(NLS.getFormattedMessage("NOT_FOUND_CWSIV0757", new Object[]{string2, string4}, null), (Throwable)sIBExceptionDestinationNotFound);
            }
            catch (SIBExceptionBase sIBExceptionBase) {
                FFDCFilter.processException((Throwable)sIBExceptionBase, (String)(CLASS_NAME + "." + "validateDestination"), (String)FFDC_PROBE_2);
                if (TRACE.isEventEnabled()) {
                    SibTr.exception((TraceComponent)TRACE, (Exception)((Object)sIBExceptionBase));
                }
                throw new ResourceAdapterInternalException(NLS.getFormattedMessage("UNEXPECTED_EXCEPTION_CWSIV0758", new Object[]{string2, string4, sIBExceptionBase}, null), (Throwable)sIBExceptionBase);
            }
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((TraceComponent)TRACE, (String)"validateDestination", (Object)string3);
        }
        return string3;
    }

    private Set getRequiredMessagingEngines(JsMessagingEngine jsMessagingEngine) throws NotSupportedException, ResourceAdapterInternalException {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"getRequiredMessagingEngines");
        }
        HashSet<String> hashSet = new HashSet<String>();
        JsMessagingEngine[] jsMessagingEngineArray = SibRaEngineComponent.getMessagingEngines((String)this._endpointConfiguration.getBusName());
        String string = SibRaStaticDestinationEndpointActivation.validateDestination(jsMessagingEngine, this._endpointConfiguration.getDestination().getBusName(), this._endpointConfiguration.getDestination().getDestinationName(), this._endpointConfiguration.getDestinationType());
        if (DestinationType.TOPICSPACE == this._endpointConfiguration.getDestinationType()) {
            if (this._endpointConfiguration.isDurableSubscription()) {
                this._remoteDestination = true;
                for (int i = 0; i < jsMessagingEngineArray.length; ++i) {
                    if (!jsMessagingEngineArray[i].getName().equals(this._endpointConfiguration.getDurableSubscriptionHome())) continue;
                    hashSet.add(jsMessagingEngineArray[i].getUuid().toString());
                    this._remoteDestination = false;
                    break;
                }
            } else {
                this._remoteDestination = false;
            }
        } else {
            Set set;
            try {
                set = jsMessagingEngine.getSIBDestinationLocalitySet(this._endpointConfiguration.getDestination().getBusName(), string);
            }
            catch (SIBExceptionBase sIBExceptionBase) {
                FFDCFilter.processException((Throwable)sIBExceptionBase, (String)(CLASS_NAME + "." + "getRequiredMessagingEngines"), (String)FFDC_PROBE_3, (Object)this);
                if (TRACE.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)sIBExceptionBase));
                }
                throw new ResourceAdapterInternalException(NLS.getFormattedMessage("DESTINATION_LOCALITY_CWSIV0753", new Object[]{sIBExceptionBase, string}, null), (Throwable)sIBExceptionBase);
            }
            this._remoteDestination = true;
            for (int i = 0; i < jsMessagingEngineArray.length; ++i) {
                String string2 = jsMessagingEngineArray[i].getUuid().toString();
                if (!set.contains(string2)) continue;
                hashSet.add(string2);
                this._remoteDestination = false;
            }
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((TraceComponent)TRACE, (String)"getRequiredMessagingEngines", hashSet);
        }
        return hashSet;
    }

    private void createListener(JsMessagingEngine jsMessagingEngine) throws ResourceException {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"createListener", (Object)jsMessagingEngine);
        }
        SibRaMessagingEngineConnection sibRaMessagingEngineConnection = this.getConnection(jsMessagingEngine);
        this.createListener(sibRaMessagingEngineConnection);
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"createListener");
        }
    }

    private void createListener(final SibRaMessagingEngineConnection sibRaMessagingEngineConnection) throws ResourceException {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"createListener", (Object)sibRaMessagingEngineConnection);
        }
        SIDestinationAddress sIDestinationAddress = this._endpointConfiguration.getDestination();
        try {
            sibRaMessagingEngineConnection.createListener(sIDestinationAddress);
        }
        catch (IllegalStateException illegalStateException) {
            throw illegalStateException;
        }
        catch (ResourceException resourceException) {
            if (this._remoteDestination) {
                SibTr.warning((TraceComponent)TRACE, (String)"ATTACH_FAILED_CWSIV0769", (Object)new Object[]{sIDestinationAddress.getDestinationName(), this._endpointConfiguration.getBusName(), this, resourceException});
                this._timer.schedule(new TimerTask(){

                    public void run() {
                        try {
                            SibRaStaticDestinationEndpointActivation.this.createListener(sibRaMessagingEngineConnection);
                        }
                        catch (ResourceException resourceException) {
                            // empty catch block
                        }
                    }
                }, this.RETRY_INTERVAL);
            }
            throw resourceException;
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"createListener");
        }
    }

    public synchronized void messagingEngineStopping(JsMessagingEngine jsMessagingEngine, int n) {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"messagingEngineStopping", (Object)new Object[]{jsMessagingEngine, new Integer(n)});
        }
        super.messagingEngineStopping(jsMessagingEngine, n);
        try {
            Set set = this.getRequiredMessagingEngines(jsMessagingEngine);
            JsMessagingEngine[] jsMessagingEngineArray = SibRaEngineComponent.getActiveMessagingEngines((String)this._endpointConfiguration.getBusName());
            if (set.size() == 0 && this._connections.size() == 0) {
                if (jsMessagingEngineArray.length > 0) {
                    int n2 = _random.nextInt(jsMessagingEngineArray.length);
                    this.createListener(jsMessagingEngineArray[n2]);
                } else {
                    SibTr.info((TraceComponent)TRACE, (String)"LAST_ME_CWSIV0768", (Object)new Object[]{jsMessagingEngine.getName(), jsMessagingEngine.getBus(), this});
                }
            }
        }
        catch (ResourceException resourceException) {
            FFDCFilter.processException((Throwable)resourceException, (String)(CLASS_NAME + "." + "messagingEngineStopping"), (String)FFDC_PROBE_4, (Object)this);
            SibTr.error((TraceComponent)TRACE, (String)"MESSAGING_ENGINE_STOPPING_CWSIV0765", (Object)new Object[]{resourceException, jsMessagingEngine.getName(), jsMessagingEngine.getBusName()});
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"messagingEngineStopping");
        }
    }

    public synchronized void messagingEngineInitializing(JsMessagingEngine jsMessagingEngine) {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"messagingEngineInitializing", (Object)jsMessagingEngine);
        }
        if (this._remoteMessagingEngine && jsMessagingEngine.getBusName().equals(this._endpointConfiguration.getBusName())) {
            SibTr.info((TraceComponent)TRACE, (String)"ME_INITIALIZING_CWSIV0778", (Object)new Object[]{jsMessagingEngine.getName(), this._endpointConfiguration.getBusName(), this});
            this._remoteMessagingEngine = false;
            if (this._remoteConnection != null) {
                this._remoteConnection.close();
            }
            this._timer.cancel();
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"messagingEngineInitializing");
        }
    }

    public void messagingEngineDestroyed(JsMessagingEngine jsMessagingEngine) {
        JsMessagingEngine[] jsMessagingEngineArray;
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"messagingEngineDestroyed", (Object)jsMessagingEngine);
        }
        if (0 == (jsMessagingEngineArray = SibRaEngineComponent.getMessagingEngines((String)this._endpointConfiguration.getBusName())).length) {
            SibTr.info((TraceComponent)TRACE, (String)"ME_DESTROYED_CWSIV0779", (Object)new Object[]{jsMessagingEngine.getName(), this._endpointConfiguration.getBusName(), this});
            this._remoteDestination = true;
            this._remoteMessagingEngine = true;
            this.createRemoteListenerDeactivateOnException(true);
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"messagingEngineDestroyed");
        }
    }

    public void messagingEngineReloaded(JsMessagingEngine jsMessagingEngine) {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"messagingEngineReloaded", (Object)jsMessagingEngine);
        }
        try {
            if (!this._connections.containsKey(jsMessagingEngine.getUuid().toString()) && this.isListenerRequired(jsMessagingEngine)) {
                this.createListener(jsMessagingEngine);
            }
        }
        catch (ResourceException resourceException) {
            if (TRACE.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)resourceException));
            }
            SibTr.error((TraceComponent)TRACE, (String)"RELOAD_FAILED_CWSIV0773", (Object)new Object[]{resourceException, jsMessagingEngine.getName(), jsMessagingEngine.getBusName(), this});
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"messagingEngineReloaded");
        }
    }

    void sessionError(SibRaMessagingEngineConnection sibRaMessagingEngineConnection, ConsumerSession consumerSession, Throwable throwable) {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"sessionError", (Object)new Object[]{sibRaMessagingEngineConnection, consumerSession});
        }
        SIDestinationAddress sIDestinationAddress = consumerSession.getDestinationAddress();
        if (this._remoteDestination) {
            SibTr.warning((TraceComponent)TRACE, (String)"CONSUMER_FAILED_CWSIV0770", (Object)new Object[]{sIDestinationAddress.getDestinationName(), this._endpointConfiguration.getBusName(), this, throwable});
            try {
                this.createListener(sibRaMessagingEngineConnection);
            }
            catch (ResourceException resourceException) {}
        } else if (SibRaEngineComponent.isMessagingEngineReloading((String)sibRaMessagingEngineConnection.getConnection().getMeUuid())) {
            SibTr.warning((TraceComponent)TRACE, (String)"FAILURE_DURING_RELOAD_CWSIV0774", (Object)new Object[]{throwable, sIDestinationAddress.getDestinationName(), sibRaMessagingEngineConnection.getConnection().getMeName(), sIDestinationAddress.getBusName(), this});
            this.closeConnection(sibRaMessagingEngineConnection.getConnection().getMeUuid());
        } else {
            SibTr.error((TraceComponent)TRACE, (String)"SESSION_ERROR_CWSIV0766", (Object)new Object[]{throwable, sIDestinationAddress.getDestinationName(), sibRaMessagingEngineConnection.getConnection().getMeName(), sIDestinationAddress.getBusName(), this});
            this.deactivate();
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"sessionError");
        }
    }

    synchronized void connectionError(SibRaMessagingEngineConnection sibRaMessagingEngineConnection, SIException sIException) {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"connectionError", (Object)new Object[]{sibRaMessagingEngineConnection, sIException});
        }
        if (this._remoteMessagingEngine) {
            if (sibRaMessagingEngineConnection.equals(this._remoteConnection)) {
                SibTr.warning((TraceComponent)TRACE, (String)"CONNECTION_ERROR_CWSIV0776", (Object)new Object[]{sibRaMessagingEngineConnection.getConnection().getMeName(), this._endpointConfiguration.getBusName(), this, sIException});
                this._remoteConnection.close();
                this._remoteConnection = null;
                this.scheduleCreateRemoteListener();
            } else if (TRACE.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)TRACE, (String)("Connection " + sibRaMessagingEngineConnection + " not equal to current remote connection " + this._remoteConnection));
            }
        } else {
            SibTr.error((TraceComponent)TRACE, (String)"CONNECTION_ERROR_CWSIV0767", (Object)new Object[]{sIException, sibRaMessagingEngineConnection.getConnection().getMeName(), this});
            this.deactivate();
            if (TRACE.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"connectionError");
            }
        }
    }

    synchronized void messagingEngineTerminated(SibRaMessagingEngineConnection sibRaMessagingEngineConnection) {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"messagingEngineTerminated", (Object)sibRaMessagingEngineConnection);
        }
        if (sibRaMessagingEngineConnection.equals(this._remoteConnection)) {
            SibTr.warning((TraceComponent)TRACE, (String)"ME_TERMINATED_CWSIV0780", (Object)new Object[]{sibRaMessagingEngineConnection.getConnection().getMeName(), this._endpointConfiguration.getBusName(), this});
            this._remoteConnection.close();
            this._remoteConnection = null;
            this.scheduleCreateRemoteListener();
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"messagingEngineTerminated");
        }
    }

    synchronized void messagingEngineQuiescing(SibRaMessagingEngineConnection sibRaMessagingEngineConnection) {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"messagingEngineQuiescing", (Object)sibRaMessagingEngineConnection);
        }
        if (sibRaMessagingEngineConnection.equals(this._remoteConnection)) {
            SibTr.warning((TraceComponent)TRACE, (String)"ME_QUIESCING_CWSIV0781", (Object)new Object[]{sibRaMessagingEngineConnection.getConnection().getMeName(), this._endpointConfiguration.getBusName(), this});
            this._remoteConnection.close();
            this._remoteConnection = null;
            this.scheduleCreateRemoteListener();
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"messagingEngineQuiescing");
        }
    }

    private synchronized void createRemoteListener(boolean bl) throws ResourceException {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"createRemoteListener", (Object)bl);
        }
        if (this._remoteMessagingEngine) {
            try {
                this._remoteConnection = new SibRaMessagingEngineConnection((SibRaEndpointActivation)this, this._endpointConfiguration.getBusName());
                this.createListener(this._remoteConnection);
            }
            catch (SIResourceException sIResourceException) {
                FFDCFilter.processException((Throwable)sIResourceException, (String)(CLASS_NAME + "." + "createRemoteListener"), (String)FFDC_PROBE_5, (Object)this);
                if (TRACE.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)sIResourceException));
                }
                if (bl) {
                    SibTr.warning((TraceComponent)TRACE, (String)"CONNECT_FAILED_CWSIV0775", (Object)new Object[]{this._endpointConfiguration.getDestination().getDestinationName(), this._endpointConfiguration.getBusName(), this, sIResourceException});
                }
                this.scheduleCreateRemoteListener();
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + "." + "createRemoteListener"), (String)FFDC_PROBE_6, (Object)this);
                if (TRACE.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)sIException));
                }
                throw new ResourceException(NLS.getFormattedMessage("CONNECT_FAILED_CWSIV0782", new Object[]{this._endpointConfiguration.getDestination().getDestinationName(), this._endpointConfiguration.getBusName(), this, sIException}, null), (Throwable)sIException);
            }
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"createRemoteListener");
        }
    }

    private void scheduleCreateRemoteListener() {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"scheduleCreateRemoteListener");
        }
        this._timer.schedule(new TimerTask(){

            public void run() {
                SibRaStaticDestinationEndpointActivation.this.createRemoteListenerDeactivateOnException(false);
                if (SibRaStaticDestinationEndpointActivation.this._remoteConnection != null) {
                    SibTr.info((TraceComponent)TRACE, (String)"CONNECTED_CWSIV0777", (Object)new Object[]{SibRaStaticDestinationEndpointActivation.this._remoteConnection.getConnection().getMeName(), SibRaStaticDestinationEndpointActivation.this._endpointConfiguration.getDestination().getDestinationName(), SibRaStaticDestinationEndpointActivation.this._endpointConfiguration.getBusName(), SibRaStaticDestinationEndpointActivation.this});
                }
            }
        }, this.RETRY_INTERVAL);
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"scheduleCreateRemoteListener");
        }
    }

    private void createRemoteListenerDeactivateOnException(boolean bl) {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"createRemoteListenerDeactivateOnException", (Object)bl);
        }
        try {
            this.createRemoteListener(bl);
        }
        catch (ResourceException resourceException) {
            FFDCFilter.processException((Throwable)resourceException, (String)(CLASS_NAME + "." + "createRemoteListenerDeactivateOnException"), (String)FFDC_PROBE_7, (Object)this);
            SibTr.error((TraceComponent)TRACE, (String)"CONNECT_FAILED_CWSIV0783", (Object)new Object[]{this._endpointConfiguration.getDestination().getDestinationName(), this._endpointConfiguration.getBusName(), this, resourceException});
            this.deactivate();
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"createRemoteListenerDeactivateOnException");
        }
    }

    protected SibRaStringGenerator getStringGenerator() {
        SibRaStringGenerator sibRaStringGenerator = super.getStringGenerator();
        sibRaStringGenerator.addField("remoteConnection", this._remoteConnection);
        sibRaStringGenerator.addField("remoteDestination", this._remoteDestination);
        sibRaStringGenerator.addField("timer", this._timer);
        return sibRaStringGenerator;
    }

    static {
        if (TRACE.isDebugEnabled()) {
            SibTr.debug((TraceComponent)TRACE, (String)"Source info: @(#)SIB/ws/code/sib.ra.impl/src/com/ibm/ws/sib/ra/inbound/impl/SibRaStaticDestinationEndpointActivation.java, SIB.ra, WAS602.SIB, o0610.11 1.23");
        }
    }
}

