/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.ra.inbound.impl;

import com.ibm.CORBA.iiop.ORB;
import com.ibm.ejs.oa.EJSORB;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.ra.impl.SibRaUtils;
import com.ibm.ws.sib.ra.inbound.SibRaEndpointConfiguration;
import com.ibm.ws.sib.ra.inbound.impl.SibRaDispatchTarget;
import com.ibm.ws.sib.ra.inbound.impl.SibRaListener;
import com.ibm.ws.sib.ra.inbound.impl.SibRaMessageToken;
import com.ibm.ws.sib.ra.inbound.impl.SibRaMessagingEngineConnection;
import com.ibm.ws.sib.ra.inbound.impl.SibRaStringGenerator;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.ws.sib.z.dispatcher.SRDispatchException;
import com.ibm.ws.sib.z.dispatcher.SRDispatcher;
import com.ibm.ws.sib.z.dispatcher.SRDispatcherFactory;
import com.ibm.wsspi.sib.core.LockedMessageEnumeration;
import com.ibm.wsspi.sib.core.SIBusMessage;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.SIMessageHandle;
import com.ibm.wsspi.sib.core.exception.SIConnectionDroppedException;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIConnectionUnavailableException;
import com.ibm.wsspi.sib.core.exception.SILimitExceededException;
import com.ibm.wsspi.sib.core.exception.SIMessageNotLockedException;
import com.ibm.wsspi.sib.core.exception.SISessionDroppedException;
import com.ibm.wsspi.sib.core.exception.SISessionUnavailableException;
import com.ibm.wsspi.sib.exitpoint.ra.HashMap;
import com.ibm.wsspi.sib.exitpoint.ra.RAExitPoint;
import com.ibm.wsspi.sib.exitpoint.ra.RAHandler;
import com.ibm.wsspi.sib.exitpoint.ra.RAHandlerManager;
import com.ibm.wsspi.sib.exitpoint.ra.RAType;
import com.ibm.wsspi.sib.pacing.AsynchDispatchScheduler;
import java.io.NotSerializableException;
import java.util.ArrayList;
import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.endpoint.MessageEndpointFactory;

final class SibRaMultiProcessListener
extends SibRaListener {
    private final RAType _raType;
    private final ActivationSpec _activationSpec;
    private final String _busName;
    private final String _meUuid;
    private final long _sessionId;
    private final String _j2eeName;
    private final String _meName;
    private final String _destinationName;
    private final SRDispatcher _srDispatcher;
    private static final TraceComponent TRACE = SibRaUtils.getTraceComponent(SibRaMultiProcessListener.class);
    private static TraceNLS NLS = SibRaUtils.getTraceNls();
    private static final String CLASS_NAME = SibRaMultiProcessListener.class.getName();
    private static final String FFDC_PROBE_1 = "1";
    private static final String FFDC_PROBE_2 = "2";
    private static final String FFDC_PROBE_4 = "4";
    private static final String FFDC_PROBE_5 = "5";
    private static final String FFDC_PROBE_6 = "6";

    public SibRaMultiProcessListener(SibRaMessagingEngineConnection sibRaMessagingEngineConnection, SIDestinationAddress sIDestinationAddress) throws ResourceException {
        super(sibRaMessagingEngineConnection, sIDestinationAddress);
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"SibRaSingleProcessListener", (Object)new Object[]{sibRaMessagingEngineConnection, sIDestinationAddress});
        }
        SibRaEndpointConfiguration sibRaEndpointConfiguration = sibRaMessagingEngineConnection.getEndpointConfiguration();
        SICoreConnection sICoreConnection = sibRaMessagingEngineConnection.getConnection();
        this._raType = sibRaEndpointConfiguration.getRaType();
        this._activationSpec = sibRaEndpointConfiguration.getActivationSpec();
        this._busName = sibRaMessagingEngineConnection.getBusName();
        this._meName = sICoreConnection.getMeName();
        this._destinationName = sIDestinationAddress.getDestinationName();
        this._meUuid = sICoreConnection.getMeUuid();
        try {
            this._sessionId = this._session.getId();
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + "." + "SibRaSingleProcessListener"), (String)FFDC_PROBE_5, (Object)this);
            if (TRACE.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)sIException));
            }
            throw new ResourceException(NLS.getFormattedMessage("GET_ID_CWSIV1151", new Object[]{this._session, this._connection}, null), (Throwable)sIException);
        }
        MessageEndpointFactory messageEndpointFactory = sibRaMessagingEngineConnection.getEndpointActivation().getMessageEndpointFactory();
        if (!(messageEndpointFactory instanceof com.ibm.ws.j2c.MessageEndpointFactory)) {
            throw new ResourceAdapterInternalException(NLS.getFormattedMessage("WAS_ENDPOINT_FACTORY_CWSIV1152", new Object[]{messageEndpointFactory, com.ibm.ws.j2c.MessageEndpointFactory.class.getName()}, null));
        }
        this._j2eeName = ((com.ibm.ws.j2c.MessageEndpointFactory)messageEndpointFactory).getJ2EEName().toString();
        this._srDispatcher = SRDispatcherFactory.getSRDispatcher(SibRaDispatchTarget.class.getName());
        this.startConsumer();
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"SibRaSingleProcessListener");
        }
    }

    public void internalConsumeMessages(LockedMessageEnumeration lockedMessageEnumeration, AsynchDispatchScheduler asynchDispatchScheduler) {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"internalConsumeMessages", (Object)lockedMessageEnumeration);
        }
        try {
            Object object;
            boolean bl;
            SIBusMessage sIBusMessage;
            RAHandler rAHandler = RAHandlerManager.getHandlers(this._raType);
            ArrayList<SibRaMessageToken> arrayList = new ArrayList<SibRaMessageToken>();
            while ((sIBusMessage = lockedMessageEnumeration.nextLocked()) != null) {
                HashMap hashMap = new HashMap();
                bl = sIBusMessage.getReliability() == Reliability.BEST_EFFORT_NONPERSISTENT;
                object = sIBusMessage.getMessageHandle();
                if (!rAHandler.handle(this._raType, RAExitPoint.PRE_DISPATCH, this._activationSpec, this._busName, this._meName, this._destinationName, sIBusMessage, hashMap)) continue;
                boolean bl2 = false;
                for (int i = 0; i < arrayList.size(); ++i) {
                    SibRaMessageToken sibRaMessageToken = (SibRaMessageToken)arrayList.get(i);
                    if (!sibRaMessageToken.addHandle((SIMessageHandle)object, hashMap, bl)) continue;
                    if (TRACE.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)TRACE, (String)"Message handle added to existing token");
                    }
                    bl2 = true;
                    break;
                }
                if (bl2) continue;
                SibRaMessageToken sibRaMessageToken = new SibRaMessageToken(this._busName, this._meUuid, this._sessionId, this._j2eeName);
                sibRaMessageToken.addHandle((SIMessageHandle)object, hashMap, bl);
                arrayList.add(sibRaMessageToken);
                if (!TRACE.isDebugEnabled()) continue;
                SibTr.debug((TraceComponent)TRACE, (String)"New token created and message handle added to it");
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                block12: {
                    bl = false;
                    object = (SibRaMessageToken)arrayList.get(i);
                    if (((SibRaMessageToken)object).getNumberOfMessageHandles() == 0) continue;
                    try {
                        this._srDispatcher.dispatch(object, ((SibRaMessageToken)object).getContext());
                        bl = true;
                        ((SibRaMessageToken)object).clear();
                    }
                    catch (NotSerializableException notSerializableException) {
                        FFDCFilter.processException((Throwable)notSerializableException, (String)(CLASS_NAME + "." + "internalConsumeMessages"), (String)FFDC_PROBE_1, (Object)this);
                        if (TRACE.isEventEnabled()) {
                            SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)notSerializableException);
                        }
                    }
                    catch (SRDispatchException sRDispatchException) {
                        FFDCFilter.processException((Throwable)sRDispatchException, (String)(CLASS_NAME + "." + "internalConsumeMessages"), (String)FFDC_PROBE_2, (Object)this);
                        if (!TRACE.isEventEnabled()) break block12;
                        SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)sRDispatchException);
                    }
                }
                if (bl) continue;
                this._session.unlockSet(((SibRaMessageToken)object).getMessageHandleArray());
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)(CLASS_NAME + "." + "internalConsumeMessages"), (String)FFDC_PROBE_4, (Object)this);
            SibTr.error((TraceComponent)TRACE, (String)"RETRIEVE_MESSAGES_CWSIV1150", (Object)new Object[]{throwable, lockedMessageEnumeration});
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"internalConsumeMessages");
        }
    }

    boolean isSessionBifurcated() {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"isSessionBifurcated");
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"isSessionBifurcated", (Object)Boolean.TRUE);
        }
        return true;
    }

    int getMaxActiveMessages() {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"getMaxActiveMessages");
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"getMaxActiveMessages", (Object)new Integer(this._maxActiveMessages));
        }
        return this._maxActiveMessages;
    }

    long getMessageLockExpiry() {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"getMessageLockExpiry");
        }
        long l = 0L;
        ORB oRB = EJSORB.getORBInstance();
        String string = oRB.getProperty("was.wlmTimeout");
        if (string != null && string.length() != 0) {
            try {
                l = Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                FFDCFilter.processException((Throwable)numberFormatException, (String)(CLASS_NAME + "." + "getMessageLockExpiry"), (String)FFDC_PROBE_6, (Object)this);
            }
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"getMessageLockExpiry", (Object)new Long(l));
        }
        return l;
    }

    protected void processCachedMessage(SIBusMessage sIBusMessage, LockedMessageEnumeration lockedMessageEnumeration) throws SISessionDroppedException, SIConnectionDroppedException, SISessionUnavailableException, SIConnectionUnavailableException, SIConnectionLostException, SILimitExceededException, SIMessageNotLockedException, SIResourceException, SIIncorrectCallException {
    }

    protected SibRaStringGenerator getStringGenerator() {
        SibRaStringGenerator sibRaStringGenerator = super.getStringGenerator();
        sibRaStringGenerator.addField("activationSpec", this._activationSpec);
        sibRaStringGenerator.addField("busName", this._busName);
        sibRaStringGenerator.addField("destinationName", this._destinationName);
        sibRaStringGenerator.addField("maxActiveMessages", this._maxActiveMessages);
        sibRaStringGenerator.addField("meName", this._meName);
        sibRaStringGenerator.addField("raType", this._raType);
        sibRaStringGenerator.addField("meUuid", this._meUuid);
        sibRaStringGenerator.addField("sessionId", this._sessionId);
        sibRaStringGenerator.addField("j2eeName", this._j2eeName);
        return sibRaStringGenerator;
    }

    static {
        if (TRACE.isDebugEnabled()) {
            SibTr.debug((TraceComponent)TRACE, (String)"Source info: @(#)SIB/ws/code/sib.ra.impl/src/com/ibm/ws/sib/ra/inbound/impl/SibRaMultiProcessListener.java, SIB.ra, WAS602.SIB, o0610.11 1.9.1.1");
        }
    }
}

