/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.ra.inbound.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SINotPossibleInCurrentConfigurationException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.JsMessagingEngine;
import com.ibm.ws.sib.processor.DestinationAvailability;
import com.ibm.ws.sib.processor.DestinationListener;
import com.ibm.ws.sib.processor.MPCoreConnection;
import com.ibm.ws.sib.ra.SibRaEngineComponent;
import com.ibm.ws.sib.ra.SibRaMessagingEngineListener;
import com.ibm.ws.sib.ra.impl.SibRaUtils;
import com.ibm.ws.sib.ra.inbound.SibRaEndpointConfiguration;
import com.ibm.ws.sib.ra.inbound.SibRaEndpointInvoker;
import com.ibm.ws.sib.ra.inbound.impl.SibRaEndpointActivation;
import com.ibm.ws.sib.ra.inbound.impl.SibRaMessagingEngineConnection;
import com.ibm.ws.sib.ra.inbound.impl.SibRaResourceAdapterImpl;
import com.ibm.ws.sib.ra.inbound.impl.SibRaStringGenerator;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.ConsumerSession;
import com.ibm.wsspi.sib.core.DestinationType;
import com.ibm.wsspi.sib.core.SICoreConnection;
import java.util.Map;
import javax.resource.ResourceException;
import javax.resource.spi.endpoint.MessageEndpointFactory;

final class SibRaDynamicDestinationEndpointActivation
extends SibRaEndpointActivation {
    private static final TraceComponent TRACE = SibRaUtils.getTraceComponent(SibRaDynamicDestinationEndpointActivation.class);
    private static final TraceComponent LISTENER_TRACE = SibRaUtils.getTraceComponent(SibRaDestinationListener.class);
    private static final String CLASS_NAME = SibRaDynamicDestinationEndpointActivation.class.getName();
    private static final String FFDC_PROBE_1 = "1";
    private static final String FFDC_PROBE_2 = "2";
    private static final String FFDC_PROBE_3 = "3";
    private static final String FFDC_PROBE_4 = "4";

    SibRaDynamicDestinationEndpointActivation(SibRaResourceAdapterImpl sibRaResourceAdapterImpl, MessageEndpointFactory messageEndpointFactory, SibRaEndpointConfiguration sibRaEndpointConfiguration, SibRaEndpointInvoker sibRaEndpointInvoker) throws ResourceException {
        super(sibRaResourceAdapterImpl, messageEndpointFactory, sibRaEndpointConfiguration, sibRaEndpointInvoker);
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"SibRaDynamicDestinationEndpointActivation", (Object)new Object[]{sibRaResourceAdapterImpl, messageEndpointFactory, sibRaEndpointConfiguration, sibRaEndpointInvoker});
        }
        JsMessagingEngine[] jsMessagingEngineArray = SibRaEngineComponent.registerMessagingEngineListener((SibRaMessagingEngineListener)this, (String)this._endpointConfiguration.getBusName());
        for (int i = 0; i < jsMessagingEngineArray.length; ++i) {
            this.addMessagingEngine(jsMessagingEngineArray[i]);
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"SibRaDynamicDestinationEndpointActivation");
        }
    }

    protected synchronized void addMessagingEngine(JsMessagingEngine jsMessagingEngine) {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"addMessagingEngine", (Object)jsMessagingEngine);
        }
        SibRaMessagingEngineConnection sibRaMessagingEngineConnection = null;
        try {
            sibRaMessagingEngineConnection = this.getConnection(jsMessagingEngine);
            SICoreConnection sICoreConnection = sibRaMessagingEngineConnection.getConnection();
            if (sICoreConnection instanceof MPCoreConnection) {
                MPCoreConnection mPCoreConnection = (MPCoreConnection)sICoreConnection;
                SibRaDestinationListener sibRaDestinationListener = new SibRaDestinationListener(sibRaMessagingEngineConnection);
                DestinationType destinationType = this._endpointConfiguration.getDestinationType();
                SIDestinationAddress[] sIDestinationAddressArray = mPCoreConnection.addDestinationListener(sibRaDestinationListener, destinationType, DestinationAvailability.RECEIVE);
                for (int i = 0; i < sIDestinationAddressArray.length; ++i) {
                    try {
                        sibRaMessagingEngineConnection.createListener(sIDestinationAddressArray[i]);
                        continue;
                    }
                    catch (ResourceException resourceException) {
                        FFDCFilter.processException((Throwable)resourceException, (String)(CLASS_NAME + "." + "addMessagingEngine"), (String)FFDC_PROBE_1, (Object)this);
                        SibTr.error((TraceComponent)TRACE, (String)"CREATE_LISTENER_FAILED_CWSIV0803", (Object)new Object[]{resourceException, sIDestinationAddressArray[i].getDestinationName(), jsMessagingEngine.getName(), jsMessagingEngine.getBusName()});
                    }
                }
            }
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + "." + "addMessagingEngine"), (String)FFDC_PROBE_2, (Object)this);
            SibTr.error((TraceComponent)TRACE, (String)"ADD_DESTINATION_LISTENER_FAILED_CWSIV0804", (Object)new Object[]{sIException, jsMessagingEngine.getName(), jsMessagingEngine.getBusName()});
            this.closeConnection(jsMessagingEngine);
        }
        catch (ResourceException resourceException) {
            FFDCFilter.processException((Throwable)resourceException, (String)(CLASS_NAME + "." + "addMessagingEngine"), (String)FFDC_PROBE_3, (Object)this);
            SibTr.error((TraceComponent)TRACE, (String)"CREATE_CONNECTION_FAILED_CWSIV0801", (Object)new Object[]{resourceException, jsMessagingEngine.getName(), jsMessagingEngine.getBusName()});
            this.closeConnection(jsMessagingEngine);
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"addMessagingEngine");
        }
    }

    void sessionError(SibRaMessagingEngineConnection sibRaMessagingEngineConnection, ConsumerSession consumerSession, Throwable throwable) {
        if (!(throwable instanceof SINotPossibleInCurrentConfigurationException)) {
            SIDestinationAddress sIDestinationAddress = consumerSession.getDestinationAddress();
            SibTr.error((TraceComponent)TRACE, (String)"SESSION_ERROR_CWSIV0806", (Object)new Object[]{throwable, sIDestinationAddress.getDestinationName(), sibRaMessagingEngineConnection.getConnection().getMeName(), sIDestinationAddress.getBusName(), this});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void connectionError(SibRaMessagingEngineConnection sibRaMessagingEngineConnection, SIException sIException) {
        SibTr.error((TraceComponent)TRACE, (String)"CONNECTION_ERROR_CWSIV0807", (Object)new Object[]{sIException, sibRaMessagingEngineConnection.getConnection().getMeName(), this});
        Map map = this._connections;
        synchronized (map) {
            this._connections.remove(sibRaMessagingEngineConnection.getConnection().getMeUuid().toString());
        }
        sibRaMessagingEngineConnection.close();
    }

    void messagingEngineTerminated(SibRaMessagingEngineConnection sibRaMessagingEngineConnection) {
    }

    void messagingEngineQuiescing(SibRaMessagingEngineConnection sibRaMessagingEngineConnection) {
    }

    public void messagingEngineInitializing(JsMessagingEngine jsMessagingEngine) {
    }

    public void messagingEngineDestroyed(JsMessagingEngine jsMessagingEngine) {
    }

    public void messagingEngineReloaded(JsMessagingEngine jsMessagingEngine) {
    }

    static {
        if (TRACE.isDebugEnabled()) {
            SibTr.debug((TraceComponent)TRACE, (String)"Source info: @(#)SIB/ws/code/sib.ra.impl/src/com/ibm/ws/sib/ra/inbound/impl/SibRaDynamicDestinationEndpointActivation.java, SIB.ra, WAS602.SIB, o0610.11 1.15");
        }
    }

    private static final class SibRaDestinationListener
    implements DestinationListener {
        private final SibRaMessagingEngineConnection _connection;

        private SibRaDestinationListener(SibRaMessagingEngineConnection sibRaMessagingEngineConnection) {
            if (LISTENER_TRACE.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)LISTENER_TRACE, (String)"SibRaDestinationListener", (Object)sibRaMessagingEngineConnection);
            }
            this._connection = sibRaMessagingEngineConnection;
            if (LISTENER_TRACE.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)LISTENER_TRACE, (String)"SibRaDestinationListener");
            }
        }

        public void destinationAvailable(SICoreConnection sICoreConnection, SIDestinationAddress sIDestinationAddress, DestinationAvailability destinationAvailability) {
            if (LISTENER_TRACE.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)LISTENER_TRACE, (String)"destinationAvailable", (Object)new Object[]{sICoreConnection, sIDestinationAddress, destinationAvailability});
            }
            try {
                this._connection.createListener(sIDestinationAddress);
            }
            catch (ResourceException resourceException) {
                FFDCFilter.processException((Throwable)resourceException, (String)(CLASS_NAME + "." + "destinationAvailable"), (String)SibRaDynamicDestinationEndpointActivation.FFDC_PROBE_4, (Object)this);
                SibTr.error((TraceComponent)TRACE, (String)"CREATE_LISTENER_FAILED_CWSIV0805", (Object)new Object[]{resourceException, sIDestinationAddress.getDestinationName(), sICoreConnection.getMeName(), sIDestinationAddress.getBusName()});
            }
            if (LISTENER_TRACE.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)LISTENER_TRACE, (String)"destinationAvailable");
            }
        }

        public String toString() {
            SibRaStringGenerator sibRaStringGenerator = new SibRaStringGenerator(this);
            return sibRaStringGenerator.getStringRepresentation();
        }
    }
}

