/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.ra.inbound.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.pmi.rm.SIBPmiRm;
import com.ibm.ws.sib.ra.impl.SibRaUtils;
import com.ibm.ws.sib.ra.inbound.SibRaEndpointConfiguration;
import com.ibm.ws.sib.ra.inbound.SibRaEndpointInvoker;
import com.ibm.ws.sib.ra.inbound.impl.SibRaEndpointActivation;
import com.ibm.ws.sib.ra.inbound.impl.SibRaStringGenerator;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.AbstractConsumerSession;
import com.ibm.wsspi.sib.core.SIBusMessage;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.SIMessageHandle;
import com.ibm.wsspi.sib.core.SITransaction;
import com.ibm.wsspi.sib.core.SIUncoordinatedTransaction;
import com.ibm.wsspi.sib.exitpoint.ra.RAExitPoint;
import com.ibm.wsspi.sib.exitpoint.ra.RAHandlerManager;
import com.ibm.wsspi.sib.pacing.AsynchDispatchScheduler;
import com.ibm.wsspi.sib.pacing.MessagePacingControlFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.resource.ResourceException;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.endpoint.MessageEndpoint;
import javax.resource.spi.endpoint.MessageEndpointFactory;

abstract class SibRaDispatcher {
    private volatile boolean _cancelled = false;
    protected final SICoreConnection _connection;
    protected final AbstractConsumerSession _session;
    protected final MessageEndpointFactory _endpointFactory;
    protected final SibRaEndpointInvoker _invoker;
    protected final SibRaEndpointConfiguration _endpointConfiguration;
    protected boolean _bestEffortNonPersistentMessagesDeleted;
    private final SIBPmiRm _requestMetrics;
    private static TraceComponent TRACE = SibRaUtils.getTraceComponent(SibRaDispatcher.class);
    private static TraceNLS NLS = SibRaUtils.getTraceNls();
    private static final String CLASS_NAME = SibRaDispatcher.class.getName();
    private static final String FFDC_PROBE_1 = "1";
    private static final String FFDC_PROBE_3 = "3";
    private static final String FFDC_PROBE_4 = "4";
    private static final String FFDC_PROBE_5 = "5";
    private static final String FFDC_PROBE_9 = "9";
    private static final String FFDC_PROBE_10 = "10";
    private static final String FFDC_PROBE_11 = "11";

    SibRaDispatcher(SICoreConnection sICoreConnection, AbstractConsumerSession abstractConsumerSession, SibRaEndpointActivation sibRaEndpointActivation) throws ResourceException {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"SibRaDispatcher", (Object)new Object[]{sICoreConnection, abstractConsumerSession, sibRaEndpointActivation});
        }
        this._bestEffortNonPersistentMessagesDeleted = false;
        this._connection = sICoreConnection;
        this._session = abstractConsumerSession;
        this._endpointConfiguration = sibRaEndpointActivation.getEndpointConfiguration();
        this._invoker = sibRaEndpointActivation.getEndpointInvoker();
        this._endpointFactory = sibRaEndpointActivation.getMessageEndpointFactory();
        try {
            this._requestMetrics = SIBPmiRm.getInstance();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + "." + "SibRaDispatcher"), (String)FFDC_PROBE_1, (Object)this);
            if (TRACE.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)exception);
            }
            throw new ResourceAdapterInternalException(NLS.getFormattedMessage("REQUEST_METRICS_CWSIV0604", new Object[]{exception}, null), (Throwable)exception);
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"SibRaDispatcher");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    synchronized void dispatch(SIBusMessage var1_1, Map var2_2) throws ResourceException {
        block36: {
            if (SibRaDispatcher.TRACE.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)SibRaDispatcher.TRACE, (String)"dispatch", (Object)new Object[]{var1_1, var2_2});
            }
            if (this._session == null) {
                if (SibRaDispatcher.TRACE.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)SibRaDispatcher.TRACE, (String)"dispatch");
                }
                return;
            }
            var4_3 = false;
            var5_4 = this._endpointConfiguration.getRaType();
            var6_5 = RAHandlerManager.getHandlers(var5_4);
            var7_6 = null;
            try {
                var7_6 = this.createEndpoint();
                var8_7 = this._session.getDestinationAddress();
                var9_8 = var8_7.getBusName();
                var10_9 = this._connection.getMeName();
                var11_10 = var8_7.getDestinationName();
                var12_11 = this._endpointConfiguration.getMessageSelector();
                var13_12 = this._endpointConfiguration.getDiscriminator();
                var14_13 = this._endpointConfiguration.getActivationSpec();
                if (!this._cancelled && var6_5.handle(var5_4, RAExitPoint.PRE_DELIVERY, var14_13, var9_8, var10_9, var11_10, var1_1, var2_2)) {
                    var15_14 = false;
                    var16_15 = null;
                    try {
                        this.beforeDelivery(var1_1, var7_6);
                        var4_3 = true;
                        try {
                            var16_15 = this._requestMetrics.preMDBConsumeMessage(var1_1, var9_8, var11_10, var12_11, var13_12);
                            var17_16 = MessagePacingControlFactory.getInstance();
                            if (var17_16 != null && var17_16.isActive()) {
                                var17_16.preMdbInvoke((Object)this, null);
                            }
                            var15_14 = this._invoker.invokeEndpoint(var7_6, var1_1, this._session, this.getTransaction());
                            if (var17_16 != null && var17_16.isActive()) {
                                var17_16.postMdbInvoke((Object)this, null);
                            }
                        }
                        finally {
                            this.afterDelivery(var1_1, var7_6, var15_14);
                        }
                        var20_18 = null;
                    }
                    catch (Throwable var19_26) {
                        var20_19 = null;
                        try {
                            var6_5.handle(var5_4, RAExitPoint.POST_DELIVERY, var14_13, var9_8, var10_9, var11_10, var1_1, var2_2);
                            v0 = null;
                        }
                        catch (Throwable var21_21) {
                            v0 = null;
                        }
                        var22_23 = v0;
                        var23_25 = this.isTransactionRolledBack();
                        if (var16_15 != null) {
                            var15_14 = var15_14 != false && var23_25 == false;
                            this._requestMetrics.postMDBConsumeMessage(var16_15, var15_14 != false ? 0 : 1);
                        }
                        throw var19_26;
                    }
                    try {
                        var6_5.handle(var5_4, RAExitPoint.POST_DELIVERY, var14_13, var9_8, var10_9, var11_10, var1_1, var2_2);
                        v1 = null;
                    }
                    catch (Throwable var21_20) {
                        v1 = null;
                    }
                    var22_22 = v1;
                    var23_24 = this.isTransactionRolledBack();
                    if (var16_15 != null) {
                        var15_14 = var15_14 != false && var23_24 == false;
                        this._requestMetrics.postMDBConsumeMessage(var16_15, var15_14 != false ? 0 : 1);
                    }
                    break block36;
                }
                if (this._cancelled) break block36;
                if (SibRaDispatcher.TRACE.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)SibRaDispatcher.TRACE, (String)"An RA Handler failed - increasing retry count on message by rolling back a delete on the message:", (Object)var1_1);
                }
                this.increaseRetryCount(var1_1);
                var4_3 = true;
            }
            catch (Throwable var24_33) {
                block37: {
                    var25_28 = null;
                    try {
                        this.cleanup();
                        if (var4_3) break block37;
                        if (SibRaDispatcher.TRACE.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)SibRaDispatcher.TRACE, (String)"Unlocking undelivered message:", (Object)var1_1);
                        }
                        try {
                            if (!this._bestEffortNonPersistentMessagesDeleted || !Reliability.BEST_EFFORT_NONPERSISTENT.equals(var1_1.getReliability())) {
                                this._session.unlockSet(new SIMessageHandle[]{var1_1.getMessageHandle()});
                            }
                        }
                        catch (SIException var26_30) {
                            if (SibRaDispatcher.TRACE.isEventEnabled()) {
                                SibTr.exception((Object)this, (TraceComponent)SibRaDispatcher.TRACE, (Exception)var26_30);
                            }
                        }
                    }
                    finally {
                        if (var7_6 != null) {
                            var7_6.release();
                        }
                    }
                }
                throw var24_33;
            }
        }
        var25_27 = null;
        try {
            this.cleanup();
            if (var4_3) ** GOTO lbl118
            if (SibRaDispatcher.TRACE.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)SibRaDispatcher.TRACE, (String)"Unlocking undelivered message:", (Object)var1_1);
            }
            try {
                if (this._bestEffortNonPersistentMessagesDeleted && Reliability.BEST_EFFORT_NONPERSISTENT.equals(var1_1.getReliability())) ** GOTO lbl118
                this._session.unlockSet(new SIMessageHandle[]{var1_1.getMessageHandle()});
            }
            catch (SIException var26_29) {
                if (!SibRaDispatcher.TRACE.isEventEnabled()) ** GOTO lbl118
                SibTr.exception((Object)this, (TraceComponent)SibRaDispatcher.TRACE, (Exception)var26_29);
            }
        }
        finally {
            if (var7_6 != null) {
                var7_6.release();
            }
        }
lbl118:
        // 5 sources

        if (SibRaDispatcher.TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)SibRaDispatcher.TRACE, (String)"dispatch");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    synchronized void dispatch(List var1_1, AsynchDispatchScheduler var2_2) throws ResourceException {
        if (SibRaDispatcher.TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)SibRaDispatcher.TRACE, (String)"dispatch", (Object)var1_1);
        }
        if (this._session == null) {
            if (SibRaDispatcher.TRACE.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)SibRaDispatcher.TRACE, (String)"dispatch");
            }
            return;
        }
        var4_3 = new ArrayList<E>(var1_1);
        var5_4 = this._endpointConfiguration.getRaType();
        var6_5 = RAHandlerManager.getHandlers(var5_4);
        var7_6 = null;
        var7_6 = this.createEndpoint();
        var8_7 = this._session.getDestinationAddress();
        var9_8 = var8_7.getBusName();
        var10_9 = this._connection.getMeName();
        var11_10 = var8_7.getDestinationName();
        var12_11 = this._endpointConfiguration.getMessageSelector();
        var13_12 = this._endpointConfiguration.getDiscriminator();
        var14_13 = this._endpointConfiguration.getActivationSpec();
        var15_14 = var1_1.iterator();
        while (var15_14.hasNext() && !this._cancelled) {
            var16_15 = (SIBusMessage)var15_14.next();
            if (var6_5.handle(var5_4, RAExitPoint.PRE_DELIVERY, var14_13, var9_8, var10_9, var11_10, var16_15, var17_16 = new HashMap<K, V>())) {
                var18_17 = false;
                var19_18 = null;
                try {
                    this.beforeDelivery(var16_15, var7_6);
                    var4_3.remove(var16_15);
                    try {
                        var19_18 = this._requestMetrics.preMDBConsumeMessage(var16_15, var9_8, var11_10, var12_11, var13_12);
                        var20_19 = MessagePacingControlFactory.getInstance();
                        if (var20_19 != null && var20_19.isActive()) {
                            var20_19.preMdbInvoke((Object)this, var2_2);
                        }
                        var18_17 = this._invoker.invokeEndpoint(var7_6, var16_15, this._session, this.getTransaction());
                        if (var20_19 != null && var20_19.isActive()) {
                            var20_19.postMdbInvoke((Object)this, var2_2);
                        }
                    }
                    finally {
                        this.afterDelivery(var16_15, var7_6, var18_17);
                    }
                    var23_20 = null;
                }
                catch (Throwable var22_25) {
                    var23_20 = null;
                    try {
                        var6_5.handle(var5_4, RAExitPoint.POST_DELIVERY, var14_13, var9_8, var10_9, var11_10, var16_15, var17_16);
                        v0 = null;
                    }
                    catch (Throwable var24_21) {
                        v0 = null;
                    }
                    var25_22 = v0;
                    var26_23 = this.isTransactionRolledBack();
                    if (var19_18 != null) {
                        var18_17 = var18_17 != false && var26_23 == false;
                        this._requestMetrics.postMDBConsumeMessage(var19_18, var18_17 != false ? 0 : 1);
                    }
                    throw var22_25;
                }
                try {
                    var6_5.handle(var5_4, RAExitPoint.POST_DELIVERY, var14_13, var9_8, var10_9, var11_10, var16_15, var17_16);
                    v1 = null;
                }
                catch (Throwable var24_21) {
                    v1 = null;
                }
                var25_22 = v1;
                var26_23 = this.isTransactionRolledBack();
                if (var19_18 == null) continue;
                var18_17 = var18_17 != false && var26_23 == false;
                this._requestMetrics.postMDBConsumeMessage(var19_18, var18_17 != false ? 0 : 1);
                {
                    continue;
                }
            }
            if (SibRaDispatcher.TRACE.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)SibRaDispatcher.TRACE, (String)"An RA Handler failed - increasing retry count on message by rolling back a delete on the message:", (Object)var16_15);
            }
            this.increaseRetryCount(var16_15);
            var4_3.remove(var16_15);
        }
        var28_26 = null;
        this.cleanup();
        try {
            if (var4_3.size() <= 0) ** GOTO lbl139
            try {
                if (this._bestEffortNonPersistentMessagesDeleted) {
                    var29_28 = var4_3.iterator();
                    while (var29_28.hasNext()) {
                        var30_32 = (SIBusMessage)var29_28.next();
                        if (!Reliability.BEST_EFFORT_NONPERSISTENT.equals(var30_32.getReliability())) continue;
                        if (SibRaDispatcher.TRACE.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)SibRaDispatcher.TRACE, (String)"Removing the following best effort non persistant message as it has already been deleted: ", (Object)var30_32);
                        }
                        var29_28.remove();
                    }
                }
                if (var4_3.size() <= 0) ** GOTO lbl139
                if (SibRaDispatcher.TRACE.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)SibRaDispatcher.TRACE, (String)"Unlocking undelivered messages:", var4_3);
                }
                this.unlockMessages(var4_3);
            }
            catch (ResourceException var29_29) {
                if (!SibRaDispatcher.TRACE.isEventEnabled()) ** GOTO lbl139
                SibTr.exception((Object)this, (TraceComponent)SibRaDispatcher.TRACE, (Exception)var29_29);
            }
        }
        finally {
            if (var7_6 != null) {
                var7_6.release();
            }
        }
        catch (Throwable var27_36) {
            block42: {
                var28_27 = null;
                this.cleanup();
                try {
                    if (var4_3.size() <= 0) break block42;
                    try {
                        if (this._bestEffortNonPersistentMessagesDeleted) {
                            var29_30 = var4_3.iterator();
                            while (var29_30.hasNext()) {
                                var30_33 = (SIBusMessage)var29_30.next();
                                if (!Reliability.BEST_EFFORT_NONPERSISTENT.equals(var30_33.getReliability())) continue;
                                if (SibRaDispatcher.TRACE.isDebugEnabled()) {
                                    SibTr.debug((Object)this, (TraceComponent)SibRaDispatcher.TRACE, (String)"Removing the following best effort non persistant message as it has already been deleted: ", (Object)var30_33);
                                }
                                var29_30.remove();
                            }
                        }
                        if (var4_3.size() > 0) {
                            if (SibRaDispatcher.TRACE.isDebugEnabled()) {
                                SibTr.debug((Object)this, (TraceComponent)SibRaDispatcher.TRACE, (String)"Unlocking undelivered messages:", var4_3);
                            }
                            this.unlockMessages(var4_3);
                        }
                    }
                    catch (ResourceException var29_31) {
                        if (SibRaDispatcher.TRACE.isEventEnabled()) {
                            SibTr.exception((Object)this, (TraceComponent)SibRaDispatcher.TRACE, (Exception)var29_31);
                        }
                    }
                }
                finally {
                    if (var7_6 != null) {
                        var7_6.release();
                    }
                }
            }
            throw var27_36;
        }
lbl139:
        // 5 sources

        if (SibRaDispatcher.TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)SibRaDispatcher.TRACE, (String)"dispatch");
        }
    }

    void close() {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"close");
        }
        this._cancelled = true;
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"close");
        }
    }

    void cancel() {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"cancel");
        }
        this._cancelled = true;
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"cancel");
        }
    }

    protected final void unlockMessages(List list) throws ResourceException {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"unlockMessages", (Object)list);
        }
        if (list.size() > 0) {
            try {
                this._session.unlockSet(SibRaDispatcher.getMessageHandles(list));
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + "." + "unlockMessages"), (String)FFDC_PROBE_3, (Object)this);
                if (TRACE.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)sIException));
                }
                throw new ResourceAdapterInternalException(NLS.getFormattedMessage("UNLOCK_EXCEPTION_CWSIV0601", new Object[]{sIException, list}, null), (Throwable)sIException);
            }
            catch (SIErrorException sIErrorException) {
                FFDCFilter.processException((Throwable)sIErrorException, (String)(CLASS_NAME + "." + "unlockMessages"), (String)FFDC_PROBE_9, (Object)this);
                if (TRACE.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)sIErrorException));
                }
                throw new ResourceAdapterInternalException(NLS.getFormattedMessage("UNLOCK_EXCEPTION_CWSIV0601", new Object[]{sIErrorException, list}, null), (Throwable)sIErrorException);
            }
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"unlockMessages");
        }
    }

    protected final void deleteMessage(SIBusMessage sIBusMessage, SITransaction sITransaction) throws ResourceException {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"deleteMessage", (Object)new Object[]{sIBusMessage, sITransaction});
        }
        try {
            this._session.deleteSet(new SIMessageHandle[]{sIBusMessage.getMessageHandle()}, sITransaction);
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + "." + "deleteMessage"), (String)FFDC_PROBE_4, (Object)this);
            if (TRACE.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)sIException));
            }
            throw new ResourceAdapterInternalException(NLS.getFormattedMessage("DELETE_EXCEPTION_CWSIV0602", new Object[]{sIException, sIBusMessage, sITransaction}, null), (Throwable)sIException);
        }
        catch (SIErrorException sIErrorException) {
            FFDCFilter.processException((Throwable)sIErrorException, (String)(CLASS_NAME + "." + "deleteMessage"), (String)FFDC_PROBE_10, (Object)this);
            if (TRACE.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)sIErrorException));
            }
            throw new ResourceAdapterInternalException(NLS.getFormattedMessage("DELETE_EXCEPTION_CWSIV0602", new Object[]{sIErrorException, sIBusMessage, sITransaction}, null), (Throwable)sIErrorException);
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"deleteMessage");
        }
    }

    protected final void deleteMessages(List list, SITransaction sITransaction) throws ResourceException {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"deleteMessages", (Object)new Object[]{list, sITransaction});
        }
        if (list.size() > 0) {
            try {
                this._session.deleteSet(SibRaDispatcher.getMessageHandles(list), sITransaction);
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + "." + "deleteMessages"), (String)FFDC_PROBE_5, (Object)this);
                if (TRACE.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)sIException));
                }
                throw new ResourceAdapterInternalException(NLS.getFormattedMessage("DELETE_SET_EXCEPTION_CWSIV0603", new Object[]{sIException, list, sITransaction}, null), (Throwable)sIException);
            }
            catch (SIErrorException sIErrorException) {
                FFDCFilter.processException((Throwable)sIErrorException, (String)(CLASS_NAME + "." + "deleteMessages"), (String)FFDC_PROBE_11, (Object)this);
                if (TRACE.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)sIErrorException));
                }
                throw new ResourceAdapterInternalException(NLS.getFormattedMessage("DELETE_SET_EXCEPTION_CWSIV0603", new Object[]{sIErrorException, list, sITransaction}, null), (Throwable)sIErrorException);
            }
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"deleteMessages");
        }
    }

    protected static final SIMessageHandle[] getMessageHandles(List list) {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((TraceComponent)TRACE, (String)"getMessageIds", (Object)list);
        }
        SIMessageHandle[] sIMessageHandleArray = new SIMessageHandle[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            SIBusMessage sIBusMessage = (SIBusMessage)list.get(i);
            sIMessageHandleArray[i] = sIBusMessage.getMessageHandle();
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((TraceComponent)TRACE, (String)"getMessageIds", (Object)sIMessageHandleArray);
        }
        return sIMessageHandleArray;
    }

    protected abstract SITransaction getTransaction() throws ResourceException;

    protected abstract MessageEndpoint createEndpoint() throws ResourceException;

    protected abstract void beforeDelivery(SIBusMessage var1, MessageEndpoint var2) throws ResourceException;

    protected abstract void afterDelivery(SIBusMessage var1, MessageEndpoint var2, boolean var3) throws ResourceException;

    protected abstract void cleanup();

    public final String toString() {
        return this.getStringGenerator().getStringRepresentation();
    }

    protected boolean isTransactionRolledBack() {
        return false;
    }

    protected void increaseRetryCount(SIBusMessage sIBusMessage) {
        block4: {
            if (TRACE.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"increaseRetryCount");
            }
            try {
                SIUncoordinatedTransaction sIUncoordinatedTransaction = this._connection.createUncoordinatedTransaction();
                this.deleteMessage(sIBusMessage, (SITransaction)sIUncoordinatedTransaction);
                sIUncoordinatedTransaction.rollback();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + "." + "increaseRetryCount"), (String)FFDC_PROBE_3, (Object)this);
                if (!TRACE.isEventEnabled()) break block4;
                SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)exception);
            }
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"increaseRetryCount");
        }
    }

    protected SibRaStringGenerator getStringGenerator() {
        SibRaStringGenerator sibRaStringGenerator = new SibRaStringGenerator(this);
        sibRaStringGenerator.addField("cancelled", this._cancelled);
        sibRaStringGenerator.addField("connection", this._connection);
        sibRaStringGenerator.addField("session", this._session);
        sibRaStringGenerator.addField("endpointFactory", this._endpointFactory);
        sibRaStringGenerator.addField("invoker", this._invoker);
        sibRaStringGenerator.addField("endpointConfiguration", this._endpointConfiguration);
        sibRaStringGenerator.addField("requestMetries", this._requestMetrics);
        return sibRaStringGenerator;
    }

    static {
        if (TRACE.isDebugEnabled()) {
            SibTr.debug((TraceComponent)TRACE, (String)"Source info: @(#)SIB/ws/code/sib.ra.impl/src/com/ibm/ws/sib/ra/inbound/impl/SibRaDispatcher.java, SIB.ra, WAS602.SIB, o0610.11 1.26.1.2");
        }
    }
}

