/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.ra.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.j2c.SelfXARecoverable;
import com.ibm.ws.sib.ra.impl.SibRaConnection;
import com.ibm.ws.sib.ra.impl.SibRaConnectionFactory;
import com.ibm.ws.sib.ra.impl.SibRaConnectionInfo;
import com.ibm.ws.sib.ra.impl.SibRaConnectionRequestInfo;
import com.ibm.ws.sib.ra.impl.SibRaManagedConnection;
import com.ibm.ws.sib.ra.impl.SibRaUtils;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.SICoreConnectionFactory;
import com.ibm.wsspi.sib.core.selector.FactoryType;
import com.ibm.wsspi.sib.core.selector.SICoreConnectionFactorySelector;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Set;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.security.auth.Subject;

public final class SibRaManagedConnectionFactory
implements ManagedConnectionFactory,
SelfXARecoverable,
Serializable {
    private static final long serialVersionUID = -736200360627318942L;
    private transient SICoreConnectionFactory _coreFactory;
    private String _xaRecoveryAlias;
    private transient PrintWriter _logWriter;
    private static final TraceComponent TRACE = SibRaUtils.getTraceComponent(SibRaConnection.class);
    private static final TraceNLS NLS = SibRaUtils.getTraceNls();
    private static final String FFDC_PROBE_1 = "1";
    private static final String FFDC_PROBE_2 = "2";
    private static final String FFDC_PROBE_3 = "3";
    private static final String FFDC_PROBE_4 = "4";
    private static final String FFDC_PROBE_5 = "5";

    public SibRaManagedConnectionFactory() {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"SibRaManagedConnectionFactory");
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"SibRaManagedConnectionFactory");
        }
    }

    public Object createConnectionFactory(ConnectionManager connectionManager) {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"createConnectionFactory", (Object)connectionManager);
        }
        SibRaConnectionFactory sibRaConnectionFactory = new SibRaConnectionFactory(this, connectionManager);
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"createConnectionFactory", (Object)sibRaConnectionFactory);
        }
        return sibRaConnectionFactory;
    }

    public Object createConnectionFactory() throws NotSupportedException {
        NotSupportedException notSupportedException = new NotSupportedException(NLS.getString("NON_MANAGED_ENVIRONMENT_CWSIV0351"));
        if (TRACE.isEventEnabled()) {
            SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)notSupportedException);
        }
        throw notSupportedException;
    }

    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceAdapterInternalException, ResourceException {
        SibRaManagedConnection sibRaManagedConnection;
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"createManagedConnection", (Object)new Object[]{SibRaUtils.subjectToString(subject), connectionRequestInfo});
        }
        if (connectionRequestInfo == null) {
            ResourceAdapterInternalException resourceAdapterInternalException = new ResourceAdapterInternalException(NLS.getString("NULL_REQUEST_INFO_CWSIV0352"));
            if (TRACE.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)resourceAdapterInternalException);
            }
            throw resourceAdapterInternalException;
        }
        if (connectionRequestInfo instanceof SibRaConnectionRequestInfo) {
            SICoreConnection sICoreConnection;
            SibRaConnectionRequestInfo sibRaConnectionRequestInfo = (SibRaConnectionRequestInfo)connectionRequestInfo;
            SibRaConnectionInfo sibRaConnectionInfo = new SibRaConnectionInfo(this, subject, sibRaConnectionRequestInfo);
            try {
                sICoreConnection = sibRaConnectionRequestInfo.getCoreConnection() == null ? sibRaConnectionInfo.createConnection() : sibRaConnectionRequestInfo.getCoreConnection().cloneConnection();
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.ra.impl.SibRaManagedConnectionFactory.createManagedConnection", (String)FFDC_PROBE_2, (Object)this);
                if (TRACE.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)sIException));
                }
                throw new ResourceException(NLS.getFormattedMessage("CONNECTION_CLONE_CWSIV0353", new Object[]{sIException}, null), (Throwable)sIException);
            }
            catch (SIErrorException sIErrorException) {
                FFDCFilter.processException((Throwable)sIErrorException, (String)"com.ibm.ws.sib.ra.impl.SibRaManagedConnectionFactory.createManagedConnection", (String)FFDC_PROBE_3, (Object)this);
                if (TRACE.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)sIErrorException));
                }
                throw new ResourceException(NLS.getFormattedMessage("CONNECTION_CLONE_CWSIV0353", new Object[]{sIErrorException}, null), (Throwable)sIErrorException);
            }
            try {
                sibRaManagedConnection = new SibRaManagedConnection(this, sibRaConnectionInfo, sICoreConnection);
                sibRaManagedConnection.setLogWriter(this._logWriter);
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.ra.impl.SibRaManagedConnectionFactory.createManagedConnection", (String)FFDC_PROBE_5, (Object)this);
                if (TRACE.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)sIException));
                }
                throw new ResourceException(NLS.getFormattedMessage("CREATE_MANAGED_CONNECTION_CWSIV0355", new Object[]{sIException}, null), (Throwable)sIException);
            }
        }
        throw new ResourceAdapterInternalException(NLS.getFormattedMessage("UNRECOGNISED_REQUEST_INFO_CWSIV0354", new Object[]{connectionRequestInfo, SibRaConnectionRequestInfo.class}, null));
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"createManagedConnection", (Object)sibRaManagedConnection);
        }
        return sibRaManagedConnection;
    }

    public ManagedConnection matchManagedConnections(Set set, Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceAdapterInternalException {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"matchManagedConnections", (Object)new Object[]{set, SibRaUtils.subjectToString(subject), connectionRequestInfo});
        }
        SibRaManagedConnection sibRaManagedConnection = null;
        if (connectionRequestInfo instanceof SibRaConnectionRequestInfo) {
            SibRaConnectionRequestInfo sibRaConnectionRequestInfo = (SibRaConnectionRequestInfo)connectionRequestInfo;
            SibRaConnectionInfo sibRaConnectionInfo = new SibRaConnectionInfo(this, subject, sibRaConnectionRequestInfo);
            Iterator iterator = set.iterator();
            while (iterator.hasNext() && sibRaManagedConnection == null) {
                SibRaManagedConnection sibRaManagedConnection2;
                Object e = iterator.next();
                if (!(e instanceof SibRaManagedConnection) || !(sibRaManagedConnection2 = (SibRaManagedConnection)e).matches(sibRaConnectionInfo, sibRaConnectionRequestInfo.getCoreConnection())) continue;
                sibRaManagedConnection = sibRaManagedConnection2;
            }
        } else {
            throw new ResourceAdapterInternalException(NLS.getString("UNRECOGNISED_REQUEST_INFO_CWSIV0354"));
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"matchManagedConnections", sibRaManagedConnection);
        }
        return sibRaManagedConnection;
    }

    public void setLogWriter(PrintWriter printWriter) {
        this._logWriter = printWriter;
    }

    public PrintWriter getLogWriter() {
        return this._logWriter;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof SibRaManagedConnectionFactory) {
            SibRaManagedConnectionFactory sibRaManagedConnectionFactory = (SibRaManagedConnectionFactory)object;
            return !SibRaUtils.objectsNotEqual(this._xaRecoveryAlias, sibRaManagedConnectionFactory._xaRecoveryAlias);
        }
        return false;
    }

    public int hashCode() {
        return SibRaUtils.objectHashCode(this._xaRecoveryAlias);
    }

    public String toString() {
        StringBuffer stringBuffer = SibRaUtils.startToString(this);
        SibRaUtils.addFieldToString(stringBuffer, "xaRecoveryAlias", this._xaRecoveryAlias);
        SibRaUtils.addFieldToString(stringBuffer, "coreFactory", this._coreFactory);
        SibRaUtils.addFieldToString(stringBuffer, "logWriter", this._logWriter);
        SibRaUtils.endToString(stringBuffer);
        return stringBuffer.toString();
    }

    public void setXARecoveryAlias(String string) {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"setXARecoveryAlias", (Object)string);
        }
        this._xaRecoveryAlias = string;
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"setXARecoveryAlias");
        }
    }

    String getXARecoveryAlias() {
        return this._xaRecoveryAlias;
    }

    SICoreConnectionFactory getCoreFactory() throws ResourceAdapterInternalException {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"getCoreFactory");
        }
        if (this._coreFactory == null) {
            try {
                this._coreFactory = SICoreConnectionFactorySelector.getSICoreConnectionFactory((FactoryType)FactoryType.TRM_CONNECTION);
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.ra.impl.SibRaManagedConnectionFactory.getCoreFactory", (String)FFDC_PROBE_1, (Object)this);
                if (TRACE.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)sIException));
                }
                throw new ResourceAdapterInternalException(NLS.getFormattedMessage("CONNECTION_FACTORY_ERROR_CWSIV0350", new Object[]{sIException}, null), (Throwable)sIException);
            }
            catch (SIErrorException sIErrorException) {
                FFDCFilter.processException((Throwable)sIErrorException, (String)"com.ibm.ws.sib.ra.impl.SibRaManagedConnectionFactory.getCoreFactory", (String)FFDC_PROBE_4, (Object)this);
                if (TRACE.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)sIErrorException));
                }
                throw new ResourceAdapterInternalException(NLS.getFormattedMessage("CONNECTION_FACTORY_ERROR_CWSIV0350", new Object[]{sIErrorException}, null), (Throwable)sIErrorException);
            }
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"getCoreFactory", (Object)this._coreFactory);
        }
        return this._coreFactory;
    }
}

